/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core.graphql;

import cn.authing.core.graphql.GraphQLException;
import cn.authing.core.graphql.GraphQLResponse;
import cn.authing.core.http.Call;
import cn.authing.core.http.Callback;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0016J\u000f\u0010\u0011\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcn/authing/core/graphql/GraphQLCall;", "T", "Lcn/authing/core/http/Call;", "call", "Lokhttp3/Call;", "adapter", "Lcom/google/gson/TypeAdapter;", "Lcn/authing/core/graphql/GraphQLResponse;", "(Lokhttp3/Call;Lcom/google/gson/TypeAdapter;)V", "gson", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "cancel", "", "enqueue", "callback", "Lcn/authing/core/http/Callback;", "execute", "()Ljava/lang/Object;", "isCanceled", "", "isExecuted", "request", "Lokhttp3/Request;", "core"})
public final class GraphQLCall<T>
implements Call<T> {
    private final Gson gson;
    private final okhttp3.Call call;
    private final TypeAdapter<GraphQLResponse<T>> adapter;

    @Override
    @Nullable
    public T execute() throws IOException, GraphQLException {
        Response response = this.call.execute();
        if (response.isSuccessful()) {
            ResponseBody responseBody = response.body();
            String body = responseBody != null ? responseBody.string() : null;
            Object object = this.adapter.fromJson(body);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"adapter.fromJson(body)");
            GraphQLResponse graphQLResponse = (GraphQLResponse)object;
            if (graphQLResponse.getErrors() != null && graphQLResponse.getErrors().size() > 0) {
                String string = this.gson.toJson(graphQLResponse.getErrors());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gson.toJson(graphQLResponse.errors)");
                throw (Throwable)new GraphQLException(string);
            }
            return graphQLResponse.getData();
        }
        throw (Throwable)new IOException("Unexpected code " + response);
    }

    @Override
    public void enqueue(@NotNull Callback<T> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        okhttp3.Callback callbackWrapper2 = new okhttp3.Callback(this, callback){
            final /* synthetic */ GraphQLCall this$0;
            final /* synthetic */ Callback $callback;

            public void onResponse(@NotNull okhttp3.Call call, @NotNull Response response) {
                GraphQLResponse graphQLResponse;
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                if (response.isSuccessful()) {
                    ResponseBody responseBody = response.body();
                    Object object = GraphQLCall.access$getAdapter$p(this.this$0).fromJson(responseBody != null ? responseBody.string() : null);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"adapter.fromJson(response.body?.string())");
                    graphQLResponse = (GraphQLResponse)object;
                    List<GraphQLResponse.ResponseError> list = graphQLResponse.getErrors();
                    Integer n = list != null ? Integer.valueOf(list.size()) : null;
                    if (n == null) {
                        Intrinsics.throwNpe();
                    }
                    if (n > 0) {
                        GraphQLResponse.ErrorInfo firstError;
                        GraphQLResponse.ErrorInfo errorInfo = firstError = graphQLResponse.getErrors().get(0).getMessage();
                        GraphQLResponse.ErrorInfo errorInfo2 = firstError;
                        this.$callback.onFailure(new GraphQLResponse.ErrorInfo(errorInfo != null ? errorInfo.getCode() : 500, errorInfo2 != null ? errorInfo2.getMessage() : null));
                    }
                } else {
                    throw (Throwable)new IOException("Unexpected code " + response);
                }
                this.$callback.onSuccess(graphQLResponse.getData());
            }

            public void onFailure(@NotNull okhttp3.Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$callback.onFailure(new GraphQLResponse.ErrorInfo(500, e.getMessage()));
            }
            {
                this.this$0 = $outer;
                this.$callback = $captured_local_variable$1;
            }
        };
        this.call.enqueue(callbackWrapper2);
    }

    @Override
    public boolean isExecuted() {
        return this.call.isExecuted();
    }

    @Override
    public void cancel() {
        this.call.cancel();
    }

    @Override
    public boolean isCanceled() {
        return this.call.isCanceled();
    }

    @Override
    @Nullable
    public Request request() {
        return this.call.request();
    }

    public GraphQLCall(@NotNull okhttp3.Call call, @NotNull TypeAdapter<GraphQLResponse<T>> adapter) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull(adapter, (String)"adapter");
        this.call = call;
        this.adapter = adapter;
        this.gson = new GsonBuilder().create();
    }

    public static final /* synthetic */ TypeAdapter access$getAdapter$p(GraphQLCall $this) {
        return $this.adapter;
    }
}

