/*
 * Decompiled with CFR 0.152.
 */
package cn.authing.core;

import cn.authing.core.graphql.GraphQLCall;
import cn.authing.core.graphql.GraphQLRequest;
import cn.authing.core.graphql.GraphQLResponse;
import cn.authing.core.http.HttpCall;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004Jd\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u0002H\u001e0\u001c\"\u0004\b\u0000\u0010\u001d\"\u0004\b\u0001\u0010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0#0\"2!\u0010$\u001a\u001d\u0012\u0013\u0012\u0011H\u001d\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0004\u0012\u0002H\u001e0%H\u0010\u00a2\u0006\u0002\b)J/\u0010*\u001a\b\u0012\u0004\u0012\u0002H,0+\"\u0004\b\u0000\u0010,2\u0006\u0010-\u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H,0\"H\u0010\u00a2\u0006\u0002\b.J7\u0010/\u001a\b\u0012\u0004\u0012\u0002H,0+\"\u0004\b\u0000\u0010,2\u0006\u0010-\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H,0\"H\u0010\u00a2\u0006\u0002\b1J\u0017\u00102\u001a\u00020\u00032\b\u00103\u001a\u0004\u0018\u00010\u0003H\u0010\u00a2\u0006\u0002\b4R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0007R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\u0004R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0007\"\u0004\b\u0017\u0010\u0004R\u000e\u0010\u0018\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0007\u00a8\u00065"}, d2={"Lcn/authing/core/BaseClient;", "", "userPoolId", "", "(Ljava/lang/String;)V", "accessToken", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "client", "Lokhttp3/OkHttpClient;", "endpoint", "getEndpoint", "host", "getHost", "setHost", "json", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "mediaTypeJson", "Lokhttp3/MediaType;", "publicKey", "getPublicKey", "setPublicKey", "sdkType", "sdkVersion", "getUserPoolId$core", "createGraphQLCall", "Lcn/authing/core/graphql/GraphQLCall;", "TData", "TResult", "request", "Lcn/authing/core/graphql/GraphQLRequest;", "typeToken", "Lcom/google/gson/reflect/TypeToken;", "Lcn/authing/core/graphql/GraphQLResponse;", "resolver", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "data", "createGraphQLCall$core", "createHttpGetCall", "Lcn/authing/core/http/HttpCall;", "TResponse", "url", "createHttpGetCall$core", "createHttpPostCall", "body", "createHttpPostCall$core", "encrypt", "msg", "encrypt$core", "core"})
public abstract class BaseClient {
    @NotNull
    private String host;
    @NotNull
    private String publicKey;
    @Nullable
    private String accessToken;
    private final MediaType mediaTypeJson;
    private final String sdkType = "SDK";
    private final String sdkVersion = "java:3.0.1";
    private final OkHttpClient client;
    private final Gson json;
    @NotNull
    private final String userPoolId;

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.host = string;
    }

    @NotNull
    public final String getPublicKey() {
        return this.publicKey;
    }

    public final void setPublicKey(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.publicKey = string;
    }

    @Nullable
    public final String getAccessToken() {
        return this.accessToken;
    }

    public final void setAccessToken(@Nullable String string) {
        this.accessToken = string;
    }

    private final String getEndpoint() {
        return this.host + "/graphql/v2";
    }

    @NotNull
    public String encrypt$core(@Nullable String msg) {
        if (msg == null) {
            return "";
        }
        byte[] byArray = Base64.getDecoder().decode(this.publicKey);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(publicKey)");
        byte[] keyBytes = byArray;
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        Object object = msg;
        Cipher cipher2 = cipher;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray2 = ((String)object).getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray2;
        byte[] cipherMsg = cipher2.doFinal(byArray3);
        byte[] byArray4 = Base64.getEncoder().encode(cipherMsg);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray4, (String)"Base64.getEncoder().encode(cipherMsg)");
        object = byArray4;
        boolean bl2 = false;
        return new String((byte[])object, Charsets.UTF_8);
    }

    @NotNull
    public <TData, TResult> GraphQLCall<TData, TResult> createGraphQLCall$core(@NotNull GraphQLRequest request, @NotNull TypeToken<GraphQLResponse<TData>> typeToken, @NotNull Function1<? super TData, ? extends TResult> resolver) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(typeToken, (String)"typeToken");
        Intrinsics.checkParameterIsNotNull(resolver, (String)"resolver");
        TypeAdapter adapter = this.json.getAdapter(typeToken);
        Request.Builder builder = new Request.Builder().url(this.getEndpoint()).addHeader("Authorization", "Bearer " + this.accessToken).addHeader("Content-Type", "application/json").addHeader("x-authing-userpool-id", this.userPoolId).addHeader("x-authing-request-from", this.sdkType).addHeader("x-authing-sdk-version", this.sdkVersion);
        String string = this.json.toJson((Object)request);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.toJson(request)");
        Call call = this.client.newCall(builder.post(RequestBody.Companion.create(string, this.mediaTypeJson)).build());
        TypeAdapter typeAdapter = adapter;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeAdapter, (String)"adapter");
        return new GraphQLCall<TData, TResult>(call, typeAdapter, resolver);
    }

    @NotNull
    public <TResponse> HttpCall<TResponse> createHttpGetCall$core(@NotNull String url, @NotNull TypeToken<TResponse> typeToken) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull(typeToken, (String)"typeToken");
        TypeAdapter adapter = this.json.getAdapter(typeToken);
        Call call = this.client.newCall(new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.accessToken).addHeader("x-authing-userpool-id", this.userPoolId).addHeader("x-authing-request-from", this.sdkType).addHeader("x-authing-sdk-version", this.sdkVersion).get().build());
        TypeAdapter typeAdapter = adapter;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeAdapter, (String)"adapter");
        return new HttpCall(call, typeAdapter);
    }

    @NotNull
    public <TResponse> HttpCall<TResponse> createHttpPostCall$core(@NotNull String url, @NotNull String body, @NotNull TypeToken<TResponse> typeToken) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull(typeToken, (String)"typeToken");
        TypeAdapter adapter = this.json.getAdapter(typeToken);
        Call call = this.client.newCall(new Request.Builder().url(url).addHeader("Authorization", "Bearer " + this.accessToken).addHeader("Content-Type", "application/json").addHeader("x-authing-userpool-id", this.userPoolId).addHeader("x-authing-request-from", this.sdkType).addHeader("x-authing-sdk-version", this.sdkVersion).post(RequestBody.Companion.create(body, this.mediaTypeJson)).build());
        TypeAdapter typeAdapter = adapter;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeAdapter, (String)"adapter");
        return new HttpCall(call, typeAdapter);
    }

    @NotNull
    public final String getUserPoolId$core() {
        return this.userPoolId;
    }

    public BaseClient(@NotNull String userPoolId) {
        Intrinsics.checkParameterIsNotNull((Object)userPoolId, (String)"userPoolId");
        this.userPoolId = userPoolId;
        this.host = "https://core.authing.cn";
        this.publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC4xKeUgQ+Aoz7TLfAfs9+paePb5KIofVthEopwrXFkp8OCeocaTHt9ICjTT2QeJh6cZaDaArfZ873GPUn00eOIZ7Ae+TiA2BKHbCvloW3w5Lnqm70iSsUi5Fmu9/2+68GZRH9L7Mlh8cFksCicW2Y2W2uMGKl64GDcIq3au+aqJQIDAQAB";
        this.mediaTypeJson = MediaType.Companion.parse("application/json");
        this.sdkType = "SDK";
        this.sdkVersion = "java:3.0.1";
        this.client = new OkHttpClient();
        this.json = new GsonBuilder().create();
    }
}

