/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.easyapi.android;

import cn.featherfly.common.flux.action.Action;
import cn.featherfly.common.flux.store.Store;
import cn.featherfly.common.flux.store.StoreAction;
import cn.featherfly.common.location.LocationPoint;
import cn.featherfly.common.model.app.Platform;
import cn.featherfly.common.model.app.Version;
import cn.featherfly.easyapi.Environment;
import cn.featherfly.easyapi.EnvironmentImpl;
import cn.featherfly.easyapi.android.flux.EnvironmentAction;
import cn.featherfly.easyapi.pojo.User;
import java.util.HashMap;
import java.util.Map;

public class EnvironmentStore
extends Store<EnvironmentAction<?>>
implements Environment {
    public static final EnvironmentStore INSTANCE = new EnvironmentStore();
    private EnvironmentImpl environment = new EnvironmentImpl();

    protected EnvironmentStore() {
    }

    protected Map<Action.Type, StoreAction<EnvironmentAction<?>>> initStoreActions() {
        HashMap actions = new HashMap();
        actions.put(EnvironmentAction.EnvironmentActionType.LOCATION_CHANGE, action -> {
            this.environment.setLocation((LocationPoint)action.getData());
            this.storeChange(action);
        });
        actions.put(EnvironmentAction.EnvironmentActionType.USER_CHANGE, action -> {
            this.environment.setCurrentUser((User)action.getData());
            this.storeChange(action);
        });
        actions.put(EnvironmentAction.EnvironmentActionType.PLATFORM_CHANGE, action -> {
            this.environment.setPlatform((Platform)action.getData());
            this.storeChange(action);
        });
        actions.put(EnvironmentAction.EnvironmentActionType.VERSION_CHANGE, action -> {
            this.environment.setVersion((Version)action.getData());
            this.storeChange(action);
        });
        return actions;
    }

    public static EnvironmentStore get() {
        return INSTANCE;
    }

    public LocationPoint getLocation() {
        return this.environment.getLocation();
    }

    public Version getVersion() {
        return this.environment.getVersion();
    }

    public Platform getPlatform() {
        return this.environment.getPlatform();
    }

    public User getCurrentUser() {
        return this.environment.getCurrentUser();
    }

    public boolean isDebugEnable() {
        return this.environment.isDebugEnable();
    }

    public <O> O get(String key) {
        return (O)this.environment.get(key);
    }

    public <O> O get(Class<O> type) {
        return (O)this.environment.get(type);
    }
}

