/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.easyapi.codegen.typescript;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.easyapi.codegen.EnableExtParameters;
import cn.featherfly.easyapi.codegen.ExtParameter;
import cn.featherfly.easyapi.codegen.ModuleAbility;
import cn.featherfly.easyapi.codegen.WrapResponseAbility;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.typescript.AbstractTypeScriptClientCodegen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class TypeScriptAxiosCodegen
extends AbstractTypeScriptClientCodegen
implements EnableExtParameters,
ModuleAbility,
WrapResponseAbility {
    public static final String NPM_NAME = "npmName";
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String DEFAULT_API_PACKAGE = "apis";
    public static final String DEFAULT_MODEL_PACKAGE = "models";
    protected String npmRepository = null;
    private String tsModelPackage = "";
    private boolean wrapResponse = true;
    protected Collection<ExtParameter> extParameters = new HashSet<ExtParameter>();
    protected String module;
    protected String secondModule;
    protected String apiImportPath = "easyapi-ts";

    public TypeScriptAxiosCodegen() {
        this.importMapping.clear();
        this.outputFolder = "generated-code/typescript-axios";
    }

    public String getName() {
        return "typescript-axios";
    }

    public String getHelp() {
        return "Generates a TypeScript Axios client library.";
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }

    private static String getRelativeToRoot(String path) {
        StringBuilder sb = new StringBuilder();
        int slashCount = path.split("/").length;
        if (slashCount == 0) {
            sb.append("./");
        } else {
            for (int i = 0; i < slashCount; ++i) {
                sb.append("../");
            }
        }
        return sb.toString();
    }

    public void processOpts() {
        super.processOpts();
        if (StringUtils.isBlank((CharSequence)this.apiPackage)) {
            this.apiPackage = DEFAULT_API_PACKAGE;
        }
        this.modelPackage = this.apiPackage;
        String baseApiPackage = this.apiPackage;
        this.additionalProperties.put("baseApiPackage", baseApiPackage);
        if (StringUtils.isNotBlank((CharSequence)this.module)) {
            this.apiPackage = this.apiPackage + "/" + this.module;
            this.modelPackage = this.modelPackage + "/" + this.module;
            if (Lang.isNotEmpty((String)this.secondModule)) {
                this.apiPackage = this.apiPackage + "/" + this.secondModule;
                this.modelPackage = this.modelPackage + "/" + this.secondModule;
            }
        }
        this.tsModelPackage = this.modelPackage.replaceAll("\\.", "/");
        String tsApiPackage = this.apiPackage.replaceAll("\\.", "/");
        String modelRelativeToRoot = TypeScriptAxiosCodegen.getRelativeToRoot(this.tsModelPackage);
        String apiRelativeToRoot = TypeScriptAxiosCodegen.getRelativeToRoot(tsApiPackage);
        if (StringUtils.isBlank((CharSequence)this.apiImportPath)) {
            this.apiImportPath = apiRelativeToRoot + baseApiPackage + "/api";
        }
        this.additionalProperties.put("apiImportPath", this.apiImportPath);
        this.additionalProperties.put("tsModelPackage", this.tsModelPackage);
        this.additionalProperties.put("tsApiPackage", tsApiPackage);
        this.additionalProperties.put("apiRelativeToRoot", apiRelativeToRoot);
        this.additionalProperties.put("modelRelativeToRoot", modelRelativeToRoot);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.ts"));
        this.supportingFiles.add(new SupportingFile("baseApi.mustache", "", "base.ts"));
        this.supportingFiles.add(new SupportingFile("api.mustache", "", "api.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "", "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("npmignore", "", ".npmignore"));
        this.modelTemplateFiles.put("model.mustache", ".d.ts");
        this.apiTemplateFiles.put("apiInner.mustache", ".ts");
        this.supportingFiles.add(new SupportingFile("modelIndex.mustache", this.tsModelPackage, "index.ts"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
        if (this.wrapResponse) {
            this.modelTemplateFiles.put("model-response.mustache", ".ts");
        }
    }

    public Map<String, Object> postProcessOperations(Map<String, Object> operations) {
        boolean hasImports;
        boolean bl = hasImports = operations.get("hasImport") != null && Boolean.parseBoolean(operations.get("hasImport").toString());
        if (hasImports) {
            List imports = (List)operations.get("imports");
            for (Map importMap : imports) {
                String importValue = (String)importMap.get("import");
                if (!StringUtils.isNotBlank((CharSequence)importValue) || !importValue.contains(".")) continue;
                int index = importValue.indexOf(".");
                importMap.put("import", importValue.substring(index + 1));
            }
        }
        return operations;
    }

    public Map<String, Object> postProcessOperationsWithModels(Map<String, Object> objs, List<Object> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map vals = objs.getOrDefault("operations", new HashMap());
        List operations = vals.getOrDefault("operation", new ArrayList());
        operations.stream().filter(op -> ExtensionHelper.getBooleanValue((VendorExtendable)op, (String)"x-has-consumes")).filter(op -> op.consumes.stream().anyMatch(opc -> opc.values().stream().anyMatch("multipart/form-data"::equals))).forEach(op -> op.vendorExtensions.putIfAbsent("multipartFormData", true));
        return objs;
    }

    public Map<String, Object> postProcessAllModels(Map<String, Object> objs) {
        Map result = super.postProcessAllModels(objs);
        return result;
    }

    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        List models = (List)this.postProcessModelsEnum(objs).get(DEFAULT_MODEL_PACKAGE);
        for (Object _mo : models) {
            Map mo = (Map)_mo;
            CodegenModel cm = (CodegenModel)mo.get("model");
            cm.classFilename = cm.classname.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT);
            cm.imports = new TreeSet(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!ExtensionHelper.getBooleanValue((VendorExtendable)var, (String)"x-is-enum")) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
                var.enumName = var.enumName.replace(var.enumName, cm.classname + var.enumName);
            }
            if (cm.parent == null) continue;
            for (CodegenProperty var : cm.allVars) {
                if (!ExtensionHelper.getBooleanValue((VendorExtendable)var, (String)"x-is-enum")) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
                var.enumName = var.enumName.replace(var.enumName, cm.classname + var.enumName);
            }
        }
        for (Map m : (List)objs.get("imports")) {
            String javaImport = ((String)m.get("import")).substring(this.modelPackage.length() + 1);
            String tsImport = this.tsModelPackage + "/" + javaImport;
            m.put("tsImport", tsImport);
            m.put("class", javaImport);
            m.put("filename", javaImport.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT));
        }
        return objs;
    }

    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(pattern);
    }

    public String toModelFilename(String name) {
        return super.toModelFilename(name);
    }

    public String toApiFilename(String name) {
        return super.toApiFilename(name);
    }

    public String getDefaultTemplateDir() {
        return "easyapi-typescript-axios";
    }

    @Override
    public Collection<ExtParameter> getExtParameters() {
        return this.extParameters;
    }

    @Override
    public EnableExtParameters addExtParameter(ExtParameter extParameter) {
        if (extParameter != null) {
            this.extParameters.add(extParameter);
        }
        return this;
    }

    @Override
    public String toModelFilename(String name, String templateName) {
        if (templateName.equals("model-response.mustache")) {
            name = name + "Response";
        }
        return name;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    public void setModule(String module) {
        this.module = module;
        this.additionalProperties.put("module", module);
    }

    @Override
    public boolean isWrapResponse() {
        return this.wrapResponse;
    }

    @Override
    public void setWrapResponse(boolean wrapResponse) {
        this.wrapResponse = wrapResponse;
        if (wrapResponse) {
            this.modelTemplateFiles.put("model-response.mustache", ".java");
        }
    }

    public String getApiImportPath() {
        return this.apiImportPath;
    }

    public void setApiImportPath(String apiImportPath) {
        this.apiImportPath = apiImportPath;
    }

    @Override
    public String getSecondModule() {
        return this.secondModule;
    }

    @Override
    public void setSecondModule(String secondModule) {
        this.secondModule = secondModule;
    }
}

