/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.easyapi.codegen;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.easyapi.codegen.EnableExtParameters;
import cn.featherfly.easyapi.codegen.ExtParameter;
import cn.featherfly.easyapi.codegen.ModuleAbility;
import io.swagger.codegen.v3.CodegenModelFactory;
import io.swagger.codegen.v3.CodegenModelType;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.java.AbstractJavaCodegen;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EasyapiAbstractJavaCodegen
extends AbstractJavaCodegen
implements EnableExtParameters,
ModuleAbility {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected String module;
    protected String secondModule;
    protected String configPackage = "";
    protected String defaultApiPath = "/v1/api";
    protected String title = "easyapi java code";
    protected Collection<ExtParameter> extParameters = new HashSet<ExtParameter>();

    public EasyapiAbstractJavaCodegen() {
        this.setGroupId("cn.featherfly.easyapi");
        this.setArtifactId("easyapi-code-generator");
        this.setArtifactVersion("1.0.0");
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "boolean", "Boolean", "Double", "Integer", "Long", "Float"));
    }

    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map operations = (Map)objs.get("operations");
        if (operations != null) {
            List ops = (List)operations.get("operation");
            for (CodegenOperation operation : ops) {
                String notes;
                if (operation.returnType != null && operation.returnType.startsWith("Pagination")) {
                    String rt = operation.returnType;
                    operation.returnType = "PaginationResults<" + rt.substring("Pagination".length(), rt.length()) + ">";
                    this.addExtParameterImports(objs, "cn.featherfly.common.structure.page.PaginationResults");
                }
                if ((notes = operation.notes) == null) continue;
                this.extParameters.forEach(extParameter -> {
                    if (notes.contains(extParameter.getName())) {
                        this.addAddtionalParameter(extParameter.getCodegenParameter().copy(), operation, extParameter.getParamTypeDefined(), extParameter.getParamName());
                        this.addExtParameterImports(objs, extParameter.getParamTypeImport());
                    }
                });
            }
        }
        return objs;
    }

    private void addAddtionalParameter(CodegenParameter params, CodegenOperation operation, String dataType, String paramName) {
        params.dataType = dataType;
        params.paramName = paramName;
        params.baseName = paramName;
        if (StringUtils.isEmpty((CharSequence)params.description)) {
            params.description = paramName;
        }
        params.unescapedDescription = params.description;
        operation.allParams.add(params);
        operation.allParams = EasyapiAbstractJavaCodegen.addHasMore((List)operation.allParams);
    }

    private void addExtParameterImports(Map<String, Object> objs, String importClass) {
        List imports = (List)objs.get("imports");
        for (Map importItem : imports) {
            String className = (String)importItem.get("import");
            if (className == null || !className.equals(importClass)) continue;
            return;
        }
        LinkedHashMap<String, String> im = new LinkedHashMap<String, String>();
        im.put("import", importClass);
        imports.add(im);
    }

    @Override
    public Collection<ExtParameter> getExtParameters() {
        return this.extParameters;
    }

    @Override
    public EnableExtParameters addExtParameter(ExtParameter extParameter) {
        if (extParameter != null) {
            this.extParameters.add(extParameter);
        }
        return this;
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public String apiPackage() {
        return Strings.format((String)super.apiPackage(), (Map)BeanUtils.toMap((Object)this));
    }

    public String toModelImport(String name) {
        return Strings.format((String)super.toModelImport(name), (Map)BeanUtils.toMap((Object)this));
    }

    public String toApiImport(String name) {
        return Strings.format((String)super.toApiImport(name), (Map)BeanUtils.toMap((Object)this));
    }

    public String modelPackage() {
        return Strings.format((String)super.modelPackage(), (Map)BeanUtils.toMap((Object)this));
    }

    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    public String toModelName(String name) {
        if (name.startsWith(".")) {
            String returnType = StringUtils.substringAfterLast((String)name, (String)"/");
            return returnType;
        }
        return super.toModelName(name);
    }

    public String toApiName(String name) {
        return super.toApiName(name);
    }

    public void setDefaultApiPath(String defaultApiPath) {
        this.defaultApiPath = defaultApiPath;
        this.additionalProperties.put("apiPath", defaultApiPath);
    }

    public String getConfigPackage() {
        return this.configPackage;
    }

    public void setConfigPackage(String configPackage) {
        this.configPackage = configPackage;
        this.additionalProperties.put("configPackage", configPackage);
    }

    public String getDefaultApiPath() {
        return this.defaultApiPath;
    }

    @Override
    public String getModule() {
        return this.module;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.additionalProperties.put("title", title);
    }

    @Override
    public void setModule(String module) {
        this.module = module;
        this.additionalProperties.put("module", module);
    }

    public String getInvokerPackage() {
        return this.invokerPackage;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getArtifactVersion() {
        return this.artifactVersion;
    }

    public void setInvokerPackage(String invokerPackage) {
        this.invokerPackage = invokerPackage;
        this.additionalProperties.put("invokerPackage", invokerPackage);
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
        this.additionalProperties.put("groupId", groupId);
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
        this.additionalProperties.put("artifactId", artifactId);
    }

    public void setArtifactVersion(String artifactVersion) {
        this.artifactVersion = artifactVersion;
        this.additionalProperties.put("artifactVersion", artifactVersion);
    }

    public void setArtifactUrl(String artifactUrl) {
        this.artifactUrl = artifactUrl;
        this.additionalProperties.put("artifactUrl", artifactUrl);
    }

    public void setArtifactDescription(String artifactDescription) {
        this.artifactDescription = artifactDescription;
        this.additionalProperties.put("artifactDescription", artifactDescription);
    }

    public void setApiPackage(String apiPackage) {
        this.apiPackage = apiPackage;
        this.additionalProperties.put("apiPackage", apiPackage);
    }

    public void setModelPackage(String modelPackage) {
        this.modelPackage = modelPackage;
        this.additionalProperties.put("modelPackage", modelPackage);
    }

    public CodegenProperty fromProperty(String name, Schema propertySchema) {
        CodegenProperty cp;
        HashMap<String, List> allowableValues;
        List _enum;
        if (propertySchema == null) {
            this.logger.error("unexpected missing property for name " + name);
            return null;
        }
        CodegenProperty codegenProperty = (CodegenProperty)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.PROPERTY);
        codegenProperty.name = this.toVarName(name);
        codegenProperty.baseName = name;
        codegenProperty.nameInCamelCase = EasyapiAbstractJavaCodegen.camelize((String)codegenProperty.name, (boolean)false);
        codegenProperty.description = this.escapeText(propertySchema.getDescription());
        codegenProperty.unescapedDescription = propertySchema.getDescription();
        codegenProperty.title = propertySchema.getTitle();
        codegenProperty.getter = this.toGetter(name);
        codegenProperty.setter = this.toSetter(name);
        String example = this.toExampleValue(propertySchema);
        if (!"null".equals(example)) {
            codegenProperty.example = example;
        }
        codegenProperty.defaultValue = this.toDefaultValue(propertySchema);
        codegenProperty.defaultValueWithParam = this.toDefaultValueWithParam(name, propertySchema);
        codegenProperty.jsonSchema = Json.pretty((Object)propertySchema);
        if (propertySchema.getNullable() != null) {
            codegenProperty.nullable = propertySchema.getNullable();
        }
        if (propertySchema.getReadOnly() != null) {
            codegenProperty.getVendorExtensions().put("x-is-read-only", propertySchema.getReadOnly());
        }
        if (propertySchema.getXml() != null) {
            if (propertySchema.getXml().getAttribute() != null) {
                codegenProperty.getVendorExtensions().put("x-is-xml-attribute", propertySchema.getXml().getAttribute());
            }
            codegenProperty.xmlPrefix = propertySchema.getXml().getPrefix();
            codegenProperty.xmlName = propertySchema.getXml().getName();
            codegenProperty.xmlNamespace = propertySchema.getXml().getNamespace();
        }
        if (propertySchema.getExtensions() != null && !propertySchema.getExtensions().isEmpty()) {
            codegenProperty.getVendorExtensions().putAll(propertySchema.getExtensions());
        }
        String type = this.getSchemaType(propertySchema);
        if (propertySchema instanceof IntegerSchema) {
            codegenProperty.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            if ("int64".equals(propertySchema.getFormat())) {
                codegenProperty.getVendorExtensions().put("x-is-long", Boolean.TRUE);
            } else {
                codegenProperty.getVendorExtensions().put("x-is-integer", Boolean.TRUE);
            }
            this.handleMinMaxValues(propertySchema, codegenProperty);
            if (codegenProperty.minimum != null || codegenProperty.maximum != null) {
                codegenProperty.getVendorExtensions().put("x-has-validation", Boolean.TRUE);
            }
            HashMap<String, Object> allowableValues2 = new HashMap<String, Object>();
            if (propertySchema.getMinimum() != null) {
                allowableValues2.put("min", propertySchema.getMinimum());
            }
            if (propertySchema.getMaximum() != null) {
                allowableValues2.put("max", propertySchema.getMaximum());
            }
            if (propertySchema.getEnum() != null) {
                List _enum2 = propertySchema.getEnum();
                codegenProperty._enum = new ArrayList();
                for (Integer i : _enum2) {
                    codegenProperty._enum.add(i.toString());
                }
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues2.put("values", _enum2);
            }
            if (allowableValues2.size() > 0) {
                codegenProperty.allowableValues = allowableValues2;
            }
        }
        if (propertySchema instanceof StringSchema) {
            codegenProperty.maxLength = propertySchema.getMaxLength();
            codegenProperty.minLength = propertySchema.getMinLength();
            codegenProperty.pattern = this.toRegularExpression(propertySchema.getPattern());
            if (codegenProperty.pattern != null || codegenProperty.minLength != null || codegenProperty.maxLength != null) {
                codegenProperty.getVendorExtensions().put("x-has-validation", Boolean.TRUE);
            }
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
            if (propertySchema.getEnum() != null) {
                codegenProperty._enum = _enum = propertySchema.getEnum();
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues = new HashMap<String, List>();
                allowableValues.put("values", _enum);
                codegenProperty.allowableValues = allowableValues;
            }
        }
        if (propertySchema instanceof FileSchema || propertySchema instanceof BinarySchema) {
            codegenProperty.getVendorExtensions().put("x-is-file", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-binary", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        }
        if (propertySchema instanceof EmailSchema) {
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        }
        if (propertySchema instanceof UUIDSchema) {
            codegenProperty.getVendorExtensions().put("x-is-uuid", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-string", Boolean.TRUE);
        }
        if (propertySchema instanceof ByteArraySchema) {
            codegenProperty.getVendorExtensions().put("x-is-byte-array", Boolean.TRUE);
        }
        if (propertySchema instanceof NumberSchema) {
            codegenProperty.getVendorExtensions().put("x-is-numeric", Boolean.TRUE);
            if ("float".equals(propertySchema.getFormat())) {
                codegenProperty.getVendorExtensions().put("x-is-float", Boolean.TRUE);
            } else {
                codegenProperty.getVendorExtensions().put("x-is-double", Boolean.TRUE);
            }
            this.handleMinMaxValues(propertySchema, codegenProperty);
            if (propertySchema.getEnum() != null && !propertySchema.getEnum().isEmpty()) {
                _enum = propertySchema.getEnum();
                codegenProperty._enum = _enum.stream().map(number -> number.toString()).collect(Collectors.toList());
                codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
                allowableValues = new HashMap();
                allowableValues.put("values", _enum);
                codegenProperty.allowableValues = allowableValues;
            }
        }
        if (propertySchema instanceof DateSchema) {
            codegenProperty.getVendorExtensions().put("x-is-date", Boolean.TRUE);
            this.handlePropertySchema(propertySchema, codegenProperty);
        }
        if (propertySchema instanceof DateTimeSchema) {
            codegenProperty.getVendorExtensions().put("x-is-date-time", Boolean.TRUE);
            this.handlePropertySchema(propertySchema, codegenProperty);
        }
        codegenProperty.datatype = this.getTypeDeclaration(propertySchema);
        codegenProperty.dataFormat = propertySchema.getFormat();
        boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)codegenProperty, (String)"x-is-enum");
        if (isEnum) {
            codegenProperty.datatypeWithEnum = this.toEnumName(codegenProperty);
            codegenProperty.enumName = this.toEnumName(codegenProperty);
        } else {
            codegenProperty.datatypeWithEnum = codegenProperty.datatype;
        }
        codegenProperty.baseType = this.getSchemaType(propertySchema);
        if (propertySchema instanceof ArraySchema) {
            codegenProperty.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-list-container", Boolean.TRUE);
            codegenProperty.containerType = "array";
            codegenProperty.baseType = this.getSchemaType(propertySchema);
            if (propertySchema.getXml() != null) {
                codegenProperty.getVendorExtensions().put("x-is-xml-wrapped", propertySchema.getXml().getWrapped() == null ? false : propertySchema.getXml().getWrapped());
                codegenProperty.xmlPrefix = propertySchema.getXml().getPrefix();
                codegenProperty.xmlNamespace = propertySchema.getXml().getNamespace();
                codegenProperty.xmlName = propertySchema.getXml().getName();
            }
            codegenProperty.maxItems = propertySchema.getMaxItems();
            codegenProperty.minItems = propertySchema.getMinItems();
            String itemName = null;
            if (propertySchema.getExtensions() != null && propertySchema.getExtensions().get("x-item-name") != null) {
                itemName = propertySchema.getExtensions().get("x-item-name").toString();
            }
            if (itemName == null) {
                itemName = codegenProperty.name;
            }
            Schema items = ((ArraySchema)propertySchema).getItems();
            CodegenProperty innerCodegenProperty = this.fromProperty(itemName, items);
            this.updatePropertyForArray(codegenProperty, innerCodegenProperty);
        } else if (propertySchema instanceof MapSchema && EasyapiAbstractJavaCodegen.hasSchemaProperties((Schema)propertySchema)) {
            codegenProperty.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
            codegenProperty.containerType = "map";
            codegenProperty.baseType = this.getSchemaType(propertySchema);
            codegenProperty.minItems = propertySchema.getMinProperties();
            codegenProperty.maxItems = propertySchema.getMaxProperties();
            cp = this.fromProperty("inner", (Schema)propertySchema.getAdditionalProperties());
            this.updatePropertyForMap(codegenProperty, cp);
        } else if (propertySchema instanceof MapSchema && EasyapiAbstractJavaCodegen.hasTrueAdditionalProperties((Schema)propertySchema)) {
            codegenProperty.getVendorExtensions().put("x-is-container", Boolean.TRUE);
            codegenProperty.getVendorExtensions().put("x-is-map-container", Boolean.TRUE);
            codegenProperty.containerType = "map";
            codegenProperty.baseType = this.getSchemaType(propertySchema);
            codegenProperty.minItems = propertySchema.getMinProperties();
            codegenProperty.maxItems = propertySchema.getMaxProperties();
            cp = this.fromProperty("inner", (Schema)new ObjectSchema());
            this.updatePropertyForMap(codegenProperty, cp);
        } else {
            if (this.isObjectSchema(propertySchema)) {
                codegenProperty.getVendorExtensions().put("x-is-object", Boolean.TRUE);
            }
            this.setNonArrayMapProperty(codegenProperty, type);
        }
        return codegenProperty;
    }

    private void handleMinMaxValues(Schema propertySchema, CodegenProperty codegenProperty) {
        if (propertySchema.getMinimum() != null) {
            codegenProperty.minimum = String.valueOf(propertySchema.getMinimum().longValue());
        }
        if (propertySchema.getMaximum() != null) {
            codegenProperty.maximum = String.valueOf(propertySchema.getMaximum().longValue());
        }
        if (propertySchema.getExclusiveMinimum() != null) {
            codegenProperty.exclusiveMinimum = propertySchema.getExclusiveMinimum();
        }
        if (propertySchema.getExclusiveMaximum() != null) {
            codegenProperty.exclusiveMaximum = propertySchema.getExclusiveMaximum();
        }
    }

    private void handlePropertySchema(Schema propertySchema, CodegenProperty codegenProperty) {
        if (propertySchema.getEnum() != null) {
            List _enum = propertySchema.getEnum();
            codegenProperty._enum = new ArrayList();
            for (String i : _enum) {
                codegenProperty._enum.add(i);
            }
            codegenProperty.getVendorExtensions().put("x-is-enum", Boolean.TRUE);
            HashMap<String, List> allowableValues = new HashMap<String, List>();
            allowableValues.put("values", _enum);
            codegenProperty.allowableValues = allowableValues;
        }
    }

    @Override
    public String getSecondModule() {
        return this.secondModule;
    }

    @Override
    public void setSecondModule(String secondModule) {
        this.secondModule = secondModule;
    }
}

