/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Application;

import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.os.Handler;
import android.text.TextUtils;
import com.icatch.panorama.ContextProvider;
import com.icatch.panorama.Listener.PanoramaCallback;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.MyCamera.CameraType;
import com.icatch.panorama.MyCamera.MyCamera;
import com.icatch.panorama.R;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.AppInfo.ConfigureInfo;
import com.icatch.panorama.data.SystemInfo.HotSpot;
import com.icatch.panorama.ui.activity.PanoramaPreviewV35Activity;
import com.icatch.panorama.ui.activity.PanoramaPreviewV50Activity;
import com.icatch.panorama.ui.activity.PanoramaPreviewV51Activity;
import com.icatch.panorama.utils.FileOpertion.FileOper;
import java.io.File;

public class PanoramaSDK {
    private PanoramaCallback mCallback;
    private static volatile PanoramaSDK sInstance = null;
    private String mOutputFolder;
    private final Handler mHandler = new Handler();
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            if (PanoramaSDK.this.mCallback != null) {
                PanoramaSDK.this.mCallback.onConnectFailed(PanoramaSDK.getContext().getString(R.string.dialog_connect_timeout));
            }
        }
    };
    private boolean isOneShoot;

    private PanoramaSDK() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PanoramaSDK getInstance() {
        if (sInstance == null) {
            Class<PanoramaSDK> clazz = PanoramaSDK.class;
            // MONITORENTER : com.icatch.panorama.Application.PanoramaSDK.class
            if (sInstance == null) {
                sInstance = new PanoramaSDK();
            }
            // MONITOREXIT : clazz
        }
        sInstance.init();
        return sInstance;
    }

    private void init() {
        FileOper.createDirectory(Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720photo/");
        FileOper.createDirectory(Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720video/");
    }

    public PanoramaSDK initCfg() {
        ConfigureInfo.getInstance().initCfgInfo(PanoramaSDK.getContext());
        return this;
    }

    public static Context getContext() {
        return ContextProvider.get().getContext();
    }

    public PanoramaCallback getCallback() {
        return this.mCallback;
    }

    public PanoramaSDK setCallback(PanoramaCallback callback) {
        this.mCallback = callback;
        return this;
    }

    public String getOutputFolder() {
        return this.mOutputFolder;
    }

    public PanoramaSDK setOutputFolder(String outputFolder) {
        this.mOutputFolder = outputFolder;
        return this;
    }

    public PanoramaSDK setOneShoot(boolean isOneShoot) {
        this.isOneShoot = isOneShoot;
        return this;
    }

    public boolean isOneShoot() {
        return this.isOneShoot;
    }

    public void connectCamera(final String ssid) {
        if (!TextUtils.isEmpty((CharSequence)this.mOutputFolder)) {
            File folder = new File(this.mOutputFolder);
            folder.mkdirs();
            if (!folder.exists()) {
                if (this.mCallback != null) {
                    this.mCallback.onConnectFailed("\u8f93\u51fa\u8def\u5f84\u4e0d\u6b63\u786e");
                }
                return;
            }
        }
        this.mHandler.removeCallbacks(this.runnable);
        this.mHandler.postDelayed(this.runnable, 8000L);
        new Thread(new Runnable(){

            @Override
            public void run() {
                PanoramaSDK.this.beginConnectCamera(PanoramaSDK.this.getCameraIp(), ssid);
            }
        }).start();
    }

    private String getCameraIp() {
        String ip = "";
        ip = HotSpot.isApEnabled(PanoramaSDK.getContext()) ? HotSpot.getFirstConnectedHotIP() : (!AppInfo.enableLive ? "192.168.1.1" : AppInfo.inputIp);
        return ip;
    }

    private void beginConnectCamera(String ip, String wifiSsid) {
        CameraManager.getInstance().createCamera(CameraType.PANORAMA_CAMERA, wifiSsid, ip, 1);
        final MyCamera currentCamera = CameraManager.getInstance().getCurCamera();
        if (!currentCamera.connect(true)) {
            this.mHandler.removeCallbacks(this.runnable);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (PanoramaSDK.this.mCallback != null) {
                        PanoramaSDK.this.mCallback.onConnectFailed(PanoramaSDK.getContext().getString(R.string.dialog_connect_failed));
                    }
                }
            });
            return;
        }
        if (currentCamera.getCameraProperties().hasFuction(20497)) {
            currentCamera.getCameraProperties().setCameraDate();
        }
        this.mHandler.removeCallbacks(this.runnable);
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (PanoramaSDK.this.mCallback != null) {
                    PanoramaSDK.this.mCallback.onConnectSucceed();
                }
                if ("V50 Serial".equals(currentCamera.getBaseProrertys().getProjectModel())) {
                    Intent intent = new Intent(PanoramaSDK.getContext(), PanoramaPreviewV50Activity.class);
                    intent.setFlags(0x10000000);
                    PanoramaSDK.getContext().startActivity(intent);
                } else if ("V50 SBC".equals(currentCamera.getBaseProrertys().getProjectModel())) {
                    Intent intent = new Intent(PanoramaSDK.getContext(), PanoramaPreviewV51Activity.class);
                    intent.setFlags(0x10000000);
                    PanoramaSDK.getContext().startActivity(intent);
                } else {
                    Intent intent = new Intent(PanoramaSDK.getContext(), PanoramaPreviewV35Activity.class);
                    intent.setFlags(0x10000000);
                    PanoramaSDK.getContext().startActivity(intent);
                }
            }
        });
    }
}

