/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.CameraAction;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.AsyncTask;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.Toast;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.FileOperation;
import com.icatch.panorama.data.entity.DownloadInfo;
import com.icatch.panorama.ui.adapter.DownloadManagerAdapter;
import com.icatch.panorama.ui.appdialog.CustomDownloadDialog;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatch.panorama.utils.MediaRefresh;
import com.icatchtek.reliant.customer.type.ICatchFile;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PbDownloadManager {
    private static String TAG = "PbDownloadManager";
    private ExecutorService executor;
    public long downloadProgress;
    public FileOperation fileOperation;
    private LinkedList<ICatchFile> downloadTaskList;
    private LinkedList<ICatchFile> downloadChooseList;
    private LinkedList<ICatchFile> downloadProgressList;
    private DownloadManagerAdapter downloadManagerAdapter;
    private AlertDialog.Builder builder;
    private Context context;
    private HashMap<ICatchFile, DownloadInfo> downloadInfoMap = new HashMap();
    private ICatchFile currentDownloadFile;
    private Timer downloadProgressTimer;
    private int downloadFailed = 0;
    private int downloadSucceed = 0;
    private CustomDownloadDialog customDownloadDialog;
    private String curFilePath = "";
    Handler downloadManagerHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 770: {
                    ICatchFile icatchFile = ((DownloadInfo)msg.obj).file;
                    PbDownloadManager.this.downloadInfoMap.put(icatchFile, (DownloadInfo)msg.obj);
                    PbDownloadManager.this.downloadManagerAdapter.notifyDataSetChanged();
                    break;
                }
                case 772: {
                    AppLog.d(TAG, "receive CANCEL_DOWNLOAD_ALL");
                    PbDownloadManager.this.alertForQuitDownload();
                    break;
                }
                case 769: {
                    ICatchFile temp = (ICatchFile)msg.obj;
                    AppLog.d(TAG, "1122 receive MESSAGE_CANCEL_DOWNLOAD_SINGLE");
                    if (PbDownloadManager.this.currentDownloadFile == temp) {
                        if (!PbDownloadManager.this.fileOperation.cancelDownload()) {
                            Toast.makeText((Context)PbDownloadManager.this.context, (int)R.string.dialog_cancel_downloading_failed, (int)0).show();
                            break;
                        }
                        if (PbDownloadManager.this.curFilePath != null) {
                            File file = new File(PbDownloadManager.this.curFilePath);
                            if (file == null || !file.exists()) {
                                return;
                            }
                            if (file.delete()) {
                                AppLog.d("2222", "delete file success == " + PbDownloadManager.this.curFilePath);
                            }
                        }
                    }
                    Toast.makeText((Context)PbDownloadManager.this.context, (int)R.string.dialog_cancel_downloading_succeeded, (int)0).show();
                    PbDownloadManager.this.downloadInfoMap.remove(temp);
                    PbDownloadManager.this.downloadChooseList.remove(temp);
                    PbDownloadManager.this.downloadTaskList.remove(temp);
                    AppLog.d(TAG, "1122 receive MESSAGE_CANCEL_DOWNLOAD_SINGLE downloadChooseList size=" + PbDownloadManager.this.downloadChooseList.size() + "downloadInfoMap size=" + PbDownloadManager.this.downloadInfoMap.size());
                    PbDownloadManager.this.downloadManagerAdapter = new DownloadManagerAdapter(PbDownloadManager.this.context, PbDownloadManager.this.downloadInfoMap, PbDownloadManager.this.downloadChooseList, PbDownloadManager.this.downloadManagerHandler);
                    PbDownloadManager.this.customDownloadDialog.setAdapter(PbDownloadManager.this.downloadManagerAdapter);
                    PbDownloadManager.this.downloadManagerAdapter.notifyDataSetChanged();
                    PbDownloadManager.this.updateDownloadMessage();
                    if (PbDownloadManager.this.downloadTaskList.size() > 0 || PbDownloadManager.this.customDownloadDialog == null) break;
                    PbDownloadManager.this.customDownloadDialog.dismissDownloadDialog();
                    break;
                }
                case 778: {
                    AppLog.d(TAG, "receive DOWNLOAD_FAILURE downloadFailed=" + PbDownloadManager.this.downloadFailed);
                    PbDownloadManager.this.downloadFailed++;
                    PbDownloadManager.this.updateDownloadMessage();
                    break;
                }
                case 777: {
                    PbDownloadManager.this.downloadSucceed++;
                    PbDownloadManager.this.updateDownloadMessage();
                }
            }
        }
    };

    public PbDownloadManager(Context context, LinkedList<ICatchFile> downloadList) {
        this.context = context;
        this.downloadTaskList = downloadList;
        this.fileOperation = CameraManager.getInstance().getCurCamera().getFileOperation();
        this.downloadChooseList = new LinkedList();
        this.downloadProgressList = new LinkedList();
        this.downloadChooseList.addAll(this.downloadTaskList);
        for (int ii = 0; ii < this.downloadChooseList.size(); ++ii) {
            DownloadInfo downloadInfo = new DownloadInfo(this.downloadChooseList.get(ii), this.downloadChooseList.get(ii).getFileSize(), 0L, 0, false);
            this.downloadInfoMap.put(this.downloadChooseList.get(ii), downloadInfo);
        }
    }

    public void show() {
        this.showDownloadManagerDialog();
        this.executor = Executors.newSingleThreadExecutor();
        if (this.downloadTaskList.size() > 0) {
            this.currentDownloadFile = this.downloadTaskList.getFirst();
            new DownloadAsytask(this.currentDownloadFile).execute(new String[0]);
            this.downloadProgressTimer = new Timer();
            this.downloadProgressTimer.schedule((TimerTask)new DownloadProgressTask(), 0L, 100L);
        }
    }

    public void showDownloadManagerDialog() {
        this.downloadManagerAdapter = new DownloadManagerAdapter(this.context, this.downloadInfoMap, this.downloadChooseList, this.downloadManagerHandler);
        this.customDownloadDialog = new CustomDownloadDialog();
        this.customDownloadDialog.showDownloadDialog(this.context, this.downloadManagerAdapter);
        this.customDownloadDialog.setBackBtnOnClickListener(new View.OnClickListener(){

            public void onClick(View arg0) {
                PbDownloadManager.this.downloadManagerHandler.obtainMessage(772).sendToTarget();
            }
        });
        this.updateDownloadMessage();
    }

    public void alertForQuitDownload() {
        if (this.builder != null) {
            return;
        }
        this.builder = new AlertDialog.Builder(this.context);
        this.builder.setIcon(R.drawable.warning).setTitle(R.string.dialog_btn_exit).setMessage(R.string.downloading_quit);
        this.builder.setPositiveButton(R.string.dialog_btn_exit, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PbDownloadManager.this.downloadTaskList.clear();
                if (PbDownloadManager.this.curFilePath != null) {
                    File file = new File(PbDownloadManager.this.curFilePath);
                    if (file == null || !file.exists()) {
                        return;
                    }
                    if (file.delete()) {
                        AppLog.d("2222", "alertForQuitDownload file success == " + PbDownloadManager.this.curFilePath);
                    }
                }
                if (!PbDownloadManager.this.fileOperation.cancelDownload()) {
                    Toast.makeText((Context)PbDownloadManager.this.context, (int)R.string.dialog_cancel_downloading_failed, (int)0).show();
                    return;
                }
                PbDownloadManager.this.customDownloadDialog.dismissDownloadDialog();
                if (PbDownloadManager.this.downloadProgressTimer != null) {
                    PbDownloadManager.this.downloadProgressTimer.cancel();
                }
                Toast.makeText((Context)PbDownloadManager.this.context, (int)R.string.dialog_cancel_downloading_succeeded, (int)0).show();
                AppLog.d(TAG, "cancel download task and quit download manager");
            }
        });
        this.builder.setNegativeButton(R.string.gallery_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PbDownloadManager.this.builder = null;
            }
        });
        AlertDialog dialog = this.builder.create();
        dialog.setCancelable(false);
        dialog.show();
    }

    public void downloadCompleted() {
        this.curFilePath = null;
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setTitle((CharSequence)this.context.getResources().getString(R.string.download_manager));
        String message = this.context.getResources().getString(R.string.download_complete_result).replace("$1$", String.valueOf(this.downloadSucceed)).replace("$2$", String.valueOf(this.downloadFailed));
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setCancelable(false);
        dialog.show();
    }

    private void updateDownloadMessage() {
        String message = this.context.getResources().getString(R.string.download_progress).replace("$1$", String.valueOf(this.downloadSucceed)).replace("$2$", String.valueOf(this.downloadChooseList.size() - this.downloadSucceed)).replace("$3$", String.valueOf(this.downloadFailed));
        this.customDownloadDialog.setMessage(message);
    }

    class DownloadAsytask
    extends AsyncTask<String, Integer, Boolean> {
        private String TAG = "DownloadAsytask";
        ICatchFile downloadFile;
        private String fileName;
        private String fileType = null;
        private String filePath = null;

        public DownloadAsytask(ICatchFile iCatchFile) {
            this.downloadFile = iCatchFile;
            PbDownloadManager.this.downloadProgressList.addLast(this.downloadFile);
            if (this.downloadFile.getFileType() == 1) {
                this.filePath = Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720photo/";
            } else if (this.downloadFile.getFileType() == 2) {
                this.filePath = Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720video/";
            }
        }

        protected Boolean doInBackground(String ... params) {
            boolean retvalue = false;
            this.fileName = this.downloadFile.getFileName();
            File file = new File(this.filePath);
            if (!file.exists()) {
                file.mkdirs();
            }
            AppLog.d(this.TAG, "start downloadFile=" + this.filePath + this.fileName);
            PbDownloadManager.this.curFilePath = FileTools.chooseUniqueFilename(this.filePath + this.fileName);
            retvalue = PbDownloadManager.this.fileOperation.downloadFile(this.downloadFile, PbDownloadManager.this.curFilePath);
            AppLog.d(this.TAG, "end downloadFile retvalue =" + retvalue);
            if (retvalue) {
                if (this.downloadFile.getFileType() == 2) {
                    AppLog.d(this.TAG, "fileName = " + this.fileName);
                    this.fileType = this.fileName.endsWith(".mov") || this.fileName.endsWith(".MOV") ? "video/mov" : "video/mp4";
                    MediaRefresh.addMediaToDB(PbDownloadManager.this.context, this.filePath + this.downloadFile.getFileName(), this.fileType);
                } else if (this.downloadFile.getFileType() == 1) {
                    MediaRefresh.scanFileAsync(PbDownloadManager.this.context, this.filePath + this.downloadFile.getFileName());
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return retvalue;
        }

        protected void onProgressUpdate(Integer ... progress) {
        }

        protected void onPostExecute(Boolean result) {
            if (!result.booleanValue()) {
                AppLog.d(this.TAG, "receive DOWNLOAD_FAILURE downloadFailed=" + PbDownloadManager.this.downloadFailed);
                PbDownloadManager.this.downloadProgressList.remove(this.downloadFile);
                PbDownloadManager.this.downloadFailed++;
                PbDownloadManager.this.updateDownloadMessage();
            } else {
                PbDownloadManager.this.downloadSucceed++;
                PbDownloadManager.this.updateDownloadMessage();
            }
            PbDownloadManager.this.downloadTaskList.remove(this.downloadFile);
            if (PbDownloadManager.this.downloadTaskList.size() > 0) {
                PbDownloadManager.this.currentDownloadFile = (ICatchFile)PbDownloadManager.this.downloadTaskList.getFirst();
                new DownloadAsytask(PbDownloadManager.this.currentDownloadFile).execute(new String[0]);
            } else {
                if (PbDownloadManager.this.customDownloadDialog != null) {
                    PbDownloadManager.this.customDownloadDialog.dismissDownloadDialog();
                }
                if (PbDownloadManager.this.downloadProgressTimer != null) {
                    PbDownloadManager.this.downloadProgressTimer.cancel();
                }
                PbDownloadManager.this.downloadCompleted();
            }
        }
    }

    class DownloadProgressTask
    extends TimerTask {
        DownloadProgressTask() {
        }

        @Override
        public void run() {
            if (PbDownloadManager.this.downloadProgressList.isEmpty()) {
                return;
            }
            String TAG = "DownloadProgressTask";
            final ICatchFile iCatchFile = (ICatchFile)PbDownloadManager.this.downloadProgressList.getFirst();
            File file = new File(PbDownloadManager.this.curFilePath);
            AppLog.d(TAG, "filename = " + file);
            if (!PbDownloadManager.this.downloadInfoMap.containsKey(iCatchFile)) {
                PbDownloadManager.this.downloadProgressList.removeFirst();
                return;
            }
            long fileLength = file.length();
            if (file != null) {
                if (fileLength == iCatchFile.getFileSize()) {
                    PbDownloadManager.this.downloadProgress = 100L;
                    PbDownloadManager.this.downloadProgressList.removeFirst();
                } else {
                    PbDownloadManager.this.downloadProgress = file.length() * 100L / iCatchFile.getFileSize();
                }
            } else {
                PbDownloadManager.this.downloadProgress = 0L;
            }
            if (!PbDownloadManager.this.downloadInfoMap.containsKey(iCatchFile)) {
                return;
            }
            final DownloadInfo downloadInfo = (DownloadInfo)PbDownloadManager.this.downloadInfoMap.get(iCatchFile);
            downloadInfo.curFileLength = fileLength;
            downloadInfo.progress = (int)PbDownloadManager.this.downloadProgress;
            AppLog.d(TAG, "downloadProgress = " + PbDownloadManager.this.downloadProgress);
            PbDownloadManager.this.downloadManagerHandler.post(new Runnable(){

                @Override
                public void run() {
                    PbDownloadManager.this.downloadInfoMap.put(iCatchFile, downloadInfo);
                    PbDownloadManager.this.downloadManagerAdapter.notifyDataSetChanged();
                }
            });
        }
    }
}

