/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.CameraAction;

import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.SdkApi.CameraAction;
import com.icatch.panorama.SdkApi.CameraProperties;
import java.util.Timer;
import java.util.TimerTask;

public class PhotoCapture {
    private static final String TAG = PhotoCapture.class.getSimpleName();
    private OnStopPreviewListener onStopPreviewListener;
    private static final int TYPE_BURST_CAPTURE = 1;
    private static final int TYPE_NORMAL_CAPTURE = 2;
    private CameraProperties cameraProperties = CameraManager.getInstance().getCurCamera().getCameraProperties();
    private CameraAction cameraAction = CameraManager.getInstance().getCurCamera().getCameraAction();

    public void startCapture() {
        AppLog.i(TAG, "start CameraCaptureThread");
        int delayTime = this.cameraProperties.hasFuction(20498) ? this.cameraProperties.getCurrentCaptureDelay() : 0;
        if (delayTime < 1000) {
            this.onStopPreviewListener.onStop();
        } else if (this.cameraProperties.hasFuction(55280)) {
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    PhotoCapture.this.onStopPreviewListener.onStop();
                }
            };
            Timer timer = new Timer(true);
            timer.schedule(task, delayTime - 500);
        } else {
            this.onStopPreviewListener.onStop();
        }
        int needCaptureCount = 1;
        if (this.cameraProperties.hasFuction(20504)) {
            needCaptureCount = this.cameraProperties.getCurrentAppBurstNum();
        }
        if (needCaptureCount == 1) {
            // empty if block
        }
        int count = delayTime / 1000;
        int timerDelay = 0;
        if (delayTime >= 5000) {
            timerDelay = delayTime;
        } else {
            timerDelay = 0;
            count = delayTime / 500;
        }
        if (delayTime >= 3000) {
            timerDelay = delayTime;
        } else {
            timerDelay = 0;
            count = delayTime / 250;
        }
        this.cameraAction.triggerCapturePhoto();
        AppLog.i(TAG, "delayTime = " + delayTime + " needCaptureCount=" + needCaptureCount);
        AppLog.i(TAG, "end CameraCaptureThread");
    }

    public void addOnStopPreviewListener(OnStopPreviewListener onStopPreviewListener) {
        this.onStopPreviewListener = onStopPreviewListener;
    }

    private class DelayTimerTask
    extends TimerTask {
        private int count;
        private Timer timer;

        public DelayTimerTask(int count, Timer timer) {
            this.count = count;
            this.timer = timer;
        }

        @Override
        public void run() {
            if (this.count-- <= 0 && this.timer != null) {
                this.timer.cancel();
            }
        }
    }

    private class CaptureAudioTask
    extends TimerTask {
        private int burstNumber;
        private int type = 2;

        public CaptureAudioTask(int burstNumber, int type) {
            this.burstNumber = burstNumber;
            this.type = type;
        }

        @Override
        public void run() {
            if (this.type == 2) {
                if (this.burstNumber > 0) {
                    AppLog.i(TAG, "CaptureAudioTask remainBurstNumer =" + this.burstNumber);
                    --this.burstNumber;
                } else {
                    this.cancel();
                }
            } else if (this.burstNumber > 0) {
                AppLog.i(TAG, "CaptureAudioTask remainBurstNumer =" + this.burstNumber);
                --this.burstNumber;
            } else {
                this.cancel();
            }
        }
    }

    public static interface OnStopPreviewListener {
        public void onStop();
    }
}

