/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function;

import android.os.Handler;
import android.util.Log;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.SdkApi.CameraAction;
import com.icatch.panorama.SdkApi.PanoramaControl;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatchtek.control.customer.ICatchCameraListener;
import com.icatchtek.control.customer.type.ICatchCamEvent;
import com.icatchtek.pancam.customer.ICatchIPancamListener;
import com.icatchtek.pancam.customer.type.ICatchGLEvent;

public class SDKEvent {
    private static final String TAG = "SDKEvent";
    public static final int EVENT_BATTERY_ELETRIC_CHANGED = 0;
    public static final int EVENT_CAPTURE_COMPLETED = 1;
    public static final int EVENT_CAPTURE_START = 3;
    public static final int EVENT_SD_CARD_FULL = 4;
    public static final int EVENT_VIDEO_OFF = 5;
    public static final int EVENT_VIDEO_ON = 6;
    public static final int EVENT_FILE_ADDED = 7;
    public static final int EVENT_CONNECTION_FAILURE = 8;
    public static final int EVENT_TIME_LAPSE_STOP = 9;
    public static final int EVENT_SERVER_STREAM_ERROR = 10;
    public static final int EVENT_FILE_DOWNLOAD = 11;
    public static final int EVENT_VIDEO_RECORDING_TIME = 12;
    public static final int EVENT_FW_UPDATE_COMPLETED = 13;
    public static final int EVENT_FW_UPDATE_POWEROFF = 14;
    public static final int EVENT_SEARCHED_NEW_CAMERA = 15;
    public static final int EVENT_SDCARD_REMOVED = 16;
    public static final int EVENT_SDCARD_INSERT = 17;
    public static final int EVENT_VIDEO_PLAY_PTS = 23;
    public static final int EVENT_VIDEO_PLAY_CLOSED = 24;
    public static final int EVENT_MOTOR_FINISHED = 25;
    public static final int EVENT_SHOOT_FINISHED = 26;
    public static final int PTP_ICAT_EVENT_MOTOR_FINISHED = 58117;
    public static final int PTP_ICAT_EVENT_SHOOT_FINISHED = 58118;
    private CameraAction cameraAction;
    private Handler handler;
    private SdcardStateListener sdcardStateListener;
    private BatteryStateListener batteryStateListener;
    private CaptureStartListener captureStartListener;
    private CaptureDoneListener captureDoneListener;
    private VideoOffListener videoOffListener;
    private FileAddedListener fileAddedListener;
    private VideoOnListener videoOnListener;
    private ConnectionFailureListener connectionFailureListener;
    private TimeLapseStopListener timeLapseStopListener;
    private VideoRecordingTimeStartListener videoRecordingTimeStartListener;
    private FileDownloadListener fileDownloadListener;
    private UpdateFWCompletedListener updateFWCompletedListener;
    private UpdateFWPoweroffListener updateFWPoweroffListener;
    private InsertSdcardListener insertSdcardListener;
    private NoSdcardListener noSdcardListener;
    private MotorListener mMotorListener;
    private ShootListener mShootListener;
    private VideoStreamStatusListener videoStreamStatusListener;
    private VideoStreamCloseListener videoStreamCloseListener;
    private CacheStateChangedListener cacheStateChangedListener;
    private CacheProgressListener cacheProgressListener;
    private NetworkDisconnectListener networkDisconnectListener;
    private PanoramaControl panoramaControl;
    private NoEISInformationListener noEISInformationListener;

    public SDKEvent(Handler handler) {
        this.handler = handler;
        this.cameraAction = CameraManager.getInstance().getCurCamera().getCameraAction();
        this.panoramaControl = CameraManager.getInstance().getCurCamera().getPanoramaControl();
    }

    public SDKEvent(Handler handler, PanoramaControl panoramaControl) {
        this.handler = handler;
        this.panoramaControl = panoramaControl;
    }

    public void addEventListener(int iCatchEventID) {
        if (this.cameraAction == null) {
            this.cameraAction = CameraManager.getInstance().getCurCamera().getCameraAction();
        }
        if (iCatchEventID == 17) {
            this.sdcardStateListener = new SdcardStateListener();
            this.cameraAction.addEventListener(17, this.sdcardStateListener);
        } else if (iCatchEventID == 36) {
            this.batteryStateListener = new BatteryStateListener();
            this.cameraAction.addEventListener(36, this.batteryStateListener);
        } else if (iCatchEventID == 82) {
            this.captureStartListener = new CaptureStartListener();
            this.cameraAction.addEventListener(82, this.captureStartListener);
        } else if (iCatchEventID == 35) {
            this.captureDoneListener = new CaptureDoneListener();
            this.cameraAction.addEventListener(35, this.captureDoneListener);
        } else if (iCatchEventID == 34) {
            this.videoOffListener = new VideoOffListener();
            this.cameraAction.addEventListener(34, this.videoOffListener);
        } else if (iCatchEventID == 1) {
            this.fileAddedListener = new FileAddedListener();
            this.cameraAction.addEventListener(1, this.fileAddedListener);
        } else if (iCatchEventID == 33) {
            this.videoOnListener = new VideoOnListener();
            this.cameraAction.addEventListener(33, this.videoOnListener);
        } else if (iCatchEventID == 81) {
            this.timeLapseStopListener = new TimeLapseStopListener();
            this.cameraAction.addEventListener(81, this.timeLapseStopListener);
        } else if (iCatchEventID == 103) {
            this.fileDownloadListener = new FileDownloadListener();
            this.cameraAction.addEventListener(103, this.fileDownloadListener);
        } else if (iCatchEventID == 97) {
            this.updateFWCompletedListener = new UpdateFWCompletedListener();
            this.cameraAction.addEventListener(97, this.updateFWCompletedListener);
        } else if (iCatchEventID == 98) {
            this.updateFWPoweroffListener = new UpdateFWPoweroffListener();
            this.cameraAction.addEventListener(98, this.updateFWPoweroffListener);
        } else if (iCatchEventID == 19) {
            this.noSdcardListener = new NoSdcardListener();
            this.cameraAction.addEventListener(19, this.noSdcardListener);
        } else if (iCatchEventID == 74) {
            this.connectionFailureListener = new ConnectionFailureListener();
            this.cameraAction.addEventListener(74, this.connectionFailureListener);
        } else if (iCatchEventID == 20) {
            this.insertSdcardListener = new InsertSdcardListener();
            this.cameraAction.addEventListener(iCatchEventID, this.insertSdcardListener);
        }
    }

    public void addPanoramaEventListener(int iCatchEventID) {
        switch (iCatchEventID) {
            case 67: {
                this.videoStreamStatusListener = new VideoStreamStatusListener();
                AppLog.d(TAG, "addPanoramaEventListener videoStreamStatusListener");
                this.panoramaControl.addEventListener(67, this.videoStreamStatusListener);
                break;
            }
            case 69: {
                this.videoStreamCloseListener = new VideoStreamCloseListener();
                this.panoramaControl.addEventListener(69, this.videoStreamCloseListener);
                break;
            }
            case 72: {
                this.cacheStateChangedListener = new CacheStateChangedListener();
                this.panoramaControl.addEventListener(72, this.cacheStateChangedListener);
                break;
            }
            case 71: {
                this.cacheProgressListener = new CacheProgressListener();
                this.panoramaControl.addEventListener(71, this.cacheProgressListener);
                break;
            }
            case 97: {
                this.networkDisconnectListener = new NetworkDisconnectListener();
                this.panoramaControl.addEventListener(97, this.networkDisconnectListener);
                break;
            }
            case 78: {
                this.noEISInformationListener = new NoEISInformationListener();
                this.panoramaControl.addEventListener(78, this.noEISInformationListener);
            }
        }
    }

    public void removePanoramaEventListener(int iCatchEventID) {
        switch (iCatchEventID) {
            case 67: {
                if (this.videoStreamStatusListener == null) break;
                this.panoramaControl.removeEventListener(67, this.videoStreamStatusListener);
                this.videoStreamStatusListener = null;
                break;
            }
            case 69: {
                if (this.videoStreamCloseListener == null) break;
                this.panoramaControl.removeEventListener(69, this.videoStreamCloseListener);
                this.videoStreamCloseListener = null;
                break;
            }
            case 72: {
                if (this.cacheStateChangedListener == null) break;
                this.panoramaControl.removeEventListener(72, this.cacheStateChangedListener);
                this.cacheStateChangedListener = null;
                break;
            }
            case 71: {
                if (this.cacheProgressListener == null) break;
                this.panoramaControl.removeEventListener(71, this.cacheProgressListener);
                this.cacheProgressListener = null;
                break;
            }
            case 97: {
                if (this.networkDisconnectListener == null) break;
                this.panoramaControl.removeEventListener(97, this.networkDisconnectListener);
                this.networkDisconnectListener = null;
                break;
            }
            case 78: {
                if (this.noEISInformationListener == null) break;
                this.panoramaControl.removeEventListener(78, this.noEISInformationListener);
                this.noEISInformationListener = null;
            }
        }
    }

    public void addCustomizeEvent(int eventID) {
        switch (eventID) {
            case 20481: {
                this.videoRecordingTimeStartListener = new VideoRecordingTimeStartListener();
                this.cameraAction.addCustomEventListener(eventID, this.videoRecordingTimeStartListener);
                break;
            }
            case 14081: {
                this.insertSdcardListener = new InsertSdcardListener();
                this.cameraAction.addCustomEventListener(eventID, this.insertSdcardListener);
                break;
            }
            case 58117: {
                this.mMotorListener = new MotorListener();
                this.cameraAction.addCustomEventListener(eventID, this.mMotorListener);
                break;
            }
            case 58118: {
                this.mShootListener = new ShootListener();
                this.cameraAction.addCustomEventListener(eventID, this.mShootListener);
            }
        }
    }

    public void delCustomizeEventListener(int eventID) {
        switch (eventID) {
            case 20481: {
                if (this.videoRecordingTimeStartListener == null) break;
                this.cameraAction.delCustomEventListener(eventID, this.videoRecordingTimeStartListener);
                this.videoRecordingTimeStartListener = null;
                break;
            }
            case 14081: {
                if (this.insertSdcardListener == null) break;
                this.cameraAction.delCustomEventListener(eventID, this.insertSdcardListener);
                this.insertSdcardListener = null;
                break;
            }
            case 58117: {
                if (this.mMotorListener == null) break;
                this.cameraAction.delCustomEventListener(eventID, this.mMotorListener);
                this.mMotorListener = null;
                break;
            }
            case 58118: {
                if (this.mShootListener == null) break;
                this.cameraAction.delCustomEventListener(eventID, this.mShootListener);
                this.mShootListener = null;
            }
        }
    }

    public void delEventListener(int iCatchEventID) {
        if (iCatchEventID == 17 && this.sdcardStateListener != null) {
            this.cameraAction.delEventListener(17, this.sdcardStateListener);
            this.sdcardStateListener = null;
        } else if (iCatchEventID == 36 && this.batteryStateListener != null) {
            this.cameraAction.delEventListener(36, this.batteryStateListener);
            this.batteryStateListener = null;
        } else if (iCatchEventID == 35 && this.captureDoneListener != null) {
            this.cameraAction.delEventListener(35, this.captureDoneListener);
            this.captureDoneListener = null;
        } else if (iCatchEventID == 82 && this.captureStartListener != null) {
            this.cameraAction.delEventListener(82, this.captureStartListener);
            this.captureStartListener = null;
        } else if (iCatchEventID == 34 && this.videoOffListener != null) {
            this.cameraAction.delEventListener(34, this.videoOffListener);
            this.videoOffListener = null;
        } else if (iCatchEventID == 1 && this.fileAddedListener != null) {
            this.cameraAction.delEventListener(1, this.fileAddedListener);
            this.fileAddedListener = null;
        } else if (iCatchEventID == 33 && this.videoOnListener != null) {
            this.cameraAction.delEventListener(33, this.videoOnListener);
            this.videoOnListener = null;
        } else if (iCatchEventID == 81 && this.timeLapseStopListener != null) {
            this.cameraAction.delEventListener(81, this.timeLapseStopListener);
            this.timeLapseStopListener = null;
        } else if (iCatchEventID == 103 && this.fileDownloadListener != null) {
            this.cameraAction.delEventListener(103, this.fileDownloadListener);
            this.fileDownloadListener = null;
        } else if (iCatchEventID == 97 && this.updateFWCompletedListener != null) {
            this.cameraAction.delEventListener(97, this.updateFWCompletedListener);
            this.updateFWCompletedListener = null;
        } else if (iCatchEventID == 98 && this.updateFWPoweroffListener != null) {
            this.cameraAction.delEventListener(98, this.updateFWPoweroffListener);
            this.updateFWPoweroffListener = null;
        } else if (iCatchEventID == 19 && this.noSdcardListener != null) {
            this.cameraAction.delEventListener(19, this.noSdcardListener);
            this.noSdcardListener = null;
        } else if (iCatchEventID == 74 && this.connectionFailureListener != null) {
            Log.d((String)"1111", (String)"connectionFailureListener != null");
            this.cameraAction.delEventListener(74, this.connectionFailureListener);
            this.connectionFailureListener = null;
        } else if (iCatchEventID == 20) {
            this.cameraAction.delEventListener(iCatchEventID, this.insertSdcardListener);
            this.insertSdcardListener = null;
        }
    }

    public class ShootListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent iCatchCamEvent) {
            AppLog.i(SDKEvent.TAG, "--------------receive ShootListener");
            SDKEvent.this.handler.obtainMessage(26).sendToTarget();
        }
    }

    public class MotorListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent iCatchCamEvent) {
            AppLog.i(SDKEvent.TAG, "--------------receive MotorListener");
            SDKEvent.this.handler.obtainMessage(25).sendToTarget();
        }
    }

    private class NoEISInformationListener
    implements ICatchIPancamListener {
        private NoEISInformationListener() {
        }

        public void eventNotify(ICatchGLEvent iCatchGLEvent) {
            AppLog.i(SDKEvent.TAG, "--------------receive NoEISInformationListener");
            SDKEvent.this.handler.obtainMessage(1542).sendToTarget();
        }
    }

    private class NetworkDisconnectListener
    implements ICatchIPancamListener {
        private NetworkDisconnectListener() {
        }

        public void eventNotify(ICatchGLEvent iCatchGLEvent) {
            AppLog.i(SDKEvent.TAG, "--------------receive VideoStreamCloseListener");
            SDKEvent.this.handler.obtainMessage(514).sendToTarget();
        }
    }

    public class NoSdcardListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive NoSdcardListener");
            AppInfo.isSdCardExist = false;
            SDKEvent.this.handler.obtainMessage(16).sendToTarget();
            AppLog.i(SDKEvent.TAG, "receive NoSdcardListener GlobalInfo.isSdCard = " + AppInfo.isSdCardExist);
        }
    }

    public class InsertSdcardListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent iCatchCamEvent) {
            AppLog.i(SDKEvent.TAG, "--------------receive InsertSdcardListener");
            AppInfo.isSdCardExist = true;
            SDKEvent.this.handler.obtainMessage(17).sendToTarget();
            AppLog.i(SDKEvent.TAG, "receive InsertSdcardListener GlobalInfo.isSdCard = " + AppInfo.isSdCardExist);
        }
    }

    public class CacheProgressListener
    implements ICatchIPancamListener {
        public void eventNotify(ICatchGLEvent iCatchGLEvent) {
            int temp = new Double(iCatchGLEvent.getDoubleValue1() * 100.0).intValue();
            AppLog.d(SDKEvent.TAG, "receive CacheProgressListener.......temp=" + temp);
            SDKEvent.this.handler.obtainMessage(1538, (int)iCatchGLEvent.getLongValue1(), temp).sendToTarget();
        }
    }

    public class CacheStateChangedListener
    implements ICatchIPancamListener {
        public void eventNotify(ICatchGLEvent iCatchGLEvent) {
            AppLog.d(SDKEvent.TAG, "receive CacheStateChangedListener........iCatchGLEvent.getLongValue1()=" + iCatchGLEvent.getLongValue1());
            SDKEvent.this.handler.obtainMessage(1537, (int)iCatchGLEvent.getLongValue1(), 0).sendToTarget();
        }
    }

    public class VideoStreamCloseListener
    implements ICatchIPancamListener {
        public void eventNotify(ICatchGLEvent iCatchGLEvent) {
            AppLog.i(SDKEvent.TAG, "--------------receive VideoStreamCloseListener");
            SDKEvent.this.handler.obtainMessage(24).sendToTarget();
        }
    }

    public class VideoStreamStatusListener
    implements ICatchIPancamListener {
        public void eventNotify(ICatchGLEvent iCatchGLEvent) {
            SDKEvent.this.handler.obtainMessage(23, (Object)iCatchGLEvent.getDoubleValue1()).sendToTarget();
        }
    }

    public class UpdateFWPoweroffListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive UpdateFWPoweroffListener");
            SDKEvent.this.handler.obtainMessage(14).sendToTarget();
        }
    }

    public class UpdateFWCompletedListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive UpdateFWCompletedListener");
            SDKEvent.this.handler.obtainMessage(13).sendToTarget();
        }
    }

    public class VideoRecordingTimeStartListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive VideoRecordingTimeStartListener");
            SDKEvent.this.handler.obtainMessage(12).sendToTarget();
        }
    }

    public class FileDownloadListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive event:FileDownloadListener");
            Log.d((String)"1111", (String)"receive event:FileDownloadListener");
            SDKEvent.this.handler.obtainMessage(11, (Object)arg0.getFileValue1()).sendToTarget();
        }
    }

    public class ServerStreamErrorListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive event:ServerStreamErrorListener");
            SDKEvent.this.handler.obtainMessage(10).sendToTarget();
        }
    }

    public class TimeLapseStopListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive event:TimeLapseStopListener");
            SDKEvent.this.handler.obtainMessage(9).sendToTarget();
        }
    }

    public class ConnectionFailureListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive event:ConnectionFailureListener");
            SDKEvent.this.handler.obtainMessage(8).sendToTarget();
        }
    }

    public class FileAddedListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive event:FileAddedListener");
            SDKEvent.this.handler.obtainMessage(7).sendToTarget();
        }
    }

    public class VideoOnListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive event:videoON");
            SDKEvent.this.handler.obtainMessage(6).sendToTarget();
        }
    }

    public class VideoOffListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive event:videooff");
            SDKEvent.this.handler.obtainMessage(5).sendToTarget();
        }
    }

    public class CaptureStartListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive event:capture start");
            SDKEvent.this.handler.obtainMessage(3).sendToTarget();
        }
    }

    public class CaptureDoneListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive event:capture done");
            SDKEvent.this.handler.obtainMessage(1).sendToTarget();
        }
    }

    public class BatteryStateListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            AppLog.i(SDKEvent.TAG, "--------------receive event:BatteryStateListener intValue1:" + arg0.getIntValue1() + " intValue2:" + arg0.getIntValue2());
            SDKEvent.this.handler.obtainMessage(0, arg0.getIntValue1(), 0).sendToTarget();
        }
    }

    public class SdcardStateListener
    implements ICatchCameraListener {
        public void eventNotify(ICatchCamEvent arg0) {
            SDKEvent.this.handler.obtainMessage(4).sendToTarget();
            AppLog.i(SDKEvent.TAG, "event: EVENT_SD_CARD_FULL");
        }
    }
}

