/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.Setting;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.net.wifi.WifiManager;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import com.icatch.panorama.Function.BaseProrertys;
import com.icatch.panorama.Function.SDKEvent;
import com.icatch.panorama.Listener.OnSettingCompleteListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.MyCamera.MyCamera;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.CameraAction;
import com.icatch.panorama.SdkApi.CameraProperties;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.GlobalApp.ExitApp;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.appdialog.AppDialog;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatch.panorama.utils.WifiAPUtil;
import com.icatch.panorama.utils.WifiCheck;
import com.icatchtek.reliant.customer.type.ICatchImageSize;
import java.lang.reflect.Field;
import java.util.List;

public class OptionSetting {
    private static final String TAG = OptionSetting.class.getSimpleName();
    private OnSettingCompleteListener onSettingCompleteListener;
    private AlertDialog alertDialog;
    private final SettingHander handler = new SettingHander();
    private SDKEvent sdkEvent;
    static Context context;
    private Activity activity;
    private String wifiSsid;
    private String password;
    private MyCamera myCamera = CameraManager.getInstance().getCurCamera();
    private BaseProrertys baseProrertys = this.myCamera.getBaseProrertys();
    private CameraProperties cameraProperties = this.myCamera.getCameraProperties();
    private CameraAction cameraAction = this.myCamera.getCameraAction();
    private int step = 2000;

    public void addSettingCompleteListener(OnSettingCompleteListener onSettingCompleteListener) {
        this.onSettingCompleteListener = onSettingCompleteListener;
    }

    public void showSettingDialog(int nameId, Activity activity) {
        context = activity;
        this.activity = activity;
        if (nameId == R.string.setting_image_size) {
            Log.d((String)"1111", (String)"setting_image_size");
            this.showImageSizeOptionDialog(context);
        } else if (nameId == R.string.setting_video_size) {
            Log.d((String)"1111", (String)"setting_video_size");
            this.showVideoSizeOptionDialog(context);
        } else if (nameId == R.string.setting_capture_delay) {
            Log.d((String)"1111", (String)"setting_capture_delay");
            this.showDelayTimeOptionDialog(context);
        } else if (nameId == R.string.title_burst) {
            this.showBurstOptionDialog(context);
        } else if (nameId == R.string.title_awb) {
            Log.d((String)"1111", (String)"showWhiteBalanceOptionDialog =");
            this.showWhiteBalanceOptionDialog(context);
        } else if (nameId == R.string.setting_power_supply) {
            this.showElectricityFrequencyOptionDialog(context);
        } else if (nameId == R.string.setting_datestamp) {
            this.showDateStampOptionDialog(context);
        } else if (nameId == R.string.setting_format) {
            if (!this.cameraProperties.isSDCardExist()) {
                this.sdCardIsNotReadyAlert(context);
            } else {
                this.showFormatConfirmDialog(context);
            }
        } else if (nameId == R.string.setting_time_lapse_interval) {
            this.showTimeLapseIntervalDialog(context);
        } else if (nameId == R.string.setting_time_lapse_duration) {
            this.showTimeLapseDurationDialog(context);
        } else if (nameId == R.string.title_timeLapse_mode) {
            this.showTimeLapseModeDialog(context);
        } else if (nameId == R.string.slowmotion) {
            this.showSlowMotionDialog(context);
        } else if (nameId == R.string.upside) {
            this.showUpsideDialog(context);
        } else if (nameId == R.string.camera_wifi_configuration) {
            this.showCameraConfigurationDialog(context);
        } else if (nameId == R.string.setting_update_fw) {
            if (!this.cameraProperties.isSDCardExist()) {
                this.sdCardIsNotReadyAlert(context);
            } else {
                this.showUpdateFWDialog(context);
            }
        } else if (nameId == R.string.setting_auto_download_size_limit) {
            this.showSetDownloadSizeLimitDialog(context);
        } else if (nameId == R.string.setting_enable_wifi_hotspot) {
            this.showEnableWifihotspotDialog();
        }
    }

    public void showEnableWifihotspotDialog() {
        LayoutInflater factory = LayoutInflater.from((Context)context);
        View textEntryView = factory.inflate(R.layout.setting_enable_wifi_hotspot, null);
        final EditText wifiName = (EditText)textEntryView.findViewById(R.id.wifi_ssid);
        final EditText cameraPassword = (EditText)textEntryView.findViewById(R.id.wifi_password);
        AlertDialog.Builder ad1 = new AlertDialog.Builder(context);
        ad1.setTitle(R.string.setting_enable_wifi_hotspot);
        ad1.setIcon(17301659);
        ad1.setView(textEntryView);
        ad1.setCancelable(true);
        ad1.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    Log.d((String)"1111", (String)"KeyEvent.KEYCODE_BACK");
                    try {
                        Field field = dialog.getClass().getSuperclass().getDeclaredField("mShowing");
                        field.setAccessible(true);
                        field.set(dialog, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    dialog.dismiss();
                }
                return false;
            }
        });
        ad1.setPositiveButton(R.string.camera_configuration_set, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int arg1) {
                OptionSetting.this.wifiSsid = wifiName.getText().toString();
                if (OptionSetting.this.wifiSsid.length() > 20) {
                    Toast.makeText((Context)context, (int)R.string.camera_name_limit, (int)1).show();
                    try {
                        Field field = dialog.getClass().getSuperclass().getDeclaredField("mShowing");
                        field.setAccessible(true);
                        field.set(dialog, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                OptionSetting.this.password = cameraPassword.getText().toString();
                if (OptionSetting.this.password.length() > 20) {
                    Toast.makeText((Context)context, (int)R.string.password_limit, (int)1).show();
                    try {
                        Field field = dialog.getClass().getSuperclass().getDeclaredField("mShowing");
                        field.setAccessible(true);
                        field.set(dialog, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                try {
                    Field field = dialog.getClass().getSuperclass().getDeclaredField("mShowing");
                    field.setAccessible(true);
                    field.set(dialog, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                MyProgressDialog.showProgressDialog(context, R.string.action_processing);
                WifiAPUtil.getInstance(context.getApplicationContext()).regitsterHandler(OptionSetting.this.handler);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean ret = OptionSetting.this.cameraProperties.setStringPropertyValue(55348, OptionSetting.this.wifiSsid);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (!ret) {
                            OptionSetting.this.handler.obtainMessage(4098).sendToTarget();
                        }
                        ret = OptionSetting.this.cameraProperties.setStringPropertyValue(55349, OptionSetting.this.password);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        if (!ret) {
                            OptionSetting.this.handler.obtainMessage(4098).sendToTarget();
                        }
                        if (!(ret = OptionSetting.this.cameraProperties.setPropertyValue(55291, 1))) {
                            OptionSetting.this.handler.obtainMessage(4098).sendToTarget();
                            return;
                        }
                        ret = WifiAPUtil.getInstance(context).turnOnWifiAp(OptionSetting.this.wifiSsid, OptionSetting.this.password, WifiAPUtil.WifiSecurityType.WIFICIPHER_WPA2);
                        if (!ret) {
                            OptionSetting.this.handler.obtainMessage(4098).sendToTarget();
                        }
                    }
                }).start();
            }
        });
        ad1.show();
    }

    private void showUpdateFWDialog(final Context context) {
        AppLog.i(TAG, "showUpdateFWDialog");
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage(R.string.setting_updateFW_prompt);
        builder.setNegativeButton(R.string.setting_no, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        builder.setPositiveButton(R.string.setting_yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (OptionSetting.this.sdkEvent == null) {
                    OptionSetting.this.sdkEvent = new SDKEvent(OptionSetting.this.handler);
                }
                OptionSetting.this.sdkEvent.addEventListener(97);
                OptionSetting.this.sdkEvent.addEventListener(98);
                MyProgressDialog.showProgressDialog(context, R.string.setting_update_fw);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        FileTools.copyFile(R.raw.camera_timer);
                        String fileName = Environment.getExternalStorageDirectory().toString() + "/SportCamResoure/sphost.BRN";
                        if (!OptionSetting.this.cameraAction.updateFW(fileName)) {
                            int messageId = R.string.text_operation_success;
                            AlertDialog.Builder updateFWFailedBuilder = new AlertDialog.Builder(context);
                            updateFWFailedBuilder.setMessage(R.string.setting_updatefw_failedInfo);
                            updateFWFailedBuilder.setNegativeButton(R.string.dialog_btn_exit, new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialog, int which) {
                                    Log.d((String)"1111", (String)"update FW has failed,App quit");
                                    ExitApp.getInstance().exit();
                                }
                            });
                            OptionSetting.this.alertDialog = updateFWFailedBuilder.create();
                            OptionSetting.this.alertDialog.setCancelable(false);
                            OptionSetting.this.alertDialog.show();
                        }
                    }
                }).start();
            }
        });
        builder.create().show();
    }

    private void showCameraConfigurationDialog(final Context context) {
        LayoutInflater factory = LayoutInflater.from((Context)context);
        View textEntryView = factory.inflate(R.layout.camera_name_password_set, null);
        final EditText cameraName = (EditText)textEntryView.findViewById(R.id.camera_name);
        final String name = this.cameraProperties.getCameraSsid();
        cameraName.setText((CharSequence)name);
        final EditText cameraPassword = (EditText)textEntryView.findViewById(R.id.wifi_password);
        final String password = this.cameraProperties.getCameraPassword();
        cameraPassword.setText((CharSequence)password);
        AlertDialog.Builder ad1 = new AlertDialog.Builder(context);
        ad1.setTitle(R.string.camera_wifi_configuration);
        ad1.setIcon(17301659);
        ad1.setView(textEntryView);
        ad1.setCancelable(true);
        ad1.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    Log.d((String)"1111", (String)"KeyEvent.KEYCODE_BACK");
                    try {
                        Field field = dialog.getClass().getSuperclass().getDeclaredField("mShowing");
                        field.setAccessible(true);
                        field.set(dialog, true);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    dialog.dismiss();
                }
                return true;
            }
        });
        ad1.setPositiveButton(R.string.camera_configuration_set, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int arg1) {
                String temp1 = cameraName.getText().toString();
                if (temp1.length() > 20) {
                    Toast.makeText((Context)context, (int)R.string.camera_name_limit, (int)1).show();
                    try {
                        Field field = dialog.getClass().getSuperclass().getDeclaredField("mShowing");
                        field.setAccessible(true);
                        field.set(dialog, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                String temp = cameraPassword.getText().toString();
                if (temp.length() > 10 || temp.length() < 8) {
                    Toast.makeText((Context)context, (int)R.string.password_limit, (int)1).show();
                    try {
                        Field field = dialog.getClass().getSuperclass().getDeclaredField("mShowing");
                        field.setAccessible(true);
                        field.set(dialog, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    return;
                }
                try {
                    Field field = dialog.getClass().getSuperclass().getDeclaredField("mShowing");
                    field.setAccessible(true);
                    field.set(dialog, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (!name.equals(cameraName.getText().toString())) {
                    OptionSetting.this.cameraProperties.setCameraSsid(cameraName.getText().toString());
                }
                if (!password.equals(temp)) {
                    OptionSetting.this.cameraProperties.setCameraPassword(cameraPassword.getText().toString());
                }
            }
        });
        ad1.show();
    }

    private void showUpsideDialog(Context context) {
        String title = context.getResources().getString(R.string.upside);
        CharSequence[] upsideUIString = this.baseProrertys.getUpside().getValueList();
        if (upsideUIString == null) {
            AppLog.e(TAG, "upsideUIString == null");
            return;
        }
        int length = upsideUIString.length;
        int curIdx = 0;
        for (int i = 0; i < length; ++i) {
            if (!upsideUIString[i].equals(this.baseProrertys.getUpside().getCurrentUiStringInSetting())) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getUpside().setValueByPosition(arg1);
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, upsideUIString, curIdx, listener, true);
    }

    private void showSlowMotionDialog(Context context) {
        String title = context.getResources().getString(R.string.title_slow_motion);
        CharSequence[] slowmotionUIString = this.baseProrertys.getSlowMotion().getValueList();
        if (slowmotionUIString == null) {
            AppLog.e(TAG, "slowmotionUIString == null");
            return;
        }
        int length = slowmotionUIString.length;
        int curIdx = 0;
        for (int i = 0; i < length; ++i) {
            if (!slowmotionUIString[i].equals(this.baseProrertys.getSlowMotion().getCurrentUiStringInSetting())) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getSlowMotion().setValueByPosition(arg1);
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, slowmotionUIString, curIdx, listener, true);
    }

    private void showTimeLapseModeDialog(Context context) {
        String title = context.getResources().getString(R.string.title_timeLapse_mode);
        CharSequence[] timeLapseModeString = this.baseProrertys.getTimeLapseMode().getValueList();
        if (timeLapseModeString == null) {
            AppLog.e(TAG, "timeLapseModeString == null");
            return;
        }
        int length = timeLapseModeString.length;
        int curIdx = 0;
        for (int i = 0; i < length; ++i) {
            Log.d((String)"tigertiger", (String)("timeLapseModeString[i] =" + timeLapseModeString[i]));
            if (timeLapseModeString[i] == null || !((String)timeLapseModeString[i]).equals(this.baseProrertys.getTimeLapseMode().getCurrentUiStringInSetting())) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                ((OptionSetting)OptionSetting.this).myCamera.timeLapsePreviewMode = arg1;
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.settingTimeLapseModeComplete(arg1);
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
                Log.d((String)"tigertiger", (String)("showTimeLapseModeDialog  timeLapseMode =" + arg1));
            }
        };
        this.showOptionDialog(title, timeLapseModeString, curIdx, listener, true);
    }

    private void showTimeLapseDurationDialog(Context context) {
        String title = context.getResources().getString(R.string.setting_time_lapse_duration);
        CharSequence[] videoTimeLapseDurationString = this.baseProrertys.gettimeLapseDuration().getValueStringList();
        if (videoTimeLapseDurationString == null) {
            AppLog.e(TAG, "videoTimeLapseDurationString == null");
            return;
        }
        int length = videoTimeLapseDurationString.length;
        int curIdx = 0;
        String temp = this.baseProrertys.gettimeLapseDuration().getCurrentValue();
        for (int i = 0; i < length; ++i) {
            if (!videoTimeLapseDurationString[i].equals(temp)) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.gettimeLapseDuration().setValueByPosition(arg1);
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, videoTimeLapseDurationString, curIdx, listener, true);
    }

    private void showTimeLapseIntervalDialog(Context context) {
        String title = context.getResources().getString(R.string.setting_time_lapse_interval);
        CharSequence[] videoTimeLapseIntervalString = this.baseProrertys.getTimeLapseInterval().getValueStringList();
        if (videoTimeLapseIntervalString == null) {
            AppLog.e(TAG, "videoTimeLapseIntervalString == null");
            return;
        }
        int length = videoTimeLapseIntervalString.length;
        int curIdx = 0;
        String temp = this.baseProrertys.getTimeLapseInterval().getCurrentValue();
        for (int i = 0; i < length; ++i) {
            if (!videoTimeLapseIntervalString[i].equals(temp)) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getTimeLapseInterval().setValueByPosition(arg1);
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, videoTimeLapseIntervalString, curIdx, listener, true);
    }

    private void showDelayTimeOptionDialog(Context context, final OnSettingCompleteListener settingCompleteListener) {
        String title = context.getResources().getString(R.string.stream_set_timer);
        CharSequence[] delayTimeUIString = this.baseProrertys.getCaptureDelay().getValueList();
        if (delayTimeUIString == null) {
            AppLog.e(TAG, "delayTimeUIString == null");
            return;
        }
        int length = delayTimeUIString.length;
        int curIdx = 0;
        String temp = this.baseProrertys.getCaptureDelay().getCurrentUiStringInPreview();
        for (int i = 0; i < length; ++i) {
            if (!delayTimeUIString[i].equals(temp)) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getCaptureDelay().setValueByPosition(arg1);
                arg0.dismiss();
                settingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, delayTimeUIString, curIdx, listener, true);
    }

    private void showVideoSizeOptionDialog(Context context, final OnSettingCompleteListener settingCompleteListener) {
        String title = context.getResources().getString(R.string.stream_set_res_vid);
        CharSequence[] videoSizeUIString = this.baseProrertys.getVideoSize().getValueArrayString();
        final List<String> videoSizeValueString = this.baseProrertys.getVideoSize().getValueList();
        if (videoSizeUIString == null) {
            AppLog.e(TAG, "videoSizeUIString == null");
            return;
        }
        int length = videoSizeUIString.length;
        int curIdx = 0;
        for (int i = 0; i < length; ++i) {
            if (!videoSizeUIString[i].equals(this.baseProrertys.getVideoSize().getCurrentUiStringInSetting())) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                String value = (String)videoSizeValueString.get(arg1);
                OptionSetting.this.baseProrertys.getVideoSize().setValue(value);
                arg0.dismiss();
                settingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, videoSizeUIString, curIdx, listener, false);
    }

    private void showImageSizeOptionDialog(Context context, final OnSettingCompleteListener settingCompleteListener) {
        String title = context.getResources().getString(R.string.stream_set_res_photo);
        CharSequence[] imageSizeUIString = this.baseProrertys.getImageSize().getValueArrayString();
        if (imageSizeUIString == null) {
            AppLog.e(TAG, "imageSizeUIString == null");
            return;
        }
        int length = imageSizeUIString.length;
        int curIdx = 0;
        for (int ii = 0; ii < length; ++ii) {
            if (!imageSizeUIString[ii].equals(this.baseProrertys.getImageSize().getCurrentUiStringInSetting())) continue;
            curIdx = ii;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getImageSize().setValueByPosition(arg1);
                arg0.dismiss();
                settingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, imageSizeUIString, curIdx, listener, true);
    }

    public void showImageSizeOptionDialog(Context context) {
        String title = context.getResources().getString(R.string.stream_set_res_photo);
        CharSequence[] imageSizeUIString = this.baseProrertys.getImageSize().getValueArrayString();
        if (imageSizeUIString == null) {
            AppLog.e(TAG, "imageSizeUIString == null");
            return;
        }
        int length = imageSizeUIString.length;
        int curIdx = 0;
        for (int ii = 0; ii < length; ++ii) {
            if (!imageSizeUIString[ii].equals(this.baseProrertys.getImageSize().getCurrentUiStringInSetting())) continue;
            curIdx = ii;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getImageSize().setValueByPosition(arg1);
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, imageSizeUIString, curIdx, listener, true);
    }

    public void showUSBImageSizeOptionDialog(Context context) {
        final String title = context.getResources().getString(R.string.stream_set_res_photo);
        final Handler handler = new Handler();
        final MyCamera myCamera = CameraManager.getInstance().getCurCamera();
        MyProgressDialog.showProgressDialog(context, R.string.action_processing);
        new Thread(new Runnable(){

            @Override
            public void run() {
                final List<ICatchImageSize> list = myCamera.getPanoramaPreviewPlayback().getSupportedImageSize();
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyProgressDialog.closeProgressDialog();
                    }
                });
                if (list == null) {
                    AppLog.e(TAG, "list == null");
                    return;
                }
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        ICatchImageSize size;
                        int ii;
                        int curIdx = 0;
                        CharSequence[] imageSizeUIString = new String[list.size()];
                        ICatchImageSize curImagesize = myCamera.getPanoramaPreviewPlayback().getCurImageSize();
                        if (curImagesize == null) {
                            curIdx = 0;
                        } else {
                            for (ii = 0; ii < list.size(); ++ii) {
                                size = (ICatchImageSize)list.get(ii);
                                if (size.getImageH() != curImagesize.getImageH() || size.getImageW() != curImagesize.getImageW()) continue;
                                curIdx = ii;
                                break;
                            }
                        }
                        for (ii = 0; ii < list.size(); ++ii) {
                            size = (ICatchImageSize)list.get(ii);
                            imageSizeUIString[ii] = size.getImageW() + "x" + size.getImageH();
                        }
                        if (imageSizeUIString == null) {
                            AppLog.e(TAG, "imageSizeUIString == null");
                            return;
                        }
                        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface arg0, int arg1) {
                                myCamera.getPanoramaPreviewPlayback().setImageSize((ICatchImageSize)list.get(arg1));
                                arg0.dismiss();
                                if (OptionSetting.this.onSettingCompleteListener != null) {
                                    OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
                                }
                            }
                        };
                        OptionSetting.this.showOptionDialog(title, imageSizeUIString, curIdx, listener, true);
                    }
                });
            }
        }).start();
    }

    private void showDelayTimeOptionDialog(Context context) {
        String title = context.getResources().getString(R.string.stream_set_timer);
        CharSequence[] delayTimeUIString = this.baseProrertys.getCaptureDelay().getValueList();
        if (delayTimeUIString == null) {
            AppLog.e(TAG, "delayTimeUIString == null");
            return;
        }
        int length = delayTimeUIString.length;
        int curIdx = 0;
        String temp = this.baseProrertys.getCaptureDelay().getCurrentUiStringInPreview();
        for (int i = 0; i < length; ++i) {
            if (!delayTimeUIString[i].equals(temp)) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getCaptureDelay().setValueByPosition(arg1);
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, delayTimeUIString, curIdx, listener, true);
    }

    private void showVideoSizeOptionDialog(Context context) {
        String title = context.getResources().getString(R.string.stream_set_res_vid);
        CharSequence[] videoSizeUIString = this.baseProrertys.getVideoSize().getValueArrayString();
        final List<String> videoSizeValueString = this.baseProrertys.getVideoSize().getValueList();
        if (videoSizeUIString == null) {
            AppLog.e(TAG, "videoSizeUIString == null");
            return;
        }
        int length = videoSizeUIString.length;
        int curIdx = 0;
        for (int i = 0; i < length; ++i) {
            if (!videoSizeUIString[i].equals(this.baseProrertys.getVideoSize().getCurrentUiStringInSetting())) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                String value = (String)videoSizeValueString.get(arg1);
                OptionSetting.this.baseProrertys.getVideoSize().setValue(value);
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.settingVideoSizeComplete();
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, videoSizeUIString, curIdx, listener, false);
    }

    private void showFormatConfirmDialog(final Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage(R.string.setting_format_desc);
        builder.setNegativeButton(R.string.setting_no, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        builder.setPositiveButton(R.string.setting_yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                final Handler handler = new Handler();
                MyProgressDialog.showProgressDialog(context, R.string.setting_format);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        final int messageId = OptionSetting.this.cameraAction.formatStorage() ? R.string.text_operation_success : R.string.text_operation_failed;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                MyProgressDialog.closeProgressDialog();
                                MyToast.show(context, messageId);
                            }
                        });
                    }
                }).start();
            }
        });
        builder.create().show();
    }

    private void showDateStampOptionDialog(Context context) {
        String title = context.getResources().getString(R.string.setting_datestamp);
        CharSequence[] dateStampUIString = this.baseProrertys.getDateStamp().getValueList();
        if (dateStampUIString == null) {
            AppLog.e(TAG, "dateStampUIString == null");
            return;
        }
        int length = dateStampUIString.length;
        int curIdx = 0;
        for (int i = 0; i < length; ++i) {
            if (!dateStampUIString[i].equals(this.baseProrertys.getDateStamp().getCurrentUiStringInSetting())) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getDateStamp().setValueByPosition(arg1);
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, dateStampUIString, curIdx, listener, true);
    }

    private void showElectricityFrequencyOptionDialog(Context context) {
        String title = context.getResources().getString(R.string.setting_power_supply);
        CharSequence[] eleFreUIString = this.baseProrertys.getElectricityFrequency().getValueList();
        if (eleFreUIString == null) {
            AppLog.e(TAG, "eleFreUIString == null");
            return;
        }
        int length = eleFreUIString.length;
        int curIdx = 0;
        for (int i = 0; i < length; ++i) {
            if (!eleFreUIString[i].equals(this.baseProrertys.getElectricityFrequency().getCurrentUiStringInSetting())) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getElectricityFrequency().setValueByPosition(arg1);
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, eleFreUIString, curIdx, listener, true);
    }

    private void showWhiteBalanceOptionDialog(Context context) {
        String title = context.getResources().getString(R.string.title_awb);
        CharSequence[] whiteBalanceUIString = this.baseProrertys.getWhiteBalance().getValueList();
        if (whiteBalanceUIString == null) {
            AppLog.e(TAG, "whiteBalanceUIString == null");
            return;
        }
        int length = whiteBalanceUIString.length;
        int curIdx = 0;
        for (int i = 0; i < length; ++i) {
            if (!whiteBalanceUIString[i].equals(this.baseProrertys.getWhiteBalance().getCurrentUiStringInSetting())) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getWhiteBalance().setValueByPosition(arg1);
                arg0.dismiss();
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, whiteBalanceUIString, curIdx, listener, true);
    }

    private void showBurstOptionDialog(Context context) {
        String title = context.getResources().getString(R.string.title_burst);
        CharSequence[] burstUIString = this.baseProrertys.getBurst().getValueList();
        if (burstUIString == null) {
            AppLog.e(TAG, "burstUIString == null");
            return;
        }
        int length = burstUIString.length;
        int curIdx = 0;
        for (int i = 0; i < length; ++i) {
            if (!burstUIString[i].equals(this.baseProrertys.getBurst().getCurrentUiStringInSetting())) continue;
            curIdx = i;
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface arg0, int arg1) {
                OptionSetting.this.baseProrertys.getBurst().setValueByPosition(arg1);
                arg0.dismiss();
                Log.d((String)"1111", (String)"refresh optionListAdapter!");
                OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
            }
        };
        this.showOptionDialog(title, burstUIString, curIdx, listener, true);
    }

    private void showOptionDialog(CharSequence title, CharSequence[] items, int checkedItem, DialogInterface.OnClickListener listener, boolean cancelable) {
        AlertDialog.Builder optionDialog = new AlertDialog.Builder(GlobalInfo.getInstance().getAppContext());
        optionDialog.setTitle(title).setSingleChoiceItems(items, checkedItem, listener).create();
        optionDialog.show();
        optionDialog.setCancelable(cancelable);
    }

    private void sdCardIsNotReadyAlert(Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setMessage(R.string.dialog_no_sd);
        builder.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        AlertDialog dialog = builder.create();
        dialog.setCancelable(true);
        dialog.show();
    }

    public void showSetDownloadSizeLimitDialog(Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        View contentView = View.inflate((Context)context, (int)R.layout.content_download_size_dialog, null);
        final EditText resetTxv = (EditText)contentView.findViewById(R.id.download_size);
        String value = AppInfo.autoDownloadSizeLimit + "";
        resetTxv.setHint((CharSequence)value);
        builder.setTitle(R.string.setting_auto_download_size_limit);
        builder.setView(contentView);
        builder.setCancelable(false);
        builder.setPositiveButton((CharSequence)context.getResources().getString(R.string.action_save), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (!resetTxv.getText().toString().equals("")) {
                    float sizeLimit;
                    AppInfo.autoDownloadSizeLimit = sizeLimit = Float.parseFloat(resetTxv.getText().toString());
                    OptionSetting.this.onSettingCompleteListener.onOptionSettingComplete();
                }
            }
        });
        builder.setNegativeButton((CharSequence)context.getResources().getString(R.string.gallery_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        builder.create().show();
    }

    public void connectWifi(String ssid, String password) {
        WifiCheck wifiCheck = new WifiCheck(this.activity);
        wifiCheck.openWifi();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
        while (wifiManager.getWifiState() == 2) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        wifiCheck.connectWifi(ssid, password, 8);
    }

    private class SettingHander
    extends Handler {
        private SettingHander() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 13: {
                    AppLog.d(TAG, "receive EVENT_FW_UPDATE_COMPLETED");
                    MyProgressDialog.closeProgressDialog();
                    AlertDialog.Builder builder2 = new AlertDialog.Builder(context);
                    builder2.setMessage(R.string.setting_updatefw_closeAppInfo);
                    builder2.setNegativeButton(R.string.ok, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            Log.d((String)"1111", (String)"update FW completed!");
                        }
                    });
                    OptionSetting.this.alertDialog = builder2.create();
                    OptionSetting.this.alertDialog.setCancelable(false);
                    OptionSetting.this.alertDialog.show();
                    break;
                }
                case 14: {
                    AppLog.d(TAG, "receive EVENT_FW_UPDATE_POWEROFF");
                    OptionSetting.this.sdkEvent.delEventListener(97);
                    OptionSetting.this.sdkEvent.delEventListener(98);
                    AlertDialog.Builder builder3 = new AlertDialog.Builder(context);
                    builder3.setMessage(R.string.setting_updatefw_closeAppInfo);
                    builder3.setNegativeButton(R.string.dialog_btn_exit, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            Log.d((String)"1111", (String)"App quit");
                            ExitApp.getInstance().exit();
                        }
                    });
                    OptionSetting.this.alertDialog = builder3.create();
                    OptionSetting.this.alertDialog.setCancelable(false);
                    OptionSetting.this.alertDialog.show();
                    break;
                }
                case 4098: {
                    MyProgressDialog.closeProgressDialog();
                    MyToast.show(context, R.string.dialog_failed);
                    break;
                }
                case 1: {
                    MyProgressDialog.closeProgressDialog();
                    String ssid = WifiAPUtil.getInstance(context).getValidApSsid();
                    String pw = WifiAPUtil.getInstance(context).getValidPassword();
                    String hint = "wifi hotspot is open:\nSSID = " + ssid + "\nPassword = " + pw + "\nApp will exit, please wait for the camera to connect to the wifi hotspot and click search to enter preview.";
                    AppDialog.showDialogQuit(context, hint);
                    AppInfo.isNeedReconnect = false;
                    WifiAPUtil.getInstance(context.getApplicationContext()).unregitsterHandler();
                    break;
                }
            }
        }
    }
}

