/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.Setting;

import android.content.Context;
import com.icatch.panorama.Function.BaseProrertys;
import com.icatch.panorama.MyCamera.MyCamera;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.CameraFixedInfo;
import com.icatch.panorama.SdkApi.CameraProperties;
import com.icatch.panorama.SdkApi.CameraState;
import com.icatch.panorama.data.entity.SettingMenu;
import java.util.LinkedList;

public class UIDisplaySource {
    public static final int CAPTURE_SETTING_MENU = 1;
    public static final int VIDEO_SETTING_MENU = 2;
    public static final int TIMELAPSE_SETTING_MENU = 3;
    private static UIDisplaySource uiDisplayResource;
    private CameraState cameraState;
    private CameraProperties cameraProperties;
    private BaseProrertys baseProrertys;
    private CameraFixedInfo cameraFixedInfo;
    private MyCamera curCamera;
    private LinkedList<SettingMenu> settingMenuList;

    public static UIDisplaySource getinstance() {
        if (uiDisplayResource == null) {
            uiDisplayResource = new UIDisplaySource();
        }
        return uiDisplayResource;
    }

    public LinkedList<SettingMenu> getList(int type, MyCamera currCamera) {
        this.curCamera = currCamera;
        this.cameraState = currCamera.getCameraState();
        this.cameraProperties = currCamera.getCameraProperties();
        this.baseProrertys = currCamera.getBaseProrertys();
        this.cameraFixedInfo = currCamera.getCameraFixedInfo();
        switch (type) {
            case 1: {
                return this.getForCaptureMode();
            }
            case 2: {
                return this.getForVideoMode();
            }
            case 3: {
                return this.getForTimelapseMode();
            }
        }
        return null;
    }

    public LinkedList<SettingMenu> getForCaptureMode() {
        if (this.settingMenuList == null) {
            this.settingMenuList = new LinkedList();
        } else {
            this.settingMenuList.clear();
        }
        if (this.cameraProperties.hasFuction(20483)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_image_size, this.baseProrertys.getImageSize().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(20498)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_capture_delay, this.baseProrertys.getCaptureDelay().getCurrentUiStringInPreview()));
        }
        if (this.cameraProperties.hasFuction(20485)) {
            this.settingMenuList.add(new SettingMenu(R.string.title_awb, this.baseProrertys.getWhiteBalance().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(54790)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_power_supply, this.baseProrertys.getElectricityFrequency().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(54791)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_datestamp, this.baseProrertys.getDateStamp().getCurrentUiStringInSetting()));
        }
        if (this.cameraState.isSupportImageAutoDownload()) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_auto_download, ""));
            this.settingMenuList.add(new SettingMenu(R.string.setting_auto_download_size_limit, ""));
        }
        this.settingMenuList.add(new SettingMenu(R.string.setting_audio_switch, ""));
        this.settingMenuList.add(new SettingMenu(R.string.setting_format, ""));
        if (this.cameraProperties.hasFuction(54804)) {
            this.settingMenuList.add(new SettingMenu(R.string.upside, this.baseProrertys.getUpside().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(55356)) {
            this.settingMenuList.add(new SettingMenu(R.string.camera_wifi_configuration, ""));
        }
        this.settingMenuList.add(new SettingMenu(R.string.setting_app_version, "F1.1.19_beta2"));
        this.settingMenuList.add(new SettingMenu(R.string.setting_product_name, this.cameraFixedInfo.getCameraName()));
        if (this.cameraProperties.hasFuction(20511)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_firmware_version, this.cameraFixedInfo.getCameraVersion()));
        }
        return this.settingMenuList;
    }

    private LinkedList<SettingMenu> getForVideoMode() {
        if (this.settingMenuList == null) {
            this.settingMenuList = new LinkedList();
        } else {
            this.settingMenuList.clear();
        }
        if (this.cameraProperties.hasFuction(54789)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_video_size, this.baseProrertys.getVideoSize().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(20485)) {
            this.settingMenuList.add(new SettingMenu(R.string.title_awb, this.baseProrertys.getWhiteBalance().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(54790)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_power_supply, this.baseProrertys.getElectricityFrequency().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(54791)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_datestamp, this.baseProrertys.getDateStamp().getCurrentUiStringInSetting()));
        }
        if (this.cameraState.isSupportImageAutoDownload()) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_auto_download, ""));
            this.settingMenuList.add(new SettingMenu(R.string.setting_auto_download_size_limit, ""));
        }
        this.settingMenuList.add(new SettingMenu(R.string.setting_audio_switch, ""));
        this.settingMenuList.add(new SettingMenu(R.string.setting_format, ""));
        this.settingMenuList.add(new SettingMenu(R.string.setting_enable_wifi_hotspot, ""));
        if (this.cameraProperties.hasFuction(54805)) {
            this.settingMenuList.add(new SettingMenu(R.string.slowmotion, this.baseProrertys.getSlowMotion().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(54804)) {
            this.settingMenuList.add(new SettingMenu(R.string.upside, this.baseProrertys.getUpside().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(55356)) {
            this.settingMenuList.add(new SettingMenu(R.string.camera_wifi_configuration, ""));
        }
        this.settingMenuList.add(new SettingMenu(R.string.setting_app_version, "F1.1.19_beta2"));
        this.settingMenuList.add(new SettingMenu(R.string.setting_product_name, this.cameraFixedInfo.getCameraName()));
        if (this.cameraProperties.hasFuction(20511)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_firmware_version, this.cameraFixedInfo.getCameraVersion()));
        }
        return this.settingMenuList;
    }

    public LinkedList<SettingMenu> getForTimelapseMode() {
        if (this.settingMenuList == null) {
            this.settingMenuList = new LinkedList();
        } else {
            this.settingMenuList.clear();
        }
        if (this.curCamera.timeLapsePreviewMode == 0) {
            if (this.cameraProperties.hasFuction(20483)) {
                this.settingMenuList.add(new SettingMenu(R.string.setting_image_size, this.baseProrertys.getImageSize().getCurrentUiStringInSetting()));
            }
        } else if (this.curCamera.timeLapsePreviewMode == 1 && this.cameraProperties.hasFuction(54789)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_video_size, this.baseProrertys.getVideoSize().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(20485)) {
            this.settingMenuList.add(new SettingMenu(R.string.title_awb, this.baseProrertys.getWhiteBalance().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(54790)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_power_supply, this.baseProrertys.getElectricityFrequency().getCurrentUiStringInSetting()));
        }
        if (this.cameraState.isSupportImageAutoDownload()) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_auto_download, ""));
            this.settingMenuList.add(new SettingMenu(R.string.setting_auto_download_size_limit, ""));
        }
        this.settingMenuList.add(new SettingMenu(R.string.setting_audio_switch, ""));
        this.settingMenuList.add(new SettingMenu(R.string.setting_format, ""));
        this.settingMenuList.add(new SettingMenu(R.string.setting_enable_wifi_hotspot, ""));
        if (this.cameraProperties.cameraModeSupport(43)) {
            this.settingMenuList.add(new SettingMenu(R.string.title_timeLapse_mode, this.baseProrertys.getTimeLapseMode().getCurrentUiStringInSetting()));
            this.settingMenuList.add(new SettingMenu(R.string.setting_time_lapse_interval, this.baseProrertys.getTimeLapseInterval().getCurrentValue()));
            this.settingMenuList.add(new SettingMenu(R.string.setting_time_lapse_duration, this.baseProrertys.gettimeLapseDuration().getCurrentValue()));
        }
        if (this.cameraProperties.hasFuction(54804)) {
            this.settingMenuList.add(new SettingMenu(R.string.upside, this.baseProrertys.getUpside().getCurrentUiStringInSetting()));
        }
        if (this.cameraProperties.hasFuction(55356)) {
            this.settingMenuList.add(new SettingMenu(R.string.camera_wifi_configuration, ""));
        }
        this.settingMenuList.add(new SettingMenu(R.string.setting_app_version, "F1.1.19_beta2"));
        this.settingMenuList.add(new SettingMenu(R.string.setting_product_name, this.cameraFixedInfo.getCameraName()));
        if (this.cameraProperties.hasFuction(20511)) {
            this.settingMenuList.add(new SettingMenu(R.string.setting_firmware_version, this.cameraFixedInfo.getCameraVersion()));
        }
        return this.settingMenuList;
    }

    public LinkedList<SettingMenu> getUSBList(Context context) {
        if (this.settingMenuList == null) {
            this.settingMenuList = new LinkedList();
        } else {
            this.settingMenuList.clear();
        }
        this.settingMenuList.add(new SettingMenu(R.string.setting_app_version, "F1.1.19_beta2"));
        return this.settingMenuList;
    }
}

