/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.ThumbnailGetting;

import android.graphics.Bitmap;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.LocalSession;
import com.icatch.panorama.R;
import com.icatch.panorama.utils.BitmapTools;
import com.icatchtek.control.customer.ICatchCameraPlayback;
import com.icatchtek.reliant.customer.type.ICatchFile;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;

public class ThumbnailOperation {
    private static String TAG = "ThumbnailOperation";

    public static Bitmap getVideoThumbnailFromSdk(String videoPath) {
        if (videoPath == null) {
            return null;
        }
        ICatchCameraPlayback cameraPlayback = null;
        AppLog.d(TAG, "start getVideoThumbnailFromSdk");
        Bitmap bitmap = null;
        ICatchFrameBuffer frameBuffer = null;
        int datalength = 0;
        byte[] buffer = null;
        LocalSession.getInstance().prepareCommandSession();
        cameraPlayback = LocalSession.getInstance().getICatchCameraPlayback();
        if (cameraPlayback == null) {
            return null;
        }
        ICatchFile icathfile = new ICatchFile(33, 2, videoPath, "", 0L);
        AppLog.d(TAG, "start getThumbnail videoPath=" + videoPath);
        try {
            frameBuffer = cameraPlayback.getThumbnail(icathfile);
        }
        catch (Exception e) {
            AppLog.d(TAG, "getThumbnail Exception");
            e.printStackTrace();
        }
        AppLog.d(TAG, "frameBuffer=" + frameBuffer);
        if (frameBuffer == null) {
            return null;
        }
        buffer = frameBuffer.getBuffer();
        datalength = frameBuffer.getFrameSize();
        AppLog.d(TAG, "frameBuffer buffer=" + buffer + " datalength=" + datalength);
        if (datalength > 0) {
            bitmap = BitmapTools.decodeByteArray(buffer, 300, 300);
        }
        LocalSession.getInstance().destroyCommandSession();
        AppLog.d(TAG, "end getVideoThumbnailFromSdk bitmap=" + bitmap);
        return bitmap;
    }

    public static Bitmap getVideoThumbnail(String videoPath) {
        AppLog.d(TAG, "start getVideoThumbnail");
        Bitmap bitmap = ThumbnailOperation.getVideoThumbnailFromSdk(videoPath);
        AppLog.d(TAG, "end getVideoThumbnail bitmap=" + bitmap);
        return bitmap;
    }

    public static Bitmap getlocalVideoWallThumbnail(ICatchCameraPlayback iCatchCameraPlayback, String videoPath) {
        AppLog.d(TAG, "start getVideoThumbnail");
        Bitmap bitmap = BitmapTools.getVideoThumbnail(videoPath, 100, 100);
        if (bitmap == null) {
            bitmap = ThumbnailOperation.getLocalVideoThumbnail(iCatchCameraPlayback, videoPath);
        }
        AppLog.d(TAG, "end getVideoThumbnail bitmap=" + bitmap);
        return bitmap;
    }

    public static Bitmap getLocalVideoThumbnail(ICatchCameraPlayback iCatchCameraPlayback, String videoPath) {
        AppLog.d(TAG, "start getLocalVideoThumbnail");
        if (iCatchCameraPlayback == null) {
            return null;
        }
        Bitmap bitmap = null;
        ICatchFrameBuffer frameBuffer = null;
        int datalength = 0;
        byte[] buffer = null;
        ICatchFile icathfile = new ICatchFile(33, 2, videoPath, "", 0L);
        try {
            frameBuffer = iCatchCameraPlayback.getThumbnail(icathfile);
        }
        catch (Exception e) {
            AppLog.d(TAG, "start getLocalVideoThumbnail " + e.getClass().getSimpleName());
            e.printStackTrace();
        }
        if (frameBuffer != null) {
            buffer = frameBuffer.getBuffer();
            datalength = frameBuffer.getFrameSize();
            AppLog.d(TAG, "start getLocalVideoThumbnail buffer=" + buffer + " datalength=" + datalength);
            if (datalength > 0) {
                bitmap = BitmapTools.decodeByteArray(buffer, 160, 160);
            }
        }
        AppLog.d(TAG, "end getLocalVideoThumbnail bitmap=" + bitmap);
        return bitmap;
    }

    public static int getBatteryLevelIcon(int batteryPower) {
        AppLog.d(TAG, "current setBatteryLevelIcon= " + batteryPower);
        int drawableId = -1;
        drawableId = batteryPower <= 0 ? R.drawable.ic_battery_alert_green_24dp : (batteryPower > 0 && batteryPower <= 10 ? R.drawable.video_buttery_10 : (batteryPower > 10 && batteryPower <= 20 ? R.drawable.video_buttery_20 : (batteryPower > 20 && batteryPower <= 30 ? R.drawable.video_buttery_30 : (batteryPower > 30 && batteryPower <= 40 ? R.drawable.video_buttery_40 : (batteryPower > 40 && batteryPower <= 50 ? R.drawable.video_buttery_50 : (batteryPower > 50 && batteryPower <= 60 ? R.drawable.video_buttery_60 : (batteryPower > 60 && batteryPower <= 70 ? R.drawable.video_buttery_70 : (batteryPower > 70 && batteryPower <= 80 ? R.drawable.video_buttery_80 : (batteryPower > 80 && batteryPower <= 90 ? R.drawable.video_buttery_90 : (batteryPower > 90 && batteryPower <= 100 ? R.drawable.video_buttery_100 : R.drawable.ic_battery_charging_full_green_24dp))))))))));
        return drawableId;
    }

    public static String getBatteryLevelText(int batteryLevel) {
        if (batteryLevel <= 0) {
            return "--";
        }
        if (batteryLevel > 100) {
            return "\u5145\u7535\u4e2d";
        }
        return batteryLevel + "%";
    }
}

