/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.USB;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.os.Message;
import android.util.Log;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class USBHost_Feature {
    public static final int USB_VENDOR_ID = 10925;
    public static final int USB_PRODUCT_ID = 25427;
    public static final int USB_UAC_FREQUENCY = 48000;
    public static final int USB_UAC_SAMPLEBIT = 16;
    public static final int USB_UAC_NCHANNELS = 2;
    public static final int HANDLER_USB_DEVICE_ATTACHED_ID = 1;
    public static final String HANDLER_USB_DEVICE_ATTACHED_KEY = "HANDLER_USB_DEVICE_ATTACHED";
    public static final int HANDLER_USB_DEVICE_DETACHED_ID = 2;
    public static final String HANDLER_USB_DEVICE_DETACHED_KEY = "HANDLER_USB_DEVICE_DETACHED";
    private static final String ACTION_USB_PERMISSION_BASE = "com.example.USB_PERMISSION.";
    private final String ACTION_USB_PERMISSION = "com.example.USB_PERMISSION." + this.hashCode();
    private int mVendorID = 10925;
    private int mProductID = 25427;
    private Context context;
    private PendingIntent mPermissionIntent;
    private UsbDevice usbDevice;
    private UsbManager usbManager;
    private UsbDeviceConnection usbDeviceConnection;
    private final BroadcastReceiver usbReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            UsbDevice device;
            String action = intent.getAction();
            if (USBHost_Feature.this.ACTION_USB_PERMISSION.equals(action)) {
                UsbDevice device2 = (UsbDevice)intent.getParcelableExtra("device");
                if (device2 != null) {
                    Log.i((String)"__lib_uvc__", (String)("ACTION_USB_PERMISSION, USBDevice: " + device2));
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                UsbDevice device3 = (UsbDevice)intent.getParcelableExtra("device");
                if (device3 != null) {
                    Message message = new Message();
                    message.what = 1;
                    Bundle data = new Bundle();
                    data.putString(USBHost_Feature.HANDLER_USB_DEVICE_ATTACHED_KEY, USBHost_Feature.generateNameForUsbDevice(device3));
                    message.setData(data);
                    Log.i((String)"__lib_uvc__", (String)("ACTION_USB_DEVICE_ATTACHED, USBDevice: " + device3));
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && (device = (UsbDevice)intent.getParcelableExtra("device")) != null) {
                Message message = new Message();
                message.what = 2;
                Bundle data = new Bundle();
                data.putString(USBHost_Feature.HANDLER_USB_DEVICE_DETACHED_KEY, USBHost_Feature.generateNameForUsbDevice(device));
                message.setData(data);
                Log.i((String)"__lib_uvc__", (String)("ACTION_USB_DEVICE_DETACHED, USBDevice: " + device));
            }
        }
    };

    public USBHost_Feature(Context context) {
        this.context = context;
        this.usbManager = (UsbManager)context.getSystemService("usb");
    }

    public void setUsbDevice(int vendorID, int productID) {
        this.mVendorID = vendorID;
        this.mProductID = productID;
    }

    public boolean hasPermission() {
        this.usbDevice = this.getSpecifiedDevice(this.mVendorID, this.mProductID);
        return this.usbDevice != null && this.usbManager.hasPermission(this.usbDevice);
    }

    public void requestPermission() {
        this.usbDevice = this.getSpecifiedDevice(this.mVendorID, this.mProductID);
        if (this.usbDevice == null) {
            return;
        }
        if (this.hasPermission()) {
            Log.i((String)"__lib_uvc__", (String)"has permission");
            return;
        }
        Log.i((String)"__lib_uvc__", (String)"request permission");
        this.usbManager.requestPermission(this.usbDevice, this.mPermissionIntent);
    }

    public UsbDevice getUsbDevice() {
        this.usbDevice = this.getSpecifiedDevice(this.mVendorID, this.mProductID);
        if (this.usbDevice == null) {
            return null;
        }
        return this.usbDevice;
    }

    public int getProductID() {
        return this.mProductID;
    }

    public int getVendorID() {
        return this.mVendorID;
    }

    public int getFileDescriptor() {
        this.usbDeviceConnection = this.getUsbDeviceConnection();
        if (this.usbDeviceConnection == null) {
            return -1;
        }
        return this.usbDeviceConnection.getFileDescriptor();
    }

    public UsbDeviceConnection getUsbDeviceConnection() {
        if (this.usbDeviceConnection == null) {
            this.usbDevice = this.getSpecifiedDevice(this.mVendorID, this.mProductID);
            if (this.usbDevice == null) {
                return null;
            }
            this.usbDeviceConnection = this.usbManager.openDevice(this.usbDevice);
        }
        return this.usbDeviceConnection;
    }

    public void register() {
        if (this.mPermissionIntent == null) {
            this.mPermissionIntent = PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)0x40000000);
            IntentFilter filter = new IntentFilter(this.ACTION_USB_PERMISSION);
            filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
            filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
            this.context.registerReceiver(this.usbReceiver, filter);
        }
    }

    public void unregister() {
        if (this.mPermissionIntent != null) {
            this.context.unregisterReceiver(this.usbReceiver);
            this.mPermissionIntent = null;
        }
    }

    public static String generateNameForUsbDevice(UsbDevice usbDevice) {
        if (usbDevice == null) {
            return "";
        }
        return USBHost_Feature.generateNameForUsbDevice(usbDevice.getVendorId(), usbDevice.getProductId());
    }

    public static String generateNameForUsbDevice(int vendorID, int productID) {
        return String.format(Locale.getDefault(), "USB[VID:0x%04x PID:0x%04x]", vendorID, productID);
    }

    private UsbDevice getSpecifiedDevice(int mVendorId, int mProductId) {
        HashMap deviceList = this.usbManager.getDeviceList();
        if (deviceList != null) {
            for (UsbDevice device : deviceList.values()) {
                Log.i((String)"__lib_uvc__", (String)("getDeviceList, USBDevice: " + device.getDeviceName()));
                Log.i((String)"__lib_uvc__", (String)("getDeviceList, USBDevice: " + device.getVendorId()));
                Log.i((String)"__lib_uvc__", (String)("getDeviceList, USBDevice: " + device.getProductId()));
                if (device.getVendorId() != mVendorId || device.getProductId() != mProductId) continue;
                return device;
            }
        }
        return null;
    }

    public List<UsbDevice> getExistsUsbDevices() {
        HashMap deviceList = this.usbManager.getDeviceList();
        LinkedList<UsbDevice> usbDevices = new LinkedList<UsbDevice>();
        if (deviceList != null) {
            for (UsbDevice device : deviceList.values()) {
                Log.i((String)"__lib_uvc__", (String)("getDeviceList, USBDevice: " + device.getDeviceName()));
                Log.i((String)"__lib_uvc__", (String)("getDeviceList, USBDevice: " + device.getVendorId()));
                Log.i((String)"__lib_uvc__", (String)("getDeviceList, USBDevice: " + device.getProductId()));
                usbDevices.add(device);
            }
            return usbDevices;
        }
        return null;
    }
}

