/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.USB;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Handler;
import android.util.SparseArray;
import com.icatch.panorama.Function.USB.DeviceFilter;
import com.icatch.panorama.Log.AppLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class USBMonitor {
    private static final boolean DEBUG = true;
    private static final String TAG = "USBMonitor";
    private static final String ACTION_USB_PERMISSION_BASE = "com.serenegiant.USB_PERMISSION.";
    private final String ACTION_USB_PERMISSION = "com.serenegiant.USB_PERMISSION." + this.hashCode();
    private final ConcurrentHashMap<UsbDevice, UsbControlBlock> mCtrlBlocks = new ConcurrentHashMap();
    private final WeakReference<Context> mWeakContext;
    private final UsbManager mUsbManager;
    private final OnDeviceConnectListener mOnDeviceConnectListener;
    private List<DeviceFilter> mDeviceFilters = new ArrayList<DeviceFilter>();
    private final Handler mHandler = new Handler();
    private IntentFilter filter;
    private final BroadcastReceiver mUsbReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            UsbDevice device;
            String action = intent.getAction();
            if (USBMonitor.this.ACTION_USB_PERMISSION.equals(action)) {
                AppLog.d(USBMonitor.TAG, "ACTION_USB_PERMISSION.");
                USBMonitor uSBMonitor = USBMonitor.this;
                synchronized (uSBMonitor) {
                    UsbDevice device2 = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        AppLog.d(USBMonitor.TAG, "onReceive....EXTRA_PERMISSION_GRANTED!!.");
                        if (device2 != null) {
                            USBMonitor.this.processConnect(device2);
                        }
                    } else {
                        USBMonitor.this.processCancel(device2);
                    }
                }
            } else if ("android.hardware.usb.action.USB_DEVICE_ATTACHED".equals(action)) {
                AppLog.d(USBMonitor.TAG, "ACTION_USB_DEVICE_ATTACHED");
                UsbDevice device3 = (UsbDevice)intent.getParcelableExtra("device");
                USBMonitor.this.processAttach(device3);
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(action) && (device = (UsbDevice)intent.getParcelableExtra("device")) != null) {
                UsbControlBlock ctrlBlock = null;
                ctrlBlock = (UsbControlBlock)USBMonitor.this.mCtrlBlocks.remove(device);
                if (ctrlBlock != null) {
                    ctrlBlock.close();
                }
                USBMonitor.this.mDeviceCounts = 0;
                USBMonitor.this.processDettach(device);
            }
        }
    };
    private volatile int mDeviceCounts = 0;
    private final Runnable mDeviceCheckRunnable = new Runnable(){

        @Override
        public void run() {
            int n = USBMonitor.this.getDeviceCount();
            if (n != USBMonitor.this.mDeviceCounts && n > USBMonitor.this.mDeviceCounts) {
                USBMonitor.this.mDeviceCounts = n;
                if (USBMonitor.this.mOnDeviceConnectListener != null) {
                    USBMonitor.this.mOnDeviceConnectListener.onAttach(null);
                }
            }
            USBMonitor.this.mHandler.postDelayed((Runnable)this, 2000L);
        }
    };

    public USBMonitor(Context context, OnDeviceConnectListener listener) {
        AppLog.d(TAG, "USBMonitor:Constructor");
        this.mWeakContext = new WeakReference<Context>(context);
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
        this.mOnDeviceConnectListener = listener;
        AppLog.d(TAG, "USBMonitor:mUsbManager=" + this.mUsbManager);
    }

    public void destroy() {
        AppLog.i(TAG, "destroy:");
        this.unregister();
        Set keys = this.mCtrlBlocks.keySet();
        if (keys != null) {
            try {
                for (UsbDevice key : keys) {
                    UsbControlBlock ctrlBlock = this.mCtrlBlocks.remove(key);
                    ctrlBlock.close();
                }
            }
            catch (Exception e) {
                AppLog.e(TAG, "destroy:" + e);
            }
            this.mCtrlBlocks.clear();
        }
    }

    public synchronized void register() {
        if (this.filter == null) {
            Context context = (Context)this.mWeakContext.get();
            if (context != null) {
                this.filter = new IntentFilter(this.ACTION_USB_PERMISSION);
                this.filter.addAction("android.hardware.usb.action.USB_DEVICE_ATTACHED");
                this.filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
                context.registerReceiver(this.mUsbReceiver, this.filter);
            }
            this.mDeviceCounts = 0;
            this.mHandler.postDelayed(this.mDeviceCheckRunnable, 1000L);
        }
    }

    public synchronized void unregister() {
        if (this.filter != null) {
            AppLog.i(TAG, "unregisterUSB:");
            Context context = (Context)this.mWeakContext.get();
            if (context != null) {
                context.unregisterReceiver(this.mUsbReceiver);
            }
            this.filter = null;
        }
        this.mDeviceCounts = 0;
        this.mHandler.removeCallbacks(this.mDeviceCheckRunnable);
    }

    public synchronized boolean isRegistered() {
        return this.filter != null;
    }

    public void setDeviceFilter(DeviceFilter filter) {
        this.mDeviceFilters.clear();
        this.mDeviceFilters.add(filter);
    }

    public void setDeviceFilter(List<DeviceFilter> filters) {
        this.mDeviceFilters.clear();
        this.mDeviceFilters.addAll(filters);
    }

    public int getDeviceCount() {
        return this.getDeviceList().size();
    }

    public List<UsbDevice> getDeviceList() {
        return this.getDeviceList(this.mDeviceFilters);
    }

    public List<UsbDevice> getDeviceList(List<DeviceFilter> filters) {
        HashMap deviceList = this.mUsbManager.getDeviceList();
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        if (deviceList != null) {
            for (DeviceFilter filter : filters) {
                for (UsbDevice device : deviceList.values()) {
                    if (filter != null && !filter.matches(device)) continue;
                    result.add(device);
                }
            }
        }
        return result;
    }

    public List<UsbDevice> getDeviceList(DeviceFilter filter) {
        HashMap deviceList = this.mUsbManager.getDeviceList();
        ArrayList<UsbDevice> result = new ArrayList<UsbDevice>();
        AppLog.d(TAG, "getDeviceList size is: " + deviceList.size());
        if (deviceList != null) {
            for (UsbDevice device : deviceList.values()) {
                AppLog.d(TAG, "the device is: " + device);
                if (filter != null && !filter.matches(device)) continue;
                result.add(device);
            }
        }
        AppLog.d(TAG, "getDeviceList result size is: " + result.size());
        return result;
    }

    public final void dumpDevices() {
        HashMap list = this.mUsbManager.getDeviceList();
        if (list != null) {
            Set keys = list.keySet();
            if (keys != null && keys.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String key : keys) {
                    UsbDevice device = (UsbDevice)list.get(key);
                    int num_interface = device != null ? device.getInterfaceCount() : 0;
                    sb.setLength(0);
                    for (int i = 0; i < num_interface; ++i) {
                        sb.append(String.format("interface%d:%s", i, device.getInterface(i).toString()));
                    }
                    AppLog.i(TAG, "key=" + key + ":" + device + ":" + sb.toString());
                }
            } else {
                AppLog.i(TAG, "no device");
            }
        } else {
            AppLog.i(TAG, "no device");
        }
    }

    public boolean hasPermission(UsbDevice device) {
        return device != null && this.mUsbManager.hasPermission(device);
    }

    public synchronized void requestPermission(UsbDevice device) {
        AppLog.d(TAG, "requestPermission:device=" + device);
        if (this.filter != null) {
            if (device != null) {
                AppLog.d(TAG, "mUsbManager.hasPermission( device )=" + this.mUsbManager.hasPermission(device));
                if (this.mUsbManager.hasPermission(device)) {
                    AppLog.d(TAG, "processConnect not from broadcaster");
                    this.processConnect(device);
                } else {
                    AppLog.d(TAG, "do not has permission,so  requestPermission");
                    PendingIntent permissionIntent = PendingIntent.getBroadcast((Context)((Context)this.mWeakContext.get()), (int)0, (Intent)new Intent(this.ACTION_USB_PERMISSION), (int)0);
                    this.mUsbManager.requestPermission(device, permissionIntent);
                }
            } else {
                this.processCancel(device);
            }
        } else {
            this.processCancel(device);
        }
    }

    private final void processConnect(final UsbDevice device) {
        AppLog.d(TAG, "processConnect:");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                boolean createNew;
                UsbControlBlock ctrlBlock = (UsbControlBlock)USBMonitor.this.mCtrlBlocks.get(device);
                if (ctrlBlock == null) {
                    ctrlBlock = new UsbControlBlock(USBMonitor.this, device);
                    USBMonitor.this.mCtrlBlocks.put(device, ctrlBlock);
                    createNew = true;
                } else {
                    createNew = false;
                }
                if (USBMonitor.this.mOnDeviceConnectListener != null) {
                    UsbControlBlock ctrlB = ctrlBlock;
                    USBMonitor.this.mOnDeviceConnectListener.onConnect(device, ctrlB, createNew);
                }
            }
        });
    }

    private final void processCancel(UsbDevice device) {
        AppLog.d(TAG, "processCancel:");
        if (this.mOnDeviceConnectListener != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onCancel();
                }
            });
        }
    }

    private final void processAttach(final UsbDevice device) {
        AppLog.d(TAG, "processAttach:");
        if (this.mOnDeviceConnectListener != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onAttach(device);
                }
            });
        }
    }

    private final void processDettach(final UsbDevice device) {
        AppLog.d(TAG, "processDettach:");
        if (this.mOnDeviceConnectListener != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    USBMonitor.this.mOnDeviceConnectListener.onDettach(device);
                }
            });
        }
    }

    public static final class UsbControlBlock {
        private final WeakReference<USBMonitor> mWeakMonitor;
        private final WeakReference<UsbDevice> mWeakDevice;
        protected UsbDeviceConnection mConnection;
        private final SparseArray<UsbInterface> mInterfaces = new SparseArray();

        public UsbControlBlock(USBMonitor monitor, UsbDevice device) {
            AppLog.i(USBMonitor.TAG, "UsbControlBlock:constructor");
            this.mWeakMonitor = new WeakReference<USBMonitor>(monitor);
            this.mWeakDevice = new WeakReference<UsbDevice>(device);
            this.mConnection = monitor.mUsbManager.openDevice(device);
            String name = device.getDeviceName();
            if (this.mConnection != null) {
                int desc = this.mConnection.getFileDescriptor();
                byte[] rawDesc = this.mConnection.getRawDescriptors();
                AppLog.i(USBMonitor.TAG, "UsbControlBlock:name=" + name + ", desc=" + desc + ", rawDesc=" + rawDesc);
            } else {
                AppLog.e(USBMonitor.TAG, "could not connect to device " + name);
            }
        }

        public UsbDevice getDevice() {
            return (UsbDevice)this.mWeakDevice.get();
        }

        public String getDeviceName() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getDeviceName() : "";
        }

        public UsbDeviceConnection getUsbDeviceConnection() {
            return this.mConnection;
        }

        public synchronized int getFileDescriptor() {
            return this.mConnection != null ? this.mConnection.getFileDescriptor() : -1;
        }

        public byte[] getRawDescriptors() {
            return this.mConnection != null ? this.mConnection.getRawDescriptors() : null;
        }

        public int getVenderId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getVendorId() : 0;
        }

        public int getProductId() {
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            return device != null ? device.getProductId() : 0;
        }

        public synchronized String getSerial() {
            return this.mConnection != null ? this.mConnection.getSerial() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized UsbInterface open(int interfaceIndex) {
            AppLog.i(USBMonitor.TAG, "UsbControlBlock#open:" + interfaceIndex);
            UsbDevice device = (UsbDevice)this.mWeakDevice.get();
            UsbInterface intf = null;
            intf = (UsbInterface)this.mInterfaces.get(interfaceIndex);
            if (intf == null && (intf = device.getInterface(interfaceIndex)) != null) {
                SparseArray<UsbInterface> sparseArray = this.mInterfaces;
                synchronized (sparseArray) {
                    this.mInterfaces.append(interfaceIndex, (Object)intf);
                }
            }
            return intf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(int interfaceIndex) {
            UsbInterface intf = null;
            SparseArray<UsbInterface> sparseArray = this.mInterfaces;
            synchronized (sparseArray) {
                intf = (UsbInterface)this.mInterfaces.get(interfaceIndex);
                if (intf != null) {
                    this.mInterfaces.delete(interfaceIndex);
                    this.mConnection.releaseInterface(intf);
                }
            }
        }

        public synchronized void close() {
            AppLog.i(USBMonitor.TAG, "UsbControlBlock#close:");
            if (this.mConnection != null) {
                int n = this.mInterfaces.size();
                for (int i = 0; i < n; ++i) {
                    int key = this.mInterfaces.keyAt(i);
                    UsbInterface intf = (UsbInterface)this.mInterfaces.get(key);
                    this.mConnection.releaseInterface(intf);
                }
                this.mConnection.close();
                this.mConnection = null;
                USBMonitor monitor = (USBMonitor)this.mWeakMonitor.get();
                if (monitor != null) {
                    if (monitor.mOnDeviceConnectListener != null) {
                        UsbDevice device = (UsbDevice)this.mWeakDevice.get();
                        monitor.mOnDeviceConnectListener.onDisconnect(device, this);
                    }
                    monitor.mCtrlBlocks.remove(this.getDevice());
                }
            }
        }
    }

    public static interface OnDeviceConnectListener {
        public void onAttach(UsbDevice var1);

        public void onDettach(UsbDevice var1);

        public void onConnect(UsbDevice var1, UsbControlBlock var2, boolean var3);

        public void onDisconnect(UsbDevice var1, UsbControlBlock var2);

        public void onCancel();
    }
}

