/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.streaming;

import android.media.MediaCodec;
import android.view.Surface;
import com.icatch.panorama.Function.streaming.H264DecoderThread;
import com.icatch.panorama.Function.streaming.MjpgDecoderThread;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.SdkApi.PanoramaPreviewPlayback;
import com.icatch.panorama.SdkApi.StreamProvider;
import com.icatch.panorama.data.type.Tristate;
import com.icatch.panorama.ui.view.TextureVideoView;
import com.icatchtek.pancam.customer.stream.ICatchIStreamProvider;
import com.icatchtek.reliant.customer.type.ICatchStreamParam;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;

public class CameraStreaming {
    private final String TAG = CameraStreaming.class.getSimpleName();
    private PanoramaPreviewPlayback previewPlayback;
    private ICatchIStreamProvider iCatchIStreamProvider;
    private StreamProvider streamProvider;
    private TextureVideoView surface;
    private MediaCodec decoder;
    private boolean isStreaming = false;
    private boolean freezeDecoder = false;
    private H264DecoderThread h264DecoderThread;
    private MjpgDecoderThread mjpgDecoderThread;
    private ICatchVideoFormat videoFormat;
    private int frmW = 0;
    private int frmH = 0;
    private int viewWidth = 0;
    private int viewHeigth = 0;
    private int previewCodec;

    public CameraStreaming(PanoramaPreviewPlayback previewPlayback) {
        this.previewPlayback = previewPlayback;
    }

    public void setSurface(TextureVideoView surface) {
        this.surface = surface;
        AppLog.d(this.TAG, "initSurface: " + (Object)((Object)surface));
    }

    public void setViewParam(int w, int h) {
        this.viewWidth = w;
        this.viewHeigth = h;
    }

    public void disnableRender() {
        this.iCatchIStreamProvider = this.previewPlayback.disableRender();
        this.streamProvider = new StreamProvider(this.iCatchIStreamProvider);
    }

    public Tristate start(ICatchStreamParam param, boolean enableAudio) {
        AppLog.d(this.TAG, "startStreaming, enableAudio: " + enableAudio);
        if (this.surface == null) {
            AppLog.e(this.TAG, "surface is not set");
            return Tristate.FALSE;
        }
        if (this.isStreaming) {
            AppLog.d(this.TAG, "apv streaming already started");
            return Tristate.NORMAL;
        }
        Tristate ret = this.previewPlayback.start(param, enableAudio);
        AppLog.d(this.TAG, "sdk start streamProvider ret =" + (Object)((Object)ret));
        if (ret != Tristate.NORMAL) {
            return ret;
        }
        AppLog.d(this.TAG, "sdk start streamProvider OK");
        try {
            this.videoFormat = this.streamProvider.getVideoFormat();
            if (this.videoFormat != null) {
                this.frmW = this.videoFormat.getVideoW();
                this.frmH = this.videoFormat.getVideoH();
            }
            this.startDecoderThread(2, this.videoFormat);
        }
        catch (Exception e) {
            AppLog.e(this.TAG, "get video format err: " + e.getMessage());
            return Tristate.FALSE;
        }
        return Tristate.NORMAL;
    }

    private void startDecoderThread(int previewLaunchMode, ICatchVideoFormat videoFormat) {
        AppLog.i(this.TAG, "start startDecoderThread");
        if (videoFormat == null) {
            AppLog.i(this.TAG, "start startDecoderThread videoFormat=" + videoFormat);
            return;
        }
        boolean enableAudio = this.streamProvider.containsAudioStream();
        this.previewCodec = videoFormat.getCodec();
        AppLog.i(this.TAG, "start startDecoderThread previewCodec=" + this.previewCodec + " enableAudio=" + enableAudio);
        switch (this.previewCodec) {
            case 149: {
                this.mjpgDecoderThread = new MjpgDecoderThread(this.streamProvider, this.surface, previewLaunchMode, this.viewWidth, this.viewHeigth);
                this.mjpgDecoderThread.start(enableAudio, true);
                this.setSurfaceViewArea();
                break;
            }
            case 41: {
                this.h264DecoderThread = new H264DecoderThread(this.streamProvider, new Surface(this.surface.getSurfaceTexture()), previewLaunchMode);
                this.h264DecoderThread.start(enableAudio, true);
                this.setSurfaceViewArea();
                break;
            }
            default: {
                return;
            }
        }
    }

    public boolean stop() {
        AppLog.d(this.TAG, "stopStreaming isStreaming = " + this.isStreaming);
        AppLog.i(this.TAG, "stopMPreview preview");
        if (this.mjpgDecoderThread != null) {
            this.mjpgDecoderThread.stop();
            AppLog.i(this.TAG, "start stopMPreview mjpgDecoderThread.isAlive() =" + this.mjpgDecoderThread.isAlive());
        }
        if (this.h264DecoderThread != null) {
            this.h264DecoderThread.stop();
            AppLog.i(this.TAG, "start stopMPreview h264DecoderThread.isAlive() =" + this.h264DecoderThread.isAlive());
        }
        AppLog.i(this.TAG, "end preview");
        boolean ret = this.previewPlayback.stop();
        this.isStreaming = false;
        return ret;
    }

    public boolean isStreaming() {
        AppLog.d(this.TAG, "get getStream: " + this.isStreaming);
        return this.isStreaming;
    }

    public void setSurfaceViewArea() {
        AppLog.e(this.TAG, "setSurfaceViewArea viewWidth=" + this.viewWidth + " viewHeigth=" + this.viewHeigth + " frmW=" + this.frmW + " frmH=" + this.frmH + " previewCodec=" + this.previewCodec);
        if (this.viewWidth <= 0 || this.viewHeigth <= 0) {
            return;
        }
        if (this.frmH <= 0 || this.frmW <= 0) {
            AppLog.e(this.TAG, "setSurfaceViewArea frmW or frmH <= 0!!!");
            this.surface.setFixedSize(this.viewWidth, this.viewWidth * 9 / 16);
            return;
        }
        if (this.previewCodec == 149) {
            if (this.mjpgDecoderThread != null) {
                this.mjpgDecoderThread.redrawBitmap(this.surface, this.viewWidth, this.viewHeigth);
            }
        } else if (this.previewCodec == 41) {
            this.surface.adjustAspectRatio(this.frmW * this.viewWidth / this.frmH, this.viewWidth);
        }
        AppLog.d(this.TAG, "end setSurfaceViewArea");
    }
}

