/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.streaming;

import android.media.AudioTrack;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.util.Log;
import android.view.Surface;
import com.icatch.panorama.Listener.VideoFramePtsChangedListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.SdkApi.StreamProvider;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.type.ICatchAudioFormat;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;
import java.io.IOException;
import java.nio.ByteBuffer;

public class H264DecoderThread {
    private static final String TAG = "H264DecoderThread";
    private StreamProvider streamProvider;
    private Surface surface;
    private VideoThread videoThread;
    private AudioThread audioThread;
    private boolean audioPlayFlag = false;
    private int BUFFER_LENGTH = 3686400;
    private int timeout = 20000;
    private MediaCodec decoder;
    private int previewLaunchMode;
    private ICatchVideoFormat videoFormat;
    private int frameWidth;
    private int frameHeight;
    private VideoFramePtsChangedListener framePtsChangedListener;
    long videoShowtime = 0L;
    double curVideoPts = 0.0;

    public H264DecoderThread(StreamProvider streamProvider, Surface surface, int previewLaunchMode) {
        this.surface = surface;
        this.streamProvider = streamProvider;
        this.previewLaunchMode = previewLaunchMode;
        this.videoFormat = streamProvider.getVideoFormat();
        if (this.videoFormat != null) {
            this.frameWidth = this.videoFormat.getVideoW();
            this.frameHeight = this.videoFormat.getVideoH();
        }
    }

    public void setframePtsChangedListener(VideoFramePtsChangedListener framePtsChangedListener) {
        this.framePtsChangedListener = framePtsChangedListener;
    }

    public void start(boolean enableAudio, boolean enableVideo) {
        AppLog.i(TAG, "start");
        this.setFormat();
        if (enableAudio) {
            this.audioThread = new AudioThread();
            this.audioThread.start();
        }
        if (enableVideo) {
            this.videoThread = new VideoThread();
            this.videoThread.start();
        }
    }

    public boolean isAlive() {
        if (this.videoThread != null && this.videoThread.isAlive()) {
            return true;
        }
        return this.audioThread != null && this.audioThread.isAlive();
    }

    public void stop() {
        if (this.audioThread != null) {
            this.audioThread.requestExitAndWait();
        }
        if (this.videoThread != null) {
            this.videoThread.requestExitAndWait();
        }
        this.audioPlayFlag = false;
    }

    private void setFormat() {
        ICatchVideoFormat videoFormat = this.videoFormat;
        AppLog.i(TAG, "create  MediaFormat");
        int w = videoFormat.getVideoW();
        int h = videoFormat.getVideoH();
        String type = videoFormat.getMineType();
        MediaFormat format = MediaFormat.createVideoFormat((String)type, (int)w, (int)h);
        if (this.previewLaunchMode == 2) {
            format.setByteBuffer("csd-0", ByteBuffer.wrap(videoFormat.getCsd_0(), 0, videoFormat.getCsd_0_size()));
            format.setByteBuffer("csd-1", ByteBuffer.wrap(videoFormat.getCsd_1(), 0, videoFormat.getCsd_0_size()));
            format.setInteger("durationUs", videoFormat.getDurationUs());
            format.setInteger("max-input-size", videoFormat.getMaxInputSize());
        }
        String ret = videoFormat.getMineType();
        Log.i((String)TAG, (String)("h264 videoFormat.getMineType()=" + ret));
        this.decoder = null;
        try {
            this.decoder = MediaCodec.createDecoderByType((String)ret);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AppLog.d(TAG, "MediaFormat format=" + format);
        this.decoder.configure(format, this.surface, null, 0);
        this.decoder.start();
    }

    private class AudioThread
    extends Thread {
        private boolean done = false;
        private AudioTrack audioTrack;

        private AudioThread() {
        }

        @Override
        public void run() {
            AppLog.i(H264DecoderThread.TAG, "Run AudioThread");
            ICatchAudioFormat audioFormat = H264DecoderThread.this.streamProvider.getAudioFormat();
            if (audioFormat == null) {
                AppLog.e(H264DecoderThread.TAG, "Run AudioThread audioFormat is null!");
                return;
            }
            int bufferSize = AudioTrack.getMinBufferSize((int)audioFormat.getFrequency(), (int)(audioFormat.getNChannels() == 2 ? 12 : 4), (int)(audioFormat.getSampleBits() == 16 ? 2 : 3));
            this.audioTrack = new AudioTrack(3, audioFormat.getFrequency(), audioFormat.getNChannels() == 2 ? 12 : 4, audioFormat.getSampleBits() == 16 ? 2 : 3, bufferSize, 1);
            this.audioTrack.play();
            AppLog.i(H264DecoderThread.TAG, "Run AudioThread 3");
            byte[] audioBuffer = new byte[51200];
            ICatchFrameBuffer icatchBuffer = new ICatchFrameBuffer(51200);
            icatchBuffer.setBuffer(audioBuffer);
            boolean ret = false;
            while (!this.done) {
                ret = false;
                try {
                    ret = H264DecoderThread.this.streamProvider.getNextAudioFrame(icatchBuffer);
                }
                catch (IchTryAgainException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception ex) {
                    AppLog.e(H264DecoderThread.TAG, "getNextVideoFrame " + ex.getClass().getSimpleName());
                    ex.printStackTrace();
                    return;
                }
                if (!ret) continue;
                this.audioTrack.write(icatchBuffer.getBuffer(), 0, icatchBuffer.getFrameSize());
            }
            this.audioTrack.stop();
            this.audioTrack.release();
            AppLog.i(H264DecoderThread.TAG, "stopMPreview audio thread");
        }

        public void requestExitAndWait() {
            this.done = true;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class VideoThread
    extends Thread {
        private boolean done = false;
        private MediaCodec.BufferInfo info;
        long startTime = 0L;
        int frameSize = 0;

        VideoThread() {
        }

        @Override
        public void run() {
            AppLog.i(H264DecoderThread.TAG, "h264 run for gettting surface image");
            ByteBuffer[] inputBuffers = H264DecoderThread.this.decoder.getInputBuffers();
            this.info = new MediaCodec.BufferInfo();
            byte[] mPixel = new byte[H264DecoderThread.this.frameWidth * H264DecoderThread.this.frameHeight * 4];
            ICatchFrameBuffer frameBuffer = new ICatchFrameBuffer(H264DecoderThread.this.frameWidth * H264DecoderThread.this.frameHeight * 4);
            frameBuffer.setBuffer(mPixel);
            int inIndex = -1;
            int sampleSize = 0;
            long pts = 0L;
            boolean retvalue = true;
            boolean isFirst = true;
            long lastTime = System.currentTimeMillis();
            long endTime = System.currentTimeMillis();
            while (!this.done) {
                int outBufId;
                retvalue = false;
                H264DecoderThread.this.curVideoPts = -1.0;
                try {
                    retvalue = H264DecoderThread.this.streamProvider.getNextVideoFrame(frameBuffer);
                    if (!retvalue) {
                        continue;
                    }
                }
                catch (IchTryAgainException ex) {
                    ex.printStackTrace();
                    retvalue = false;
                    continue;
                }
                catch (Exception ex) {
                    AppLog.e(H264DecoderThread.TAG, "getNextVideoFrame " + ex.getClass().getSimpleName());
                    ex.printStackTrace();
                    retvalue = false;
                    break;
                }
                if (frameBuffer.getFrameSize() <= 0 || frameBuffer == null) {
                    retvalue = false;
                    continue;
                }
                if (!retvalue) continue;
                inIndex = H264DecoderThread.this.decoder.dequeueInputBuffer((long)H264DecoderThread.this.timeout);
                H264DecoderThread.this.curVideoPts = frameBuffer.getPresentationTime();
                ++this.frameSize;
                if (isFirst) {
                    isFirst = false;
                    this.startTime = System.currentTimeMillis();
                    AppLog.i(H264DecoderThread.TAG, "get first Frame");
                }
                if (inIndex >= 0) {
                    sampleSize = frameBuffer.getFrameSize();
                    pts = (long)(frameBuffer.getPresentationTime() * 1000.0 * 1000.0);
                    ByteBuffer buffer = inputBuffers[inIndex];
                    buffer.clear();
                    buffer.rewind();
                    buffer.put(frameBuffer.getBuffer(), 0, sampleSize);
                    H264DecoderThread.this.decoder.queueInputBuffer(inIndex, 0, sampleSize, pts, 0);
                }
                if ((outBufId = H264DecoderThread.this.decoder.dequeueOutputBuffer(this.info, (long)H264DecoderThread.this.timeout)) < 0) continue;
                H264DecoderThread.this.decoder.releaseOutputBuffer(outBufId, true);
                if (!H264DecoderThread.this.audioPlayFlag) {
                    H264DecoderThread.this.audioPlayFlag = true;
                    H264DecoderThread.this.videoShowtime = System.currentTimeMillis();
                    AppLog.d(H264DecoderThread.TAG, "ok show image!.....................startTime= " + (System.currentTimeMillis() - this.startTime) + " frameSize=" + this.frameSize + " curVideoPts=" + H264DecoderThread.this.curVideoPts);
                }
                if (H264DecoderThread.this.framePtsChangedListener == null) continue;
                H264DecoderThread.this.framePtsChangedListener.onFramePtsChanged(frameBuffer.getPresentationTime());
            }
            try {
                AppLog.i(H264DecoderThread.TAG, "start decoder stop");
                H264DecoderThread.this.decoder.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                AppLog.i(H264DecoderThread.TAG, "start decoder pancamGLRelease");
                H264DecoderThread.this.decoder.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            AppLog.i(H264DecoderThread.TAG, "stopMPreview video thread");
        }

        public boolean dequeueAndRenderOutputBuffer(int outtime) {
            int outIndex = H264DecoderThread.this.decoder.dequeueOutputBuffer(this.info, (long)outtime);
            switch (outIndex) {
                case -3: {
                    return false;
                }
                case -2: {
                    return false;
                }
                case -1: {
                    return false;
                }
                case 1: {
                    return false;
                }
            }
            H264DecoderThread.this.decoder.releaseOutputBuffer(outIndex, true);
            if (!H264DecoderThread.this.audioPlayFlag) {
                H264DecoderThread.this.audioPlayFlag = true;
                H264DecoderThread.this.videoShowtime = System.currentTimeMillis();
                AppLog.d(H264DecoderThread.TAG, "ok show image!.....................startTime= " + (System.currentTimeMillis() - this.startTime) + " frameSize=" + this.frameSize + " curVideoPts=" + H264DecoderThread.this.curVideoPts);
            }
            return true;
        }

        public void requestExitAndWait() {
            AppLog.e(H264DecoderThread.TAG, "H264Decoder requestExitAndWait isAlive=" + this.isAlive());
            this.done = true;
            AppLog.e(H264DecoderThread.TAG, "end  H264Decoder requestExitAndWait");
        }
    }
}

