/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.streaming;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.media.AudioTrack;
import android.view.TextureView;
import com.icatch.panorama.Listener.VideoFramePtsChangedListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.SdkApi.StreamProvider;
import com.icatch.panorama.utils.ScaleTool;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.type.ICatchAudioFormat;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class MjpgDecoderThread {
    private static final String TAG = "MjpgDecoderThread";
    private StreamProvider streamProvider;
    private Bitmap videoFrameBitmap;
    private int frameWidth;
    private int frameHeight;
    private AudioThread audioThread;
    private VideoThread videoThread;
    private int previewLaunchMode;
    private Rect drawFrameRect;
    private ICatchVideoFormat videoFormat;
    private int viewWidth;
    private int viewHeight;
    private VideoFramePtsChangedListener framePtsChangedListener;
    private TextureView mTextureView;

    public MjpgDecoderThread(StreamProvider streamProvider, TextureView textureView, int previewLaunchMode, int viewWidth, int viewHeight) {
        this.streamProvider = streamProvider;
        this.previewLaunchMode = previewLaunchMode;
        this.mTextureView = textureView;
        this.videoFormat = streamProvider.getVideoFormat();
        this.frameWidth = this.videoFormat.getVideoW();
        this.frameHeight = this.videoFormat.getVideoH();
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        AppLog.i(TAG, "start frameHeight=" + this.frameHeight + " frameWidth=" + this.frameWidth);
    }

    public void setframePtsChangedListener(VideoFramePtsChangedListener framePtsChangedListener) {
        this.framePtsChangedListener = framePtsChangedListener;
    }

    public void start(boolean enableAudio, boolean enableVideo) {
        AppLog.i(TAG, "start");
        if (enableAudio) {
            this.audioThread = new AudioThread();
            this.audioThread.start();
        }
        if (enableVideo) {
            this.videoThread = new VideoThread();
            this.videoThread.start();
        }
    }

    public boolean isAlive() {
        if (this.videoThread != null && this.videoThread.isAlive()) {
            return true;
        }
        return this.audioThread != null && this.audioThread.isAlive();
    }

    public void stop() {
        if (this.audioThread != null) {
            this.audioThread.requestExitAndWait();
        }
        if (this.videoThread != null) {
            this.videoThread.requestExitAndWait();
        }
    }

    public void redrawBitmap(TextureView holder, int w, int h) {
        Canvas canvas;
        AppLog.d(TAG, "redrawBitmap w=" + w + " h=" + h);
        AppLog.d(TAG, "redrawBitmap frameWidth=" + this.frameWidth + " frameHeight=" + this.frameHeight);
        AppLog.d(TAG, "redrawBitmap videoFrameBitmap=" + this.videoFrameBitmap);
        this.viewWidth = w;
        this.viewHeight = h;
        if (this.videoFrameBitmap != null && (canvas = holder.lockCanvas()) != null) {
            this.drawFrameRect = ScaleTool.getScaledPosition(this.frameWidth, this.frameHeight, w, h);
            canvas.drawBitmap(this.videoFrameBitmap, null, this.drawFrameRect, null);
            holder.unlockCanvasAndPost(canvas);
        }
    }

    private class AudioThread
    extends Thread {
        private boolean done = false;
        private AudioTrack audioTrack;

        private AudioThread() {
        }

        @Override
        public void run() {
            AppLog.i(MjpgDecoderThread.TAG, "Run AudioThread");
            ICatchAudioFormat audioFormat = MjpgDecoderThread.this.streamProvider.getAudioFormat();
            if (audioFormat == null) {
                AppLog.e(MjpgDecoderThread.TAG, "Run AudioThread audioFormat is null!");
                return;
            }
            int bufferSize = AudioTrack.getMinBufferSize((int)audioFormat.getFrequency(), (int)(audioFormat.getNChannels() == 2 ? 12 : 4), (int)(audioFormat.getSampleBits() == 16 ? 2 : 3));
            this.audioTrack = new AudioTrack(3, audioFormat.getFrequency(), audioFormat.getNChannels() == 2 ? 12 : 4, audioFormat.getSampleBits() == 16 ? 2 : 3, bufferSize, 1);
            this.audioTrack.play();
            AppLog.i(MjpgDecoderThread.TAG, "Run AudioThread 3");
            byte[] audioBuffer = new byte[51200];
            ICatchFrameBuffer icatchBuffer = new ICatchFrameBuffer(51200);
            icatchBuffer.setBuffer(audioBuffer);
            boolean ret = false;
            while (!this.done) {
                ret = false;
                try {
                    ret = MjpgDecoderThread.this.streamProvider.getNextAudioFrame(icatchBuffer);
                }
                catch (IchTryAgainException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (Exception ex) {
                    AppLog.e(MjpgDecoderThread.TAG, "getNextVideoFrame " + ex.getClass().getSimpleName());
                    ex.printStackTrace();
                    return;
                }
                if (!ret) continue;
                this.audioTrack.write(icatchBuffer.getBuffer(), 0, icatchBuffer.getFrameSize());
            }
            this.audioTrack.stop();
            this.audioTrack.release();
            AppLog.i(MjpgDecoderThread.TAG, "stopMPreview audio thread");
        }

        public void requestExitAndWait() {
            this.done = true;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class VideoThread
    extends Thread {
        private boolean done = false;
        private ByteBuffer bmpBuf;
        private byte[] pixelBuf;

        VideoThread() {
            this.pixelBuf = new byte[MjpgDecoderThread.this.frameWidth * MjpgDecoderThread.this.frameHeight * 4];
            this.bmpBuf = ByteBuffer.wrap(this.pixelBuf);
            MjpgDecoderThread.this.videoFrameBitmap = Bitmap.createBitmap((int)MjpgDecoderThread.this.frameWidth, (int)MjpgDecoderThread.this.frameHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            MjpgDecoderThread.this.drawFrameRect = new Rect(0, 0, MjpgDecoderThread.this.frameWidth, MjpgDecoderThread.this.frameHeight);
        }

        @Override
        public void run() {
            AppLog.i(MjpgDecoderThread.TAG, "start running video thread");
            ICatchFrameBuffer buffer = new ICatchFrameBuffer(MjpgDecoderThread.this.frameWidth * MjpgDecoderThread.this.frameHeight * 4);
            buffer.setBuffer(this.pixelBuf);
            boolean ret = false;
            boolean isSaveBitmapToDb = false;
            boolean isFirstFrame = true;
            boolean isStartGet = true;
            long lastTime = System.currentTimeMillis();
            while (!this.done) {
                Canvas canvas;
                ret = false;
                try {
                    ret = MjpgDecoderThread.this.streamProvider.getNextVideoFrame(buffer);
                }
                catch (IchTryAgainException e) {
                    AppLog.e(MjpgDecoderThread.TAG, "IchTryAgainException");
                    e.printStackTrace();
                    continue;
                }
                catch (Exception ex) {
                    AppLog.e(MjpgDecoderThread.TAG, "getNextVideoFrame " + ex.getClass().getSimpleName());
                    ex.printStackTrace();
                    return;
                }
                if (!ret) continue;
                if (buffer == null || buffer.getFrameSize() == 0) {
                    AppLog.e(MjpgDecoderThread.TAG, "getNextVideoFrame buffer == null\n");
                    continue;
                }
                this.bmpBuf.rewind();
                if (MjpgDecoderThread.this.videoFrameBitmap == null) continue;
                if (isFirstFrame) {
                    isFirstFrame = false;
                    AppLog.i(MjpgDecoderThread.TAG, "get first Frame");
                }
                MjpgDecoderThread.this.videoFrameBitmap.copyPixelsFromBuffer((Buffer)this.bmpBuf);
                if (!isSaveBitmapToDb && MjpgDecoderThread.this.videoFrameBitmap != null && MjpgDecoderThread.this.previewLaunchMode == 2) {
                    isSaveBitmapToDb = true;
                }
                if ((canvas = MjpgDecoderThread.this.mTextureView.lockCanvas()) == null) continue;
                MjpgDecoderThread.this.drawFrameRect = ScaleTool.getScaledPosition(MjpgDecoderThread.this.frameWidth, MjpgDecoderThread.this.frameHeight, MjpgDecoderThread.this.viewWidth, MjpgDecoderThread.this.viewHeight);
                canvas.drawBitmap(MjpgDecoderThread.this.videoFrameBitmap, null, MjpgDecoderThread.this.drawFrameRect, null);
                MjpgDecoderThread.this.mTextureView.unlockCanvasAndPost(canvas);
                if (MjpgDecoderThread.this.framePtsChangedListener == null) continue;
                MjpgDecoderThread.this.framePtsChangedListener.onFramePtsChanged(buffer.getPresentationTime());
            }
            AppLog.i(MjpgDecoderThread.TAG, "stopMPreview video thread");
        }

        public void requestExitAndWait() {
            this.done = true;
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

