/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Function.streaming;

import android.view.Surface;
import com.icatch.panorama.Function.streaming.H264DecoderThread;
import com.icatch.panorama.Function.streaming.MjpgDecoderThread;
import com.icatch.panorama.Listener.VideoFramePtsChangedListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.SdkApi.PanoramaVideoPlayback;
import com.icatch.panorama.SdkApi.StreamProvider;
import com.icatch.panorama.ui.view.TextureVideoView;
import com.icatch.panorama.utils.PanoramaTools;
import com.icatchtek.pancam.customer.exception.IchGLFormatNotSupportedException;
import com.icatchtek.pancam.customer.exception.IchGLSurfaceNotSetException;
import com.icatchtek.pancam.customer.stream.ICatchIStreamProvider;
import com.icatchtek.pancam.customer.surface.ICatchSurfaceContext;
import com.icatchtek.reliant.customer.type.ICatchFile;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;

public class VideoStreaming {
    private final String TAG = VideoStreaming.class.getSimpleName();
    private PanoramaVideoPlayback videoPlayback;
    private ICatchIStreamProvider iCatchIStreamProvider;
    private StreamProvider streamProvider;
    private TextureVideoView holder;
    private boolean isStreaming = false;
    private boolean needRelease = true;
    private H264DecoderThread h264DecoderThread;
    private MjpgDecoderThread mjpgDecoderThread;
    private ICatchVideoFormat videoFormat;
    private int frmW = 0;
    private int frmH = 0;
    private int viewWidth = 0;
    private int viewHeigth = 0;
    private int previewCodec;
    private boolean enableRender;
    private ICatchSurfaceContext iCatchSurfaceContext;
    private VideoFramePtsChangedListener framePtsChangedListener = null;

    public VideoStreaming(PanoramaVideoPlayback videoPlayback) {
        this.videoPlayback = videoPlayback;
    }

    public void changePanoramaType(int var1) {
        if (this.enableRender) {
            this.videoPlayback.changePanoramaType(var1);
        }
    }

    public void setFramePtsChangedListener(VideoFramePtsChangedListener framePtsChangedListener) {
        this.framePtsChangedListener = framePtsChangedListener;
    }

    public void initSurface(boolean enableRender, TextureVideoView surfaceHolder, long videoWidth, long videoHeigth) {
        this.enableRender = enableRender;
        this.holder = surfaceHolder;
        if (enableRender) {
            this.iCatchSurfaceContext = new ICatchSurfaceContext(new Surface(surfaceHolder.getSurfaceTexture()));
            if (PanoramaTools.isPanorama(videoWidth, videoHeigth)) {
                this.videoPlayback.enableGLRender();
                this.videoPlayback.initPancamGL(1);
                this.videoPlayback.setSurface(1, this.iCatchSurfaceContext);
            } else {
                this.videoPlayback.enableCommonRender(this.iCatchSurfaceContext);
            }
        } else {
            this.iCatchIStreamProvider = this.videoPlayback.disableRender();
            this.streamProvider = new StreamProvider(this.iCatchIStreamProvider);
        }
    }

    public void setViewParam(int w, int h) {
        this.viewWidth = w;
        this.viewHeigth = h;
        if (this.enableRender) {
            this.setDrawingArea(w, h);
        }
    }

    public void setDrawingArea(int windowW, int windowH) {
        if (this.enableRender && this.iCatchSurfaceContext != null) {
            try {
                this.iCatchSurfaceContext.setViewPort(0, 0, windowW, windowH);
            }
            catch (IchGLSurfaceNotSetException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean play(ICatchFile iCatchFile, boolean disableAudio, boolean isRemote) throws IchGLFormatNotSupportedException {
        AppLog.d(this.TAG, "play enableRender=" + this.enableRender + " iCatchFile=" + iCatchFile + " disableAudio=" + disableAudio + " isRemote=" + isRemote);
        if (this.holder == null) {
            AppLog.e(this.TAG, "surface is not set");
            return false;
        }
        if (this.isStreaming) {
            AppLog.d(this.TAG, "apv streaming already started");
            return false;
        }
        boolean ret = this.videoPlayback.openVideoStream(iCatchFile, disableAudio, isRemote);
        AppLog.d(this.TAG, "start openVideoStream ret =" + ret);
        if (!ret) {
            return false;
        }
        ret = this.videoPlayback.resumePlayback();
        if (!ret) {
            return false;
        }
        this.isStreaming = true;
        this.needRelease = true;
        AppLog.d(this.TAG, "sdk start streamProvider OK");
        if (this.enableRender) {
            return true;
        }
        this.frmW = 0;
        this.frmH = 0;
        for (int times = 0; (this.frmW <= 0 || this.frmH <= 0) && times <= 30; ++times) {
            this.videoFormat = this.streamProvider.getVideoFormat();
            if (this.videoFormat != null) {
                this.frmW = this.videoFormat.getVideoW();
                this.frmH = this.videoFormat.getVideoH();
            }
            AppLog.e(this.TAG, "getVideoFormat frmW=" + this.frmW + " frmH=" + this.frmH);
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this.frmW <= 0 || this.frmH <= 0) {
            AppLog.e(this.TAG, "get video format err: frmW<0 or frmH < 0");
            return false;
        }
        this.startDecoderThread(2, this.videoFormat);
        return true;
    }

    private void startDecoderThread(int previewLaunchMode, ICatchVideoFormat videoFormat) {
        AppLog.i(this.TAG, "start startDecoderThread videoFormat=" + videoFormat);
        if (videoFormat == null) {
            return;
        }
        boolean enableAudio = this.streamProvider.containsAudioStream();
        this.previewCodec = videoFormat.getCodec();
        AppLog.i(this.TAG, "start startDecoderThread previewCodec=" + this.previewCodec + " enableAudio=" + enableAudio);
        switch (this.previewCodec) {
            case 149: {
                this.mjpgDecoderThread = new MjpgDecoderThread(this.streamProvider, this.holder, previewLaunchMode, this.viewWidth, this.viewHeigth);
                this.mjpgDecoderThread.setframePtsChangedListener(this.framePtsChangedListener);
                this.mjpgDecoderThread.start(enableAudio, true);
                this.setSurfaceViewArea();
                break;
            }
            case 41: {
                this.h264DecoderThread = new H264DecoderThread(this.streamProvider, new Surface(this.holder.getSurfaceTexture()), previewLaunchMode);
                this.h264DecoderThread.setframePtsChangedListener(this.framePtsChangedListener);
                this.h264DecoderThread.start(enableAudio, true);
                this.setSurfaceViewArea();
                break;
            }
            default: {
                return;
            }
        }
    }

    public boolean stop() {
        AppLog.d(this.TAG, "stopStreaming enableRender=" + this.enableRender + " isStreaming = " + this.isStreaming);
        AppLog.i(this.TAG, "stopMPreview preview");
        if (!this.enableRender) {
            if (this.mjpgDecoderThread != null) {
                this.mjpgDecoderThread.stop();
                AppLog.i(this.TAG, "start stopMPreview mjpgDecoderThread.isAlive() =" + this.mjpgDecoderThread.isAlive());
            }
            if (this.h264DecoderThread != null) {
                this.h264DecoderThread.stop();
                AppLog.i(this.TAG, "start stopMPreview h264DecoderThread.isAlive() =" + this.h264DecoderThread.isAlive());
            }
            AppLog.i(this.TAG, "end preview");
        }
        if (!this.isStreaming) {
            AppLog.d(this.TAG, "pv streaming already stoped");
            return true;
        }
        this.videoPlayback.pausePlayback();
        boolean ret = this.videoPlayback.stop();
        this.isStreaming = false;
        return ret;
    }

    public boolean release() {
        AppLog.d(this.TAG, "pancamGLRelease enableRender=" + this.enableRender + " needRelease = " + this.needRelease);
        boolean ret = false;
        if (this.needRelease) {
            ret = this.videoPlayback.pancamGLRelease();
            this.needRelease = false;
        }
        return ret;
    }

    public void removeSurface(int iCatchSphereType) {
        if (this.iCatchSurfaceContext != null) {
            this.videoPlayback.removeSurface(iCatchSphereType, this.iCatchSurfaceContext);
            this.iCatchSurfaceContext = null;
        }
    }

    public boolean isStreaming() {
        AppLog.d(this.TAG, "get getStream: " + this.isStreaming);
        return this.isStreaming;
    }

    public void setSurfaceViewArea() {
        AppLog.e(this.TAG, "setSurfaceViewArea enableRender=" + this.enableRender + " viewWidth=" + this.viewWidth + " viewHeigth=" + this.viewHeigth + " frmW=" + this.frmW + " frmH=" + this.frmH + " previewCodec=" + this.previewCodec);
        if (this.enableRender) {
            return;
        }
        if (this.viewWidth <= 0 || this.viewHeigth <= 0) {
            return;
        }
        if (this.holder == null) {
            return;
        }
        if (this.frmH <= 0 || this.frmW <= 0) {
            AppLog.e(this.TAG, "setSurfaceViewArea frmW or frmH <= 0!!!");
            this.holder.setFixedSize(this.viewWidth, this.viewWidth * 9 / 16);
            return;
        }
        if (this.previewCodec == 149) {
            if (this.mjpgDecoderThread != null) {
                this.mjpgDecoderThread.redrawBitmap(this.holder, this.viewWidth, this.viewHeigth);
            }
        } else if (this.previewCodec == 41) {
            if (this.viewWidth * this.frmH / this.frmW <= this.viewHeigth) {
                AppLog.d(this.TAG, "setSurfaceViewArea setFixedSize 01 w=" + this.viewWidth + " h=" + this.viewWidth * this.frmH / this.frmW);
                this.holder.setFixedSize(this.viewWidth, this.viewWidth * this.frmH / this.frmW);
            } else {
                AppLog.d(this.TAG, "setSurfaceViewArea setFixedSize 02 w=" + this.viewHeigth * this.frmW / this.frmH + " h=" + this.viewHeigth);
                this.holder.setFixedSize(this.viewHeigth * this.frmW / this.frmH, this.viewHeigth);
            }
        }
        AppLog.d(this.TAG, "end setSurfaceViewArea");
    }
}

