/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Listener;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Handler;
import com.icatch.panorama.Log.AppLog;

public class WifiListener {
    private String TAG = "WifiListener";
    private WifiReceiver wifiReceiver;
    private Context context;
    private Handler handler;

    public WifiListener(Context context, Handler handler) {
        this.context = context;
        this.handler = handler;
    }

    public void registerReceiver() {
        AppLog.d(this.TAG, "registerReceiver");
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.wifi.STATE_CHANGE");
        filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.wifiReceiver = new WifiReceiver();
        this.context.registerReceiver((BroadcastReceiver)this.wifiReceiver, filter);
    }

    public void unregisterReceiver() {
        AppLog.d(this.TAG, "unregisterReceiver");
        if (this.wifiReceiver != null) {
            this.context.unregisterReceiver((BroadcastReceiver)this.wifiReceiver);
        }
    }

    private class WifiReceiver
    extends BroadcastReceiver {
        private WifiReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (!intent.getAction().equals("android.net.wifi.RSSI_CHANGED")) {
                if (intent.getAction().equals("android.net.wifi.STATE_CHANGE")) {
                    NetworkInfo info = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    if (info.getState().equals((Object)NetworkInfo.State.DISCONNECTED)) {
                        AppLog.d(WifiListener.this.TAG, "\u7f51\u7edc\u8fde\u63a5\u65ad\u5f00");
                        WifiListener.this.handler.obtainMessage(4099, null).sendToTarget();
                    } else if (info.getState().equals((Object)NetworkInfo.State.CONNECTED)) {
                        WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
                        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                        AppLog.d(WifiListener.this.TAG, "\u8fde\u63a5\u5230\u7f51\u7edc " + wifiInfo.getSSID());
                        WifiListener.this.handler.obtainMessage(4100, (Object)wifiInfo).sendToTarget();
                    }
                } else if (intent.getAction().equals("android.net.wifi.WIFI_STATE_CHANGED")) {
                    int wifistate = intent.getIntExtra("wifi_state", 1);
                    if (wifistate == 1) {
                        AppLog.d(WifiListener.this.TAG, "\u7cfb\u7edf\u5173\u95edwifi");
                    } else if (wifistate == 3) {
                        AppLog.d(WifiListener.this.TAG, "\u7cfb\u7edf\u5f00\u542fwifi");
                    }
                }
            }
        }
    }
}

