/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Log;

import android.util.Log;
import com.icatch.panorama.Application.PanoramaSDK;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class AppLog {
    private static String TAG = AppLog.class.getSimpleName();
    private static String writeFile;
    private static FileOutputStream out;
    private static boolean hasConfiguration;
    private static File writeLogFile;
    private static final long maxFileSize = 0x3200000L;
    private static boolean enableLog;

    public static void enableAppLog(boolean flag) {
        enableLog = flag;
        AppLog.initConfiguration();
    }

    private static void initConfiguration() {
        File file;
        File directory = null;
        String fileName = null;
        String path = null;
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss", Locale.CHINA);
        path = PanoramaSDK.getContext().getExternalFilesDir(null) + "/360Cam_APP_Log/";
        if (path != null && !(directory = new File(path)).exists()) {
            directory.mkdirs();
        }
        if (!(file = new File(directory, fileName = sdf.format(date) + ".log")).exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        writeFile = path + fileName;
        writeLogFile = new File(writeFile);
        if (out != null) {
            AppLog.closeWriteStream();
        }
        try {
            out = new FileOutputStream(writeFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        hasConfiguration = true;
        AppLog.i("", sdf.format(date) + "\n");
        AppLog.i("", "F1.1.19_beta2\n");
    }

    public static String getSystemDate() {
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:sss\t");
        return sdf.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void e(String tag, String conent) {
        if (!enableLog) {
            return;
        }
        if (!hasConfiguration) {
            AppLog.initConfiguration();
        }
        if (writeLogFile.length() >= 0x3200000L) {
            AppLog.initConfiguration();
        }
        String temp = "[" + tag + "]" + AppLog.getSystemDate() + ": AppError:" + conent + "\n";
        Log.i((String)TAG, (String)temp);
        try {
            if (out != null) {
                out.write(temp.getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void i(String tag, String conent) {
        if (!enableLog) {
            return;
        }
        if (!hasConfiguration) {
            AppLog.initConfiguration();
        }
        if (writeLogFile.length() >= 0x3200000L) {
            AppLog.initConfiguration();
        }
        String temp = AppLog.getSystemDate() + " AppInfo:[" + tag + "]" + conent + "\n";
        Log.i((String)TAG, (String)temp);
        try {
            if (out != null) {
                out.write(temp.getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void w(String tag, String conent) {
        if (!enableLog) {
            return;
        }
        if (!hasConfiguration) {
            AppLog.initConfiguration();
        }
        if (writeLogFile.length() >= 0x3200000L) {
            AppLog.initConfiguration();
        }
        String temp = "[" + tag + "]" + AppLog.getSystemDate() + ": AppWarning:" + conent + "\n";
        try {
            if (out != null) {
                out.write(temp.getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void d(String tag, String conent) {
        if (!enableLog) {
            return;
        }
        if (!hasConfiguration) {
            AppLog.initConfiguration();
        }
        if (writeLogFile.length() >= 0x3200000L) {
            AppLog.initConfiguration();
        }
        String temp = AppLog.getSystemDate() + "[" + tag + "]:AppDebug:" + conent + "\n";
        Log.i((String)TAG, (String)temp);
        try {
            if (out != null) {
                out.write(temp.getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void closeWriteStream() {
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        out = null;
        hasConfiguration = false;
        writeLogFile = null;
        enableLog = false;
    }
}

