/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.MyCamera;

import android.content.SharedPreferences;
import android.hardware.usb.UsbDevice;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.MyCamera.CameraType;
import com.icatch.panorama.MyCamera.MyCamera;

public class CameraManager {
    private MyCamera curCamera;
    private static CameraManager instance;

    public static synchronized CameraManager getInstance() {
        if (instance == null) {
            instance = new CameraManager();
        }
        return instance;
    }

    public MyCamera getCurCamera() {
        if (this.curCamera == null) {
            SharedPreferences pref = PanoramaSDK.getContext().getSharedPreferences("config", 0);
            this.createCamera(CameraType.PANORAMA_CAMERA, pref.getString("cam_ssid", ""), pref.getString("cam_ip", ""), 1);
        }
        return this.curCamera;
    }

    public void setCurCamera(MyCamera curCamera) {
        this.curCamera = curCamera;
    }

    public void createCamera(int cameraType, String ssid, String ipAddress, int mode) {
        this.curCamera = new MyCamera(cameraType, ssid, ipAddress, mode);
        SharedPreferences pref = PanoramaSDK.getContext().getSharedPreferences("config", 0);
        pref.edit().putString("cam_ip", ipAddress).putString("cam_ssid", ssid).apply();
    }

    public void createUSBCamera(int cameraType, UsbDevice usbDevice) {
        this.curCamera = new MyCamera(cameraType, usbDevice);
    }
}

