/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.MyCamera;

import android.util.Log;
import com.icatch.panorama.Log.AppLog;
import com.icatchtek.control.customer.ICatchCameraSession;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.transport.ICatchITransport;

public class CommandSession {
    private static final String TAG = CommandSession.class.getSimpleName();
    private static int scanflag;
    private static final String tag = "CommandSession";
    private ICatchCameraSession session;
    private String ipAddress;
    private String uid;
    private String username;
    private String password;
    private boolean sessionPrepared = false;

    public CommandSession(String ipAddress, String uid, String username, String password) {
        this.ipAddress = ipAddress;
        this.username = username;
        this.password = password;
        this.uid = uid;
    }

    public CommandSession() {
    }

    public boolean prepareSession(ICatchITransport itrans) {
        try {
            ICatchCameraSession.getCameraConfig((ICatchITransport)itrans).enablePTPIP();
        }
        catch (IchInvalidArgumentException e) {
            e.printStackTrace();
        }
        this.sessionPrepared = true;
        this.session = ICatchCameraSession.createSession();
        boolean retValue = false;
        try {
            retValue = this.session.prepareSession(itrans);
        }
        catch (IchTransportException e) {
            AppLog.d(tag, "IchTransportException");
            e.printStackTrace();
        }
        this.sessionPrepared = retValue;
        AppLog.e(tag, "preparePanoramaSession =" + this.sessionPrepared);
        return retValue;
    }

    public boolean prepareSession(ICatchITransport itrans, boolean enablePTPIP) {
        AppLog.d(TAG, "start prepareSession itrans=" + itrans + " enablePTPIP=" + enablePTPIP);
        if (enablePTPIP) {
            try {
                ICatchCameraSession.getCameraConfig((ICatchITransport)itrans).enablePTPIP();
            }
            catch (IchInvalidArgumentException e) {
                AppLog.e(tag, "enablePTPIP IchInvalidArgumentException");
                e.printStackTrace();
            }
        } else {
            try {
                ICatchCameraSession.getCameraConfig((ICatchITransport)itrans).disablePTPIP();
            }
            catch (IchInvalidArgumentException e) {
                AppLog.e(tag, "disablePTPIP IchInvalidArgumentException");
                e.printStackTrace();
            }
        }
        this.sessionPrepared = true;
        AppLog.d(tag, "start createSession");
        this.session = ICatchCameraSession.createSession();
        boolean retValue = false;
        try {
            retValue = this.session.prepareSession(itrans);
        }
        catch (IchTransportException e) {
            e.printStackTrace();
        }
        if (!retValue) {
            AppLog.e(tag, "failed to preparePanoramaSession");
            this.sessionPrepared = false;
            Log.v((String)"1111", (String)"CommandSession,preparePanoramaSession fail!");
        }
        AppLog.d(tag, "end preparePanoramaSession ret=" + this.sessionPrepared);
        return this.sessionPrepared;
    }

    public ICatchCameraSession getSDKSession() {
        AppLog.d(TAG, "getSDKSession =" + this.session);
        return this.session;
    }

    public boolean checkWifiConnection() {
        AppLog.i(tag, "Start checkWifiConnection");
        boolean retValue = false;
        try {
            retValue = this.session.checkConnection();
        }
        catch (IchInvalidSessionException e) {
            e.printStackTrace();
        }
        AppLog.i(tag, "End checkWifiConnection,retValue=" + retValue);
        return retValue;
    }

    public boolean destroySession() {
        AppLog.i(tag, "Start destroyPanoramaSession");
        Boolean retValue = false;
        try {
            retValue = this.session.destroySession();
            AppLog.i(tag, "End  destroyPanoramaSession,retValue=" + retValue);
        }
        catch (IchInvalidSessionException e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static boolean startDeviceScan() {
        AppLog.i(tag, "Start startDeviceScan");
        boolean tempStartDeviceScanValue = false;
        AppLog.i(tag, "End startDeviceScan,tempStartDeviceScanValue=" + tempStartDeviceScanValue);
        if (tempStartDeviceScanValue) {
            scanflag = 1;
        }
        return tempStartDeviceScanValue;
    }

    public static void stopDeviceScan() {
        AppLog.i(tag, "Start stopDeviceScan");
        boolean tempStopDeviceScanValue = false;
        if (scanflag != 1) {
            tempStopDeviceScanValue = true;
        }
        scanflag = 0;
        AppLog.i(tag, "End stopDeviceScan,tempStopDeviceScanValue=" + tempStopDeviceScanValue);
    }
}

