/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.MyCamera;

import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CommandSession;
import com.icatch.panorama.MyCamera.PanoramaSession;
import com.icatch.panorama.SdkApi.PanoramaControl;
import com.icatch.panorama.SdkApi.PanoramaPhotoPlayback;
import com.icatch.panorama.SdkApi.PanoramaVideoPlayback;
import com.icatchtek.control.customer.ICatchCameraPlayback;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.transport.ICatchINETTransport;
import com.icatchtek.reliant.customer.transport.ICatchITransport;

public class LocalSession {
    private static final String TAG = LocalSession.class.getSimpleName();
    private static LocalSession instance;
    private PanoramaPhotoPlayback panoramaPhotoPlayback;
    private PanoramaVideoPlayback panoramaVideoPlayback;
    private PanoramaControl panoramaControl;
    private PanoramaSession panoramaSession;
    private CommandSession commandSession;
    private ICatchCameraPlayback iCatchCameraPlayback;

    public static synchronized LocalSession getInstance() {
        if (instance == null) {
            instance = new LocalSession();
        }
        return instance;
    }

    private LocalSession() {
    }

    public boolean preparePanoramaSession() {
        boolean ret = false;
        this.panoramaSession = new PanoramaSession();
        ICatchINETTransport transport = new ICatchINETTransport("192.168.1.1");
        ret = this.panoramaSession.prepareSession((ICatchITransport)transport);
        if (ret) {
            this.initPanorama();
        }
        return ret;
    }

    public boolean destroyPanoramaSession() {
        boolean ret = false;
        AppLog.d(TAG, "begin destroyPanoramaSession");
        if (this.panoramaSession != null) {
            ret = this.panoramaSession.destroySession();
            this.panoramaSession = null;
        }
        AppLog.d(TAG, "end destroyPanoramaSession ret=" + ret);
        return ret;
    }

    void initPanorama() {
        this.panoramaVideoPlayback = new PanoramaVideoPlayback(this.panoramaSession.getSession());
        this.panoramaPhotoPlayback = new PanoramaPhotoPlayback(this.panoramaSession.getSession());
        this.panoramaControl = new PanoramaControl(this.panoramaSession.getSession());
    }

    public boolean prepareCommandSession() {
        boolean ret = false;
        this.commandSession = new CommandSession();
        ICatchINETTransport transport = new ICatchINETTransport("192.168.1.1");
        ret = this.commandSession.prepareSession((ICatchITransport)transport, false);
        if (ret) {
            this.initCommand();
        }
        return ret;
    }

    public boolean destroyCommandSession() {
        boolean ret = false;
        if (this.commandSession != null) {
            ret = this.commandSession.destroySession();
            this.commandSession = null;
        }
        return ret;
    }

    void initCommand() {
        try {
            this.iCatchCameraPlayback = this.commandSession.getSDKSession().getPlaybackClient();
        }
        catch (IchInvalidSessionException e) {
            e.printStackTrace();
        }
    }

    public PanoramaVideoPlayback getPanoramaVideoPlayback() {
        return this.panoramaVideoPlayback;
    }

    public PanoramaPhotoPlayback getPanoramaPhotoPlayback() {
        return this.panoramaPhotoPlayback;
    }

    public ICatchCameraPlayback getICatchCameraPlayback() {
        return this.iCatchCameraPlayback;
    }

    public PanoramaControl getPanoramaControl() {
        return this.panoramaControl;
    }
}

