/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.MyCamera;

import android.hardware.usb.UsbDevice;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.Function.BaseProrertys;
import com.icatch.panorama.Function.USB.USBHost_Feature;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraType;
import com.icatch.panorama.MyCamera.CommandSession;
import com.icatch.panorama.MyCamera.PanoramaSession;
import com.icatch.panorama.SdkApi.CameraAction;
import com.icatch.panorama.SdkApi.CameraFixedInfo;
import com.icatch.panorama.SdkApi.CameraProperties;
import com.icatch.panorama.SdkApi.CameraState;
import com.icatch.panorama.SdkApi.FileOperation;
import com.icatch.panorama.SdkApi.PanoramaControl;
import com.icatch.panorama.SdkApi.PanoramaPhotoPlayback;
import com.icatch.panorama.SdkApi.PanoramaPreviewPlayback;
import com.icatch.panorama.SdkApi.PanoramaVideoPlayback;
import com.icatchtek.control.customer.ICatchCameraSession;
import com.icatchtek.pancam.customer.ICatchPancamSession;
import com.icatchtek.reliant.customer.exception.IchInvalidArgumentException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.transport.ICatchINETTransport;
import com.icatchtek.reliant.customer.transport.ICatchITransport;
import com.icatchtek.reliant.customer.transport.ICatchUVCBulkTransport;

public class MyCamera {
    private final String TAG = MyCamera.class.getSimpleName();
    private CommandSession commandSession;
    private PanoramaSession panoramaSession;
    private CameraAction cameraAction;
    private CameraFixedInfo cameraFixedInfo;
    private CameraProperties cameraProperties;
    private CameraState cameraState;
    private FileOperation fileOperation;
    private PanoramaPhotoPlayback panoramaPhotoPlayback;
    private PanoramaPreviewPlayback panoramaPreviewPlayback;
    private PanoramaVideoPlayback panoramaVideoPlayback;
    private PanoramaControl panoramaControl;
    private BaseProrertys baseProrertys;
    public int timeLapsePreviewMode = 1;
    public String cameraName;
    private String ipAddress;
    public int mode;
    public boolean needInputPassword = true;
    public boolean isStreamReady = false;
    private int cameraType;
    private boolean isConnected = false;
    private UsbDevice usbDevice;
    private ICatchITransport transport;

    public MyCamera(int cameraType) {
        this.cameraType = cameraType;
    }

    public MyCamera(int cameraType, String cameraName) {
        this.cameraName = cameraName;
        this.cameraType = cameraType;
    }

    public MyCamera(int cameraType, String ssid, String ipAddress, int mode) {
        this.cameraName = ssid;
        this.ipAddress = ipAddress;
        this.mode = mode;
        this.cameraType = cameraType;
    }

    public MyCamera(int cameraType, UsbDevice usbDevice) {
        this.cameraType = cameraType;
        this.usbDevice = usbDevice;
        this.cameraName = "UsbDevice_" + String.valueOf(usbDevice.getVendorId());
    }

    public boolean connect(boolean enablePTPIP) {
        AppLog.d(this.TAG, "connect cameraType=" + this.cameraType + " enablePTPIP=" + enablePTPIP);
        boolean ret = false;
        this.commandSession = new CommandSession();
        this.panoramaSession = new PanoramaSession();
        if (this.cameraType == CameraType.PANORAMA_CAMERA) {
            this.transport = new ICatchINETTransport(this.ipAddress);
        } else if (this.cameraType == CameraType.USB_CAMERA) {
            USBHost_Feature feature = new USBHost_Feature(PanoramaSDK.getContext());
            feature.setUsbDevice(this.usbDevice.getVendorId(), this.usbDevice.getProductId());
            try {
                this.transport = new ICatchUVCBulkTransport(feature.getUsbDevice(), feature.getUsbDeviceConnection());
            }
            catch (IchInvalidArgumentException e) {
                AppLog.i(this.TAG, "ICatchUVCBulkTransport IchInvalidArgumentException");
                e.printStackTrace();
            }
            catch (IchTransportException e) {
                e.printStackTrace();
            }
        }
        if (this.transport != null) {
            AppLog.i(this.TAG, "transport is" + this.transport.getClass().getSimpleName());
            try {
                this.transport.prepareTransport();
            }
            catch (IchTransportException e) {
                AppLog.i(this.TAG, "ICatchUVCBulkTransport IchTransportException");
                e.printStackTrace();
            }
            ret = this.commandSession.prepareSession(this.transport, enablePTPIP);
            if (!ret) {
                return false;
            }
            ret = this.panoramaSession.prepareSession(this.transport);
        }
        if (ret) {
            this.isConnected = true;
            try {
                this.cameraAction = new CameraAction(this.commandSession.getSDKSession().getControlClient(), ICatchCameraSession.getCameraAssist((ICatchITransport)this.transport));
            }
            catch (IchInvalidSessionException e) {
                e.printStackTrace();
            }
            catch (IchInvalidArgumentException e) {
                e.printStackTrace();
            }
            this.initCamera();
        }
        return ret;
    }

    public boolean disconnect() {
        if (this.isConnected) {
            if (this.transport != null) {
                try {
                    this.transport.destroyTransport();
                }
                catch (IchTransportException e) {
                    e.printStackTrace();
                }
            }
            this.commandSession.destroySession();
            this.panoramaSession.destroySession();
            this.isConnected = false;
        }
        return true;
    }

    private boolean initCamera() {
        boolean retValue = false;
        AppLog.i(this.TAG, "Start initClient");
        ICatchCameraSession iCatchCommandSession = this.commandSession.getSDKSession();
        ICatchPancamSession iCatchPancamSession = this.panoramaSession.getSession();
        try {
            this.cameraFixedInfo = new CameraFixedInfo(iCatchCommandSession.getInfoClient());
            this.cameraProperties = new CameraProperties(iCatchCommandSession.getPropertyClient(), iCatchCommandSession.getControlClient());
            this.cameraState = new CameraState(iCatchCommandSession.getStateClient());
            this.fileOperation = new FileOperation(iCatchCommandSession.getPlaybackClient());
            this.panoramaPhotoPlayback = new PanoramaPhotoPlayback(iCatchPancamSession);
            this.panoramaPreviewPlayback = new PanoramaPreviewPlayback(iCatchPancamSession);
            this.panoramaVideoPlayback = new PanoramaVideoPlayback(iCatchPancamSession);
            this.panoramaControl = new PanoramaControl(iCatchPancamSession);
        }
        catch (IchInvalidSessionException e) {
            e.printStackTrace();
        }
        this.baseProrertys = new BaseProrertys(this.cameraProperties);
        return retValue;
    }

    public int getMyMode() {
        return this.mode;
    }

    public CommandSession getSDKsession() {
        if (this.commandSession == null) {
            this.connect(true);
        }
        return this.commandSession;
    }

    public CameraAction getCameraAction() {
        if (this.cameraAction == null) {
            this.connect(true);
        }
        return this.cameraAction;
    }

    public CameraFixedInfo getCameraFixedInfo() {
        if (this.cameraFixedInfo == null) {
            this.connect(true);
        }
        return this.cameraFixedInfo;
    }

    public CameraProperties getCameraProperties() {
        if (this.cameraProperties == null) {
            this.connect(true);
        }
        return this.cameraProperties;
    }

    public CameraState getCameraState() {
        if (this.cameraState == null) {
            this.connect(true);
        }
        return this.cameraState;
    }

    public FileOperation getFileOperation() {
        if (this.fileOperation == null) {
            this.connect(true);
        }
        return this.fileOperation;
    }

    public PanoramaPhotoPlayback getPanoramaPhotoPlayback() {
        if (this.panoramaPhotoPlayback == null) {
            this.connect(true);
        }
        return this.panoramaPhotoPlayback;
    }

    public PanoramaPreviewPlayback getPanoramaPreviewPlayback() {
        if (this.panoramaPreviewPlayback == null) {
            this.connect(true);
        }
        return this.panoramaPreviewPlayback;
    }

    public PanoramaVideoPlayback getPanoramaVideoPlayback() {
        if (this.panoramaVideoPlayback == null) {
            this.connect(true);
        }
        return this.panoramaVideoPlayback;
    }

    public PanoramaControl getPanoramaControl() {
        if (this.panoramaControl == null) {
            this.connect(true);
        }
        return this.panoramaControl;
    }

    public BaseProrertys getBaseProrertys() {
        if (this.baseProrertys == null) {
            this.connect(true);
        }
        return this.baseProrertys;
    }

    public boolean isConnected() {
        AppLog.d(this.TAG, "isConnected:" + this.isConnected);
        return this.isConnected;
    }

    public String getCameraName() {
        return this.cameraName;
    }

    public UsbDevice getUsbDevice() {
        return this.usbDevice;
    }

    public int getCameraType() {
        return this.cameraType;
    }
}

