/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.MyCamera;

import android.content.res.Resources;
import android.util.DisplayMetrics;
import com.icatch.panorama.Log.AppLog;
import com.icatchtek.pancam.customer.ICatchPancamSession;
import com.icatchtek.pancam.customer.type.ICatchGLColor;
import com.icatchtek.pancam.customer.type.ICatchGLDisplayPPI;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchTransportException;
import com.icatchtek.reliant.customer.transport.ICatchITransport;

public class PanoramaSession {
    private static final String TAG = PanoramaSession.class.getSimpleName();
    private ICatchPancamSession iCatchPancamSession;

    public boolean prepareSession(ICatchITransport transport) {
        boolean ret = false;
        this.iCatchPancamSession = ICatchPancamSession.createSession();
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        ICatchGLDisplayPPI displayPPI = new ICatchGLDisplayPPI(displayMetrics.xdpi, displayMetrics.ydpi);
        try {
            ret = this.iCatchPancamSession.prepareSession(transport, ICatchGLColor.BLACK, displayPPI);
        }
        catch (IchTransportException e) {
            e.printStackTrace();
        }
        AppLog.d(TAG, "ICatchPancamSession preparePanoramaSession ret=" + ret);
        return ret;
    }

    public ICatchPancamSession getSession() {
        return this.iCatchPancamSession;
    }

    public boolean destroySession() {
        boolean ret = false;
        if (this.iCatchPancamSession != null) {
            try {
                ret = this.iCatchPancamSession.destroySession();
            }
            catch (IchInvalidSessionException e) {
                e.printStackTrace();
            }
            AppLog.d(TAG, "ICatchPancamSession destroyPanoramaSession ret=" + ret);
        }
        return ret;
    }
}

