/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Presenter.Interface;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.Menu;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.GlobalApp.ExitApp;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import java.lang.reflect.Method;

public abstract class BasePresenter {
    private final String tag = "BasePresenter";
    protected Activity activity;

    public BasePresenter(Activity activity) {
        this.activity = activity;
    }

    public void initCfg() {
        GlobalInfo.getInstance().setCurrentApp(this.activity);
        this.activity.getWindow().setFlags(128, 128);
        this.activity.getWindow().addFlags(1024);
    }

    public void redirectToAnotherActivity(Context context, Class<?> cls) {
        Intent intent = new Intent();
        AppLog.i("BasePresenter", "intent:start redirectToAnotherActivity class =" + cls.getName());
        intent.setClass(context, cls);
        context.startActivity(intent);
    }

    public void finishActivity() {
        this.activity.finish();
    }

    public void isAppBackground() {
        if (AppInfo.isAppSentToBackground((Context)this.activity)) {
            ExitApp.getInstance().exit();
        }
    }

    public void submitAppInfo() {
        GlobalInfo.getInstance().setCurrentApp(this.activity);
        ExitApp.getInstance().addActivity(this.activity);
    }

    public void removeActivity() {
        if (this.activity != null) {
            ExitApp.getInstance().removeActivity(this.activity);
        }
    }

    public void showOptionIcon(Menu menu) {
        if (menu != null && menu.getClass().getSimpleName().equals("MenuBuilder")) {
            try {
                Method m = menu.getClass().getDeclaredMethod("setOptionalIconsVisible", Boolean.TYPE);
                m.setAccessible(true);
                m.invoke((Object)menu, true);
            }
            catch (Exception e) {
                Log.e((String)this.getClass().getSimpleName(), (String)"onMenuOpened...unable to set icons for overflow menu", (Throwable)e);
            }
        }
    }
}

