/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Presenter;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.EditText;
import com.icatch.panorama.Function.GlobalEvent;
import com.icatch.panorama.Listener.WifiListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.MyCamera.CameraType;
import com.icatch.panorama.MyCamera.CommandSession;
import com.icatch.panorama.MyCamera.MyCamera;
import com.icatch.panorama.Presenter.Interface.BasePresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.AppInfo.AppSharedPreferences;
import com.icatch.panorama.data.AppInfo.ConfigureInfo;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.Mode.CameraNetworkMode;
import com.icatch.panorama.data.SystemInfo.HotSpot;
import com.icatch.panorama.data.SystemInfo.MWifiManager;
import com.icatch.panorama.data.entity.CameraSlot;
import com.icatch.panorama.data.entity.SearchedCameraInfo;
import com.icatch.panorama.data.entity.SelectedCameraInfo;
import com.icatch.panorama.db.CameraSlotSQLite;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.Interface.LaunchView;
import com.icatch.panorama.ui.activity.PanoramaPreviewV35Activity;
import com.icatch.panorama.ui.activity.PanoramaPreviewV50Activity;
import com.icatch.panorama.ui.activity.PanoramaPreviewV51Activity;
import com.icatch.panorama.ui.adapter.CamAdapter;
import com.icatch.panorama.ui.appdialog.AppDialog;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class LaunchPresenter
extends BasePresenter {
    private static final String TAG = LaunchPresenter.class.getSimpleName();
    private LaunchView launchView;
    private CamAdapter mCamAdapter;
    private ArrayList<CameraSlot> camSlotList;
    private final LaunchHandler launchHandler = new LaunchHandler();
    private Activity activity;
    private GlobalEvent globalEvent;
    private LinkedList<SelectedCameraInfo> searchCameraInfoList;
    private WifiListener wifiListener;

    public LaunchPresenter(Activity activity) {
        super(activity);
        this.activity = activity;
    }

    public void setView(LaunchView launchView) {
        this.launchView = launchView;
        this.initCfg();
        this.globalEvent = new GlobalEvent(this.launchHandler);
    }

    @Override
    public void initCfg() {
        GlobalInfo.getInstance().setCurrentApp(this.activity);
        this.activity.getWindow().setFlags(128, 128);
        this.activity.getWindow().addFlags(1024);
        AppInfo.inputIp = AppSharedPreferences.readDataByName((Context)this.activity, "inputIp");
        ConfigureInfo.getInstance().initCfgInfo(this.activity.getApplicationContext());
        GlobalInfo.getInstance().startScreenListener();
    }

    public void addGlobalLisnter(int eventId, boolean forAllSession) {
        this.globalEvent.addGlobalEventListener(eventId, forAllSession);
    }

    public void delGlobalLisnter(int eventId, boolean forAllSession) {
        this.globalEvent.delGlobalEventListener(eventId, forAllSession);
    }

    private String getCameraIp() {
        String ip = "";
        ip = HotSpot.isApEnabled((Context)this.activity) ? HotSpot.getFirstConnectedHotIP() : (!AppInfo.enableLive ? "192.168.1.1" : AppInfo.inputIp);
        return ip;
    }

    public void launchCamera(int position, final int cameraType) {
        String cameraName = null;
        AppLog.d(TAG, "launchCamera position=" + position + " cameraType=" + cameraType);
        if (cameraType == CameraType.PANORAMA_CAMERA) {
            cameraName = MWifiManager.getSsid((Context)this.activity);
        }
        if (this.camSlotList.get((int)position).isReady) {
            MyProgressDialog.showProgressDialog((Context)this.activity, R.string.action_processing);
            final String finalWifiSsid1 = cameraName;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (cameraType == CameraType.PANORAMA_CAMERA) {
                        LaunchPresenter.this.beginConnectCamera(LaunchPresenter.this.getCameraIp(), finalWifiSsid1);
                    }
                }
            }).start();
        } else if (this.camSlotList.get((int)position).isOccupied) {
            AppDialog.showDialogWarn((Context)this.activity, "Please connect camera " + this.camSlotList.get((int)position).cameraName);
        } else if (!this.isRegistered(cameraName)) {
            MyProgressDialog.showProgressDialog((Context)this.activity, R.string.action_processing);
            final String finalWifiSsid = cameraName;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (cameraType == CameraType.PANORAMA_CAMERA) {
                        LaunchPresenter.this.beginConnectCamera(LaunchPresenter.this.getCameraIp(), finalWifiSsid);
                    }
                }
            }).start();
        } else {
            AppDialog.showDialogWarn((Context)this.activity, "Camera " + cameraName + " has been registered");
        }
    }

    public void launchCamera(CameraSlot cameraSlot) {
        int position = this.camSlotList.indexOf(cameraSlot);
        String wifiSsid = null;
        wifiSsid = MWifiManager.getSsid((Context)this.activity);
        final int cameraType = this.camSlotList.get((int)position).cameraType;
        if (this.camSlotList.get((int)position).isReady) {
            MyProgressDialog.showProgressDialog((Context)this.activity, R.string.action_processing);
            final String finalWifiSsid = wifiSsid;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (cameraType == CameraType.PANORAMA_CAMERA) {
                        LaunchPresenter.this.beginConnectCamera(LaunchPresenter.this.getCameraIp(), finalWifiSsid);
                    }
                }
            }).start();
        } else if (this.camSlotList.get((int)position).isOccupied) {
            AppDialog.showDialogWifi((Context)this.activity, "\u8bf7\u8fde\u63a5WIFI: " + this.camSlotList.get((int)position).cameraName);
        } else {
            this.launchView.setLaunchLayoutVisibility(8);
            this.launchView.setLaunchSettingFrameVisibility(0);
        }
    }

    public void removeCamera(int position) {
        AppLog.i(TAG, "remove camera position = " + position);
        CameraSlotSQLite.getInstance().deleteByPosition(position);
        this.loadListview();
    }

    public void loadListview() {
        this.camSlotList = CameraSlotSQLite.getInstance().getAllCameraSlotFormDb();
        if (this.mCamAdapter != null) {
            this.mCamAdapter.notifyDataSetChanged();
        }
        this.mCamAdapter = new CamAdapter(this.camSlotList);
        this.launchView.setListviewAdapter(this.mCamAdapter);
    }

    public void notifyListview() {
        if (this.mCamAdapter != null) {
            this.mCamAdapter.notifyDataSetChanged();
        }
    }

    private void setReadyState(boolean isReady, String cameraName) {
        if (cameraName == null || cameraName.equals("")) {
            return;
        }
        for (CameraSlot temp : this.camSlotList) {
            if (temp.cameraName == null || !temp.cameraName.equals(cameraName)) continue;
            temp.isReady = isReady;
            break;
        }
    }

    private void resetWifiState() {
        for (CameraSlot temp : this.camSlotList) {
            if (temp.cameraType == CameraType.USB_CAMERA) continue;
            temp.isReady = false;
        }
    }

    public void startSearchCamera() {
        if (this.searchCameraInfoList != null) {
            this.searchCameraInfoList.clear();
        }
        this.searchCameraInfoList = new LinkedList();
        this.addGlobalLisnter(85, false);
        CommandSession.stopDeviceScan();
        CommandSession.startDeviceScan();
        this.startSearchTimeoutTimer();
        MyProgressDialog.showProgressDialog((Context)this.activity, R.string.action_processing);
    }

    private void startSearchTimeoutTimer() {
        Timer searchTimer = new Timer();
        TimerTask searchTask = new TimerTask(){

            @Override
            public void run() {
                LaunchPresenter.this.launchHandler.obtainMessage(2).sendToTarget();
            }
        };
        searchTimer.schedule(searchTask, 20000L);
    }

    private void showSearchCameraListSingleDialog() {
        if (this.searchCameraInfoList.isEmpty()) {
            return;
        }
        String title = "Please selectOrCancelAll camera";
        CharSequence[] tempsearchCameraInfoList = new CharSequence[this.searchCameraInfoList.size()];
        for (int ii = 0; ii < tempsearchCameraInfoList.length; ++ii) {
            tempsearchCameraInfoList[ii] = this.searchCameraInfoList.get((int)ii).cameraName + "\n" + this.searchCameraInfoList.get((int)ii).cameraIp + "          " + CameraNetworkMode.getModeConvert(this.searchCameraInfoList.get((int)ii).cameraMode);
        }
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        };
        this.showOptionDialogSingle(title, tempsearchCameraInfoList, 0, listener, true);
    }

    private void showOptionDialogSingle(CharSequence title, CharSequence[] items, int checkedItem, DialogInterface.OnClickListener listener, boolean cancelable) {
        AlertDialog optionDialog = new AlertDialog.Builder((Context)this.activity).setTitle(title).setSingleChoiceItems(items, checkedItem, listener).create();
        optionDialog.setCancelable(cancelable);
        optionDialog.show();
    }

    public void inputIp() {
        this.showInputIpDialog((Context)this.activity);
    }

    public void showInputIpDialog(final Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        View contentView = View.inflate((Context)context, (int)R.layout.input_ip, null);
        final EditText resetTxv = (EditText)contentView.findViewById(R.id.ip_address);
        resetTxv.setText((CharSequence)AppInfo.inputIp);
        builder.setTitle(R.string.action_input_ip);
        builder.setView(contentView);
        builder.setCancelable(false);
        builder.setPositiveButton((CharSequence)context.getResources().getString(R.string.ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                AppInfo.inputIp = resetTxv.getText().toString();
                AppSharedPreferences.writeDataByName(context, "inputIp", AppInfo.inputIp);
            }
        });
        builder.setNegativeButton((CharSequence)context.getResources().getString(R.string.gallery_cancel), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        builder.create().show();
    }

    private void beginConnectCamera(String ip, String wifiSsid) {
        AppLog.i(TAG, "isWifiConnect() == true");
        CameraManager.getInstance().createCamera(CameraType.PANORAMA_CAMERA, wifiSsid, ip, 1);
        final MyCamera currentCamera = CameraManager.getInstance().getCurCamera();
        if (!currentCamera.connect(true)) {
            this.launchHandler.obtainMessage(3).sendToTarget();
            return;
        }
        if (currentCamera.getCameraProperties().hasFuction(20497)) {
            currentCamera.getCameraProperties().setCameraDate();
        }
        this.launchHandler.post(new Runnable(){

            @Override
            public void run() {
                MyProgressDialog.closeProgressDialog();
                if ("V50 Serial".equals(currentCamera.getBaseProrertys().getProjectModel())) {
                    LaunchPresenter.this.redirectToAnotherActivity((Context)LaunchPresenter.this.activity, PanoramaPreviewV50Activity.class);
                } else if ("V50 SBC".equals(currentCamera.getBaseProrertys().getProjectModel())) {
                    LaunchPresenter.this.redirectToAnotherActivity((Context)LaunchPresenter.this.activity, PanoramaPreviewV51Activity.class);
                } else {
                    LaunchPresenter.this.redirectToAnotherActivity((Context)LaunchPresenter.this.activity, PanoramaPreviewV35Activity.class);
                }
            }
        });
    }

    private boolean isRegistered(String ssid) {
        for (CameraSlot camSlot : this.camSlotList) {
            if (camSlot.cameraName == null || !camSlot.cameraName.equals(ssid)) continue;
            return true;
        }
        return false;
    }

    public void registerWifiReceiver() {
        if (this.wifiListener == null) {
            this.wifiListener = new WifiListener((Context)this.activity, this.launchHandler);
        }
        this.wifiListener.registerReceiver();
    }

    public void unregisterWifiReceiver() {
        if (this.wifiListener != null) {
            this.wifiListener.unregisterReceiver();
            this.wifiListener = null;
        }
    }

    private class LaunchHandler
    extends Handler {
        private LaunchHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    MyProgressDialog.closeProgressDialog();
                    AppDialog.showDialogWarn((Context)LaunchPresenter.this.activity, R.string.dialog_connect_failed);
                    break;
                }
                case 4: {
                    MyProgressDialog.closeProgressDialog();
                    if ("V50 Serial".equals(CameraManager.getInstance().getCurCamera().getBaseProrertys().getProjectModel())) {
                        LaunchPresenter.this.redirectToAnotherActivity((Context)LaunchPresenter.this.activity, PanoramaPreviewV50Activity.class);
                        break;
                    }
                    if ("V50 SBC".equals(CameraManager.getInstance().getCurCamera().getBaseProrertys().getProjectModel())) {
                        LaunchPresenter.this.redirectToAnotherActivity((Context)LaunchPresenter.this.activity, PanoramaPreviewV51Activity.class);
                        break;
                    }
                    LaunchPresenter.this.redirectToAnotherActivity((Context)LaunchPresenter.this.activity, PanoramaPreviewV35Activity.class);
                    break;
                }
                case 1: {
                    LaunchPresenter.this.removeCamera(msg.arg1);
                    break;
                }
                case 2: {
                    AppLog.i(TAG, "MESSAGE_CAMERA_SCAN_TIME_OUT:count =" + LaunchPresenter.this.searchCameraInfoList.size());
                    CommandSession.stopDeviceScan();
                    LaunchPresenter.this.globalEvent.delGlobalEventListener(85, false);
                    MyProgressDialog.closeProgressDialog();
                    if (LaunchPresenter.this.searchCameraInfoList.isEmpty()) {
                        MyToast.show((Context)LaunchPresenter.this.activity, R.string.alert_no_camera_found);
                        break;
                    }
                    LaunchPresenter.this.showSearchCameraListSingleDialog();
                    break;
                }
                case 15: {
                    SearchedCameraInfo temp = (SearchedCameraInfo)msg.obj;
                    LaunchPresenter.this.searchCameraInfoList.addLast(new SelectedCameraInfo(temp.cameraName, temp.cameraIp, temp.cameraMode, temp.uid));
                    break;
                }
                case 5: {
                    int cameraType = msg.arg1;
                    int position = msg.arg2;
                    LaunchPresenter.this.launchCamera(position, cameraType);
                    break;
                }
                case 4099: {
                    AppLog.i(TAG, "receive MESSAGE_DISCONNECTED");
                    LaunchPresenter.this.resetWifiState();
                    LaunchPresenter.this.notifyListview();
                    break;
                }
                case 4100: {
                    AppLog.i(TAG, "receive MESSAGE_CONNECTED");
                    String ssid = MWifiManager.getSsid((Context)LaunchPresenter.this.activity);
                    if (ssid == null) break;
                    LaunchPresenter.this.setReadyState(true, ssid);
                    LaunchPresenter.this.notifyListview();
                }
            }
        }
    }
}

