/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Presenter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Environment;
import android.os.Handler;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.Presenter.Interface.BasePresenter;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.Mode.OperationMode;
import com.icatch.panorama.data.entity.LocalPbItemInfo;
import com.icatch.panorama.data.type.FileType;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.Interface.LocalMultiPbFragmentView;
import com.icatch.panorama.ui.activity.LocalPhotoPbActivity;
import com.icatch.panorama.ui.activity.LocalVideoPbActivity;
import com.icatch.panorama.ui.adapter.LocalMultiPbWallListAdapter;
import com.icatch.panorama.utils.FileOpertion.MFileTools;
import com.icatch.panorama.utils.PanoramaTools;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LocalMultiPbFragmentPresenter
extends BasePresenter {
    private String TAG = LocalMultiPbFragmentPresenter.class.getSimpleName();
    private LocalMultiPbFragmentView multiPbPhotoView;
    private LocalMultiPbWallListAdapter photoWallListAdapter;
    private Activity activity;
    private static int section = 1;
    private Map<String, Integer> sectionMap = new HashMap<String, Integer>();
    private OperationMode curOperationMode = OperationMode.MODE_BROWSE;
    private List<LocalPbItemInfo> pbItemInfoList;
    private Handler handler;
    private FileType fileType = FileType.FILE_PHOTO;
    private boolean isChoose;

    public LocalMultiPbFragmentPresenter(Activity activity, FileType fileType) {
        super(activity);
        this.activity = activity;
        this.handler = new Handler();
        this.fileType = fileType;
    }

    public void setView(LocalMultiPbFragmentView localPhotoWallView) {
        this.multiPbPhotoView = localPhotoWallView;
        this.initCfg();
    }

    public boolean isChoose() {
        return this.isChoose;
    }

    public void setChoose(boolean choose) {
        this.isChoose = choose;
    }

    public List<LocalPbItemInfo> getPhotoInfoList(FileType fileType) {
        List<File> fileList;
        String filePath;
        ArrayList<LocalPbItemInfo> photoList = new ArrayList<LocalPbItemInfo>();
        if (fileType == FileType.FILE_PHOTO) {
            filePath = Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720photo/";
            fileList = MFileTools.getPhotosOrderByDate(filePath);
        } else {
            filePath = Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720video/";
            fileList = MFileTools.getVideosOrderByDate(filePath);
        }
        if (fileList == null || fileList.size() <= 0) {
            return null;
        }
        AppLog.i(this.TAG, "fileList size=" + fileList.size());
        for (int ii = 0; ii < fileList.size(); ++ii) {
            LocalPbItemInfo mGridItem;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            long time = fileList.get(ii).lastModified();
            String fileDate = format.format(new Date(time));
            if (!this.sectionMap.containsKey(fileDate)) {
                this.sectionMap.put(fileDate, section);
                mGridItem = new LocalPbItemInfo(fileList.get(ii), section, PanoramaTools.isPanorama(fileList.get(ii).getPath()));
                photoList.add(mGridItem);
                ++section;
                continue;
            }
            mGridItem = new LocalPbItemInfo(fileList.get(ii), this.sectionMap.get(fileDate), PanoramaTools.isPanorama(fileList.get(ii).getPath()));
            photoList.add(mGridItem);
        }
        if (fileType == FileType.FILE_PHOTO) {
            GlobalInfo.getInstance().setLocalPhotoList(photoList);
        } else {
            GlobalInfo.getInstance().setLocalVideoList(photoList);
        }
        return photoList;
    }

    public void loadPhotoWall() {
        MyProgressDialog.showProgressDialog((Context)this.activity, "Loading...");
        new Thread(new Runnable(){

            @Override
            public void run() {
                LocalMultiPbFragmentPresenter.this.pbItemInfoList = LocalMultiPbFragmentPresenter.this.getPhotoInfoList(LocalMultiPbFragmentPresenter.this.fileType);
                if (LocalMultiPbFragmentPresenter.this.pbItemInfoList == null || LocalMultiPbFragmentPresenter.this.pbItemInfoList.size() <= 0) {
                    LocalMultiPbFragmentPresenter.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            MyProgressDialog.closeProgressDialog();
                            LocalMultiPbFragmentPresenter.this.multiPbPhotoView.setListViewVisibility(8);
                            LocalMultiPbFragmentPresenter.this.multiPbPhotoView.setNoContentTxvVisibility(0);
                        }
                    });
                } else {
                    LocalMultiPbFragmentPresenter.this.handler.post(new Runnable(){

                        @Override
                        public void run() {
                            LocalMultiPbFragmentPresenter.this.multiPbPhotoView.setNoContentTxvVisibility(8);
                            LocalMultiPbFragmentPresenter.this.setAdapter();
                            MyProgressDialog.closeProgressDialog();
                        }
                    });
                }
            }
        }).start();
    }

    public void setAdapter() {
        this.curOperationMode = OperationMode.MODE_BROWSE;
        if (this.pbItemInfoList != null && this.pbItemInfoList.size() > 0) {
            String fileDate = this.pbItemInfoList.get(0).getFileDate();
            AppLog.d(this.TAG, "fileDate=" + fileDate);
            this.multiPbPhotoView.setListViewHeaderText(fileDate);
        }
        this.multiPbPhotoView.setListViewVisibility(0);
        this.photoWallListAdapter = new LocalMultiPbWallListAdapter((Context)this.activity, this.pbItemInfoList, FileType.FILE_PHOTO);
        this.multiPbPhotoView.setListViewAdapter(this.photoWallListAdapter);
        if (this.isChoose) {
            this.enterEditMode();
        }
    }

    public void refreshPhotoWall() {
        this.pbItemInfoList = this.getPhotoInfoList(this.fileType);
        if (this.pbItemInfoList == null || this.pbItemInfoList.size() <= 0) {
            this.multiPbPhotoView.setListViewVisibility(8);
            this.multiPbPhotoView.setNoContentTxvVisibility(0);
        } else {
            this.multiPbPhotoView.setNoContentTxvVisibility(8);
            this.setAdapter();
        }
    }

    public void listViewEnterEditMode(int position) {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            this.curOperationMode = OperationMode.MODE_EDIT;
            this.multiPbPhotoView.notifyChangeMultiPbMode(this.curOperationMode);
            this.photoWallListAdapter.setOperationMode(this.curOperationMode);
            this.photoWallListAdapter.changeSelectionState(position);
            this.multiPbPhotoView.setPhotoSelectNumText(this.photoWallListAdapter.getSelectedCount());
            AppLog.i(this.TAG, "gridViewSelectOrCancelOnce curOperationMode=" + (Object)((Object)this.curOperationMode));
        }
    }

    private void enterEditMode() {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            this.curOperationMode = OperationMode.MODE_EDIT;
            this.multiPbPhotoView.notifyChangeMultiPbMode(this.curOperationMode);
            this.photoWallListAdapter.setOperationMode(this.curOperationMode);
            this.multiPbPhotoView.setPhotoSelectNumText(this.photoWallListAdapter.getSelectedCount());
        }
    }

    public void quitEditMode() {
        if (this.curOperationMode == OperationMode.MODE_EDIT) {
            this.curOperationMode = OperationMode.MODE_BROWSE;
            this.multiPbPhotoView.notifyChangeMultiPbMode(this.curOperationMode);
            this.photoWallListAdapter.quitEditMode();
        }
    }

    public void listViewSelectOrCancelOnce(int position) {
        String videoPath = this.pbItemInfoList.get(position).getFilePath();
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            AppLog.i(this.TAG, "listViewSelectOrCancelOnce curOperationMode=" + (Object)((Object)this.curOperationMode));
            if (this.fileType == FileType.FILE_PHOTO) {
                Intent intent = new Intent();
                intent.putExtra("curfilePosition", position);
                intent.setClass((Context)this.activity, LocalPhotoPbActivity.class);
                this.activity.startActivity(intent);
            } else {
                Intent intent = new Intent();
                intent.putExtra("curfilePath", videoPath);
                intent.putExtra("curfilePosition", position);
                intent.setClass((Context)this.activity, LocalVideoPbActivity.class);
                this.activity.startActivity(intent);
            }
        } else {
            this.photoWallListAdapter.changeSelectionState(position);
            this.multiPbPhotoView.setPhotoSelectNumText(this.photoWallListAdapter.getSelectedCount());
        }
    }

    public void selectOrCancelAll(boolean isSelectAll) {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            return;
        }
        if (isSelectAll) {
            this.photoWallListAdapter.selectAllItems();
        } else {
            this.photoWallListAdapter.cancelAllSelections();
        }
        int selectNum = this.photoWallListAdapter.getSelectedCount();
        this.multiPbPhotoView.setPhotoSelectNumText(selectNum);
    }

    public List<LocalPbItemInfo> getSelectedList() {
        return this.photoWallListAdapter.getSelectedList();
    }
}

