/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Presenter;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Handler;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.icatch.panorama.Listener.OnStatusChangedListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.Presenter.Interface.BasePresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.Mode.OperationMode;
import com.icatch.panorama.data.entity.LocalPbItemInfo;
import com.icatch.panorama.data.type.FileType;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.Fragment.LocalMultiPbFragment;
import com.icatch.panorama.ui.Interface.LocalMultiPbView;
import com.icatch.panorama.ui.adapter.ViewPagerAdapter;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public class LocalMultiPbPresenter
extends BasePresenter {
    private static final String TAG = LocalMultiPbPresenter.class.getSimpleName();
    private LocalMultiPbView multiPbView;
    private Activity activity;
    LocalMultiPbFragment multiPbPhotoFragment;
    LocalMultiPbFragment multiPbVideoFragment;
    OperationMode curOperationMode = OperationMode.MODE_BROWSE;
    ViewPagerAdapter adapter;
    private boolean curSelectAll = false;

    public LocalMultiPbPresenter(Activity activity) {
        super(activity);
        this.activity = activity;
        Intent intent = activity.getIntent();
        AppInfo.currentViewpagerPosition = intent.getIntExtra("CUR_POSITION", 0);
    }

    public void setView(LocalMultiPbView multiPbView) {
        this.multiPbView = multiPbView;
        this.initCfg();
    }

    public void loadViewPager() {
        this.initViewpager();
    }

    public void reset() {
        AppInfo.currentViewpagerPosition = 0;
        AppInfo.curVisibleItem = 0;
    }

    private void initViewpager() {
        if (this.multiPbPhotoFragment == null) {
            this.multiPbPhotoFragment = LocalMultiPbFragment.newInstance(1);
        }
        this.multiPbPhotoFragment.setOperationListener(new OnStatusChangedListener(){

            @Override
            public void onChangeOperationMode(OperationMode operationMode) {
                LocalMultiPbPresenter.this.curOperationMode = operationMode;
                if (LocalMultiPbPresenter.this.curOperationMode == OperationMode.MODE_BROWSE) {
                    LocalMultiPbPresenter.this.multiPbView.setViewPagerScanScroll(true);
                    LocalMultiPbPresenter.this.multiPbView.setSelectBtnVisibility(8);
                    LocalMultiPbPresenter.this.multiPbView.setSelectNumTextVisibility(8);
                    LocalMultiPbPresenter.this.multiPbView.setEditLayoutVisibility(8);
                    LocalMultiPbPresenter.this.multiPbView.setSelectBtnIcon(R.drawable.ic_select_all_white_24dp);
                    LocalMultiPbPresenter.this.curSelectAll = false;
                    AppLog.d(TAG, "multiPbPhotoFragment quit EditMode");
                } else {
                    LocalMultiPbPresenter.this.multiPbView.setViewPagerScanScroll(false);
                    LocalMultiPbPresenter.this.multiPbView.setSelectBtnVisibility(0);
                    LocalMultiPbPresenter.this.multiPbView.setSelectNumTextVisibility(0);
                    LocalMultiPbPresenter.this.multiPbView.setEditLayoutVisibility(0);
                }
            }

            @Override
            public void onSelectedItemsCountChanged(int SelectedNum) {
                String temp = "Selected(" + SelectedNum + ")";
                LocalMultiPbPresenter.this.multiPbView.setSelectNumText(temp);
            }
        });
        if (this.multiPbVideoFragment == null) {
            this.multiPbVideoFragment = LocalMultiPbFragment.newInstance(0);
        }
        this.multiPbVideoFragment.setOperationListener(new OnStatusChangedListener(){

            @Override
            public void onChangeOperationMode(OperationMode operationMode) {
                LocalMultiPbPresenter.this.curOperationMode = operationMode;
                if (LocalMultiPbPresenter.this.curOperationMode == OperationMode.MODE_BROWSE) {
                    LocalMultiPbPresenter.this.multiPbView.setViewPagerScanScroll(true);
                    LocalMultiPbPresenter.this.multiPbView.setSelectBtnVisibility(8);
                    LocalMultiPbPresenter.this.multiPbView.setSelectNumTextVisibility(8);
                    LocalMultiPbPresenter.this.multiPbView.setEditLayoutVisibility(8);
                    LocalMultiPbPresenter.this.multiPbView.setSelectBtnIcon(R.drawable.ic_select_all_white_24dp);
                    LocalMultiPbPresenter.this.curSelectAll = false;
                    AppLog.d(TAG, "multiPbVideoFragment quit EditMode");
                } else {
                    LocalMultiPbPresenter.this.multiPbView.setViewPagerScanScroll(false);
                    LocalMultiPbPresenter.this.multiPbView.setSelectBtnVisibility(0);
                    LocalMultiPbPresenter.this.multiPbView.setSelectNumTextVisibility(0);
                    LocalMultiPbPresenter.this.multiPbView.setEditLayoutVisibility(0);
                }
            }

            @Override
            public void onSelectedItemsCountChanged(int SelectedNum) {
                String temp = "Selected(" + SelectedNum + ")";
                LocalMultiPbPresenter.this.multiPbView.setSelectNumText(temp);
            }
        });
        FragmentManager manager = ((FragmentActivity)this.activity).getSupportFragmentManager();
        this.adapter = new ViewPagerAdapter(manager);
        this.adapter.addFragment(this.multiPbPhotoFragment, this.activity.getResources().getString(R.string.title_photo));
        this.multiPbView.setViewPageAdapter(this.adapter);
        this.multiPbView.setViewPageCurrentItem(AppInfo.currentViewpagerPosition);
    }

    public void updateViewpagerStatus(int arg0) {
        AppLog.d(TAG, "updateViewpagerStatus arg0=" + arg0);
        AppInfo.currentViewpagerPosition = arg0;
    }

    public void reback() {
        if (this.curOperationMode == OperationMode.MODE_BROWSE) {
            this.activity.finish();
        } else if (this.curOperationMode == OperationMode.MODE_EDIT) {
            this.curOperationMode = OperationMode.MODE_BROWSE;
            if (AppInfo.currentViewpagerPosition == 0) {
                this.multiPbPhotoFragment.quitEditMode();
            } else if (AppInfo.currentViewpagerPosition == 1) {
                this.multiPbVideoFragment.quitEditMode();
            }
        }
    }

    public void selectOrCancel() {
        if (this.curSelectAll) {
            this.multiPbView.setSelectBtnIcon(R.drawable.ic_select_all_white_24dp);
            this.curSelectAll = false;
        } else {
            this.multiPbView.setSelectBtnIcon(R.drawable.ic_unselected_white_24dp);
            this.curSelectAll = true;
        }
        if (AppInfo.currentViewpagerPosition == 0) {
            this.multiPbPhotoFragment.selectOrCancelAll(this.curSelectAll);
        } else if (AppInfo.currentViewpagerPosition == 1) {
            this.multiPbVideoFragment.selectOrCancelAll(this.curSelectAll);
        }
    }

    public void delete() {
        List<LocalPbItemInfo> list = null;
        FileType fileType = FileType.FILE_PHOTO;
        AppLog.d(TAG, "delete AppInfo.currentViewpagerPosition=" + AppInfo.currentViewpagerPosition);
        if (AppInfo.currentViewpagerPosition == 0) {
            list = this.multiPbPhotoFragment.getSelectedList();
            fileType = FileType.FILE_PHOTO;
        } else if (AppInfo.currentViewpagerPosition == 1) {
            list = this.multiPbVideoFragment.getSelectedList();
            fileType = FileType.FILE_VIDEO;
        }
        if (list == null || list.size() <= 0) {
            AppLog.d(TAG, "asytaskList size=" + list.size());
            MyToast.show((Context)this.activity, R.string.gallery_no_file_selected);
        } else {
            String what = this.activity.getResources().getString(R.string.gallery_delete_des).replace("$1$", String.valueOf(list.size()));
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
            builder.setCancelable(false);
            builder.setMessage((CharSequence)what);
            builder.setPositiveButton((CharSequence)this.activity.getResources().getString(R.string.gallery_cancel), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            });
            final List<LocalPbItemInfo> finalList = list;
            final FileType finalFileType = fileType;
            builder.setNegativeButton((CharSequence)this.activity.getResources().getString(R.string.gallery_delete), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MyProgressDialog.showProgressDialog((Context)LocalMultiPbPresenter.this.activity, R.string.dialog_deleting);
                    new DeleteFileThread(finalList, finalFileType).run();
                }
            });
            builder.create().show();
        }
    }

    public void clealAsytaskList() {
        this.multiPbPhotoFragment.clealAsytaskList();
        this.multiPbVideoFragment.clealAsytaskList();
    }

    class DeleteFileThread
    implements Runnable {
        private List<LocalPbItemInfo> fileList;
        private List<LocalPbItemInfo> deleteFailedList;
        private List<LocalPbItemInfo> deleteSucceedList;
        private Handler handler;
        private FileType fileType;

        public DeleteFileThread(List<LocalPbItemInfo> fileList, FileType fileType) {
            this.fileList = fileList;
            this.handler = new Handler();
            this.fileType = fileType;
        }

        @Override
        public void run() {
            AppLog.d(TAG, "DeleteThread");
            if (this.deleteFailedList == null) {
                this.deleteFailedList = new LinkedList<LocalPbItemInfo>();
            } else {
                this.deleteFailedList.clear();
            }
            if (this.deleteSucceedList == null) {
                this.deleteSucceedList = new LinkedList<LocalPbItemInfo>();
            } else {
                this.deleteSucceedList.clear();
            }
            for (LocalPbItemInfo tempFile : this.fileList) {
                File file = tempFile.file;
                if (!file.delete()) {
                    this.deleteFailedList.add(tempFile);
                    continue;
                }
                this.deleteSucceedList.add(tempFile);
            }
            LocalMultiPbPresenter.this.clealAsytaskList();
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    MyProgressDialog.closeProgressDialog();
                    LocalMultiPbPresenter.this.curOperationMode = OperationMode.MODE_BROWSE;
                    if (AppInfo.currentViewpagerPosition == 0) {
                        LocalMultiPbPresenter.this.multiPbPhotoFragment.quitEditMode();
                        LocalMultiPbPresenter.this.multiPbPhotoFragment.refreshPhotoWall();
                    } else if (AppInfo.currentViewpagerPosition == 1) {
                        LocalMultiPbPresenter.this.multiPbVideoFragment.quitEditMode();
                        LocalMultiPbPresenter.this.multiPbVideoFragment.refreshPhotoWall();
                    }
                }
            });
        }
    }
}

