/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Presenter;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.util.Log;
import android.view.MotionEvent;
import android.view.Surface;
import androidx.core.content.FileProvider;
import androidx.viewpager.widget.ViewPager;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.LocalSession;
import com.icatch.panorama.Presenter.Interface.BasePresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.PanoramaPhotoPlayback;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.Mode.TouchMode;
import com.icatch.panorama.data.entity.LocalPbItemInfo;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.Interface.LocalPhotoPbView;
import com.icatch.panorama.ui.adapter.LocalPhotoPbViewPagerAdapter;
import com.icatch.panorama.utils.GlideUtils;
import com.icatch.panorama.utils.MediaRefresh;
import com.icatchtek.pancam.customer.exception.IchGLSurfaceNotSetException;
import com.icatchtek.pancam.customer.surface.ICatchSurfaceContext;
import com.icatchtek.pancam.customer.type.ICatchGLImage;
import com.icatchtek.pancam.customer.type.ICatchGLPoint;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class LocalPhotoPbPresenter
extends BasePresenter
implements SensorEventListener {
    private String TAG = LocalPhotoPbPresenter.class.getSimpleName();
    private LocalPhotoPbView photoPbView;
    private Activity activity;
    private List<LocalPbItemInfo> fileList;
    private LocalPhotoPbViewPagerAdapter viewPagerAdapter;
    private int curPhotoIdx;
    private int lastItem = -1;
    private int tempLastItem = -1;
    private boolean isScrolling = false;
    private int photoNums = 0;
    private int slideDirection = 1;
    private static final int DIRECTION_RIGHT = 1;
    private static final int DIRECTION_LEFT = 2;
    private static final int DIRECTION_UNKNOWN = 4;
    private ExecutorService executor;
    private Handler handler;
    private PanoramaPhotoPlayback panoramaPhotoPlayback;
    private static final float MIN_ZOOM = 0.5f;
    private static final float MAX_ZOOM = 2.2f;
    private static final float FIXED_OUTSIDE_FOCUS = 1.0f;
    private static final float FIXED_INSIDE_FOCUS = 2.0f;
    private static final float FIXED_NEAR_DISTANCE = 0.6f;
    private static final float FIXED_OUTSIDE_DISTANCE = 2.0f;
    private static final float FIXED_INSIDE_DISTANCE = 0.45454544f;
    private TouchMode touchMode = TouchMode.NONE;
    private float mPreviousY;
    private float mPreviousX;
    private float beforeLenght;
    private float afterLenght;
    private float currentZoomRate = 2.2f;
    private SensorManager sensorManager;
    private Sensor gyroscopeSensor;
    private ICatchSurfaceContext iCatchSurfaceContext;
    private int curPanoramaType = 1;
    private boolean surfaceCreated = false;

    public LocalPhotoPbPresenter(Activity activity) {
        super(activity);
        this.activity = activity;
        this.handler = new Handler();
        this.slideDirection = 4;
    }

    public void setView(LocalPhotoPbView localPhotoPbView) {
        this.photoPbView = localPhotoPbView;
        this.initCfg();
        this.fileList = GlobalInfo.getInstance().getLocalPhotoList();
        Bundle data = this.activity.getIntent().getExtras();
        this.curPhotoIdx = data.getInt("curfilePosition");
        AppLog.d(this.TAG, "photo position =" + this.curPhotoIdx);
        this.initClient();
    }

    private void initClient() {
        LocalSession.getInstance().preparePanoramaSession();
        this.panoramaPhotoPlayback = LocalSession.getInstance().getPanoramaPhotoPlayback();
    }

    private void destroySession() {
        LocalSession.getInstance().destroyPanoramaSession();
    }

    public void initView() {
        this.viewPagerAdapter = new LocalPhotoPbViewPagerAdapter((Context)this.activity, this.fileList);
        this.viewPagerAdapter.setOnPhotoTapListener(new LocalPhotoPbViewPagerAdapter.OnPhotoTapListener(){

            @Override
            public void onPhotoTap() {
                LocalPhotoPbPresenter.this.showBar();
            }
        });
        this.photoPbView.setViewPagerAdapter(this.viewPagerAdapter);
        this.photoPbView.setViewPagerCurrentItem(this.curPhotoIdx);
        this.updateUi();
        this.photoPbView.setOnPageChangeListener(new MyViewPagerOnPagerChangeListener());
    }

    public void loadPanoramaImage() {
        int curIndex = this.photoPbView.getViewPagerCurrentItem();
        this.loadPanoramaPhoto(this.fileList.get(curIndex));
    }

    public void showBar() {
        boolean isShowBar = this.photoPbView.getTopBarVisibility() == 0;
        AppLog.d(this.TAG, "showBar isShowBar=" + isShowBar);
        if (isShowBar) {
            this.photoPbView.setTopBarVisibility(8);
            this.photoPbView.setBottomBarVisibility(8);
        } else {
            this.photoPbView.setTopBarVisibility(0);
            this.photoPbView.setBottomBarVisibility(0);
        }
    }

    public void loadPreviousImage() {
        AppLog.d(this.TAG, "loadPreviousImage=");
        if (this.curPhotoIdx > 0) {
            --this.curPhotoIdx;
        }
        this.photoPbView.setViewPagerCurrentItem(this.curPhotoIdx);
    }

    public void loadNextImage() {
        AppLog.d(this.TAG, "loadNextImage=");
        if (this.curPhotoIdx < this.fileList.size() - 1) {
            ++this.curPhotoIdx;
        }
        this.photoPbView.setViewPagerCurrentItem(this.curPhotoIdx);
    }

    public void setPanoramaType() {
        if (!this.fileList.get(this.curPhotoIdx).isPanorama()) {
            MyToast.show((Context)this.activity, R.string.non_360_picture_not_support_switch);
            return;
        }
        if (this.curPanoramaType == 1) {
            this.panoramaPhotoPlayback.changePanoramaType(4);
            this.curPanoramaType = 4;
            this.photoPbView.setPanoramaTypeTxv(R.string.text_asteroid);
            this.activity.setRequestedOrientation(4);
        } else if (this.curPanoramaType == 4) {
            this.panoramaPhotoPlayback.changePanoramaType(6);
            this.curPanoramaType = 6;
            this.photoPbView.setPanoramaTypeTxv(R.string.text_vr);
            this.activity.setRequestedOrientation(6);
        } else {
            this.panoramaPhotoPlayback.changePanoramaType(1);
            this.curPanoramaType = 1;
            this.photoPbView.setPanoramaTypeTxv(R.string.text_panorama);
            this.activity.setRequestedOrientation(4);
        }
        this.loadPanoramaImage();
    }

    private void updateUi() {
        int curIndex = this.photoPbView.getViewPagerCurrentItem();
        String indexInfo = curIndex + 1 + "/" + this.fileList.size();
        this.photoPbView.setIndexInfoTxv(indexInfo);
        LocalPbItemInfo itemInfo = this.fileList.get(curIndex);
        this.photoPbView.setSurfaceviewVisibility(itemInfo.isPanorama() ? 0 : 8);
        this.photoPbView.setViewPagerVisibility(itemInfo.isPanorama() ? 8 : 0);
        if (itemInfo.isPanorama() && this.surfaceCreated) {
            this.loadPanoramaPhoto(itemInfo);
        }
    }

    private void loadPanoramaPhoto(LocalPbItemInfo itemInfo) {
        if (itemInfo == null) {
            return;
        }
        if (itemInfo.isPanorama()) {
            GlideUtils.getPanoramaBitmap((Context)this.activity, itemInfo.file, new GlideUtils.GlideListener(){

                @Override
                public void onStart() {
                }

                @Override
                public void onComplete(Bitmap loadedImage) {
                    if (loadedImage != null) {
                        LocalPhotoPbPresenter.this.photoPbView.setViewPagerVisibility(8);
                        LocalPhotoPbPresenter.this.panoramaPhotoPlayback.pancamGLSetFormat(130, loadedImage.getWidth(), loadedImage.getHeight());
                        LocalPhotoPbPresenter.this.panoramaPhotoPlayback.update(new ICatchGLImage(loadedImage));
                        LocalPhotoPbPresenter.this.insidePanorama();
                    }
                }

                @Override
                public void onFailed() {
                }
            });
        }
    }

    public void delete() {
        this.showDeleteEnsureDialog();
    }

    public void share(Context context) {
        int curPosition = this.photoPbView.getViewPagerCurrentItem();
        String photoPath = this.fileList.get((int)curPosition).file.getPath();
        String packagename = context.getPackageName();
        AppLog.d(this.TAG, "share curPosition=" + curPosition + " photoPath=" + photoPath + " packagename:" + packagename);
        Uri fileUri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)this.activity, (String)(packagename + ".WLPanoFileProvider"), (File)new File(photoPath)) : Uri.fromFile((File)new File(photoPath));
        Intent shareIntent = new Intent();
        shareIntent.setAction("android.intent.action.SEND");
        shareIntent.addFlags(1);
        shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)fileUri);
        shareIntent.setDataAndType(fileUri, "image/*");
        this.activity.startActivity(Intent.createChooser((Intent)shareIntent, (CharSequence)this.activity.getResources().getString(R.string.gallery_share_to)));
    }

    public void info() {
    }

    private void showDeleteEnsureDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
        builder.setCancelable(false);
        builder.setTitle(R.string.image_delete_des);
        builder.setNegativeButton(R.string.gallery_delete, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                MyProgressDialog.showProgressDialog((Context)LocalPhotoPbPresenter.this.activity, R.string.dialog_deleting);
                LocalPhotoPbPresenter.this.executor = Executors.newSingleThreadExecutor();
                LocalPhotoPbPresenter.this.executor.submit(new DeleteThread(), null);
            }
        });
        builder.setPositiveButton(R.string.gallery_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    public void setShowArea(Surface surface) {
        AppLog.d(this.TAG, "start initSurface");
        this.iCatchSurfaceContext = new ICatchSurfaceContext(surface);
        this.panoramaPhotoPlayback.setSurface(1, this.iCatchSurfaceContext);
        AppLog.d(this.TAG, "end initSurface");
        this.surfaceCreated = true;
    }

    public void insidePanorama() {
        this.locate(0.45454544f);
    }

    private void locate(float distance) {
        this.panoramaPhotoPlayback.pancamGLTransLocate(distance);
    }

    public void clearImage(int iCatchSphereType) {
        this.surfaceCreated = false;
        this.removeGyroscopeListener();
        if (this.panoramaPhotoPlayback != null) {
            if (this.iCatchSurfaceContext != null) {
                this.panoramaPhotoPlayback.removeSurface(iCatchSphereType, this.iCatchSurfaceContext);
                this.iCatchSurfaceContext = null;
            }
            this.panoramaPhotoPlayback.clear();
        }
    }

    public void destroyImage(int iCatchSphereType) {
        if (this.panoramaPhotoPlayback != null) {
            this.panoramaPhotoPlayback.clear();
            if (this.iCatchSurfaceContext != null) {
                this.panoramaPhotoPlayback.removeSurface(iCatchSphereType, this.iCatchSurfaceContext);
                this.iCatchSurfaceContext = null;
            }
            this.panoramaPhotoPlayback.release();
        }
    }

    public void finish() {
        this.destroySession();
        this.activity.finish();
    }

    public void rotateB(MotionEvent e, float prevX, float prevY) {
        ICatchGLPoint prev = new ICatchGLPoint(prevX, prevY);
        ICatchGLPoint curr = new ICatchGLPoint(e.getX(), e.getY());
        this.panoramaPhotoPlayback.pancamGLTransformRotate(prev, curr);
    }

    public void onSufaceViewTouchDown(MotionEvent event) {
        this.touchMode = TouchMode.DRAG;
        this.mPreviousY = event.getY();
        this.mPreviousX = event.getX();
        this.beforeLenght = 0.0f;
        this.afterLenght = 0.0f;
    }

    public void onSufaceViewPointerDown(MotionEvent event) {
        Log.d((String)"2222", (String)("event.getPointerCount()................=" + event.getPointerCount()));
        if (event.getPointerCount() == 2) {
            this.touchMode = TouchMode.ZOOM;
            this.beforeLenght = this.getDistance(event);
        }
    }

    public void onSufaceViewTouchMove(MotionEvent event) {
        if (this.touchMode == TouchMode.DRAG) {
            this.rotateB(event, this.mPreviousX, this.mPreviousY);
            this.mPreviousY = event.getY();
            this.mPreviousX = event.getX();
        } else if (this.touchMode == TouchMode.ZOOM) {
            this.afterLenght = this.getDistance(event);
            float gapLenght = this.afterLenght - this.beforeLenght;
            if (Math.abs(gapLenght) > 5.0f) {
                float scale_temp = this.afterLenght / this.beforeLenght;
                this.setScale(scale_temp);
                this.beforeLenght = this.afterLenght;
            }
        }
    }

    float getDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)StrictMath.sqrt(x * x + y * y);
    }

    void setScale(float scale) {
        if (this.currentZoomRate >= 2.2f && scale > 1.0f || this.currentZoomRate <= 0.5f && scale < 1.0f) {
            return;
        }
        float temp = this.currentZoomRate * scale;
        if (scale > 1.0f) {
            if (temp <= 2.2f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 2.2f;
                this.zoom(this.currentZoomRate);
            }
        } else if (scale < 1.0f) {
            if (temp >= 0.5f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 0.5f;
                this.zoom(this.currentZoomRate);
            }
        }
    }

    private void zoom(float currentZoomRate) {
        this.locate(1.0f / currentZoomRate);
    }

    public void onSufaceViewTouchUp() {
        this.touchMode = TouchMode.NONE;
    }

    public void onSufaceViewTouchPointerUp() {
        this.touchMode = TouchMode.NONE;
    }

    public void onSensorChanged(SensorEvent event) {
        if (this.fileList == null || this.curPhotoIdx < 0) {
            return;
        }
        if (!this.fileList.get(this.curPhotoIdx).isPanorama()) {
            return;
        }
        if (event.sensor == null) {
            return;
        }
        if (event.sensor.getType() == 4) {
            float speedX = event.values[0];
            float speedY = event.values[1];
            float speedZ = event.values[2];
            if ((double)Math.abs(speedY) < 0.02 && (double)Math.abs(speedZ) < 0.02) {
                return;
            }
            this.rotate(speedX, speedY, speedZ, event.timestamp);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void rotate(float speedX, float speedY, float speedZ, long timestamp) {
        int rotation = this.activity.getWindowManager().getDefaultDisplay().getRotation();
        this.panoramaPhotoPlayback.pancamGLTransformRotate(rotation, speedX, speedY, speedZ, timestamp);
    }

    public void registerGyroscopeSensor() {
        this.sensorManager = (SensorManager)this.activity.getSystemService("sensor");
        this.gyroscopeSensor = this.sensorManager.getDefaultSensor(4);
        this.sensorManager.registerListener((SensorEventListener)this, this.gyroscopeSensor, 1);
    }

    public void removeGyroscopeListener() {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public void setDrawingArea(int windowW, int windowH) {
        AppLog.d(this.TAG, "start setDrawingArea windowW= " + windowW + " windowH= " + windowH);
        if (this.iCatchSurfaceContext != null) {
            try {
                this.iCatchSurfaceContext.setViewPort(0, 0, windowW, windowH);
            }
            catch (IchGLSurfaceNotSetException e) {
                e.printStackTrace();
            }
        }
        AppLog.d(this.TAG, "end setDrawingArea");
    }

    public void initPanorama() {
        this.panoramaPhotoPlayback.pancamGLInit();
    }

    private class DeleteThread
    implements Runnable {
        private DeleteThread() {
        }

        @Override
        public void run() {
            LocalPhotoPbPresenter.this.curPhotoIdx = LocalPhotoPbPresenter.this.photoPbView.getViewPagerCurrentItem();
            File tempFile = ((LocalPbItemInfo)((LocalPhotoPbPresenter)LocalPhotoPbPresenter.this).fileList.get((int)((LocalPhotoPbPresenter)LocalPhotoPbPresenter.this).curPhotoIdx)).file;
            if (tempFile.exists()) {
                tempFile.delete();
                MediaRefresh.notifySystemToScan(tempFile);
            }
            LocalPhotoPbPresenter.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    LocalPhotoPbPresenter.this.fileList.remove(LocalPhotoPbPresenter.this.curPhotoIdx);
                    LocalPhotoPbPresenter.this.viewPagerAdapter.notifyDataSetChanged();
                    LocalPhotoPbPresenter.this.photoPbView.setViewPagerAdapter(LocalPhotoPbPresenter.this.viewPagerAdapter);
                    LocalPhotoPbPresenter.this.photoNums = LocalPhotoPbPresenter.this.fileList.size();
                    if (LocalPhotoPbPresenter.this.photoNums == 0) {
                        LocalPhotoPbPresenter.this.activity.finish();
                        return;
                    }
                    if (LocalPhotoPbPresenter.this.curPhotoIdx == LocalPhotoPbPresenter.this.photoNums) {
                        LocalPhotoPbPresenter.this.curPhotoIdx--;
                    }
                    AppLog.d(LocalPhotoPbPresenter.this.TAG, "photoNums=" + LocalPhotoPbPresenter.this.photoNums + " curPhotoIdx=" + LocalPhotoPbPresenter.this.curPhotoIdx);
                    LocalPhotoPbPresenter.this.photoPbView.setViewPagerCurrentItem(LocalPhotoPbPresenter.this.curPhotoIdx);
                    LocalPhotoPbPresenter.this.updateUi();
                    MyProgressDialog.closeProgressDialog();
                }
            });
            AppLog.d(LocalPhotoPbPresenter.this.TAG, "end DeleteThread");
        }
    }

    private class MyViewPagerOnPagerChangeListener
    implements ViewPager.OnPageChangeListener {
        private MyViewPagerOnPagerChangeListener() {
        }

        public void onPageScrollStateChanged(int arg0) {
            switch (arg0) {
                case 1: {
                    LocalPhotoPbPresenter.this.isScrolling = true;
                    LocalPhotoPbPresenter.this.tempLastItem = LocalPhotoPbPresenter.this.photoPbView.getViewPagerCurrentItem();
                    break;
                }
                case 2: {
                    if (LocalPhotoPbPresenter.this.isScrolling && LocalPhotoPbPresenter.this.tempLastItem != -1 && LocalPhotoPbPresenter.this.tempLastItem != LocalPhotoPbPresenter.this.photoPbView.getViewPagerCurrentItem()) {
                        LocalPhotoPbPresenter.this.lastItem = LocalPhotoPbPresenter.this.tempLastItem;
                    }
                    LocalPhotoPbPresenter.this.curPhotoIdx = LocalPhotoPbPresenter.this.photoPbView.getViewPagerCurrentItem();
                    LocalPhotoPbPresenter.this.isScrolling = false;
                    break;
                }
                case 0: {
                    break;
                }
            }
        }

        public void onPageScrolled(int arg0, float arg1, int arg2) {
            if (!LocalPhotoPbPresenter.this.isScrolling || LocalPhotoPbPresenter.this.lastItem > arg2 || LocalPhotoPbPresenter.this.lastItem < arg2 || LocalPhotoPbPresenter.this.lastItem == arg2) {
                // empty if block
            }
            LocalPhotoPbPresenter.this.lastItem = arg2;
        }

        public void onPageSelected(int arg0) {
            AppLog.d(LocalPhotoPbPresenter.this.TAG, "onPageSelected arg0:" + arg0);
            LocalPhotoPbPresenter.this.updateUi();
        }
    }
}

