/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Presenter;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import com.icatch.panorama.Function.SDKEvent;
import com.icatch.panorama.Function.streaming.VideoStreaming;
import com.icatch.panorama.Listener.VideoFramePtsChangedListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.LocalSession;
import com.icatch.panorama.Presenter.Interface.BasePresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.PanoramaControl;
import com.icatch.panorama.SdkApi.PanoramaVideoPlayback;
import com.icatch.panorama.SdkApi.StreamStablization;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.Mode.TouchMode;
import com.icatch.panorama.data.Mode.VideoPbMode;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.Interface.LocalVideoPbView;
import com.icatch.panorama.ui.view.TextureVideoView;
import com.icatch.panorama.utils.ConvertTools;
import com.icatch.panorama.utils.PanoramaTools;
import com.icatchtek.pancam.customer.exception.IchGLFormatNotSupportedException;
import com.icatchtek.pancam.customer.type.ICatchGLPoint;
import com.icatchtek.reliant.customer.type.ICatchFile;

public class LocalVideoPbPresenter
extends BasePresenter
implements SensorEventListener {
    private String TAG = LocalVideoPbPresenter.class.getSimpleName();
    private LocalVideoPbView localVideoPbView;
    private Activity activity;
    private VideoPbMode videoPbMode = VideoPbMode.MODE_VIDEO_IDLE;
    private boolean needUpdateSeekBar = false;
    private String curLocalVideoPath;
    private VideoPbHandler handler = new VideoPbHandler();
    private boolean cacheFlag = false;
    private Boolean waitForCaching = false;
    private double currentTime = -1.0;
    private int videoDuration = 0;
    private int lastSeekBarPosition;
    private SDKEvent sdkEvent;
    private static final float MIN_ZOOM = 0.5f;
    private static final float MAX_ZOOM = 2.2f;
    private static final float FIXED_OUTSIDE_DISTANCE = 2.0f;
    private static final float FIXED_INSIDE_DISTANCE = 0.45454544f;
    private PanoramaVideoPlayback panoramaVideoPlayback;
    private PanoramaControl panoramaControl;
    private TouchMode touchMode = TouchMode.NONE;
    private float mPreviousY;
    private float mPreviousX;
    private float beforeLenght;
    private float afterLenght;
    private float currentZoomRate = 2.2f;
    private SensorManager sensorManager;
    private Sensor gyroscopeSensor;
    private VideoStreaming videoStreaming;
    private boolean enableRender = AppInfo.enableRender;
    private int curPanoramaType = 1;

    public LocalVideoPbPresenter(Activity activity, String videoPath) {
        super(activity);
        this.activity = activity;
        this.curLocalVideoPath = videoPath;
    }

    public void updatePbSeekbar(double pts) {
        if (this.videoPbMode != VideoPbMode.MODE_VIDEO_PLAY || !this.needUpdateSeekBar) {
            return;
        }
        this.currentTime = pts;
        int temp = new Double(this.currentTime * 100.0).intValue();
        this.localVideoPbView.setSeekBarProgress(temp);
    }

    public void setView(LocalVideoPbView localVideoPbView) {
        this.localVideoPbView = localVideoPbView;
        this.initCfg();
        this.initView();
        this.initClient();
    }

    private void initClient() {
        LocalSession.getInstance().preparePanoramaSession();
        this.panoramaVideoPlayback = LocalSession.getInstance().getPanoramaVideoPlayback();
        this.panoramaControl = LocalSession.getInstance().getPanoramaControl();
        this.videoStreaming = new VideoStreaming(this.panoramaVideoPlayback);
    }

    private void initView() {
        int start = this.curLocalVideoPath.lastIndexOf("/");
        String videoName = this.curLocalVideoPath.substring(start + 1);
        this.localVideoPbView.setVideoNameTxv(videoName);
        if (this.enableRender && PanoramaTools.isPanoramaForVideo(this.curLocalVideoPath)) {
            this.localVideoPbView.setPanoramaTypeBtnVisibility(0);
        } else {
            this.localVideoPbView.setPanoramaTypeBtnVisibility(8);
        }
    }

    public void initZoomView() {
        this.localVideoPbView.setZoomMinValue(0.5f);
        this.localVideoPbView.setZoomMaxValue(2.2f);
        this.localVideoPbView.updateZoomRateTV(0.45454544f);
        this.localVideoPbView.setProgress(0.45454544f);
    }

    public void addEventListener() {
        if (this.panoramaVideoPlayback == null) {
            return;
        }
        if (this.sdkEvent == null) {
            this.sdkEvent = new SDKEvent(this.handler, this.panoramaControl);
        }
        this.sdkEvent.addPanoramaEventListener(67);
        this.sdkEvent.addPanoramaEventListener(69);
        this.sdkEvent.addPanoramaEventListener(72);
        this.sdkEvent.addPanoramaEventListener(71);
        this.sdkEvent.addPanoramaEventListener(78);
    }

    public void removeEventListener() {
        if (this.panoramaVideoPlayback == null) {
            return;
        }
        this.sdkEvent.removePanoramaEventListener(67);
        this.sdkEvent.removePanoramaEventListener(69);
        this.sdkEvent.removePanoramaEventListener(72);
        this.sdkEvent.removePanoramaEventListener(71);
        this.sdkEvent.removePanoramaEventListener(78);
    }

    public void play() {
        AppLog.i(this.TAG, "start play video videoPbMode=" + (Object)((Object)this.videoPbMode));
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            AppLog.i(this.TAG, "start play video");
            this.addEventListener();
            if (this.enableRender) {
                this.registerGyroscopeSensor();
            }
            if (!this.enableRender) {
                this.videoStreaming.setFramePtsChangedListener(new VideoFramePtsChangedListener(){

                    @Override
                    public void onFramePtsChanged(double pts) {
                        LocalVideoPbPresenter.this.updatePbSeekbar(pts);
                    }
                });
            }
            boolean ret = false;
            AppLog.i(this.TAG, "start play video curLocalVideoPath=" + this.curLocalVideoPath);
            ICatchFile file = new ICatchFile(0, 2, this.curLocalVideoPath, this.curLocalVideoPath, 0L);
            try {
                ret = this.videoStreaming.play(file, false, false);
            }
            catch (IchGLFormatNotSupportedException e) {
                e.printStackTrace();
                MyToast.show((Context)this.activity, R.string.video_format_not_support);
                AppLog.e(this.TAG, "failed to startPlaybackStream");
                this.removeEventListener();
                this.removeGyroscopeListener();
                return;
            }
            if (!ret) {
                MyToast.show((Context)this.activity, R.string.dialog_failed);
                AppLog.e(this.TAG, "failed to startPlaybackStream");
                this.removeEventListener();
                if (this.enableRender) {
                    this.removeGyroscopeListener();
                }
                return;
            }
            this.cacheFlag = true;
            this.waitForCaching = true;
            this.localVideoPbView.showLoadingCircle(true);
            AppLog.i(this.TAG, "seekBar.getProgress() =" + this.localVideoPbView.getSeekBarProgress());
            this.videoDuration = this.panoramaVideoPlayback.getLength();
            AppLog.i(this.TAG, "end getLength = " + this.videoDuration);
            this.localVideoPbView.setPlayBtnSrc(R.drawable.ic_pause_white_36dp);
            this.localVideoPbView.setTimeLapsedValue("00:00");
            this.localVideoPbView.setTimeDurationValue(ConvertTools.secondsToMinuteOrHours(this.videoDuration / 100));
            this.localVideoPbView.setSeekBarMaxValue(this.videoDuration);
            this.videoPbMode = VideoPbMode.MODE_VIDEO_PLAY;
            this.localVideoPbView.showLoadingCircle(false);
            return;
        }
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_PAUSE) {
            AppLog.i(this.TAG, "mode == MODE_VIDEO_PAUSE");
            if (!this.panoramaVideoPlayback.resumePlayback()) {
                MyToast.show((Context)this.activity, R.string.dialog_failed);
                AppLog.i(this.TAG, "failed to resumePlayback");
                return;
            }
            this.localVideoPbView.setPlayBtnSrc(R.drawable.ic_pause_white_36dp);
            this.videoPbMode = VideoPbMode.MODE_VIDEO_PLAY;
            return;
        }
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_PLAY) {
            AppLog.i(this.TAG, "begin pause the playing");
            if (!this.panoramaVideoPlayback.pausePlayback()) {
                MyToast.show((Context)this.activity, R.string.dialog_failed);
                AppLog.i(this.TAG, "failed to pausePlayback");
                return;
            }
            this.removeEventListener();
            this.removeGyroscopeListener();
            this.localVideoPbView.setPlayBtnSrc(R.drawable.ic_play_arrow_white_36dp);
            this.videoPbMode = VideoPbMode.MODE_VIDEO_PAUSE;
            return;
        }
    }

    public void completedSeekToPosition() {
        this.lastSeekBarPosition = this.localVideoPbView.getSeekBarProgress();
        if (this.panoramaVideoPlayback.videoSeek((double)this.lastSeekBarPosition / 100.0)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.localVideoPbView.setTimeLapsedValue(ConvertTools.secondsToMinuteOrHours(this.lastSeekBarPosition / 100));
        } else {
            this.localVideoPbView.setSeekBarProgress(this.lastSeekBarPosition);
            MyToast.show((Context)this.activity, R.string.dialog_failed);
        }
        this.needUpdateSeekBar = false;
    }

    public void startSeekTouch() {
        this.lastSeekBarPosition = this.localVideoPbView.getSeekBarProgress();
    }

    public void setTimeLapsedValue(int progress) {
        this.localVideoPbView.setTimeLapsedValue(ConvertTools.secondsToMinuteOrHours(progress / 100));
    }

    public void initSurface(TextureVideoView surfaceHolder) {
        AppLog.i(this.TAG, "begin initSurface");
        this.videoStreaming.initSurface(this.enableRender, surfaceHolder, 0L, 0L);
        if (this.enableRender) {
            this.locate(0.45454544f);
        }
        int width = this.localVideoPbView.getSurfaceViewWidth();
        int heigth = this.localVideoPbView.getSurfaceViewHeight();
        AppLog.i(this.TAG, "SurfaceViewWidth=" + width + " SurfaceViewHeight=" + heigth);
        if (width <= 0 || heigth <= 0) {
            width = 1080;
            heigth = 1920;
        }
        this.videoStreaming.setViewParam(width, heigth);
        AppLog.i(this.TAG, "end initSurface");
    }

    public void stopVideoStream() {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        this.removeEventListener();
        this.removeGyroscopeListener();
        this.localVideoPbView.setTimeLapsedValue("00:00");
        this.videoStreaming.stop();
        this.localVideoPbView.setPlayBtnSrc(R.drawable.ic_play_arrow_white_36dp);
        this.localVideoPbView.setSeekBarProgress(0);
        this.localVideoPbView.setSeekBarSecondProgress(0);
        this.localVideoPbView.setTopBarVisibility(0);
        this.localVideoPbView.setBottomBarVisibility(0);
        this.localVideoPbView.setMoreSettingLayoutVisibility(8);
        this.videoPbMode = VideoPbMode.MODE_VIDEO_IDLE;
        this.localVideoPbView.setProgress(0.0f);
    }

    public void insidePanorama() {
        this.locate(0.45454544f);
    }

    public void locate(float progerss) {
        if (this.enableRender) {
            this.panoramaVideoPlayback.locate(progerss);
            this.localVideoPbView.updateZoomRateTV(progerss);
        }
    }

    public void destroyVideo() {
        this.removeEventListener();
        if (this.enableRender) {
            this.removeGyroscopeListener();
        }
        this.videoStreaming.stop();
        this.videoStreaming.removeSurface(this.curPanoramaType);
        this.videoStreaming.release();
    }

    public void release() {
        this.videoStreaming.removeSurface(this.curPanoramaType);
        this.videoStreaming.release();
    }

    public void rotateB(MotionEvent e, float prevX, float prevY) {
        if (!this.enableRender) {
            return;
        }
        ICatchGLPoint prev = new ICatchGLPoint(prevX, prevY);
        ICatchGLPoint curr = new ICatchGLPoint(e.getX(), e.getY());
        this.panoramaVideoPlayback.rotate(prev, curr);
    }

    public void destroySession() {
        LocalSession.getInstance().destroyPanoramaSession();
    }

    public void enableEIS(boolean enable) {
        StreamStablization streamStablization = this.panoramaVideoPlayback.getStreamStablization();
        if (streamStablization == null) {
            return;
        }
        if (enable) {
            streamStablization.enableStablization();
        } else {
            streamStablization.disableStablization();
        }
    }

    public void showBar(boolean isShowBar) {
        if (isShowBar) {
            if (this.videoPbMode != VideoPbMode.MODE_VIDEO_IDLE) {
                this.localVideoPbView.setBottomBarVisibility(8);
                this.localVideoPbView.setTopBarVisibility(8);
            }
        } else {
            this.localVideoPbView.setBottomBarVisibility(0);
            this.localVideoPbView.setTopBarVisibility(0);
        }
    }

    public void showMoreSettingLayout(boolean isShowBar) {
        if (isShowBar) {
            this.localVideoPbView.setBottomBarVisibility(8);
            this.localVideoPbView.setTopBarVisibility(8);
            this.localVideoPbView.setMoreSettingLayoutVisibility(0);
        } else {
            this.localVideoPbView.setBottomBarVisibility(0);
            this.localVideoPbView.setTopBarVisibility(0);
            this.localVideoPbView.setMoreSettingLayoutVisibility(8);
        }
    }

    public void onSufaceViewTouchDown(MotionEvent event) {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        this.touchMode = TouchMode.DRAG;
        this.mPreviousY = event.getY();
        this.mPreviousX = event.getX();
        this.beforeLenght = 0.0f;
        this.afterLenght = 0.0f;
    }

    public void onSufaceViewPointerDown(MotionEvent event) {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        if (event.getPointerCount() == 2) {
            this.touchMode = TouchMode.ZOOM;
            this.beforeLenght = this.getDistance(event);
        }
    }

    public void onSufaceViewTouchMove(MotionEvent event) {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        if (this.touchMode == TouchMode.DRAG) {
            this.rotateB(event, this.mPreviousX, this.mPreviousY);
            this.mPreviousY = event.getY();
            this.mPreviousX = event.getX();
        } else if (this.touchMode == TouchMode.ZOOM) {
            this.afterLenght = this.getDistance(event);
            float gapLenght = this.afterLenght - this.beforeLenght;
            if (Math.abs(gapLenght) > 5.0f) {
                float scale_temp = this.afterLenght / this.beforeLenght;
                this.setScale(scale_temp);
                this.beforeLenght = this.afterLenght;
            }
        }
    }

    float getDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)StrictMath.sqrt(x * x + y * y);
    }

    void setScale(float scale) {
        if (this.currentZoomRate >= 2.2f && scale > 1.0f || this.currentZoomRate <= 0.5f && scale < 1.0f) {
            return;
        }
        float temp = this.currentZoomRate * scale;
        if (scale > 1.0f) {
            if (temp <= 2.2f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 2.2f;
                this.zoom(this.currentZoomRate);
            }
        } else if (scale < 1.0f) {
            if (temp >= 0.5f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 0.5f;
                this.zoom(this.currentZoomRate);
            }
        }
    }

    private void zoom(float currentZoomRate) {
        this.locate(1.0f / currentZoomRate);
    }

    public void onSufaceViewTouchUp() {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        this.touchMode = TouchMode.NONE;
    }

    public void onSufaceViewTouchPointerUp() {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        this.touchMode = TouchMode.NONE;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor == null) {
            return;
        }
        if (event.sensor.getType() == 4) {
            float speedX = event.values[0];
            float speedY = event.values[1];
            float speedZ = event.values[2];
            if ((double)Math.abs(speedY) < 0.02 && (double)Math.abs(speedZ) < 0.02) {
                return;
            }
            this.rotate(speedX, speedY, speedZ, event.timestamp);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void rotate(float speedX, float speedY, float speedZ, long timestamp) {
        int rotation = this.activity.getWindowManager().getDefaultDisplay().getRotation();
        this.panoramaVideoPlayback.rotate(rotation, speedX, speedY, speedZ, timestamp);
    }

    private void registerGyroscopeSensor() {
        this.sensorManager = (SensorManager)this.activity.getSystemService("sensor");
        this.gyroscopeSensor = this.sensorManager.getDefaultSensor(4);
        this.sensorManager.registerListener((SensorEventListener)this, this.gyroscopeSensor, 1);
    }

    protected void removeGyroscopeListener() {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
            this.sensorManager = null;
        }
    }

    public void setDrawingArea(int windowW, int windowH) {
        this.videoStreaming.setDrawingArea(windowW, windowH);
    }

    public void redrawSurface() {
        int width = this.localVideoPbView.getSurfaceViewWidth();
        int heigth = this.localVideoPbView.getSurfaceViewHeight();
        this.videoStreaming.setViewParam(width, heigth);
        this.videoStreaming.setSurfaceViewArea();
    }

    public void back() {
        AppLog.d(this.TAG, " 12233 back");
        this.destroyVideo();
        this.removeEventListener();
        this.destroySession();
        this.activity.finish();
    }

    public void setPanoramaType() {
        if (this.curPanoramaType == 1) {
            this.videoStreaming.changePanoramaType(4);
            this.curPanoramaType = 4;
            this.localVideoPbView.setPanoramaTypeImageResource(R.drawable.asteroid);
            this.activity.setRequestedOrientation(4);
        } else if (this.curPanoramaType == 4) {
            this.videoStreaming.changePanoramaType(6);
            this.curPanoramaType = 6;
            this.localVideoPbView.setPanoramaTypeImageResource(R.drawable.vr);
            this.activity.setRequestedOrientation(6);
        } else {
            this.videoStreaming.changePanoramaType(1);
            this.curPanoramaType = 1;
            this.localVideoPbView.setPanoramaTypeImageResource(R.drawable.panorama);
            this.activity.setRequestedOrientation(4);
        }
    }

    private class VideoPbHandler
    extends Handler {
        private VideoPbHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1540: {
                    if (LocalVideoPbPresenter.this.videoPbMode != VideoPbMode.MODE_VIDEO_PLAY || !LocalVideoPbPresenter.this.needUpdateSeekBar) {
                        return;
                    }
                    LocalVideoPbPresenter.this.localVideoPbView.setSeekBarProgress(msg.arg1);
                    break;
                }
                case 1537: {
                    AppLog.i(LocalVideoPbPresenter.this.TAG, "receive EVENT_CACHE_STATE_CHANGED cacheFlag=" + LocalVideoPbPresenter.this.cacheFlag);
                    AppLog.i(LocalVideoPbPresenter.this.TAG, "EVENT_CACHE_STATE_CHANGED ---------msg.arg1 = " + msg.arg1);
                    if (!LocalVideoPbPresenter.this.cacheFlag) {
                        return;
                    }
                    if (msg.arg1 == 1) {
                        LocalVideoPbPresenter.this.localVideoPbView.showLoadingCircle(true);
                        LocalVideoPbPresenter.this.waitForCaching = true;
                        break;
                    }
                    if (msg.arg1 != 2) break;
                    LocalVideoPbPresenter.this.localVideoPbView.showLoadingCircle(false);
                    LocalVideoPbPresenter.this.needUpdateSeekBar = true;
                    LocalVideoPbPresenter.this.waitForCaching = false;
                    break;
                }
                case 1538: {
                    AppLog.i(LocalVideoPbPresenter.this.TAG, "receive EVENT_CACHE_PROGRESS_NOTIFY msg.arg1=" + msg.arg1 + "   waitForCaching=" + LocalVideoPbPresenter.this.waitForCaching);
                    if (!LocalVideoPbPresenter.this.cacheFlag) {
                        return;
                    }
                    if (LocalVideoPbPresenter.this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE || LocalVideoPbPresenter.this.videoPbMode == VideoPbMode.MODE_VIDEO_PAUSE) {
                        return;
                    }
                    if (LocalVideoPbPresenter.this.waitForCaching.booleanValue()) {
                        LocalVideoPbPresenter.this.localVideoPbView.setLoadPercent(msg.arg1);
                    }
                    LocalVideoPbPresenter.this.localVideoPbView.setSeekBarSecondProgress(msg.arg2);
                    break;
                }
                case 23: {
                    double temp = (Double)msg.obj;
                    LocalVideoPbPresenter.this.updatePbSeekbar(temp);
                    break;
                }
                case 24: {
                    AppLog.i(LocalVideoPbPresenter.this.TAG, "receive EVENT_VIDEO_PLAY_CLOSED");
                    LocalVideoPbPresenter.this.stopVideoStream();
                    break;
                }
                case 1542: {
                    LocalVideoPbPresenter.this.enableEIS(false);
                    LocalVideoPbPresenter.this.localVideoPbView.setEisSwitchChecked(false);
                }
            }
        }
    }
}

