/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Presenter;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.widget.LinearLayout;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.CameraConstants;
import com.icatch.panorama.DataConvert.StreamInfoConvert;
import com.icatch.panorama.Function.BaseProrertys;
import com.icatch.panorama.Function.CameraAction.PhotoCapture;
import com.icatch.panorama.Function.SDKEvent;
import com.icatch.panorama.Function.ThumbnailGetting.ThumbnailOperation;
import com.icatch.panorama.Function.streaming.CameraStreaming;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.MyCamera.CameraType;
import com.icatch.panorama.MyCamera.MyCamera;
import com.icatch.panorama.Presenter.Interface.BasePresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.CameraAction;
import com.icatch.panorama.SdkApi.CameraProperties;
import com.icatch.panorama.SdkApi.CameraState;
import com.icatch.panorama.SdkApi.FileOperation;
import com.icatch.panorama.SdkApi.PanoramaPreviewPlayback;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.CustomException.NullPointerException;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.Mode.TouchMode;
import com.icatch.panorama.data.entity.SettingMenu;
import com.icatch.panorama.data.entity.StreamInfo;
import com.icatch.panorama.data.type.SlowMotion;
import com.icatch.panorama.data.type.Tristate;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.Interface.PanoramaPreviewView;
import com.icatch.panorama.ui.appdialog.AppDialog;
import com.icatch.panorama.ui.view.TextureVideoView;
import com.icatch.panorama.utils.BitmapTools;
import com.icatch.panorama.utils.ConvertTools;
import com.icatch.panorama.utils.FileOpertion.FileOper;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatch.panorama.utils.PanoramaTools;
import com.icatch.panorama.utils.TimeTools;
import com.icatchtek.pancam.customer.ICatchPancamConfig;
import com.icatchtek.pancam.customer.exception.IchGLSurfaceNotSetException;
import com.icatchtek.pancam.customer.surface.ICatchSurfaceContext;
import com.icatchtek.pancam.customer.type.ICatchGLPoint;
import com.icatchtek.reliant.customer.type.ICatchFile;
import com.icatchtek.reliant.customer.type.ICatchH264StreamParam;
import com.icatchtek.reliant.customer.type.ICatchJPEGStreamParam;
import com.icatchtek.reliant.customer.type.ICatchStreamParam;
import java.io.File;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PanoramaPreviewPresenter
extends BasePresenter
implements SensorEventListener {
    private static final String TAG = "PanoramaPreviewPresenter";
    private static final float MIN_ZOOM = 0.4f;
    private static final float MAX_ZOOM = 2.2f;
    private PanoramaPreviewPlayback panoramaPreviewPlayback;
    private TouchMode touchMode = TouchMode.NONE;
    private float mPreviousY;
    private float mPreviousX;
    private float beforeLenght;
    private float afterLenght;
    private float currentZoomRate = 2.2f;
    private SensorManager sensorManager;
    private Sensor gyroscopeSensor;
    private Activity activity;
    private PanoramaPreviewView previewView;
    private CameraProperties cameraProperties;
    private CameraAction cameraAction;
    private CameraState cameraState;
    private FileOperation fileOperation;
    private BaseProrertys baseProrertys;
    private MyCamera curCamera;
    private PreviewHandler previewHandler;
    private SDKEvent sdkEvent;
    private int curMode = 0;
    private Timer videoCaptureButtomChangeTimer;
    public boolean videoCaptureButtomChangeFlag = true;
    private Timer recordingLapseTimeTimer;
    private int lapseTime = 0;
    private List<SettingMenu> settingMenuList;
    private boolean allowClickButtoms = true;
    private int currentSettingMenuMode;
    private WifiSSReceiver wifiSSReceiver;
    private long lastCilckTime = 0L;
    private long lastRecodeTime;
    private int curIcatchMode;
    private ICatchSurfaceContext iCatchSurfaceContext;
    private boolean hasInitSurface = false;
    private int curVideoWidth = 1920;
    private int curVideoHeight = 960;
    private int curVideoFps = 30;
    private String curCodecType = "H264";
    private CameraStreaming cameraStreaming;
    private int count;
    private ExecutorService cachedThreadPool = Executors.newCachedThreadPool();
    private boolean isPreviewing;
    private boolean isVideoModeDefault;
    private boolean isCapturing;

    public PanoramaPreviewPresenter(Activity activity) {
        super(activity);
        this.activity = activity;
    }

    public void setView(PanoramaPreviewView previewView) {
        this.previewView = previewView;
        this.initCfg();
        this.initData();
        LinearLayout layout_wifi_setting = (LinearLayout)this.activity.findViewById(R.id.layout_wifi_setting);
        if (layout_wifi_setting != null) {
            layout_wifi_setting.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PanoramaPreviewPresenter.this.setWifiMode();
                }
            });
        }
    }

    public void setVideoModeDefault(boolean videoModeDefault) {
        this.isVideoModeDefault = videoModeDefault;
    }

    public void initData() {
        this.curCamera = CameraManager.getInstance().getCurCamera();
        this.panoramaPreviewPlayback = this.curCamera.getPanoramaPreviewPlayback();
        this.cameraStreaming = new CameraStreaming(this.panoramaPreviewPlayback);
        this.cameraProperties = this.curCamera.getCameraProperties();
        this.cameraAction = this.curCamera.getCameraAction();
        this.cameraState = this.curCamera.getCameraState();
        this.fileOperation = this.curCamera.getFileOperation();
        this.baseProrertys = this.curCamera.getBaseProrertys();
        GlobalInfo.getInstance().enableConnectCheck(true);
        this.previewHandler = new PreviewHandler();
        this.sdkEvent = new SDKEvent(this.previewHandler);
        if (this.cameraProperties.hasFuction(55280)) {
            this.cameraProperties.setCaptureDelayMode(1);
        }
        if (this.curCamera.getCameraType() == CameraType.USB_CAMERA) {
            Intent intent = this.activity.getIntent();
            this.curVideoWidth = intent.getIntExtra("videoWidth", 1920);
            this.curVideoHeight = intent.getIntExtra("videoHeight", 960);
            this.curVideoFps = intent.getIntExtra("videoFps", 30);
            this.curCodecType = intent.getStringExtra("videoCodec");
            if (this.curCodecType == null) {
                this.curCodecType = "H264";
            }
            AppLog.d(TAG, "initData videoWidth=" + this.curVideoWidth + " videoHeight=" + this.curVideoHeight + " videoFps=" + this.curVideoFps + " curCodecType=" + this.curCodecType);
        }
    }

    public void initStatus() {
        this.cachedThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                final int battery = PanoramaPreviewPresenter.this.cameraProperties.getBatteryElectric();
                PanoramaPreviewPresenter.this.previewHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        int resid = ThumbnailOperation.getBatteryLevelIcon(battery);
                        if (resid > 0) {
                            PanoramaPreviewPresenter.this.previewView.setBatteryIcon(resid);
                            if (resid == R.drawable.ic_battery_charging_green24dp) {
                                AppDialog.showLowBatteryWarning((Context)PanoramaPreviewPresenter.this.activity);
                            }
                        }
                        PanoramaPreviewPresenter.this.previewView.setBatteryText(ThumbnailOperation.getBatteryLevelText(battery));
                        IntentFilter wifiSSFilter = new IntentFilter("android.net.wifi.RSSI_CHANGED");
                        PanoramaPreviewPresenter.this.wifiSSReceiver = new WifiSSReceiver();
                        PanoramaPreviewPresenter.this.activity.registerReceiver((BroadcastReceiver)PanoramaPreviewPresenter.this.wifiSSReceiver, wifiSSFilter);
                    }
                });
            }
        });
    }

    public void changeCameraMode(final int previewMode, final int ichVideoPreviewMode) {
        AppLog.i(TAG, "start changeCameraMode ichVideoPreviewMode=" + ichVideoPreviewMode);
        AppLog.i(TAG, "start changeCameraMode previewMode=" + previewMode + "  hasInitSurface=" + this.hasInitSurface);
        this.curIcatchMode = ichVideoPreviewMode;
        MyProgressDialog.showProgressDialog((Context)this.activity, R.string.action_processing);
        this.cachedThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                PanoramaPreviewPresenter.this.cameraAction.changePreviewMode(ichVideoPreviewMode);
                PanoramaPreviewPresenter.this.startPreview();
                PanoramaPreviewPresenter.this.previewHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        PanoramaPreviewPresenter.this.curMode = previewMode;
                        PanoramaPreviewPresenter.this.createUIByMode(PanoramaPreviewPresenter.this.curMode);
                        MyProgressDialog.closeProgressDialog();
                        PanoramaPreviewPresenter.this.previewView.dismissPopupWindow();
                    }
                });
            }
        });
    }

    public void redrawSurface() {
        if (this.curCamera.isStreamReady && !AppInfo.enableRender) {
            int width = this.previewView.getSurfaceViewWidth();
            int heigth = this.previewView.getSurfaceViewHeight();
            AppLog.i(TAG, "SurfaceViewWidth=" + width + " SurfaceViewHeight=" + heigth);
            if (width > 0 || heigth > 0) {
                this.cameraStreaming.setViewParam(width, heigth);
                this.cameraStreaming.setSurfaceViewArea();
            }
        }
    }

    public void startOrStopCapture() {
        if (TimeTools.isFastClick()) {
            return;
        }
        if (this.curMode == 3) {
            if (!this.cameraProperties.isSDCardExist()) {
                AppDialog.showDialogWarn((Context)this.activity, R.string.dialog_card_not_exist);
                return;
            }
            if (this.cameraProperties.getRecordingRemainTime() <= 0) {
                AppDialog.showDialogWarn((Context)this.activity, R.string.dialog_sd_card_is_full);
                return;
            }
            if (this.isVideoModeDefault) {
                boolean result = CameraManager.getInstance().getCurCamera().getCameraProperties().setPropertyValue(55138, 1);
                if (result) {
                    this.isCapturing = true;
                    this.disableCaptureBtn();
                    this.curMode = 3;
                }
            } else {
                this.lastRecodeTime = System.currentTimeMillis();
                if (this.cameraAction.startMovieRecord()) {
                    AppLog.i(TAG, "startRecordingLapseTimeTimer(0)");
                    this.curMode = 4;
                    this.startVideoCaptureButtomChangeTimer();
                    this.startRecordingLapseTimeTimer(0);
                }
            }
        } else if (this.curMode == 4) {
            if (System.currentTimeMillis() - this.lastRecodeTime < 2000L) {
                return;
            }
            if (this.cameraAction.stopVideoCapture()) {
                this.curMode = 3;
                this.stopVideoCaptureButtomChangeTimer();
                this.stopRecordingLapseTimeTimer();
                this.previewView.setRemainRecordingTimeText(ConvertTools.secondsToMinuteOrHours(this.cameraProperties.getRecordingRemainTime()));
            }
        } else if (this.curMode == 1) {
            if (!this.cameraProperties.isSDCardExist()) {
                AppDialog.showDialogWarn((Context)this.activity, R.string.dialog_card_not_exist);
                return;
            }
            if (this.cameraProperties.getRemainImageNum() < 4) {
                AppDialog.showDialogWarn((Context)this.activity, R.string.dialog_sd_card_is_full);
                return;
            }
            this.curMode = 2;
            this.startPhotoCapture();
        } else if (this.curMode == 8) {
            if (!this.cameraProperties.isSDCardExist()) {
                AppDialog.showDialogWarn((Context)this.activity, R.string.dialog_card_not_exist);
                return;
            }
            if (this.cameraProperties.getRemainImageNum() < 1) {
                AppDialog.showDialogWarn((Context)this.activity, R.string.dialog_sd_card_is_full);
                return;
            }
            if (this.cameraProperties.getCurrentTimeLapseInterval() == 0) {
                AppDialog.showDialogWarn((Context)this.activity, R.string.timeLapse_not_allow);
                return;
            }
            if (!this.cameraAction.startTimeLapse()) {
                AppLog.e(TAG, "failed to start startTimeLapse");
                return;
            }
            this.previewView.setCaptureBtnBackgroundResource(R.mipmap.btn_capture_prs);
            this.curMode = 6;
        } else if (this.curMode == 6) {
            AppLog.d(TAG, "curMode == PreviewMode.APP_STATE_TIMELAPSE_STILL_CAPTURE");
            if (!this.cameraAction.stopTimeLapse()) {
                AppLog.e(TAG, "failed to stopTimeLapse");
                return;
            }
            this.stopRecordingLapseTimeTimer();
            this.curMode = 8;
        } else if (this.curMode == 7) {
            AppLog.d(TAG, "curMode == PreviewMode.APP_STATE_TIMELAPSE_PREVIEW_VIDEO");
            if (!this.cameraProperties.isSDCardExist()) {
                AppDialog.showDialogWarn((Context)this.activity, R.string.dialog_card_not_exist);
                return;
            }
            if (this.cameraProperties.getRemainImageNum() < 1) {
                AppDialog.showDialogWarn((Context)this.activity, R.string.dialog_sd_card_is_full);
                return;
            }
            if (this.cameraProperties.getCurrentTimeLapseInterval() == 0) {
                AppLog.d(TAG, "time lapse is not allowed because of timelapse interval is OFF");
                AppDialog.showDialogWarn((Context)this.activity, R.string.timeLapse_not_allow);
                return;
            }
            if (!this.cameraAction.startTimeLapse()) {
                AppLog.e(TAG, "failed to start startTimeLapse");
                return;
            }
            this.curMode = 5;
            this.startVideoCaptureButtomChangeTimer();
            this.startRecordingLapseTimeTimer(0);
        } else if (this.curMode == 5) {
            AppLog.d(TAG, "curMode == PreviewMode.APP_STATE_TIMELAPSE_VIDEO_CAPTURE");
            if (!this.cameraAction.stopTimeLapse()) {
                AppLog.e(TAG, "failed to stopTimeLapse");
                return;
            }
            this.stopVideoCaptureButtomChangeTimer();
            this.stopRecordingLapseTimeTimer();
            this.curMode = 7;
        }
        AppLog.d(TAG, "end processing for responsing captureBtn clicking");
    }

    public void createUIByMode(int previewMode) {
        AppLog.i(TAG, "start createUIByMode previewMode=" + previewMode);
        if (this.cameraProperties.cameraModeSupport(42) && (previewMode == 3 || previewMode == 4)) {
            this.previewView.setPvModeBtnBackgroundResource(R.drawable.video_toggle_btn_on);
        }
        if (this.cameraProperties.cameraModeSupport(43) && (previewMode == 6 || previewMode == 8 || previewMode == 5 || previewMode == 7)) {
            this.previewView.setPvModeBtnBackgroundResource(R.drawable.timelapse_toggle_btn_on);
        }
        if (previewMode == 2 || previewMode == 6 || previewMode == 8 || previewMode == 1) {
            this.previewView.setCaptureBtnBackgroundResource(R.mipmap.btn_capture_nor);
        } else if (previewMode == 4 || previewMode == 5 || previewMode == 7 || previewMode == 3) {
            if (this.isVideoModeDefault) {
                this.previewView.setCaptureBtnBackgroundResource(R.mipmap.btn_capture_nor);
            } else {
                this.previewView.setCaptureBtnBackgroundResource(R.drawable.video_recording_btn_on);
            }
        }
        if (this.baseProrertys.getImageSize().needDisplayByMode(previewMode).booleanValue()) {
            this.previewView.setImageSizeLayoutVisibility(0);
            this.previewView.setImageSizeInfo(this.baseProrertys.getImageSize().getCurrentUiStringInPreview());
            this.previewView.setRemainCaptureCount(new Integer(this.cameraProperties.getRemainImageNum()).toString());
        } else {
            this.previewView.setImageSizeLayoutVisibility(8);
        }
        if (this.baseProrertys.getVideoSize().needDisplayByMode(previewMode).booleanValue()) {
            this.previewView.setVideoSizeLayoutVisibility(0);
            this.previewView.setVideoSizeInfo(this.baseProrertys.getVideoSize().getCurrentUiStringInPreview());
            this.previewView.setRemainRecordingTimeText(ConvertTools.secondsToMinuteOrHours(this.cameraProperties.getRecordingRemainTime()));
        } else {
            this.previewView.setVideoSizeLayoutVisibility(8);
        }
        if (this.baseProrertys.getBurst().needDisplayByMode(previewMode).booleanValue()) {
            this.previewView.setBurstStatusVisibility(0);
            try {
                this.previewView.setBurstStatusIcon(this.baseProrertys.getBurst().getCurrentIcon());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            this.previewView.setBurstStatusVisibility(8);
        }
        if (this.baseProrertys.getWhiteBalance().needDisplayByMode(previewMode).booleanValue()) {
            this.previewView.setWbStatusVisibility(0);
            try {
                this.previewView.setWbStatusIcon(this.baseProrertys.getWhiteBalance().getCurrentIcon());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            this.previewView.setWbStatusVisibility(8);
        }
        if (this.baseProrertys.getUpside().needDisplayByMode(previewMode).booleanValue() && this.cameraProperties.getCurrentUpsideDown() == 1) {
            this.previewView.setUpsideVisibility(0);
        } else {
            this.previewView.setUpsideVisibility(8);
        }
        if (this.baseProrertys.getSlowMotion().needDisplayByMode(previewMode).booleanValue() && this.cameraProperties.getCurrentSlowMotion() == SlowMotion.SLOW_MOTION_ON) {
            this.previewView.setSlowMotionVisibility(0);
        } else {
            this.previewView.setSlowMotionVisibility(8);
        }
        if (this.baseProrertys.getTimeLapseMode().needDisplayByMode(previewMode).booleanValue()) {
            this.previewView.settimeLapseModeVisibility(0);
            try {
                this.previewView.settimeLapseModeIcon(this.baseProrertys.getTimeLapseMode().getCurrentIcon());
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        } else {
            this.previewView.settimeLapseModeVisibility(8);
        }
    }

    public void initPreview() {
        AppLog.i(TAG, "initPreview curMode=" + this.curMode);
        if (this.cameraState.isMovieRecording()) {
            AppLog.i(TAG, "camera is recording...");
            this.curMode = 4;
            this.curIcatchMode = 2;
            this.startVideoCaptureButtomChangeTimer();
            this.startRecordingLapseTimeTimer(this.cameraProperties.getVideoRecordingTime());
        } else if (this.cameraState.isTimeLapseVideoOn()) {
            AppLog.i(TAG, "camera is TimeLapseVideoOn...");
            this.curCamera.timeLapsePreviewMode = 1;
            this.curMode = 5;
            this.curIcatchMode = 4;
            this.startVideoCaptureButtomChangeTimer();
            this.startRecordingLapseTimeTimer(this.cameraProperties.getVideoRecordingTime());
        } else if (this.cameraState.isTimeLapseStillOn()) {
            AppLog.i(TAG, "camera is TimeLapseStillOn...");
            this.curCamera.timeLapsePreviewMode = 0;
            this.curMode = 6;
            this.curIcatchMode = 3;
            this.startVideoCaptureButtomChangeTimer();
            this.startRecordingLapseTimeTimer(this.cameraProperties.getVideoRecordingTime());
        } else if (this.curMode == 0) {
            if (this.isVideoModeDefault) {
                this.curMode = 3;
                this.curIcatchMode = 2;
            } else {
                this.curMode = 1;
                this.curIcatchMode = 1;
            }
            this.changeCameraMode(this.curMode, this.curIcatchMode);
        } else if (this.curMode == 3) {
            AppLog.i(TAG, "initPreview curMode == PreviewMode.APP_STATE_VIDEO_PREVIEW");
            this.curIcatchMode = 2;
        } else if (this.curMode == 7) {
            AppLog.i(TAG, "initPreview curMode == PreviewMode.APP_STATE_TIMELAPSE_PREVIEW_VIDEO");
            this.curCamera.timeLapsePreviewMode = 1;
            this.curIcatchMode = 4;
        } else if (this.curMode == 8) {
            AppLog.i(TAG, "initPreview curMode == PreviewMode.APP_STATE_TIMELAPSE_PREVIEW_STILL");
            this.curCamera.timeLapsePreviewMode = 0;
            this.curIcatchMode = 3;
        } else if (this.curMode == 1) {
            AppLog.i(TAG, "initPreview curMode == ICH_STILL_PREVIEW_MODE");
            this.changeCameraMode(this.curMode, 1);
            this.curIcatchMode = 1;
        } else {
            this.curMode = 3;
            this.curIcatchMode = 2;
        }
        this.cameraAction.changePreviewMode(this.curIcatchMode);
        this.createUIByMode(this.curMode);
    }

    public void startVideoCaptureButtomChangeTimer() {
        AppLog.d(TAG, "startVideoCaptureButtomChangeTimer videoCaptureButtomChangeTimer=" + this.videoCaptureButtomChangeTimer);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                if (PanoramaPreviewPresenter.this.videoCaptureButtomChangeFlag) {
                    PanoramaPreviewPresenter.this.videoCaptureButtomChangeFlag = false;
                    PanoramaPreviewPresenter.this.previewHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (PanoramaPreviewPresenter.this.curMode == 4 || PanoramaPreviewPresenter.this.curMode == 5) {
                                PanoramaPreviewPresenter.this.previewView.setCaptureBtnBackgroundResource(R.drawable.video_recording_btn_on);
                            }
                        }
                    });
                } else {
                    PanoramaPreviewPresenter.this.videoCaptureButtomChangeFlag = true;
                    PanoramaPreviewPresenter.this.previewHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (PanoramaPreviewPresenter.this.curMode == 4 || PanoramaPreviewPresenter.this.curMode == 5) {
                                PanoramaPreviewPresenter.this.previewView.setCaptureBtnBackgroundResource(R.drawable.video_recording_btn_off);
                            }
                        }
                    });
                }
            }
        };
        this.videoCaptureButtomChangeTimer = new Timer(true);
        this.videoCaptureButtomChangeTimer.schedule(task, 0L, 1000L);
    }

    public void stopVideoCaptureButtomChangeTimer() {
        AppLog.d(TAG, "stopVideoCaptureButtomChangeTimer videoCaptureButtomChangeTimer=" + this.videoCaptureButtomChangeTimer);
        if (this.videoCaptureButtomChangeTimer != null) {
            this.videoCaptureButtomChangeTimer.cancel();
        }
        this.previewView.setCaptureBtnBackgroundResource(R.drawable.video_recording_btn_on);
    }

    private void startRecordingLapseTimeTimer(int startTime) {
        if (!this.cameraProperties.hasFuction(55293)) {
            return;
        }
        AppLog.i(TAG, "startRecordingLapseTimeTimer curMode=" + this.curMode);
        if (this.curMode == 4 || this.curMode == 5 || this.curMode == 6) {
            AppLog.i(TAG, "startRecordingLapseTimeTimer");
            if (this.recordingLapseTimeTimer != null) {
                this.recordingLapseTimeTimer.cancel();
            }
            this.lapseTime = startTime;
            this.recordingLapseTimeTimer = new Timer(true);
            this.previewView.setRecordingTimeVisibility(0);
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    PanoramaPreviewPresenter.this.previewHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            PanoramaPreviewPresenter.this.previewView.setRecordingTime(ConvertTools.secondsToHours(PanoramaPreviewPresenter.this.lapseTime++));
                        }
                    });
                }
            };
            this.recordingLapseTimeTimer.schedule(timerTask, 0L, 1000L);
        }
    }

    private void stopRecordingLapseTimeTimer() {
        if (this.recordingLapseTimeTimer != null) {
            this.recordingLapseTimeTimer.cancel();
        }
        this.previewView.setRecordingTime("00:00:00");
        this.previewView.setRecordingTimeVisibility(8);
    }

    public void changePreviewMode(int previewMode) {
        AppLog.d(TAG, "changePreviewMode previewMode=" + previewMode);
        AppLog.d(TAG, "changePreviewMode curMode=" + this.curMode);
        long timeInterval = System.currentTimeMillis() - this.lastCilckTime;
        AppLog.d(TAG, "repeat click: timeInterval=" + timeInterval);
        if (System.currentTimeMillis() - this.lastCilckTime < 2000L) {
            AppLog.d(TAG, "repeat click: timeInterval < 2000");
            return;
        }
        this.lastCilckTime = System.currentTimeMillis();
        if (previewMode == 4098) {
            if (this.curMode == 2 || this.curMode == 5 || this.curMode == 6) {
                MyToast.show((Context)this.activity, R.string.stream_error_capturing);
                return;
            }
            if (this.curMode == 1 || this.curMode == 8 || this.curMode == 7) {
                this.stopPreview();
                this.changeCameraMode(3, 2);
            }
        } else if (previewMode == 4097) {
            if (this.curMode == 4 || this.curMode == 6 || this.curMode == 5) {
                MyToast.show((Context)this.activity, R.string.stream_error_capturing);
                return;
            }
            if (this.curMode == 3 || this.curMode == 8 || this.curMode == 7) {
                this.stopPreview();
                this.changeCameraMode(1, 1);
            }
        } else if (previewMode == 4099) {
            if (this.curMode == 2 || this.curMode == 4) {
                MyToast.show((Context)this.activity, R.string.stream_error_capturing);
                return;
            }
            if (this.curMode == 1 || this.curMode == 3) {
                this.stopPreview();
                if (this.curCamera.timeLapsePreviewMode == 1) {
                    this.changeCameraMode(7, 4);
                } else if (this.curCamera.timeLapsePreviewMode == 0) {
                    this.changeCameraMode(8, 3);
                }
            }
        }
    }

    private void startPhotoCapture() {
        this.disableCaptureBtn();
        final PhotoCapture photoCapture = new PhotoCapture();
        if (this.cameraProperties.hasFuction(55280)) {
            photoCapture.addOnStopPreviewListener(new PhotoCapture.OnStopPreviewListener(){

                @Override
                public void onStop() {
                    if (!PanoramaPreviewPresenter.this.cameraProperties.hasFuction(55044)) {
                        PanoramaPreviewPresenter.this.stopPreview();
                    }
                }
            });
            this.cachedThreadPool.submit(new Runnable(){

                @Override
                public void run() {
                    PanoramaPreviewPresenter.this.isCapturing = true;
                    photoCapture.startCapture();
                }
            });
        } else {
            if (!this.cameraProperties.hasFuction(55044)) {
                this.stopPreview();
            }
            this.previewHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!PanoramaPreviewPresenter.this.cameraAction.capturePhoto()) {
                        PanoramaPreviewPresenter.this.curMode = 1;
                        MyToast.show((Context)PanoramaPreviewPresenter.this.activity, R.string.text_operation_failed);
                    }
                }
            }, 500L);
        }
    }

    public boolean isCapturing() {
        return this.isCapturing;
    }

    public void setCapturing(boolean capturing) {
        this.isCapturing = capturing;
    }

    public void setCurMode(int curMode) {
        this.curMode = curMode;
    }

    public boolean disconnectCamera() {
        return this.curCamera.disconnect();
    }

    public void delConnectFailureListener() {
        GlobalInfo.getInstance().enableConnectCheck(false);
    }

    public void unregisterWifiSSReceiver() {
        if (this.wifiSSReceiver != null) {
            this.activity.unregisterReceiver((BroadcastReceiver)this.wifiSSReceiver);
        }
    }

    public void showPvModePopupWindow() {
        AppLog.d(TAG, "showPvModePopupWindow curMode=" + this.curMode);
        if (this.curMode == 2 || this.curMode == 5 || this.curMode == 6 || this.curMode == 4) {
            MyToast.show((Context)this.activity, R.string.stream_error_capturing);
            return;
        }
        this.previewView.showPopupWindow(this.curMode);
        if (this.cameraProperties.cameraModeSupport(42)) {
            this.previewView.setVideoRadioBtnVisibility(0);
        }
        if (this.cameraProperties.cameraModeSupport(43)) {
            this.previewView.setTimepLapseRadioBtnVisibility(0);
        }
        if (this.curMode == 1) {
            this.previewView.setCaptureRadioBtnChecked(true);
        } else if (this.curMode == 3) {
            this.previewView.setVideoRadioBtnChecked(true);
        } else if (this.curMode == 8 || this.curMode == 7) {
            this.previewView.setTimepLapseRadioChecked(true);
        }
    }

    public void addEvent() {
        this.sdkEvent.addEventListener(17);
        this.sdkEvent.addEventListener(36);
        this.sdkEvent.addEventListener(34);
        this.sdkEvent.addEventListener(33);
        this.sdkEvent.addEventListener(82);
        this.sdkEvent.addEventListener(35);
        this.sdkEvent.addEventListener(1);
        this.sdkEvent.addEventListener(74);
        this.sdkEvent.addEventListener(81);
        this.sdkEvent.addCustomizeEvent(20481);
        this.sdkEvent.addCustomizeEvent(58117);
        this.sdkEvent.addCustomizeEvent(58118);
        this.sdkEvent.addEventListener(103);
        this.sdkEvent.addEventListener(20);
    }

    public void delEvent() {
        this.sdkEvent.delEventListener(17);
        this.sdkEvent.delEventListener(36);
        this.sdkEvent.delEventListener(35);
        this.sdkEvent.delEventListener(82);
        this.sdkEvent.delEventListener(34);
        this.sdkEvent.delEventListener(1);
        this.sdkEvent.delEventListener(33);
        this.sdkEvent.delEventListener(74);
        this.sdkEvent.delEventListener(81);
        this.sdkEvent.delCustomizeEventListener(20481);
        this.sdkEvent.delCustomizeEventListener(58117);
        this.sdkEvent.delCustomizeEventListener(58118);
        this.sdkEvent.delEventListener(103);
        this.sdkEvent.delEventListener(20);
    }

    @Override
    public void isAppBackground() {
        super.isAppBackground();
    }

    @Override
    public void finishActivity() {
        this.destroyPreview();
        super.finishActivity();
    }

    @Override
    public void redirectToAnotherActivity(final Context context, final Class<?> cls) {
        AppLog.i(TAG, "pbBtn is clicked curMode=" + this.curMode);
        if (!this.allowClickButtoms) {
            AppLog.i(TAG, "do not allow to response button clicking");
            return;
        }
        this.allowClickButtoms = false;
        if (!this.cameraProperties.isSDCardExist()) {
            AppDialog.showDialogWarn((Context)this.activity, R.string.dialog_card_lose);
            this.allowClickButtoms = true;
            return;
        }
        AppLog.i(TAG, "curMode =" + this.curMode);
        if (this.curMode == 1 || this.curMode == 3 || this.curMode == 7 || this.curMode == 8) {
            this.destroyPreview();
            this.allowClickButtoms = true;
            MyProgressDialog.showProgressDialog(context, R.string.action_processing);
            this.previewHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MyProgressDialog.closeProgressDialog();
                    Intent intent = new Intent();
                    AppLog.i(PanoramaPreviewPresenter.TAG, "intent:start PbMainActivity.class");
                    intent.setClass(context, cls);
                    context.startActivity(intent);
                    AppLog.i(PanoramaPreviewPresenter.TAG, "intent:end start PbMainActivity.class");
                }
            }, 500L);
            return;
        }
        if (this.curMode == 4 || this.curMode == 5) {
            MyToast.show((Context)this.activity, R.string.stream_error_recording);
        } else if (this.curMode == 2 || this.curMode == 6) {
            MyToast.show((Context)this.activity, R.string.stream_error_capturing);
        }
        this.allowClickButtoms = true;
        AppLog.i(TAG, "end processing for responsing pbBtn clicking");
    }

    public void startPreview() {
        if (this.isPreviewing) {
            return;
        }
        this.isPreviewing = true;
        this.cachedThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                Tristate retValue;
                AppLog.d(PanoramaPreviewPresenter.TAG, "start startPreview hasInitSurface=" + PanoramaPreviewPresenter.this.hasInitSurface);
                boolean isSupportPreview = PanoramaPreviewPresenter.this.cameraProperties.isSupportPreview();
                AppLog.d(PanoramaPreviewPresenter.TAG, "start startPreview isSupportPreview=" + isSupportPreview);
                if (!isSupportPreview) {
                    PanoramaPreviewPresenter.this.previewHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            PanoramaPreviewPresenter.this.previewView.setSupportPreviewTxvVisibility(0);
                        }
                    });
                    PanoramaPreviewPresenter.this.isPreviewing = false;
                    return;
                }
                if (!PanoramaPreviewPresenter.this.hasInitSurface) {
                    PanoramaPreviewPresenter.this.isPreviewing = false;
                    return;
                }
                if (PanoramaPreviewPresenter.this.panoramaPreviewPlayback == null) {
                    AppLog.d(PanoramaPreviewPresenter.TAG, "null point");
                    PanoramaPreviewPresenter.this.isPreviewing = false;
                    return;
                }
                if (((PanoramaPreviewPresenter)PanoramaPreviewPresenter.this).curCamera.isStreamReady) {
                    PanoramaPreviewPresenter.this.isPreviewing = false;
                    return;
                }
                if (AppInfo.enableDumpVideo) {
                    String streamOutputPath = PanoramaSDK.getContext().getExternalFilesDir(null) + "/360CamResoure/Raw/";
                    FileOper.createDirectory(streamOutputPath);
                    try {
                        ICatchPancamConfig.getInstance().enableDumpTransportStream(true, streamOutputPath);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                int cacheTime = PanoramaPreviewPresenter.this.cameraProperties.getPreviewCacheTime();
                cacheTime = 0;
                AppLog.d(PanoramaPreviewPresenter.TAG, "setPreviewCacheParam cacheTime:" + cacheTime);
                ICatchPancamConfig.getInstance().setPreviewCacheParam(cacheTime, 200);
                ICatchStreamParam iCatchStreamParam = PanoramaPreviewPresenter.this.getStreamParam();
                if (AppInfo.enableRender) {
                    if (PanoramaTools.isPanorama(iCatchStreamParam.getWidth(), iCatchStreamParam.getHeight())) {
                        PanoramaPreviewPresenter.this.registerGyroscopeSensor();
                    }
                    retValue = PanoramaPreviewPresenter.this.panoramaPreviewPlayback.start(iCatchStreamParam, !AppInfo.disableAudio);
                } else {
                    retValue = PanoramaPreviewPresenter.this.cameraStreaming.start(iCatchStreamParam, false);
                }
                ((PanoramaPreviewPresenter)PanoramaPreviewPresenter.this).curCamera.isStreamReady = retValue == Tristate.NORMAL;
                PanoramaPreviewPresenter.this.previewHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (retValue == Tristate.ABNORMAL) {
                            PanoramaPreviewPresenter.this.previewView.setSupportPreviewTxvVisibility(0);
                            PanoramaPreviewPresenter.this.isPreviewing = false;
                        } else if (retValue == Tristate.NORMAL) {
                            PanoramaPreviewPresenter.this.enableCaptureBtn();
                            PanoramaPreviewPresenter.this.isPreviewing = true;
                            PanoramaPreviewPresenter.this.previewView.setSupportPreviewTxvVisibility(8);
                        } else {
                            PanoramaPreviewPresenter.this.previewView.setSupportPreviewTxvVisibility(8);
                            PanoramaPreviewPresenter.this.isPreviewing = false;
                            MyToast.show((Context)PanoramaPreviewPresenter.this.activity, R.string.open_preview_failed);
                        }
                    }
                });
                AppLog.d(PanoramaPreviewPresenter.TAG, "end startPreview retValue=" + (Object)((Object)retValue));
            }
        });
    }

    private ICatchStreamParam getStreamParam() {
        StreamInfo streamInfo = null;
        if (this.curCamera.getCameraType() == CameraType.USB_CAMERA) {
            streamInfo = new StreamInfo(this.curCodecType, this.curVideoWidth, this.curVideoHeight, 5000000, this.curVideoFps);
            AppLog.d(TAG, "start startPreview videoWidth=" + this.curVideoWidth + " videoHeight=" + this.curVideoHeight + " videoFps=" + this.curVideoFps + " curCodecType=" + this.curCodecType);
        } else {
            String streamUrl = this.cameraProperties.getCurrentStreamInfo();
            AppLog.d(TAG, " start startStreamAndPreview streamUrl=[" + streamUrl + "]");
            if (streamUrl != null) {
                streamInfo = StreamInfoConvert.convertToStreamInfoBean(streamUrl);
            }
        }
        Object iCatchStreamParam = null;
        iCatchStreamParam = streamInfo == null ? new ICatchH264StreamParam(1920, 960, 30) : (streamInfo.mediaCodecType.equals("MJPG") ? new ICatchJPEGStreamParam(streamInfo.width, streamInfo.height, streamInfo.fps, streamInfo.bitrate) : (streamInfo.mediaCodecType.equals("H264") ? new ICatchH264StreamParam(streamInfo.width, streamInfo.height, streamInfo.fps, streamInfo.bitrate) : new ICatchH264StreamParam(1920, 960, 30)));
        return iCatchStreamParam;
    }

    public void stopPreview() {
        this.isPreviewing = false;
        if (AppInfo.enableDumpVideo) {
            ICatchPancamConfig.getInstance().disableDumpTransportStream(true);
        }
        if (AppInfo.enableRender) {
            this.removeGyroscopeListener();
            if (this.panoramaPreviewPlayback != null && this.curCamera.isStreamReady) {
                this.curCamera.isStreamReady = false;
                this.panoramaPreviewPlayback.stop();
            }
        } else if (this.curCamera.isStreamReady) {
            this.curCamera.isStreamReady = false;
            this.cameraStreaming.stop();
        }
    }

    public void locate(float progerss) {
        this.panoramaPreviewPlayback.locate(progerss);
    }

    public void destroyPreview() {
        this.isPreviewing = false;
        if (AppInfo.enableDumpVideo) {
            ICatchPancamConfig.getInstance().disableDumpTransportStream(true);
        }
        this.hasInitSurface = false;
        if (AppInfo.enableRender) {
            this.removeGyroscopeListener();
            if (this.panoramaPreviewPlayback != null && this.curCamera.isStreamReady) {
                if (this.iCatchSurfaceContext != null) {
                    AppLog.d(TAG, "destroyPreview.....");
                    this.panoramaPreviewPlayback.removeSurface(1, this.iCatchSurfaceContext);
                }
                this.panoramaPreviewPlayback.stop();
                this.panoramaPreviewPlayback.release();
                this.curCamera.isStreamReady = false;
            }
        } else if (this.curCamera.isStreamReady) {
            this.curCamera.isStreamReady = false;
            this.cameraStreaming.stop();
        }
    }

    public void rotateB(MotionEvent e, float prevX, float prevY) {
        ICatchGLPoint prev = new ICatchGLPoint(prevX, prevY);
        ICatchGLPoint curr = new ICatchGLPoint(e.getX(), e.getY());
        this.panoramaPreviewPlayback.rotate(prev, curr);
    }

    public void onSufaceViewTouchDown(MotionEvent event) {
        this.touchMode = TouchMode.DRAG;
        this.mPreviousY = event.getY();
        this.mPreviousX = event.getX();
        this.beforeLenght = 0.0f;
        this.afterLenght = 0.0f;
    }

    public void onSufaceViewPointerDown(MotionEvent event) {
        if (event.getPointerCount() == 2) {
            this.touchMode = TouchMode.ZOOM;
            this.beforeLenght = this.getDistance(event);
        }
    }

    public void onSufaceViewTouchMove(MotionEvent event) {
        if (this.touchMode == TouchMode.DRAG) {
            this.rotateB(event, this.mPreviousX, this.mPreviousY);
            this.mPreviousY = event.getY();
            this.mPreviousX = event.getX();
        } else if (this.touchMode == TouchMode.ZOOM) {
            this.afterLenght = this.getDistance(event);
            float gapLenght = this.afterLenght - this.beforeLenght;
            if (Math.abs(gapLenght) > 5.0f) {
                float scale_temp = this.afterLenght / this.beforeLenght;
                this.setScale(scale_temp);
                this.beforeLenght = this.afterLenght;
            }
        }
    }

    float getDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)StrictMath.sqrt(x * x + y * y);
    }

    void setScale(float scale) {
        if (this.currentZoomRate >= 2.2f && scale > 1.0f || this.currentZoomRate <= 0.4f && scale < 1.0f) {
            return;
        }
        float temp = this.currentZoomRate * scale;
        if (scale > 1.0f) {
            if (temp <= 2.2f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 2.2f;
                this.zoom(this.currentZoomRate);
            }
        } else if (scale < 1.0f) {
            if (temp >= 0.4f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 0.4f;
                this.zoom(this.currentZoomRate);
            }
        }
    }

    private void zoom(float currentZoomRate) {
        this.locate(1.0f / currentZoomRate);
    }

    public void onSufaceViewTouchUp() {
        this.touchMode = TouchMode.NONE;
    }

    public void onSufaceViewTouchPointerUp() {
        this.touchMode = TouchMode.NONE;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor == null) {
            return;
        }
        if (event.sensor.getType() == 4) {
            float speedX = event.values[0];
            float speedY = event.values[1];
            float speedZ = event.values[2];
            if ((double)Math.abs(speedY) < 0.05 && (double)Math.abs(speedZ) < 0.05) {
                return;
            }
            this.rotate(speedX, speedY, speedZ, event.timestamp);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void rotate(float speedX, float speedY, float speedZ, long timestamp) {
        int rotation = this.activity.getWindowManager().getDefaultDisplay().getRotation();
        this.panoramaPreviewPlayback.rotate(rotation, speedX, speedY, speedZ, timestamp);
    }

    private void registerGyroscopeSensor() {
        AppLog.d(TAG, "registerGyroscopeSensor");
        this.sensorManager = (SensorManager)this.activity.getSystemService("sensor");
        this.gyroscopeSensor = this.sensorManager.getDefaultSensor(4);
        this.sensorManager.registerListener((SensorEventListener)this, this.gyroscopeSensor, 1);
    }

    protected void removeGyroscopeListener() {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public void setDrawingArea(int width, int height) {
        if (this.panoramaPreviewPlayback != null && this.iCatchSurfaceContext != null) {
            AppLog.d(TAG, "start setDrawingArea width=" + width + " height=" + height);
            try {
                this.iCatchSurfaceContext.setViewPort(0, 0, width, height);
            }
            catch (IchGLSurfaceNotSetException e) {
                e.printStackTrace();
            }
            AppLog.d(TAG, "end setDrawingArea");
        }
    }

    public void initSurface(final TextureVideoView surface) {
        this.disableCaptureBtn();
        this.cachedThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                PanoramaPreviewPresenter.this.hasInitSurface = false;
                AppLog.i(PanoramaPreviewPresenter.TAG, "begin initSurface");
                if (PanoramaPreviewPresenter.this.panoramaPreviewPlayback == null) {
                    return;
                }
                if (AppInfo.enableRender) {
                    PanoramaPreviewPresenter.this.iCatchSurfaceContext = new ICatchSurfaceContext(new Surface(surface.getSurfaceTexture()));
                    ICatchStreamParam iCatchStreamParam = PanoramaPreviewPresenter.this.getStreamParam();
                    if (iCatchStreamParam != null && PanoramaTools.isPanorama(iCatchStreamParam.getWidth(), iCatchStreamParam.getHeight())) {
                        PanoramaPreviewPresenter.this.panoramaPreviewPlayback.enableGLRender();
                        PanoramaPreviewPresenter.this.panoramaPreviewPlayback.init(1);
                        PanoramaPreviewPresenter.this.panoramaPreviewPlayback.setSurface(1, PanoramaPreviewPresenter.this.iCatchSurfaceContext);
                    } else {
                        PanoramaPreviewPresenter.this.panoramaPreviewPlayback.enableCommonRender(PanoramaPreviewPresenter.this.iCatchSurfaceContext);
                    }
                } else {
                    PanoramaPreviewPresenter.this.cameraStreaming.disnableRender();
                    int width = PanoramaPreviewPresenter.this.previewView.getSurfaceViewWidth();
                    int heigth = PanoramaPreviewPresenter.this.previewView.getSurfaceViewHeight();
                    AppLog.i(PanoramaPreviewPresenter.TAG, "SurfaceViewWidth=" + width + " SurfaceViewHeight=" + heigth);
                    if (width <= 0 || heigth <= 0) {
                        width = 1080;
                        heigth = 1920;
                    }
                    PanoramaPreviewPresenter.this.cameraStreaming.setSurface(surface);
                    PanoramaPreviewPresenter.this.cameraStreaming.setViewParam(width, heigth);
                }
                PanoramaPreviewPresenter.this.hasInitSurface = true;
                AppLog.i(PanoramaPreviewPresenter.TAG, "end initSurface");
                PanoramaPreviewPresenter.this.startPreview();
            }
        });
    }

    public boolean enableTCP() {
        return this.cameraProperties.enableTCP();
    }

    public boolean setMotorStep(int step) {
        return this.cameraProperties.setMotorStep(step);
    }

    public int getMotorStatus() {
        return this.cameraProperties.getMotorStatus();
    }

    public void enableCaptureBtn() {
        this.previewView.setCaptureBtnEnability(true);
        this.previewView.setCaptureBtnBackgroundResource(R.mipmap.btn_capture_nor);
    }

    public void disableCaptureBtn() {
        this.previewView.setCaptureBtnEnability(false);
        this.previewView.setCaptureBtnBackgroundResource(R.mipmap.btn_capture_prs);
    }

    public void resetCount() {
        this.count = 0;
    }

    public int getCount() {
        return this.count;
    }

    public void onSelect(final int position, final boolean isV50) {
        this.cachedThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                int take;
                if (position == 1) {
                    CameraManager.getInstance().getCurCamera().getBaseProrertys().getBurst().setValueByPosition(3);
                    take = 4;
                } else if (position == 2) {
                    CameraManager.getInstance().getCurCamera().getBaseProrertys().getBurst().setValueByPosition(5);
                    take = 8;
                } else {
                    if (!PanoramaPreviewPresenter.this.isVideoModeDefault) {
                        CameraManager.getInstance().getCurCamera().getBaseProrertys().getBurst().setValueByPosition(0);
                    }
                    take = isV50 ? 1 : 3;
                }
                CameraConstants.TAKE_COUNT = take;
                CameraConstants.PICTURE_AMOUNT = take * 4;
            }
        });
    }

    public void shutDownThreadPool() {
        this.cachedThreadPool.shutdownNow();
    }

    public void setWifiMode() {
        CharSequence[] items = new String[]{"5G WIFI", "2.4G WIFI"};
        AlertDialog.Builder listDialog = new AlertDialog.Builder((Context)this.activity);
        listDialog.setTitle((CharSequence)"\u8bbe\u7f6eWIFI\u5de5\u4f5c\u6a21\u5f0f");
        listDialog.setItems(items, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (CameraManager.getInstance().getCurCamera().getCameraProperties().setPropertyValue(55143, which)) {
                    MyToast.show((Context)PanoramaPreviewPresenter.this.activity, "\u8bbe\u7f6e\u6210\u529f\uff0c\u91cd\u542f\u8bbe\u5907\u540e\u751f\u6548");
                } else {
                    MyToast.show((Context)PanoramaPreviewPresenter.this.activity, "\u8bbe\u7f6e\u5931\u8d25!");
                }
            }
        });
        listDialog.show();
    }

    private class WifiSSReceiver
    extends BroadcastReceiver {
        private WifiManager wifi;

        public WifiSSReceiver() {
            this.wifi = (WifiManager)PanoramaPreviewPresenter.this.activity.getApplicationContext().getSystemService("wifi");
            this.changeWifiStatusIcon();
        }

        public void onReceive(Context arg0, Intent arg1) {
            this.changeWifiStatusIcon();
        }

        private void changeWifiStatusIcon() {
            WifiInfo info = this.wifi.getConnectionInfo();
            if (info.getBSSID() != null) {
                int strength = WifiManager.calculateSignalLevel((int)info.getRssi(), (int)8);
                AppLog.d(PanoramaPreviewPresenter.TAG, "change Wifi Status\uff1a" + strength);
                switch (strength) {
                    case 0: {
                        PanoramaPreviewPresenter.this.previewView.setWifiIcon(R.drawable.ic_signal_wifi_0_bar_green_24dp);
                        break;
                    }
                    case 1: {
                        PanoramaPreviewPresenter.this.previewView.setWifiIcon(R.drawable.ic_signal_wifi_1_bar_green_24dp);
                        break;
                    }
                    case 2: 
                    case 3: {
                        PanoramaPreviewPresenter.this.previewView.setWifiIcon(R.drawable.ic_signal_wifi_2_bar_green_24dp);
                        break;
                    }
                    case 4: 
                    case 5: {
                        PanoramaPreviewPresenter.this.previewView.setWifiIcon(R.drawable.ic_signal_wifi_3_bar_green_24dp);
                        break;
                    }
                    case 6: 
                    case 7: {
                        PanoramaPreviewPresenter.this.previewView.setWifiIcon(R.drawable.ic_signal_wifi_4_bar_green_24dp);
                        break;
                    }
                }
            }
        }
    }

    private class PreviewHandler
    extends Handler {
        private PreviewHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_BATTERY_ELETRIC_CHANGED power =" + msg.arg1);
                    int batteryLevel = msg.arg1;
                    int resid = ThumbnailOperation.getBatteryLevelIcon(batteryLevel);
                    if (resid > 0) {
                        PanoramaPreviewPresenter.this.previewView.setBatteryIcon(resid);
                        if (batteryLevel < 20) {
                            AppDialog.showLowBatteryWarning((Context)PanoramaPreviewPresenter.this.activity);
                        }
                    }
                    PanoramaPreviewPresenter.this.previewView.setBatteryText(ThumbnailOperation.getBatteryLevelText(batteryLevel));
                    break;
                }
                case 8: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_CONNECTION_FAILURE");
                    PanoramaPreviewPresenter.this.stopPreview();
                    PanoramaPreviewPresenter.this.delEvent();
                    PanoramaPreviewPresenter.this.disconnectCamera();
                    break;
                }
                case 4: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_SD_CARD_FULL");
                    AppDialog.showDialogWarn((Context)PanoramaPreviewPresenter.this.activity, R.string.dialog_card_full);
                    break;
                }
                case 5: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_VIDEO_OFF:curMode=" + PanoramaPreviewPresenter.this.curMode);
                    if (PanoramaPreviewPresenter.this.curMode != 4 && PanoramaPreviewPresenter.this.curMode != 5) break;
                    if (PanoramaPreviewPresenter.this.curMode == 4) {
                        PanoramaPreviewPresenter.this.curMode = 3;
                    } else {
                        PanoramaPreviewPresenter.this.curMode = 7;
                    }
                    PanoramaPreviewPresenter.this.stopVideoCaptureButtomChangeTimer();
                    PanoramaPreviewPresenter.this.stopRecordingLapseTimeTimer();
                    PanoramaPreviewPresenter.this.previewView.setRemainRecordingTimeText(ConvertTools.secondsToMinuteOrHours(PanoramaPreviewPresenter.this.cameraProperties.getRecordingRemainTime()));
                    break;
                }
                case 6: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_VIDEO_ON:curMode =" + PanoramaPreviewPresenter.this.curMode);
                    if (PanoramaPreviewPresenter.this.curMode == 3) {
                        PanoramaPreviewPresenter.this.curMode = 4;
                        PanoramaPreviewPresenter.this.startVideoCaptureButtomChangeTimer();
                        PanoramaPreviewPresenter.this.startRecordingLapseTimeTimer(0);
                        break;
                    }
                    if (PanoramaPreviewPresenter.this.curMode != 7) break;
                    PanoramaPreviewPresenter.this.curMode = 5;
                    PanoramaPreviewPresenter.this.startVideoCaptureButtomChangeTimer();
                    PanoramaPreviewPresenter.this.startRecordingLapseTimeTimer(0);
                    break;
                }
                case 3: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_CAPTURE_START:curMode=" + PanoramaPreviewPresenter.this.curMode);
                    if (PanoramaPreviewPresenter.this.curMode != 6) {
                        return;
                    }
                    MyToast.show((Context)PanoramaPreviewPresenter.this.activity, R.string.capture_start);
                    break;
                }
                case 1: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_CAPTURE_COMPLETED:curMode=" + PanoramaPreviewPresenter.this.curMode);
                    if (PanoramaPreviewPresenter.this.curMode == 2) {
                        if (!PanoramaPreviewPresenter.this.cameraProperties.hasFuction(55044)) {
                            PanoramaPreviewPresenter.this.startPreview();
                        }
                        PanoramaPreviewPresenter.this.previewView.setRemainCaptureCount(new Integer(PanoramaPreviewPresenter.this.cameraProperties.getRemainImageNum()).toString());
                        PanoramaPreviewPresenter.this.curMode = 1;
                    } else if (PanoramaPreviewPresenter.this.curMode == 6) {
                        PanoramaPreviewPresenter.this.previewView.setRemainCaptureCount(new Integer(PanoramaPreviewPresenter.this.cameraProperties.getRemainImageNum()).toString());
                        MyToast.show((Context)PanoramaPreviewPresenter.this.activity, R.string.capture_completed);
                    }
                    PanoramaPreviewPresenter.this.count++;
                    PanoramaPreviewPresenter.this.previewView.onCapture(PanoramaPreviewPresenter.this.count);
                    break;
                }
                case 25: 
                case 26: {
                    PanoramaPreviewPresenter.this.previewView.onMotorFinished();
                    break;
                }
                case 7: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "EVENT_FILE_ADDED");
                    break;
                }
                case 9: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_TIME_LAPSE_STOP:curMode=" + PanoramaPreviewPresenter.this.curMode);
                    if (PanoramaPreviewPresenter.this.curMode == 5) {
                        if (!PanoramaPreviewPresenter.this.cameraAction.stopTimeLapse()) break;
                        PanoramaPreviewPresenter.this.stopVideoCaptureButtomChangeTimer();
                        PanoramaPreviewPresenter.this.stopRecordingLapseTimeTimer();
                        PanoramaPreviewPresenter.this.previewView.setRemainCaptureCount(new Integer(PanoramaPreviewPresenter.this.cameraProperties.getRemainImageNum()).toString());
                        PanoramaPreviewPresenter.this.curMode = 7;
                        break;
                    }
                    if (PanoramaPreviewPresenter.this.curMode != 6 || !PanoramaPreviewPresenter.this.cameraAction.stopTimeLapse()) break;
                    PanoramaPreviewPresenter.this.stopRecordingLapseTimeTimer();
                    PanoramaPreviewPresenter.this.previewView.setRemainCaptureCount(new Integer(PanoramaPreviewPresenter.this.cameraProperties.getRemainImageNum()).toString());
                    PanoramaPreviewPresenter.this.curMode = 8;
                    break;
                }
                case 12: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_VIDEO_RECORDING_TIME");
                    PanoramaPreviewPresenter.this.startRecordingLapseTimeTimer(0);
                    break;
                }
                case 11: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_FILE_DOWNLOAD");
                    AppLog.d(PanoramaPreviewPresenter.TAG, "receive EVENT_FILE_DOWNLOAD  msg.arg1 =" + msg.arg1);
                    if (!AppInfo.autoDownloadAllow) {
                        AppLog.d(PanoramaPreviewPresenter.TAG, "GlobalInfo.autoDownload == false");
                        return;
                    }
                    if (!Environment.getExternalStorageState().equals("mounted")) {
                        return;
                    }
                    final String path = Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720photo/";
                    File directory = new File(path);
                    if ((float)(FileTools.getFileSize(directory) / 1024L) >= AppInfo.autoDownloadSizeLimit * 1024.0f * 1024.0f) {
                        AppLog.d(PanoramaPreviewPresenter.TAG, "can not download because size limit");
                        return;
                    }
                    final ICatchFile file = (ICatchFile)msg.obj;
                    FileOper.createDirectory(path);
                    new Thread(){

                        @Override
                        public void run() {
                            AppLog.d(PanoramaPreviewPresenter.TAG, "receive downloadFile file =" + file);
                            AppLog.d(PanoramaPreviewPresenter.TAG, "receive downloadFile path =" + path);
                            boolean retvalue = PanoramaPreviewPresenter.this.fileOperation.downloadFile(file, path + file.getFileName());
                            if (retvalue) {
                                PanoramaPreviewPresenter.this.previewHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        String path1 = path + file.getFileName();
                                        Bitmap bitmap = BitmapTools.getImageByPath(path1, 150, 150);
                                        PanoramaPreviewPresenter.this.previewView.setAutoDownloadBitmap(bitmap);
                                    }
                                });
                            }
                            AppLog.d(PanoramaPreviewPresenter.TAG, "receive downloadFile retvalue =" + retvalue);
                        }
                    }.start();
                    break;
                }
                case 513: {
                    AppLog.d(PanoramaPreviewPresenter.TAG, "receive SETTING_OPTION_AUTO_DOWNLOAD");
                    Boolean switcher = (Boolean)msg.obj;
                    if (switcher.booleanValue()) {
                        AppInfo.autoDownloadAllow = true;
                        PanoramaPreviewPresenter.this.previewView.setAutoDownloadVisibility(0);
                        break;
                    }
                    AppInfo.autoDownloadAllow = false;
                    PanoramaPreviewPresenter.this.previewView.setAutoDownloadVisibility(8);
                    break;
                }
                case 17: {
                    AppLog.i(PanoramaPreviewPresenter.TAG, "receive EVENT_SDCARD_INSERT");
                    AppDialog.showDialogWarn((Context)PanoramaPreviewPresenter.this.activity, R.string.dialog_card_inserted);
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }
}

