/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Presenter;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import com.icatch.panorama.Function.SDKEvent;
import com.icatch.panorama.Function.streaming.VideoStreaming;
import com.icatch.panorama.Listener.VideoFramePtsChangedListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.MyCamera.MyCamera;
import com.icatch.panorama.Presenter.Interface.BasePresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.FileOperation;
import com.icatch.panorama.SdkApi.PanoramaVideoPlayback;
import com.icatch.panorama.SdkApi.StreamStablization;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.Mode.TouchMode;
import com.icatch.panorama.data.Mode.VideoPbMode;
import com.icatch.panorama.data.SystemInfo.SystemInfo;
import com.icatch.panorama.data.entity.DownloadInfo;
import com.icatch.panorama.data.entity.MultiPbItemInfo;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.Interface.PanoramaVideoPbView;
import com.icatch.panorama.ui.appdialog.SingleDownloadDialog;
import com.icatch.panorama.ui.view.TextureVideoView;
import com.icatch.panorama.utils.ConvertTools;
import com.icatch.panorama.utils.FileOpertion.FileOper;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatch.panorama.utils.MediaRefresh;
import com.icatch.panorama.utils.PanoramaTools;
import com.icatchtek.pancam.customer.exception.IchGLFormatNotSupportedException;
import com.icatchtek.pancam.customer.type.ICatchGLPoint;
import com.icatchtek.reliant.customer.type.ICatchFile;
import java.io.File;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PanoramaVideoPbPresenter
extends BasePresenter
implements SensorEventListener {
    private String TAG = PanoramaVideoPbPresenter.class.getSimpleName();
    private PanoramaVideoPbView panoramaVideoPbView;
    private Activity activity;
    private FileOperation fileOperation;
    private VideoPbMode videoPbMode = VideoPbMode.MODE_VIDEO_IDLE;
    private boolean needUpdateSeekBar = true;
    private ICatchFile curVideoFile;
    private VideoPbHandler handler = new VideoPbHandler();
    private boolean cacheFlag = false;
    private Boolean waitForCaching = false;
    private double currentTime = -1.0;
    private int videoDuration = 0;
    private int lastSeekBarPosition;
    private static final float MIN_ZOOM = 0.5f;
    private static final float MAX_ZOOM = 2.2f;
    private static final float FIXED_OUTSIDE_DISTANCE = 2.0f;
    private static final float FIXED_INSIDE_DISTANCE = 0.45454544f;
    private PanoramaVideoPlayback panoramaVideoPlayback;
    private TouchMode touchMode = TouchMode.NONE;
    private float mPreviousY;
    private float mPreviousX;
    private float beforeLenght;
    private float afterLenght;
    private float currentZoomRate = 2.2f;
    private SensorManager sensorManager;
    private Sensor gyroscopeSensor;
    private int curVideoPosition;
    private ExecutorService executor;
    protected Timer downloadProgressTimer;
    private String downloadingFilename = "";
    private List<MultiPbItemInfo> fileList;
    private SingleDownloadDialog singleDownloadDialog;
    private SDKEvent sdkEvent;
    private String curFilePath;
    private VideoStreaming videoStreaming;
    private boolean enableRender;
    private int curPanoramaType;

    public PanoramaVideoPbPresenter(Activity activity) {
        super(activity);
        this.fileList = GlobalInfo.getInstance().remoteVideoList;
        this.curFilePath = "";
        this.enableRender = AppInfo.enableRender;
        this.curPanoramaType = 1;
        this.activity = activity;
        Intent intent = activity.getIntent();
        Bundle data = intent.getExtras();
        this.curVideoPosition = data.getInt("curfilePosition");
        if (this.fileList != null && !this.fileList.isEmpty()) {
            this.curVideoFile = this.fileList.get((int)this.curVideoPosition).iCatchFile;
        }
        AppLog.i(this.TAG, "cur video position=" + this.curVideoPosition + " video name=" + this.curVideoFile.getFileName());
        this.initClint();
    }

    public void updatePbSeekbar(double pts) {
        if (this.videoPbMode != VideoPbMode.MODE_VIDEO_PLAY || !this.needUpdateSeekBar) {
            return;
        }
        this.currentTime = pts;
        int temp = new Double(this.currentTime * 100.0).intValue();
        this.panoramaVideoPbView.setSeekBarProgress(temp);
    }

    public void setView(PanoramaVideoPbView videoPbView) {
        this.panoramaVideoPbView = videoPbView;
        this.initCfg();
        this.initView();
    }

    private void initView() {
        String fileName = this.curVideoFile.getFileName();
        int start = fileName.lastIndexOf("/");
        String videoName = fileName.substring(start + 1);
        this.panoramaVideoPbView.setVideoNameTxv(videoName);
        if (this.enableRender && PanoramaTools.isPanorama(this.curVideoFile.getFileWidth(), this.curVideoFile.getFileHeight())) {
            this.panoramaVideoPbView.setPanoramaTypeBtnVisibility(0);
        } else {
            this.panoramaVideoPbView.setPanoramaTypeBtnVisibility(8);
        }
    }

    public void initClint() {
        MyCamera camera = CameraManager.getInstance().getCurCamera();
        this.panoramaVideoPlayback = camera.getPanoramaVideoPlayback();
        this.fileOperation = camera.getFileOperation();
        this.videoStreaming = new VideoStreaming(this.panoramaVideoPlayback);
    }

    public void addEventListener() {
        if (this.panoramaVideoPlayback == null) {
            return;
        }
        if (this.sdkEvent == null) {
            this.sdkEvent = new SDKEvent(this.handler);
        }
        this.sdkEvent.addPanoramaEventListener(67);
        this.sdkEvent.addPanoramaEventListener(69);
        this.sdkEvent.addPanoramaEventListener(72);
        this.sdkEvent.addPanoramaEventListener(71);
        this.sdkEvent.addPanoramaEventListener(78);
    }

    public void removeEventListener() {
        if (this.panoramaVideoPlayback == null) {
            return;
        }
        this.sdkEvent.removePanoramaEventListener(67);
        this.sdkEvent.removePanoramaEventListener(69);
        this.sdkEvent.removePanoramaEventListener(72);
        this.sdkEvent.removePanoramaEventListener(71);
        this.sdkEvent.removePanoramaEventListener(78);
    }

    public void play() {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            AppLog.i(this.TAG, "start play video");
            this.addEventListener();
            if (this.enableRender) {
                this.registerGyroscopeSensor();
            }
            if (!this.enableRender) {
                this.videoStreaming.setFramePtsChangedListener(new VideoFramePtsChangedListener(){

                    @Override
                    public void onFramePtsChanged(double pts) {
                        PanoramaVideoPbPresenter.this.updatePbSeekbar(pts);
                    }
                });
            }
            boolean ret = false;
            try {
                ret = this.videoStreaming.play(this.curVideoFile, false, true);
            }
            catch (IchGLFormatNotSupportedException e) {
                e.printStackTrace();
                MyToast.show((Context)this.activity, R.string.video_format_not_support);
                AppLog.e(this.TAG, "failed to startPlaybackStream");
                return;
            }
            if (!ret) {
                MyToast.show((Context)this.activity, R.string.dialog_failed);
                AppLog.e(this.TAG, "failed to startPlaybackStream");
                return;
            }
            this.panoramaVideoPbView.showLoadingCircle(true);
            this.cacheFlag = true;
            this.waitForCaching = true;
            AppLog.i(this.TAG, "seekBar.getProgress() =" + this.panoramaVideoPbView.getSeekBarProgress());
            int tempDuration = this.panoramaVideoPlayback.getLength();
            AppLog.i(this.TAG, "end getLength = " + tempDuration);
            this.panoramaVideoPbView.setPlayBtnSrc(R.drawable.ic_pause_white_36dp);
            this.panoramaVideoPbView.setTimeLapsedValue("00:00");
            this.panoramaVideoPbView.setTimeDurationValue(ConvertTools.secondsToMinuteOrHours(tempDuration / 100));
            this.panoramaVideoPbView.setSeekBarMaxValue(tempDuration);
            this.videoDuration = tempDuration;
            AppLog.i(this.TAG, "has start the GetVideoFrameThread() to get play video");
            this.videoPbMode = VideoPbMode.MODE_VIDEO_PLAY;
        } else if (this.videoPbMode == VideoPbMode.MODE_VIDEO_PAUSE) {
            this.resumeVideoPb();
        } else if (this.videoPbMode == VideoPbMode.MODE_VIDEO_PLAY) {
            this.pauseVideoPb();
        }
    }

    private void resumeVideoPb() {
        AppLog.i(this.TAG, "mode == MODE_VIDEO_PAUSE");
        if (!this.panoramaVideoPlayback.resumePlayback()) {
            MyToast.show((Context)this.activity, R.string.dialog_failed);
            AppLog.i(this.TAG, "failed to resumePlayback");
            return;
        }
        this.panoramaVideoPbView.setPlayBtnSrc(R.drawable.ic_pause_white_36dp);
        this.videoPbMode = VideoPbMode.MODE_VIDEO_PLAY;
    }

    private void pauseVideoPb() {
        AppLog.i(this.TAG, "begin pause the playing");
        if (!this.panoramaVideoPlayback.pausePlayback()) {
            MyToast.show((Context)this.activity, R.string.dialog_failed);
            AppLog.i(this.TAG, "failed to pausePlayback");
            return;
        }
        this.panoramaVideoPbView.setPlayBtnSrc(R.drawable.ic_play_arrow_white_36dp);
        this.videoPbMode = VideoPbMode.MODE_VIDEO_PAUSE;
        this.panoramaVideoPbView.showLoadingCircle(false);
    }

    public void seekBarOnStopTrackingTouch() {
        this.needUpdateSeekBar = false;
        this.lastSeekBarPosition = this.panoramaVideoPbView.getSeekBarProgress();
        if (this.panoramaVideoPlayback.videoSeek((double)this.lastSeekBarPosition / 100.0)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            this.panoramaVideoPbView.setSeekBarProgress(this.lastSeekBarPosition);
            MyToast.show((Context)this.activity, R.string.dialog_failed);
        }
    }

    public void seekBarOnStartTrackingTouch() {
        this.needUpdateSeekBar = false;
        this.lastSeekBarPosition = this.panoramaVideoPbView.getSeekBarProgress();
    }

    public void setTimeLapsedValue(int progress) {
        this.panoramaVideoPbView.setTimeLapsedValue(ConvertTools.secondsToMinuteOrHours(progress / 100));
    }

    public void initSurface(TextureVideoView surfaceHolder) {
        AppLog.i(this.TAG, "begin initSurface");
        this.videoStreaming.initSurface(this.enableRender, surfaceHolder, this.curVideoFile.getFileWidth(), this.curVideoFile.getFileHeight());
        if (this.enableRender) {
            this.locate(0.45454544f);
        }
        if (!this.enableRender) {
            int width = this.panoramaVideoPbView.getSurfaceViewWidth();
            int heigth = this.panoramaVideoPbView.getSurfaceViewHeight();
            AppLog.i(this.TAG, "SurfaceViewWidth=" + width + " SurfaceViewHeight=" + heigth);
            if (width <= 0 || heigth <= 0) {
                width = 1080;
                heigth = 1920;
            }
            this.videoStreaming.setViewParam(width, heigth);
        }
        AppLog.i(this.TAG, "end initSurface");
    }

    public void stopVideoStream() {
        AppLog.i(this.TAG, "Begin stopVideoStream");
        this.removeEventListener();
        if (this.enableRender) {
            this.removeGyroscopeListener();
        }
        this.panoramaVideoPbView.setTimeLapsedValue("00:00");
        this.videoStreaming.stop();
        this.panoramaVideoPbView.setPlayBtnSrc(R.drawable.ic_play_arrow_white_36dp);
        this.panoramaVideoPbView.setSeekBarProgress(0);
        this.panoramaVideoPbView.setSeekBarSecondProgress(0);
        this.panoramaVideoPbView.setTopBarVisibility(0);
        this.panoramaVideoPbView.setBottomBarVisibility(0);
        this.panoramaVideoPbView.showLoadingCircle(false);
        this.videoPbMode = VideoPbMode.MODE_VIDEO_IDLE;
        AppLog.i(this.TAG, "End stopVideoStream");
    }

    public void locate(float progerss) {
        if (this.enableRender) {
            this.panoramaVideoPlayback.locate(progerss);
        }
    }

    public void destroyVideo(int iCatchSphereType) {
        this.removeEventListener();
        if (this.enableRender) {
            this.removeGyroscopeListener();
        }
        this.videoStreaming.removeSurface(iCatchSphereType);
        this.videoStreaming.stop();
        this.videoStreaming.release();
    }

    public void rotateB(MotionEvent e, float prevX, float prevY) {
        ICatchGLPoint prev = new ICatchGLPoint(prevX, prevY);
        ICatchGLPoint curr = new ICatchGLPoint(e.getX(), e.getY());
        this.panoramaVideoPlayback.rotate(prev, curr);
    }

    public void delete() {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_PLAY) {
            this.pauseVideoPb();
        }
        this.showDeleteEnsureDialog();
    }

    public void download() {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_PLAY) {
            this.pauseVideoPb();
        }
        this.showDownloadEnsureDialog();
    }

    public void showBar(boolean isShowBar) {
        if (isShowBar) {
            if (this.videoPbMode == VideoPbMode.MODE_VIDEO_PLAY) {
                this.panoramaVideoPbView.setBottomBarVisibility(8);
                this.panoramaVideoPbView.setTopBarVisibility(8);
            }
        } else {
            this.panoramaVideoPbView.setBottomBarVisibility(0);
            this.panoramaVideoPbView.setTopBarVisibility(0);
            if (this.videoPbMode != VideoPbMode.MODE_VIDEO_PLAY) {
                // empty if block
            }
        }
    }

    public void showDownloadEnsureDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
        builder.setCancelable(false);
        builder.setTitle(R.string.dialog_downloading_single);
        long videoFileSize = 0L;
        videoFileSize = this.fileList.get(this.curVideoPosition).getFileSizeInteger() / 1024L / 1024L;
        AppLog.d(this.TAG, "video FileSize=" + videoFileSize);
        long minute = videoFileSize / 60L;
        long seconds = videoFileSize % 60L;
        String what = this.activity.getResources().getString(R.string.gallery_download_with_vid_msg).replace("$1$", "1").replace("$3$", String.valueOf(seconds)).replace("$2$", String.valueOf(minute));
        builder.setMessage((CharSequence)what);
        builder.setNegativeButton(R.string.gallery_download, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                AppLog.d(PanoramaVideoPbPresenter.this.TAG, "showProgressDialog");
                if (PanoramaVideoPbPresenter.this.videoPbMode == VideoPbMode.MODE_VIDEO_PAUSE) {
                    PanoramaVideoPbPresenter.this.stopVideoStream();
                }
                if (SystemInfo.getSDFreeSize() < PanoramaVideoPbPresenter.this.curVideoFile.getFileSize()) {
                    dialog.dismiss();
                    MyToast.show((Context)PanoramaVideoPbPresenter.this.activity, R.string.text_sd_card_memory_shortage);
                } else {
                    PanoramaVideoPbPresenter.this.singleDownloadDialog = new SingleDownloadDialog((Context)PanoramaVideoPbPresenter.this.activity, PanoramaVideoPbPresenter.this.curVideoFile);
                    PanoramaVideoPbPresenter.this.singleDownloadDialog.setBackBtnOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            PanoramaVideoPbPresenter.this.handler.obtainMessage(1541, 0, 0).sendToTarget();
                        }
                    });
                    PanoramaVideoPbPresenter.this.singleDownloadDialog.showDownloadDialog();
                    PanoramaVideoPbPresenter.this.executor = Executors.newSingleThreadExecutor();
                    PanoramaVideoPbPresenter.this.executor.submit(new DownloadThread(), null);
                    PanoramaVideoPbPresenter.this.downloadProgressTimer = new Timer();
                    PanoramaVideoPbPresenter.this.downloadProgressTimer.schedule((TimerTask)new DownloadProcessTask(), 0L, 1000L);
                }
            }
        });
        builder.setPositiveButton(R.string.gallery_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                if (PanoramaVideoPbPresenter.this.videoPbMode == VideoPbMode.MODE_VIDEO_PAUSE) {
                    PanoramaVideoPbPresenter.this.resumeVideoPb();
                }
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    public void showDeleteEnsureDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
        builder.setCancelable(false);
        builder.setTitle((CharSequence)this.activity.getResources().getString(R.string.gallery_delete_des).replace("$1$", "1"));
        builder.setNegativeButton(R.string.gallery_delete, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                if (PanoramaVideoPbPresenter.this.videoPbMode == VideoPbMode.MODE_VIDEO_PAUSE) {
                    PanoramaVideoPbPresenter.this.stopVideoStream();
                }
                MyProgressDialog.showProgressDialog((Context)PanoramaVideoPbPresenter.this.activity, R.string.dialog_deleting);
                PanoramaVideoPbPresenter.this.executor = Executors.newSingleThreadExecutor();
                PanoramaVideoPbPresenter.this.executor.submit(new DeleteThread(), null);
            }
        });
        builder.setPositiveButton(R.string.gallery_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                if (PanoramaVideoPbPresenter.this.videoPbMode == VideoPbMode.MODE_VIDEO_PAUSE) {
                    PanoramaVideoPbPresenter.this.resumeVideoPb();
                }
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    public void onSufaceViewTouchDown(MotionEvent event) {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        this.touchMode = TouchMode.DRAG;
        this.mPreviousY = event.getY();
        this.mPreviousX = event.getX();
        this.beforeLenght = 0.0f;
        this.afterLenght = 0.0f;
    }

    public void onSufaceViewPointerDown(MotionEvent event) {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        if (event.getPointerCount() == 2) {
            this.touchMode = TouchMode.ZOOM;
            this.beforeLenght = this.getDistance(event);
        }
    }

    public void onSufaceViewTouchMove(MotionEvent event) {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        if (this.touchMode == TouchMode.DRAG) {
            this.rotateB(event, this.mPreviousX, this.mPreviousY);
            this.mPreviousY = event.getY();
            this.mPreviousX = event.getX();
        } else if (this.touchMode == TouchMode.ZOOM) {
            this.afterLenght = this.getDistance(event);
            float gapLenght = this.afterLenght - this.beforeLenght;
            if (Math.abs(gapLenght) > 5.0f) {
                float scale_temp = this.afterLenght / this.beforeLenght;
                this.setScale(scale_temp);
                this.beforeLenght = this.afterLenght;
            }
        }
    }

    float getDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)StrictMath.sqrt(x * x + y * y);
    }

    void setScale(float scale) {
        if (this.currentZoomRate >= 2.2f && scale > 1.0f || this.currentZoomRate <= 0.5f && scale < 1.0f) {
            return;
        }
        float temp = this.currentZoomRate * scale;
        if (scale > 1.0f) {
            if (temp <= 2.2f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 2.2f;
                this.zoom(this.currentZoomRate);
            }
        } else if (scale < 1.0f) {
            if (temp >= 0.5f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 0.5f;
                this.zoom(this.currentZoomRate);
            }
        }
    }

    private void zoom(float currentZoomRate) {
        this.locate(1.0f / currentZoomRate);
    }

    public void onSufaceViewTouchUp() {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        this.touchMode = TouchMode.NONE;
    }

    public void onSufaceViewTouchPointerUp() {
        if (this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE) {
            return;
        }
        this.touchMode = TouchMode.NONE;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor == null) {
            return;
        }
        if (event.sensor.getType() == 4) {
            float speedX = event.values[0];
            float speedY = event.values[1];
            float speedZ = event.values[2];
            this.rotate(speedX, speedY, speedZ, event.timestamp);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void rotate(float speedX, float speedY, float speedZ, long timestamp) {
        int rotation = this.activity.getWindowManager().getDefaultDisplay().getRotation();
        this.panoramaVideoPlayback.rotate(rotation, speedX, speedY, speedZ, timestamp);
    }

    private void registerGyroscopeSensor() {
        this.sensorManager = (SensorManager)this.activity.getSystemService("sensor");
        this.gyroscopeSensor = this.sensorManager.getDefaultSensor(4);
        this.sensorManager.registerListener((SensorEventListener)this, this.gyroscopeSensor, 1);
    }

    protected void removeGyroscopeListener() {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
            this.sensorManager = null;
        }
    }

    public void setDrawingArea(int windowW, int windowH) {
        this.videoStreaming.setDrawingArea(windowW, windowH);
    }

    public void redrawSurface() {
        int width = this.panoramaVideoPbView.getSurfaceViewWidth();
        int heigth = this.panoramaVideoPbView.getSurfaceViewHeight();
        this.videoStreaming.setViewParam(width, heigth);
        this.videoStreaming.setSurfaceViewArea();
    }

    public void setPanoramaType() {
        if (this.curPanoramaType == 1) {
            this.videoStreaming.changePanoramaType(4);
            this.curPanoramaType = 4;
            this.panoramaVideoPbView.setPanoramaTypeImageResource(R.drawable.asteroid);
            this.activity.setRequestedOrientation(4);
        } else if (this.curPanoramaType == 4) {
            this.videoStreaming.changePanoramaType(6);
            this.curPanoramaType = 6;
            this.panoramaVideoPbView.setPanoramaTypeImageResource(R.drawable.vr);
            this.activity.setRequestedOrientation(6);
        } else {
            this.videoStreaming.changePanoramaType(1);
            this.curPanoramaType = 1;
            this.panoramaVideoPbView.setPanoramaTypeImageResource(R.drawable.panorama);
            this.activity.setRequestedOrientation(4);
        }
    }

    public void showMoreSettingLayout(boolean isShowBar) {
        if (isShowBar) {
            this.panoramaVideoPbView.setBottomBarVisibility(8);
            this.panoramaVideoPbView.setTopBarVisibility(8);
            this.panoramaVideoPbView.setMoreSettingLayoutVisibility(0);
        } else {
            this.panoramaVideoPbView.setBottomBarVisibility(0);
            this.panoramaVideoPbView.setTopBarVisibility(0);
            this.panoramaVideoPbView.setMoreSettingLayoutVisibility(8);
        }
    }

    public void enableEIS(boolean enable) {
        StreamStablization streamStablization = this.panoramaVideoPlayback.getStreamStablization();
        if (streamStablization == null) {
            return;
        }
        if (enable) {
            streamStablization.enableStablization();
        } else {
            streamStablization.disableStablization();
        }
    }

    class DownloadProcessTask
    extends TimerTask {
        int downloadProgress = 0;
        long fileSize;
        long curFileLength;

        DownloadProcessTask() {
        }

        @Override
        public void run() {
            File file = new File(PanoramaVideoPbPresenter.this.curFilePath);
            this.fileSize = PanoramaVideoPbPresenter.this.curVideoFile.getFileSize();
            this.curFileLength = file.length();
            this.downloadProgress = file != null ? (this.curFileLength == this.fileSize ? 100 : (int)(file.length() * 100L / this.fileSize)) : 0;
            final DownloadInfo downloadInfo = new DownloadInfo(PanoramaVideoPbPresenter.this.curVideoFile, this.fileSize, this.curFileLength, this.downloadProgress, false);
            PanoramaVideoPbPresenter.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (PanoramaVideoPbPresenter.this.singleDownloadDialog != null) {
                        PanoramaVideoPbPresenter.this.singleDownloadDialog.updateDownloadStatus(downloadInfo);
                    }
                    AppLog.d(PanoramaVideoPbPresenter.this.TAG, "update Process downloadProgress=" + DownloadProcessTask.this.downloadProgress);
                }
            });
            AppLog.d(PanoramaVideoPbPresenter.this.TAG, "end DownloadProcessTask");
        }
    }

    private class DeleteThread
    implements Runnable {
        private DeleteThread() {
        }

        @Override
        public void run() {
            Boolean retValue = false;
            retValue = PanoramaVideoPbPresenter.this.fileOperation.deleteFile(PanoramaVideoPbPresenter.this.curVideoFile);
            if (!retValue.booleanValue()) {
                PanoramaVideoPbPresenter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyProgressDialog.closeProgressDialog();
                        MyToast.show((Context)PanoramaVideoPbPresenter.this.activity, R.string.dialog_delete_failed_single);
                    }
                });
            } else {
                PanoramaVideoPbPresenter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyProgressDialog.closeProgressDialog();
                        GlobalInfo.getInstance().remoteVideoList.remove(PanoramaVideoPbPresenter.this.curVideoPosition);
                        PanoramaVideoPbPresenter.this.activity.finish();
                    }
                });
            }
            AppLog.d(PanoramaVideoPbPresenter.this.TAG, "end DeleteThread");
        }
    }

    private class DownloadThread
    implements Runnable {
        private String TAG = "DownloadThread";
        long fileSize;
        String fileType;

        private DownloadThread() {
        }

        @Override
        public void run() {
            AppLog.d(this.TAG, "begin DownloadThread");
            AppInfo.isDownloading = true;
            if (!Environment.getExternalStorageState().equals("mounted")) {
                PanoramaVideoPbPresenter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (PanoramaVideoPbPresenter.this.singleDownloadDialog != null) {
                            PanoramaVideoPbPresenter.this.singleDownloadDialog.dismissDownloadDialog();
                        }
                        if (PanoramaVideoPbPresenter.this.downloadProgressTimer != null) {
                            PanoramaVideoPbPresenter.this.downloadProgressTimer.cancel();
                        }
                        MyToast.show((Context)PanoramaVideoPbPresenter.this.activity, R.string.message_download_failed);
                    }
                });
                return;
            }
            String path = Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720video/";
            String fileName = PanoramaVideoPbPresenter.this.curVideoFile.getFileName();
            AppLog.d(this.TAG, "------------fileName =" + fileName);
            FileOper.createDirectory(path);
            PanoramaVideoPbPresenter.this.downloadingFilename = path + fileName;
            this.fileSize = PanoramaVideoPbPresenter.this.curVideoFile.getFileSize();
            PanoramaVideoPbPresenter.this.curFilePath = FileTools.chooseUniqueFilename(PanoramaVideoPbPresenter.this.downloadingFilename);
            boolean temp = PanoramaVideoPbPresenter.this.fileOperation.downloadFile(PanoramaVideoPbPresenter.this.curVideoFile, PanoramaVideoPbPresenter.this.curFilePath);
            if (!temp) {
                PanoramaVideoPbPresenter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (PanoramaVideoPbPresenter.this.singleDownloadDialog != null) {
                            PanoramaVideoPbPresenter.this.singleDownloadDialog.dismissDownloadDialog();
                        }
                        if (PanoramaVideoPbPresenter.this.downloadProgressTimer != null) {
                            PanoramaVideoPbPresenter.this.downloadProgressTimer.cancel();
                        }
                        MyToast.show((Context)PanoramaVideoPbPresenter.this.activity, R.string.message_download_failed);
                    }
                });
                AppInfo.isDownloading = false;
                return;
            }
            this.fileType = fileName.endsWith(".mov") || fileName.endsWith(".MOV") ? "video/mov" : "video/mp4";
            MediaRefresh.addMediaToDB((Context)PanoramaVideoPbPresenter.this.activity, PanoramaVideoPbPresenter.this.downloadingFilename, this.fileType);
            AppLog.d(this.TAG, "end downloadFile temp =" + temp);
            AppInfo.isDownloading = false;
            final String message = PanoramaVideoPbPresenter.this.activity.getResources().getString(R.string.message_download_to).replace("$1$", "/DCIM/720Cam/720video/");
            PanoramaVideoPbPresenter.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (PanoramaVideoPbPresenter.this.singleDownloadDialog != null) {
                        PanoramaVideoPbPresenter.this.singleDownloadDialog.dismissDownloadDialog();
                    }
                    if (PanoramaVideoPbPresenter.this.downloadProgressTimer != null) {
                        PanoramaVideoPbPresenter.this.downloadProgressTimer.cancel();
                    }
                    MyToast.show((Context)PanoramaVideoPbPresenter.this.activity, message);
                }
            });
            AppLog.d(this.TAG, "end DownloadThread");
        }
    }

    private class VideoPbHandler
    extends Handler {
        private VideoPbHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1537: {
                    if (!PanoramaVideoPbPresenter.this.cacheFlag) {
                        return;
                    }
                    if (msg.arg1 == 1) {
                        PanoramaVideoPbPresenter.this.panoramaVideoPbView.showLoadingCircle(true);
                        PanoramaVideoPbPresenter.this.waitForCaching = true;
                        break;
                    }
                    if (msg.arg1 != 2) break;
                    PanoramaVideoPbPresenter.this.panoramaVideoPbView.showLoadingCircle(false);
                    PanoramaVideoPbPresenter.this.waitForCaching = false;
                    PanoramaVideoPbPresenter.this.needUpdateSeekBar = true;
                    break;
                }
                case 1538: {
                    if (!PanoramaVideoPbPresenter.this.cacheFlag) {
                        return;
                    }
                    if (PanoramaVideoPbPresenter.this.videoPbMode == VideoPbMode.MODE_VIDEO_IDLE || PanoramaVideoPbPresenter.this.videoPbMode == VideoPbMode.MODE_VIDEO_PAUSE) {
                        return;
                    }
                    if (PanoramaVideoPbPresenter.this.waitForCaching.booleanValue()) {
                        PanoramaVideoPbPresenter.this.panoramaVideoPbView.setLoadPercent(msg.arg1);
                    }
                    PanoramaVideoPbPresenter.this.panoramaVideoPbView.setSeekBarSecondProgress(msg.arg2);
                    break;
                }
                case 23: {
                    double temp = (Double)msg.obj;
                    PanoramaVideoPbPresenter.this.updatePbSeekbar(temp);
                    break;
                }
                case 24: {
                    AppLog.i(PanoramaVideoPbPresenter.this.TAG, "receive EVENT_VIDEO_PLAY_CLOSED");
                    PanoramaVideoPbPresenter.this.removeEventListener();
                    PanoramaVideoPbPresenter.this.removeGyroscopeListener();
                    if (PanoramaVideoPbPresenter.this.videoPbMode != VideoPbMode.MODE_VIDEO_PLAY && PanoramaVideoPbPresenter.this.videoPbMode != VideoPbMode.MODE_VIDEO_PAUSE) break;
                    PanoramaVideoPbPresenter.this.cacheFlag = false;
                    PanoramaVideoPbPresenter.this.stopVideoStream();
                    PanoramaVideoPbPresenter.this.videoPbMode = VideoPbMode.MODE_VIDEO_IDLE;
                    PanoramaVideoPbPresenter.this.panoramaVideoPbView.setProgress(0.0f);
                    break;
                }
                case 1541: {
                    AppLog.d(PanoramaVideoPbPresenter.this.TAG, "receive CANCEL_VIDEO_DOWNLOAD_SUCCESS");
                    if (PanoramaVideoPbPresenter.this.singleDownloadDialog != null) {
                        PanoramaVideoPbPresenter.this.singleDownloadDialog.dismissDownloadDialog();
                    }
                    if (PanoramaVideoPbPresenter.this.downloadProgressTimer != null) {
                        PanoramaVideoPbPresenter.this.downloadProgressTimer.cancel();
                    }
                    if (!PanoramaVideoPbPresenter.this.fileOperation.cancelDownload()) {
                        MyToast.show((Context)PanoramaVideoPbPresenter.this.activity, R.string.dialog_cancel_downloading_failed);
                        break;
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    String filePath = Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720video/" + PanoramaVideoPbPresenter.this.curVideoFile.getFileName();
                    File file = new File(filePath);
                    if (file.exists()) {
                        file.delete();
                    }
                    PanoramaVideoPbPresenter.this.videoPbMode = VideoPbMode.MODE_VIDEO_IDLE;
                    MyToast.show((Context)PanoramaVideoPbPresenter.this.activity, R.string.dialog_cancel_downloading_succeeded);
                    break;
                }
                case 1542: {
                    PanoramaVideoPbPresenter.this.enableEIS(false);
                    PanoramaVideoPbPresenter.this.panoramaVideoPbView.setEisSwitchChecked(false);
                }
            }
        }
    }
}

