/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.Presenter;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.util.Log;
import android.util.LruCache;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import androidx.viewpager.widget.ViewPager;
import com.github.chrisbanes.photoview.PhotoView;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.Presenter.Interface.BasePresenter;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.FileOperation;
import com.icatch.panorama.SdkApi.PanoramaPhotoPlayback;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.Mode.TouchMode;
import com.icatch.panorama.data.SystemInfo.SystemInfo;
import com.icatch.panorama.data.entity.MultiPbItemInfo;
import com.icatch.panorama.ui.ExtendComponent.MyProgressDialog;
import com.icatch.panorama.ui.ExtendComponent.MyToast;
import com.icatch.panorama.ui.ExtendComponent.ProgressWheel;
import com.icatch.panorama.ui.Interface.PhotoPbView;
import com.icatch.panorama.ui.adapter.PhotoPbViewPagerAdapter;
import com.icatch.panorama.utils.BitmapTools;
import com.icatch.panorama.utils.FileOpertion.FileOper;
import com.icatch.panorama.utils.FileOpertion.FileTools;
import com.icatch.panorama.utils.MediaRefresh;
import com.icatchtek.pancam.customer.exception.IchGLSurfaceNotSetException;
import com.icatchtek.pancam.customer.surface.ICatchSurfaceContext;
import com.icatchtek.pancam.customer.type.ICatchGLImage;
import com.icatchtek.pancam.customer.type.ICatchGLPoint;
import com.icatchtek.reliant.customer.type.ICatchFile;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class PhotoPbPresenter
extends BasePresenter
implements SensorEventListener {
    private String TAG = PhotoPbPresenter.class.getSimpleName();
    private PhotoPbView photoPbView;
    private Activity activity;
    private List<MultiPbItemInfo> fileList;
    private PhotoPbViewPagerAdapter viewPagerAdapter;
    private Handler handler;
    private int curPhotoIdx;
    private int lastItem = -1;
    private int tempLastItem = -1;
    private boolean isScrolling = false;
    private int slideDirection = 1;
    private static final int DIRECTION_RIGHT = 1;
    private static final int DIRECTION_LEFT = 2;
    private static final int DIRECTION_UNKNOWN = 4;
    public String downloadingFilename;
    public long downloadProcess;
    public long downloadingFilesize;
    LinkedList<Asytask> asytaskList;
    Asytask curAsytask;
    private LruCache<Integer, Bitmap> mLruCache;
    private List<View> viewList;
    private ExecutorService executor;
    private Future<Object> future;
    private PanoramaPhotoPlayback panoramaPhotoPlayback = CameraManager.getInstance().getCurCamera().getPanoramaPhotoPlayback();
    private FileOperation fileOperation = CameraManager.getInstance().getCurCamera().getFileOperation();
    private static final float MIN_ZOOM = 0.5f;
    private static final float MAX_ZOOM = 2.2f;
    private static final float FIXED_OUTSIDE_FOCUS = 1.0f;
    private static final float FIXED_INSIDE_FOCUS = 2.0f;
    private static final float FIXED_NEAR_DISTANCE = 0.6f;
    private static final float FIXED_OUTSIDE_DISTANCE = 2.0f;
    private static final float FIXED_INSIDE_DISTANCE = 0.45454544f;
    private TouchMode touchMode = TouchMode.NONE;
    private float mPreviousY;
    private float mPreviousX;
    private float beforeLenght;
    private float afterLenght;
    private float currentZoomRate = 2.2f;
    private SensorManager sensorManager;
    private Sensor gyroscopeSensor;
    private ICatchSurfaceContext iCatchSurfaceContext;
    private String curFilePath = "";
    private int curPanoramaType = 1;

    public PhotoPbPresenter(Activity activity) {
        super(activity);
        this.activity = activity;
        this.handler = new Handler();
        this.viewList = new LinkedList<View>();
        this.initLruCache();
        this.slideDirection = 4;
    }

    public void setView(PhotoPbView photoPbView) {
        this.photoPbView = photoPbView;
        this.initCfg();
        this.fileList = GlobalInfo.getInstance().getRemotePhotoList();
        Bundle data = this.activity.getIntent().getExtras();
        this.curPhotoIdx = data.getInt("curfilePosition");
    }

    private void initLruCache() {
        int maxMemory = (int)Runtime.getRuntime().maxMemory();
        int cacheMemory = maxMemory / 8;
        AppLog.d(this.TAG, "initLruCache maxMemory=" + maxMemory);
        AppLog.d(this.TAG, "initLruCache cacheMemory=" + cacheMemory);
        this.mLruCache = new LruCache<Integer, Bitmap>(cacheMemory){

            protected int sizeOf(Integer key, Bitmap value) {
                AppLog.d(PhotoPbPresenter.this.TAG, "cacheMemory value.getByteCount()=" + value.getByteCount());
                return value.getByteCount();
            }

            protected void entryRemoved(boolean evicted, Integer key, Bitmap oldValue, Bitmap newValue) {
                super.entryRemoved(evicted, (Object)key, (Object)oldValue, (Object)newValue);
                if (oldValue != null) {
                    AppLog.d(PhotoPbPresenter.this.TAG, "cacheMemory entryRemoved key=" + key);
                    oldValue.recycle();
                    oldValue = null;
                }
            }
        };
    }

    public Bitmap getBitmapFromLruCache(int fileHandle) {
        AppLog.d(this.TAG, "getBitmapFromLruCache fileHandle=" + fileHandle);
        return (Bitmap)this.mLruCache.get((Object)fileHandle);
    }

    protected void addBitmapToLruCache(int fileHandle, Bitmap bm) {
        if (bm.getByteCount() > this.mLruCache.maxSize()) {
            AppLog.d(this.TAG, "addBitmapToLruCache greater than mLruCache size fileHandle=" + fileHandle);
            return;
        }
        if (this.getBitmapFromLruCache(fileHandle) == null && bm != null && fileHandle != 0) {
            AppLog.d(this.TAG, "addBitmapToLruCache fileHandle=" + fileHandle);
            this.mLruCache.put((Object)fileHandle, (Object)bm);
        }
    }

    public void loadPanoramaImage() {
        this.loadBitmaps(this.curPhotoIdx);
    }

    public void initView() {
        for (int ii = 0; ii < this.fileList.size(); ++ii) {
            this.viewList.add(ii, null);
        }
        this.viewPagerAdapter = new PhotoPbViewPagerAdapter((Context)this.activity, this.fileList, this.viewList, this.mLruCache);
        this.viewPagerAdapter.setOnPhotoTapListener(new PhotoPbViewPagerAdapter.OnPhotoTapListener(){

            @Override
            public void onPhotoTap() {
                PhotoPbPresenter.this.showBar();
            }
        });
        this.photoPbView.setViewPagerAdapter(this.viewPagerAdapter);
        this.photoPbView.setViewPagerCurrentItem(this.curPhotoIdx);
        this.ShowCurPageNum();
        this.loadBitmaps(this.curPhotoIdx);
        this.photoPbView.setOnPageChangeListener(new MyViewPagerOnPagerChangeListener());
    }

    public void showBar() {
        boolean isShowBar = this.photoPbView.getTopBarVisibility() == 0;
        AppLog.d(this.TAG, "showBar isShowBar=" + isShowBar);
        if (isShowBar) {
            this.photoPbView.setTopBarVisibility(8);
            this.photoPbView.setBottomBarVisibility(8);
        } else {
            this.photoPbView.setTopBarVisibility(0);
            this.photoPbView.setBottomBarVisibility(0);
        }
    }

    public void delete() {
        this.showDeleteEnsureDialog();
    }

    public void download() {
        this.showDownloadEnsureDialog();
    }

    void loadBitmaps(int curPhotoIdx) {
        AppLog.i(this.TAG, "add task loadBitmaps curPhotoIdx=" + curPhotoIdx);
        if (curPhotoIdx < 0) {
            return;
        }
        if (this.curAsytask != null && !this.curAsytask.isCancelled()) {
            AppLog.i(this.TAG, "add task curAsytask cancel curAsytask position" + this.curAsytask.position);
            this.curAsytask.cancel(true);
        }
        if (this.asytaskList == null) {
            this.asytaskList = new LinkedList();
        } else {
            this.asytaskList.clear();
        }
        if (this.fileList == null || this.fileList.size() < 0) {
            AppLog.e(this.TAG, "fileList is null or size < 0");
            return;
        }
        if (curPhotoIdx == 0) {
            Asytask task1 = new Asytask(this.fileList.get((int)curPhotoIdx).iCatchFile, curPhotoIdx);
            this.asytaskList.add(task1);
            if (this.fileList.size() > 1) {
                Asytask task2 = new Asytask(this.fileList.get((int)(curPhotoIdx + 1)).iCatchFile, curPhotoIdx + 1);
                this.asytaskList.add(task2);
            }
        } else if (curPhotoIdx == this.fileList.size() - 1) {
            Asytask task1 = new Asytask(this.fileList.get((int)curPhotoIdx).iCatchFile, curPhotoIdx);
            Asytask task2 = new Asytask(this.fileList.get((int)(curPhotoIdx - 1)).iCatchFile, curPhotoIdx - 1);
            this.asytaskList.add(task1);
            this.asytaskList.add(task2);
        } else {
            AppLog.d(this.TAG, "loadBitmaps slideDirection=" + this.slideDirection);
            if (this.slideDirection == 1) {
                Asytask task1 = new Asytask(this.fileList.get((int)curPhotoIdx).iCatchFile, curPhotoIdx);
                Asytask task2 = new Asytask(this.fileList.get((int)(curPhotoIdx - 1)).iCatchFile, curPhotoIdx - 1);
                Asytask task3 = new Asytask(this.fileList.get((int)(curPhotoIdx + 1)).iCatchFile, curPhotoIdx + 1);
                this.asytaskList.add(task1);
                this.asytaskList.add(task2);
                this.asytaskList.add(task3);
            } else {
                Asytask task1 = new Asytask(this.fileList.get((int)curPhotoIdx).iCatchFile, curPhotoIdx);
                Asytask task2 = new Asytask(this.fileList.get((int)(curPhotoIdx + 1)).iCatchFile, curPhotoIdx + 1);
                Asytask task3 = new Asytask(this.fileList.get((int)(curPhotoIdx - 1)).iCatchFile, curPhotoIdx - 1);
                this.asytaskList.add(task1);
                this.asytaskList.add(task2);
                this.asytaskList.add(task3);
            }
        }
        if (this.asytaskList != null && this.asytaskList.size() > 0) {
            this.curAsytask = this.asytaskList.removeFirst();
            this.curAsytask.execute(new String[0]);
        }
    }

    public void reloadBitmap() {
        this.photoPbView.setViewPagerAdapter(this.viewPagerAdapter);
        this.photoPbView.setViewPagerCurrentItem(this.curPhotoIdx);
        this.ShowCurPageNum();
        this.loadBitmaps(this.curPhotoIdx);
    }

    public void loadPreviousImage() {
        AppLog.d(this.TAG, "loadPreviousImage=");
        if (this.curPhotoIdx > 0) {
            --this.curPhotoIdx;
        }
        this.slideDirection = 2;
        this.loadBitmaps(this.curPhotoIdx);
        this.photoPbView.setViewPagerCurrentItem(this.curPhotoIdx);
    }

    public void loadNextImage() {
        AppLog.d(this.TAG, "loadNextImage=");
        if (this.curPhotoIdx < this.fileList.size() - 1) {
            ++this.curPhotoIdx;
        }
        this.slideDirection = 1;
        this.loadBitmaps(this.curPhotoIdx);
        this.photoPbView.setViewPagerCurrentItem(this.curPhotoIdx);
    }

    private void ShowCurPageNum() {
        int curPhoto = this.photoPbView.getViewPagerCurrentItem() + 1;
        String indexInfo = curPhoto + "/" + this.fileList.size();
        this.photoPbView.setIndexInfoTxv(indexInfo);
    }

    public void showDownloadEnsureDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
        builder.setCancelable(false);
        builder.setTitle(R.string.dialog_downloading_single);
        long videoFileSize = 0L;
        videoFileSize = this.fileList.get(this.curPhotoIdx).getFileSizeInteger() / 1024L / 1024L;
        long minute = videoFileSize / 60L;
        long seconds = videoFileSize % 60L;
        String what = this.activity.getResources().getString(R.string.gallery_download_with_vid_msg).replace("$1$", "1").replace("$3$", String.valueOf(seconds)).replace("$2$", String.valueOf(minute));
        builder.setMessage((CharSequence)what);
        builder.setNegativeButton(R.string.gallery_download, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                AppLog.d(PhotoPbPresenter.this.TAG, "showProgressDialog");
                PhotoPbPresenter.this.downloadProcess = 0L;
                if (SystemInfo.getSDFreeSize() < ((MultiPbItemInfo)PhotoPbPresenter.this.fileList.get(PhotoPbPresenter.this.curPhotoIdx)).getFileSizeInteger()) {
                    dialog.dismiss();
                    MyToast.show((Context)PhotoPbPresenter.this.activity, R.string.text_sd_card_memory_shortage);
                } else {
                    MyProgressDialog.showProgressDialog((Context)PhotoPbPresenter.this.activity, R.string.dialog_downloading_single);
                    PhotoPbPresenter.this.executor = Executors.newSingleThreadExecutor();
                    PhotoPbPresenter.this.future = PhotoPbPresenter.this.executor.submit(new DownloadThread(), null);
                }
            }
        });
        builder.setPositiveButton(R.string.gallery_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    public void showDeleteEnsureDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
        builder.setCancelable(false);
        builder.setTitle(R.string.image_delete_des);
        builder.setNegativeButton(R.string.gallery_delete, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                MyProgressDialog.showProgressDialog((Context)PhotoPbPresenter.this.activity, R.string.dialog_deleting);
                PhotoPbPresenter.this.asytaskList.clear();
                PhotoPbPresenter.this.executor = Executors.newSingleThreadExecutor();
                PhotoPbPresenter.this.future = PhotoPbPresenter.this.executor.submit(new DeleteThread(), null);
            }
        });
        builder.setPositiveButton(R.string.gallery_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                dialog.dismiss();
            }
        });
        builder.create().show();
    }

    public void setShowArea(Surface surface) {
        AppLog.d(this.TAG, "start initSurface");
        this.iCatchSurfaceContext = new ICatchSurfaceContext(surface);
        this.panoramaPhotoPlayback.setSurface(1, this.iCatchSurfaceContext);
        this.panoramaPhotoPlayback.pancamGLSetFormat(130, 1080, 720);
        AppLog.d(this.TAG, "end initSurface");
    }

    public void startRendering(ICatchGLImage image) {
        AppLog.d(this.TAG, "start startRendering panoramaPhotoPlayback=" + this.panoramaPhotoPlayback);
        this.photoPbView.setViewPagerVisibility(8);
        if (this.panoramaPhotoPlayback == null) {
            return;
        }
        this.registerGyroscopeSensor();
        this.panoramaPhotoPlayback.update(image);
        this.insidePanorama();
        AppLog.d(this.TAG, "end startRendering");
    }

    public void stopRendering() {
        AppLog.d(this.TAG, "start stopRendering");
        if (this.panoramaPhotoPlayback == null) {
            return;
        }
        this.panoramaPhotoPlayback.clear();
        AppLog.d(this.TAG, "end stopRendering");
    }

    public void insidePanorama() {
        this.locate(0.45454544f);
    }

    private void locate(float distance) {
        this.panoramaPhotoPlayback.pancamGLTransLocate(distance);
    }

    public void destroyImage(int iCatchSphereType) {
        this.removeGyroscopeListener();
        if (this.panoramaPhotoPlayback != null) {
            if (this.iCatchSurfaceContext != null) {
                this.panoramaPhotoPlayback.removeSurface(iCatchSphereType, this.iCatchSurfaceContext);
            }
            this.panoramaPhotoPlayback.clear();
            this.panoramaPhotoPlayback.release();
        }
    }

    public void rotateB(MotionEvent e, float prevX, float prevY) {
        ICatchGLPoint prev = new ICatchGLPoint(prevX, prevY);
        ICatchGLPoint curr = new ICatchGLPoint(e.getX(), e.getY());
        this.panoramaPhotoPlayback.pancamGLTransformRotate(prev, curr);
    }

    public void onSufaceViewTouchDown(MotionEvent event) {
        this.touchMode = TouchMode.DRAG;
        this.mPreviousY = event.getY();
        this.mPreviousX = event.getX();
        this.beforeLenght = 0.0f;
        this.afterLenght = 0.0f;
    }

    public void onSufaceViewPointerDown(MotionEvent event) {
        Log.d((String)"2222", (String)("event.getPointerCount()................=" + event.getPointerCount()));
        if (event.getPointerCount() == 2) {
            this.touchMode = TouchMode.ZOOM;
            this.beforeLenght = this.getDistance(event);
        }
    }

    public void onSufaceViewTouchMove(MotionEvent event) {
        if (this.touchMode == TouchMode.DRAG) {
            this.rotateB(event, this.mPreviousX, this.mPreviousY);
            this.mPreviousY = event.getY();
            this.mPreviousX = event.getX();
        } else if (this.touchMode == TouchMode.ZOOM) {
            this.afterLenght = this.getDistance(event);
            float gapLenght = this.afterLenght - this.beforeLenght;
            if (Math.abs(gapLenght) > 5.0f) {
                float scale_temp = this.afterLenght / this.beforeLenght;
                this.setScale(scale_temp);
                this.beforeLenght = this.afterLenght;
            }
        }
    }

    float getDistance(MotionEvent event) {
        float x = event.getX(0) - event.getX(1);
        float y = event.getY(0) - event.getY(1);
        return (float)StrictMath.sqrt(x * x + y * y);
    }

    void setScale(float scale) {
        if (this.currentZoomRate >= 2.2f && scale > 1.0f || this.currentZoomRate <= 0.5f && scale < 1.0f) {
            return;
        }
        float temp = this.currentZoomRate * scale;
        if (scale > 1.0f) {
            if (temp <= 2.2f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 2.2f;
                this.zoom(this.currentZoomRate);
            }
        } else if (scale < 1.0f) {
            if (temp >= 0.5f) {
                this.currentZoomRate *= scale;
                this.zoom(this.currentZoomRate);
            } else {
                this.currentZoomRate = 0.5f;
                this.zoom(this.currentZoomRate);
            }
        }
    }

    private void zoom(float currentZoomRate) {
        this.locate(1.0f / currentZoomRate);
    }

    public void onSufaceViewTouchUp() {
        this.touchMode = TouchMode.NONE;
    }

    public void onSufaceViewTouchPointerUp() {
        this.touchMode = TouchMode.NONE;
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor == null) {
            return;
        }
        if (event.sensor.getType() == 4) {
            float speedX = event.values[0];
            float speedY = event.values[1];
            float speedZ = event.values[2];
            if ((double)Math.abs(speedY) < 0.02 && (double)Math.abs(speedZ) < 0.02) {
                return;
            }
            this.rotate(speedX, speedY, speedZ, event.timestamp);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void rotate(float speedX, float speedY, float speedZ, long timestamp) {
        int rotation = this.activity.getWindowManager().getDefaultDisplay().getRotation();
        this.panoramaPhotoPlayback.pancamGLTransformRotate(rotation, speedX, speedY, speedZ, timestamp);
    }

    private void registerGyroscopeSensor() {
        this.sensorManager = (SensorManager)this.activity.getSystemService("sensor");
        this.gyroscopeSensor = this.sensorManager.getDefaultSensor(4);
        this.sensorManager.registerListener((SensorEventListener)this, this.gyroscopeSensor, 1);
    }

    protected void removeGyroscopeListener() {
        if (this.sensorManager != null) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
        }
    }

    public void setDrawingArea(int windowW, int windowH) {
        int fileHandle;
        Bitmap bitmap;
        AppLog.d(this.TAG, "start setDrawingArea windowW= " + windowW + " windowH= " + windowH);
        if (this.iCatchSurfaceContext != null) {
            try {
                this.iCatchSurfaceContext.setViewPort(0, 0, windowW, windowH);
            }
            catch (IchGLSurfaceNotSetException e) {
                e.printStackTrace();
            }
        }
        if (this.curPhotoIdx >= 0 && (bitmap = this.getBitmapFromLruCache(fileHandle = this.fileList.get(this.curPhotoIdx).getFileHandle())) != null) {
            this.panoramaPhotoPlayback.update(new ICatchGLImage(bitmap));
        }
        AppLog.d(this.TAG, "end setDrawingArea");
    }

    public void init(int sphereType) {
        this.panoramaPhotoPlayback.pancamGLInit();
    }

    public void uninit() {
        if (this.panoramaPhotoPlayback == null) {
            return;
        }
        this.panoramaPhotoPlayback.release();
    }

    public void initPanorama() {
        this.uninit();
        this.init(1);
    }

    public void clearOrRestoreSurface(boolean value) {
        AppLog.d(this.TAG, "clearOrRestoreSurface value=" + value);
        if (value) {
            this.destroyImage(1);
        }
        this.photoPbView.setSurfaceviewTransparent(value);
    }

    public void setPanoramaType() {
        if (!this.fileList.get(this.curPhotoIdx).isPanorama()) {
            MyToast.show((Context)this.activity, R.string.non_360_picture_not_support_switch);
            return;
        }
        if (this.curPanoramaType == 1) {
            this.panoramaPhotoPlayback.changePanoramaType(4);
            this.curPanoramaType = 4;
            this.photoPbView.setPanoramaTypeTxv(R.string.text_asteroid);
            this.activity.setRequestedOrientation(4);
        } else if (this.curPanoramaType == 4) {
            this.panoramaPhotoPlayback.changePanoramaType(6);
            this.curPanoramaType = 6;
            this.photoPbView.setPanoramaTypeTxv(R.string.text_vr);
            this.activity.setRequestedOrientation(6);
        } else {
            this.panoramaPhotoPlayback.changePanoramaType(1);
            this.curPanoramaType = 1;
            this.photoPbView.setPanoramaTypeTxv(R.string.text_panorama);
            this.activity.setRequestedOrientation(4);
        }
        this.loadPanoramaImage();
    }

    private class DeleteThread
    implements Runnable {
        private DeleteThread() {
        }

        @Override
        public void run() {
            PhotoPbPresenter.this.curPhotoIdx = PhotoPbPresenter.this.photoPbView.getViewPagerCurrentItem();
            ICatchFile curFile = ((MultiPbItemInfo)((PhotoPbPresenter)PhotoPbPresenter.this).fileList.get((int)((PhotoPbPresenter)PhotoPbPresenter.this).curPhotoIdx)).iCatchFile;
            Boolean retValue = false;
            retValue = PhotoPbPresenter.this.fileOperation.deleteFile(curFile);
            if (!retValue.booleanValue()) {
                PhotoPbPresenter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyProgressDialog.closeProgressDialog();
                        MyToast.show((Context)PhotoPbPresenter.this.activity, R.string.dialog_delete_failed_single);
                    }
                });
            } else {
                PhotoPbPresenter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyProgressDialog.closeProgressDialog();
                        PhotoPbPresenter.this.fileList.remove(PhotoPbPresenter.this.curPhotoIdx);
                        PhotoPbPresenter.this.viewList.remove(PhotoPbPresenter.this.curPhotoIdx);
                        PhotoPbPresenter.this.viewPagerAdapter.notifyDataSetChanged();
                        PhotoPbPresenter.this.photoPbView.setViewPagerAdapter(PhotoPbPresenter.this.viewPagerAdapter);
                        int photoNums = PhotoPbPresenter.this.fileList.size();
                        if (photoNums == 0) {
                            GlobalInfo.getInstance().setRemotePhotoList(null);
                            PhotoPbPresenter.this.activity.finish();
                            return;
                        }
                        if (PhotoPbPresenter.this.curPhotoIdx == photoNums) {
                            PhotoPbPresenter.this.curPhotoIdx--;
                        }
                        AppLog.d(PhotoPbPresenter.this.TAG, "photoNums=" + photoNums + " curPhotoIdx=" + PhotoPbPresenter.this.curPhotoIdx);
                        PhotoPbPresenter.this.photoPbView.setViewPagerCurrentItem(PhotoPbPresenter.this.curPhotoIdx);
                        PhotoPbPresenter.this.ShowCurPageNum();
                        PhotoPbPresenter.this.loadBitmaps(PhotoPbPresenter.this.curPhotoIdx);
                    }
                });
            }
            AppLog.d(PhotoPbPresenter.this.TAG, "end DeleteThread");
        }
    }

    private class DownloadThread
    implements Runnable {
        private String TAG = "DownloadThread";
        private int curIdx = PhotoPbPresenter.access$300(PhotoPbPresenter.this).getViewPagerCurrentItem();

        private DownloadThread() {
        }

        @Override
        public void run() {
            AppLog.d(this.TAG, "begin DownloadThread");
            AppInfo.isDownloading = true;
            if (!Environment.getExternalStorageState().equals("mounted")) {
                PhotoPbPresenter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyProgressDialog.closeProgressDialog();
                        MyToast.show((Context)PhotoPbPresenter.this.activity, R.string.message_download_failed);
                    }
                });
                return;
            }
            String path = Environment.getExternalStorageDirectory().toString() + "/DCIM/720Cam/720photo/";
            String fileName = ((MultiPbItemInfo)PhotoPbPresenter.this.fileList.get(this.curIdx)).getFileName();
            AppLog.d(this.TAG, "------------fileName =" + fileName);
            FileOper.createDirectory(path);
            PhotoPbPresenter.this.downloadingFilename = path + fileName;
            PhotoPbPresenter.this.downloadingFilesize = ((MultiPbItemInfo)((PhotoPbPresenter)PhotoPbPresenter.this).fileList.get((int)this.curIdx)).iCatchFile.getFileSize();
            File tempFile = new File(PhotoPbPresenter.this.downloadingFilename);
            PhotoPbPresenter.this.curFilePath = FileTools.chooseUniqueFilename(PhotoPbPresenter.this.downloadingFilename);
            boolean temp = PhotoPbPresenter.this.fileOperation.downloadFile(((MultiPbItemInfo)((PhotoPbPresenter)PhotoPbPresenter.this).fileList.get((int)this.curIdx)).iCatchFile, PhotoPbPresenter.this.curFilePath);
            if (!temp) {
                PhotoPbPresenter.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        MyProgressDialog.closeProgressDialog();
                        MyToast.show((Context)PhotoPbPresenter.this.activity, R.string.message_download_failed);
                    }
                });
                AppInfo.isDownloading = false;
                return;
            }
            MediaRefresh.scanFileAsync((Context)PhotoPbPresenter.this.activity, PhotoPbPresenter.this.downloadingFilename);
            AppLog.d(this.TAG, "end downloadFile temp =" + temp);
            AppInfo.isDownloading = false;
            final String message = PhotoPbPresenter.this.activity.getResources().getString(R.string.message_download_to).replace("$1$", "/DCIM/720Cam/720photo/");
            PhotoPbPresenter.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    MyProgressDialog.closeProgressDialog();
                    MyToast.show((Context)PhotoPbPresenter.this.activity, message);
                }
            });
            AppLog.d(this.TAG, "end DownloadThread");
        }
    }

    private class MyViewPagerOnPagerChangeListener
    implements ViewPager.OnPageChangeListener {
        private MyViewPagerOnPagerChangeListener() {
        }

        public void onPageScrollStateChanged(int arg0) {
            switch (arg0) {
                case 1: {
                    PhotoPbPresenter.this.isScrolling = true;
                    PhotoPbPresenter.this.tempLastItem = PhotoPbPresenter.this.photoPbView.getViewPagerCurrentItem();
                    break;
                }
                case 2: {
                    if (PhotoPbPresenter.this.isScrolling && PhotoPbPresenter.this.tempLastItem != -1 && PhotoPbPresenter.this.tempLastItem != PhotoPbPresenter.this.photoPbView.getViewPagerCurrentItem()) {
                        PhotoPbPresenter.this.lastItem = PhotoPbPresenter.this.tempLastItem;
                    }
                    PhotoPbPresenter.this.curPhotoIdx = PhotoPbPresenter.this.photoPbView.getViewPagerCurrentItem();
                    PhotoPbPresenter.this.isScrolling = false;
                    PhotoPbPresenter.this.loadBitmaps(PhotoPbPresenter.this.photoPbView.getViewPagerCurrentItem());
                    PhotoPbPresenter.this.ShowCurPageNum();
                    break;
                }
            }
        }

        public void onPageScrolled(int arg0, float arg1, int arg2) {
            if (PhotoPbPresenter.this.isScrolling) {
                if (PhotoPbPresenter.this.lastItem > arg2) {
                    PhotoPbPresenter.this.slideDirection = 1;
                } else if (PhotoPbPresenter.this.lastItem < arg2) {
                    PhotoPbPresenter.this.slideDirection = 2;
                } else if (PhotoPbPresenter.this.lastItem == arg2) {
                    PhotoPbPresenter.this.slideDirection = 1;
                }
            }
            PhotoPbPresenter.this.lastItem = arg2;
        }

        public void onPageSelected(int arg0) {
            PhotoPbPresenter.this.ShowCurPageNum();
        }
    }

    class Asytask
    extends AsyncTask<String, Integer, Bitmap> {
        ICatchFile iCatchFile;
        int fileHandle;
        int position;
        ICatchFrameBuffer buffer;
        boolean isZoom = false;

        public Asytask(ICatchFile iCatchFile, int position) {
            this.iCatchFile = iCatchFile;
            this.fileHandle = iCatchFile.getFileHandle();
            this.position = position;
        }

        protected Bitmap doInBackground(String ... params) {
            Bitmap bm = PhotoPbPresenter.this.getBitmapFromLruCache(this.fileHandle);
            AppLog.d(PhotoPbPresenter.this.TAG, "getBitmapFromLruCache bm=" + bm);
            if (bm != null) {
                return bm;
            }
            this.buffer = PhotoPbPresenter.this.fileOperation.getQuickview(this.iCatchFile);
            if (this.buffer == null || this.buffer.getFrameSize() <= 0) {
                AppLog.e(PhotoPbPresenter.this.TAG, "buffer == null  send _LOAD_BITMAP_FAILED 01");
                this.buffer = PhotoPbPresenter.this.fileOperation.downloadFile(this.iCatchFile);
                this.isZoom = true;
            }
            if (this.buffer == null || this.buffer.getFrameSize() <= 0) {
                AppLog.e(PhotoPbPresenter.this.TAG, "buffer == null  send _LOAD_BITMAP_FAILED 02");
                return null;
            }
            bm = BitmapTools.decodeByteArray(this.buffer.getBuffer());
            AppLog.d(PhotoPbPresenter.this.TAG, "position=" + this.position + " bm.getWidth()=" + bm.getWidth() + " bm.getHeight()" + bm.getHeight());
            AppLog.d(PhotoPbPresenter.this.TAG, "position=" + this.position + " iCatchFile.getFileWidth()=" + this.iCatchFile.getFileWidth() + " iCatchFile.getFileHeight()=" + this.iCatchFile.getFileHeight());
            if (bm == null) {
                return null;
            }
            AppLog.d(PhotoPbPresenter.this.TAG, "11 position=" + this.position + "fileHandle=" + this.fileHandle + " buffer size=" + this.buffer.getFrameSize() + " bm size=" + bm.getByteCount());
            PhotoPbPresenter.this.addBitmapToLruCache(this.fileHandle, bm);
            return bm;
        }

        protected void onProgressUpdate(Integer ... progress) {
        }

        protected void onPostExecute(Bitmap result) {
            if (this.position == PhotoPbPresenter.this.photoPbView.getViewPagerCurrentItem() && result != null) {
                if (((MultiPbItemInfo)PhotoPbPresenter.this.fileList.get(this.position)).isPanorama()) {
                    PhotoPbPresenter.this.clearOrRestoreSurface(false);
                    PhotoPbPresenter.this.panoramaPhotoPlayback.pancamGLClearFormat();
                    PhotoPbPresenter.this.panoramaPhotoPlayback.pancamGLSetFormat(130, result.getWidth(), result.getHeight());
                    PhotoPbPresenter.this.startRendering(new ICatchGLImage(result));
                    return;
                }
                PhotoPbPresenter.this.clearOrRestoreSurface(true);
                PhotoPbPresenter.this.photoPbView.setViewPagerVisibility(0);
                View view = (View)PhotoPbPresenter.this.viewList.get(this.position);
                if (view != null) {
                    PhotoView photoView = (PhotoView)view.findViewById(R.id.photo);
                    ProgressWheel progressBar = (ProgressWheel)view.findViewById(R.id.progress_wheel);
                    if (photoView != null && !result.isRecycled()) {
                        photoView.setImageBitmap(result);
                    }
                    if (progressBar != null) {
                        progressBar.setVisibility(8);
                    }
                }
            }
            if (PhotoPbPresenter.this.asytaskList != null && PhotoPbPresenter.this.asytaskList.size() > 0) {
                PhotoPbPresenter.this.curAsytask = PhotoPbPresenter.this.asytaskList.removeFirst();
                PhotoPbPresenter.this.curAsytask.execute(new String[0]);
            }
        }
    }
}

