/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.SdkApi;

import android.util.Log;
import com.icatch.panorama.DataConvert.BurstConvert;
import com.icatch.panorama.Log.AppLog;
import com.icatchtek.control.customer.ICatchCameraControl;
import com.icatchtek.control.customer.ICatchCameraProperty;
import com.icatchtek.control.customer.exception.IchCameraModeException;
import com.icatchtek.control.customer.exception.IchDevicePropException;
import com.icatchtek.control.customer.exception.IchNoSDCardException;
import com.icatchtek.reliant.customer.exception.IchDeviceException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchSocketException;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class CameraProperties {
    private final String tag = "CameraProperties";
    private List<Integer> fuction;
    private List<Integer> modeList;
    private ICatchCameraProperty cameraProperty;
    private ICatchCameraControl cameraAction;
    private List<ICatchVideoFormat> resolutionList;

    public CameraProperties(ICatchCameraProperty cameraProperty, ICatchCameraControl cameraAction) {
        this.cameraAction = cameraAction;
        this.cameraProperty = cameraProperty;
    }

    public List<String> getSupportedImageSizes() {
        List list = null;
        try {
            list = this.cameraProperty.getSupportedImageSizes();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getSupportedImageSizes list.size =" + list.size());
        if (list != null) {
            for (int ii = 0; ii < list.size(); ++ii) {
                AppLog.i("CameraProperties", "image size ii=" + ii + " size=" + (String)list.get(ii));
            }
        }
        return list;
    }

    public List<String> getSupportedVideoSizes() {
        AppLog.i("CameraProperties", "begin getSupportedVideoSizes");
        List list = null;
        try {
            list = this.cameraProperty.getSupportedVideoSizes();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "begin getSupportedVideoSizes size =" + list.size());
        return list;
    }

    public List<Integer> getSupportedWhiteBalances() {
        AppLog.i("CameraProperties", "begin getSupportedWhiteBalances");
        List list = null;
        try {
            list = this.cameraProperty.getSupportedWhiteBalances();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getSupportedWhiteBalances list.size() =" + list.size());
        return list;
    }

    public List<Integer> getSupportedCaptureDelays() {
        AppLog.i("CameraProperties", "begin getSupportedCaptureDelays");
        List list = null;
        try {
            list = this.cameraProperty.getSupportedCaptureDelays();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getSupportedCaptureDelays list.size() =" + list.size());
        for (Integer temp : list) {
            AppLog.i("CameraProperties", "end getSupportedCaptureDelays list value=" + temp);
        }
        return list;
    }

    public List<Integer> getSupportedLightFrequencys() {
        AppLog.i("CameraProperties", "begin getSupportedLightFrequencys");
        List list = null;
        try {
            list = this.cameraProperty.getSupportedLightFrequencies();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
        }
        for (int ii = 0; ii < list.size(); ++ii) {
            if ((Integer)list.get(ii) != 2) continue;
            list.remove(ii);
        }
        AppLog.i("CameraProperties", "end getSupportedLightFrequencys list.size() =" + list.size());
        return list;
    }

    public boolean setImageSize(String value) {
        AppLog.i("CameraProperties", "begin setImageSize set value =" + value);
        boolean retVal = false;
        try {
            retVal = this.cameraProperty.setImageSize(value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setImageSize retVal=" + retVal);
        return retVal;
    }

    public boolean setVideoSize(String value) {
        AppLog.i("CameraProperties", "begin setVideoSize set value =" + value);
        boolean retVal = false;
        try {
            retVal = this.cameraProperty.setVideoSize(value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setVideoSize retVal=" + retVal);
        return retVal;
    }

    public boolean setWhiteBalance(int value) {
        AppLog.i("CameraProperties", "begin setWhiteBalanceset value =" + value);
        boolean retVal = false;
        if (value < 0 || value == 255) {
            return false;
        }
        try {
            retVal = this.cameraProperty.setWhiteBalance(value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setWhiteBalance retVal=" + retVal);
        return retVal;
    }

    public boolean setLightFrequency(int value) {
        AppLog.i("CameraProperties", "begin setLightFrequency set value =" + value);
        boolean retVal = false;
        if (value < 0 || value == 255) {
            return false;
        }
        try {
            retVal = this.cameraProperty.setLightFrequency(value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setLightFrequency retVal=" + retVal);
        return retVal;
    }

    public String getCurrentImageSize() {
        AppLog.i("CameraProperties", "begin getCurrentImageSize");
        String value = "unknown";
        try {
            value = this.cameraProperty.getCurrentImageSize();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentImageSize value =" + value);
        return value;
    }

    public String getCurrentVideoSize() {
        AppLog.i("CameraProperties", "begin getCurrentVideoSize");
        String value = "unknown";
        try {
            value = this.cameraProperty.getCurrentVideoSize();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentVideoSize value =" + value);
        return value;
    }

    public int getCurrentWhiteBalance() {
        AppLog.i("CameraProperties", "begin getCurrentWhiteBalance");
        int value = 255;
        try {
            value = this.cameraProperty.getCurrentWhiteBalance();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentWhiteBalance retvalue =" + value);
        return value;
    }

    public int getCurrentLightFrequency() {
        AppLog.i("CameraProperties", "begin getCurrentLightFrequency");
        int value = 255;
        try {
            value = this.cameraProperty.getCurrentLightFrequency();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentLightFrequency value =" + value);
        return value;
    }

    public boolean setCaptureDelay(int value) {
        AppLog.i("CameraProperties", "begin setCaptureDelay set value =" + value);
        boolean retVal = false;
        try {
            AppLog.i("CameraProperties", "start setCaptureDelay ");
            retVal = this.cameraProperty.setCaptureDelay(value);
            AppLog.i("CameraProperties", "end setCaptureDelay ");
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setCaptureDelay retVal =" + retVal);
        return retVal;
    }

    public int getCurrentCaptureDelay() {
        AppLog.i("CameraProperties", "begin getCurrentCaptureDelay");
        int retVal = 0;
        try {
            retVal = this.cameraProperty.getCurrentCaptureDelay();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentCaptureDelay retVal =" + retVal);
        return retVal;
    }

    public int getCurrentDateStamp() {
        AppLog.i("CameraProperties", "begin getCurrentDateStampType");
        int retValue = 0;
        try {
            retValue = this.cameraProperty.getCurrentDateStamp();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "getCurrentDateStampType retValue =" + retValue);
        return retValue;
    }

    public boolean setDateStamp(int dateStamp) {
        AppLog.i("CameraProperties", "begin setDateStampType set value = " + dateStamp);
        Boolean retValue = false;
        try {
            retValue = this.cameraProperty.setDateStamp(dateStamp);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentVideoSize retValue =" + retValue);
        return retValue;
    }

    public List<Integer> getDateStampList() {
        AppLog.i("CameraProperties", "begin getDateStampList");
        List list = null;
        try {
            list = this.cameraProperty.getSupportedDateStamps();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getDateStampList list.size ==" + list.size());
        return list;
    }

    public List<Integer> getSupportFuction() {
        AppLog.i("CameraProperties", "begin getSupportFuction");
        List fuction = null;
        try {
            fuction = this.cameraProperty.getSupportedProperties();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getSupportFuction fuction=" + fuction);
        return fuction;
    }

    public int getCurrentBurstNum() {
        AppLog.i("CameraProperties", "begin getCurrentBurstNum");
        int number = 255;
        try {
            number = this.cameraProperty.getCurrentBurstNumber();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "getCurrentBurstNum num =" + number);
        return number;
    }

    public int getCurrentAppBurstNum() {
        AppLog.i("CameraProperties", "begin getCurrentAppBurstNum");
        int number = 255;
        try {
            number = this.cameraProperty.getCurrentBurstNumber();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        number = BurstConvert.getInstance().getBurstConverFromFw(number);
        AppLog.i("CameraProperties", "getCurrentAppBurstNum num =" + number);
        return number;
    }

    public boolean setCurrentBurst(int burstNum) {
        AppLog.i("CameraProperties", "begin setCurrentBurst set value = " + burstNum);
        if (burstNum < 0 || burstNum == 255) {
            return false;
        }
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setBurstNumber(burstNum);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setCurrentBurst retValue =" + retValue);
        return retValue;
    }

    public int getRemainImageNum() {
        AppLog.i("CameraProperties", "begin getRemainImageNum");
        int num = 0;
        try {
            num = this.cameraAction.getFreeSpaceInImages();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        catch (IchNoSDCardException e) {
            AppLog.e("CameraProperties", "IchNoSDCardException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getRemainImageNum num =" + num);
        return num;
    }

    public int getRecordingRemainTime() {
        AppLog.i("CameraProperties", "begin getRecordingRemainTimeInt");
        int recordingTime = 0;
        try {
            recordingTime = this.cameraAction.getRemainRecordingTime();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        catch (IchNoSDCardException e) {
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getRecordingRemainTimeInt recordingTime =" + recordingTime);
        return recordingTime;
    }

    public boolean isSDCardExist() {
        AppLog.i("CameraProperties", "begin isSDCardExist");
        Boolean isReady = false;
        try {
            isReady = this.cameraAction.isSDCardExist();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDeviceException e) {
            AppLog.e("CameraProperties", "IchDeviceException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end isSDCardExist isReady =" + isReady);
        return isReady;
    }

    public int getBatteryElectric() {
        AppLog.i("CameraProperties", "start getBatteryElectric");
        int electric = 0;
        try {
            electric = this.cameraAction.getCurrentBatteryLevel();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getBatteryElectric electric =" + electric);
        return electric;
    }

    public boolean supportVideoPlayback() {
        AppLog.i("CameraProperties", "begin hasVideoPlaybackFuction");
        boolean retValue = false;
        try {
            retValue = this.cameraAction.supportVideoPlayback();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        catch (IchNoSDCardException e) {
            AppLog.e("CameraProperties", "IchNoSDCardException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "hasVideoPlaybackFuction retValue =" + retValue);
        return retValue;
    }

    public boolean cameraModeSupport(int mode) {
        AppLog.i("CameraProperties", "begin cameraModeSupport  mode=" + mode);
        Boolean retValue = false;
        if (this.modeList == null) {
            this.modeList = this.getSupportedModes();
        }
        if (this.modeList.contains(mode)) {
            retValue = true;
        }
        AppLog.i("CameraProperties", "end cameraModeSupport retValue =" + retValue);
        return retValue;
    }

    public String getCameraMacAddress() {
        AppLog.i("CameraProperties", "begin getCameraMacAddress macAddress macAddress ");
        String macAddress = this.cameraAction.getMacAddress();
        AppLog.i("CameraProperties", "end getCameraMacAddress macAddress =" + macAddress);
        return macAddress;
    }

    public boolean hasFuction(int fuc) {
        AppLog.i("CameraProperties", "begin hasFuction query fuction = " + fuc);
        if (this.fuction == null) {
            this.fuction = this.getSupportFuction();
        }
        Boolean retValue = false;
        if (this.fuction.contains(fuc)) {
            retValue = true;
        }
        AppLog.i("CameraProperties", "end hasFuction retValue =" + retValue);
        return retValue;
    }

    public List<Integer> getsupportedDateStamps() {
        AppLog.i("CameraProperties", "begin getsupportedDateStamps");
        List list = null;
        try {
            list = this.cameraProperty.getSupportedDateStamps();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getsupportedDateStamps list.size() =" + list.size());
        return list;
    }

    public List<Integer> getsupportedBurstNums() {
        AppLog.i("CameraProperties", "begin getsupportedBurstNums");
        List list = null;
        try {
            list = this.cameraProperty.getSupportedBurstNumbers();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
        }
        AppLog.i("CameraProperties", "end getsupportedBurstNums list.size() =" + list.size());
        return list;
    }

    public List<Integer> getSupportedFrequencies() {
        AppLog.i("CameraProperties", "begin getSupportedFrequencies");
        List list = null;
        try {
            list = this.cameraProperty.getSupportedLightFrequencies();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getSupportedFrequencies list.size() =" + list.size());
        return list;
    }

    public List<Integer> getSupportedModes() {
        AppLog.i("CameraProperties", "begin getSupportedModes");
        List list = null;
        try {
            list = this.cameraAction.getSupportedModes();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getSupportedModes list =" + list);
        return list;
    }

    public List<Integer> getSupportedTimeLapseDurations() {
        AppLog.i("CameraProperties", "begin getSupportedTimeLapseDurations");
        List list = null;
        try {
            list = this.cameraProperty.getSupportedTimeLapseDurations();
        }
        catch (IchSocketException e) {
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            e.printStackTrace();
        }
        for (int ii = 0; ii < list.size(); ++ii) {
            AppLog.i("CameraProperties", "list.get(ii) =" + list.get(ii));
        }
        AppLog.i("CameraProperties", "end getSupportedTimeLapseDurations list =" + list.size());
        return list;
    }

    public List<Integer> getSupportedTimeLapseIntervals() {
        AppLog.i("CameraProperties", "begin getSupportedTimeLapseIntervals");
        List list = null;
        try {
            list = this.cameraProperty.getSupportedTimeLapseIntervals();
        }
        catch (IchSocketException e) {
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            e.printStackTrace();
        }
        for (int ii = 0; ii < list.size(); ++ii) {
            AppLog.i("CameraProperties", "list.get(ii) =" + list.get(ii));
        }
        AppLog.i("CameraProperties", "end getSupportedTimeLapseIntervals list =" + list.size());
        return list;
    }

    public boolean setTimeLapseDuration(int timeDuration) {
        AppLog.i("CameraProperties", "begin setTimeLapseDuration videoDuration =" + timeDuration);
        boolean retVal = false;
        if (timeDuration < 0 || timeDuration == 255) {
            return false;
        }
        try {
            retVal = this.cameraProperty.setTimeLapseDuration(timeDuration);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setTimeLapseDuration retVal=" + retVal);
        return retVal;
    }

    public int getCurrentTimeLapseDuration() {
        AppLog.i("CameraProperties", "begin getCurrentTimeLapseDuration");
        int retVal = 255;
        try {
            retVal = this.cameraProperty.getCurrentTimeLapseDuration();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentTimeLapseDuration retVal=" + retVal);
        return retVal;
    }

    public boolean setTimeLapseInterval(int timeInterval) {
        AppLog.i("CameraProperties", "begin setTimeLapseInterval videoDuration =" + timeInterval);
        boolean retVal = false;
        try {
            retVal = this.cameraProperty.setTimeLapseInterval(timeInterval);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setTimeLapseInterval retVal=" + retVal);
        return retVal;
    }

    public int getCurrentTimeLapseInterval() {
        AppLog.i("CameraProperties", "begin getCurrentTimeLapseInterval");
        int retVal = 255;
        try {
            retVal = this.cameraProperty.getCurrentTimeLapseInterval();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentTimeLapseInterval retVal=" + retVal);
        return retVal;
    }

    public float getMaxZoomRatio() {
        AppLog.i("CameraProperties", "start getMaxZoomRatio");
        float retValue = 0.0f;
        try {
            retValue = (float)this.cameraProperty.getMaxZoomRatio() / 10.0f;
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getMaxZoomRatio retValue =" + retValue);
        return retValue;
    }

    public float getCurrentZoomRatio() {
        AppLog.i("CameraProperties", "start getCurrentZoomRatio");
        float retValue = 0.0f;
        try {
            retValue = (float)this.cameraProperty.getCurrentZoomRatio() / 10.0f;
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentZoomRatio retValue =" + retValue);
        return retValue;
    }

    public int getCurrentUpsideDown() {
        AppLog.i("CameraProperties", "start getCurrentUpsideDown");
        int retValue = 0;
        try {
            retValue = this.cameraProperty.getCurrentUpsideDown();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentUpsideDown retValue =" + retValue);
        return retValue;
    }

    public boolean setUpsideDown(int upside) {
        AppLog.i("CameraProperties", "start setUpsideDown upside = " + upside);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setUpsideDown(upside);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setUpsideDown retValue =" + retValue);
        return retValue;
    }

    public int getCurrentSlowMotion() {
        AppLog.i("CameraProperties", "start getCurrentSlowMotion");
        int retValue = 0;
        try {
            retValue = this.cameraProperty.getCurrentSlowMotion();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentSlowMotion retValue =" + retValue);
        return retValue;
    }

    public boolean setSlowMotion(int slowMotion) {
        AppLog.i("CameraProperties", "start setSlowMotion slowMotion = " + slowMotion);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setSlowMotion(slowMotion);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setSlowMotion retValue =" + retValue);
        return retValue;
    }

    public boolean setCameraDate() {
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        SimpleDateFormat myFmt = new SimpleDateFormat("yyyyMMdd HHmmss");
        String tempDate = myFmt.format(date);
        tempDate = tempDate.replaceAll(" ", "T");
        tempDate = tempDate + ".0";
        AppLog.i("CameraProperties", "start setCameraDate date = " + tempDate);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(20497, tempDate);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setCameraDate retValue =" + retValue);
        return retValue;
    }

    public boolean setCameraEssidName(String ssidName) {
        AppLog.i("CameraProperties", "start setCameraEssidName date = " + ssidName);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(55348, ssidName);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setCameraEssidName retValue =" + retValue);
        return retValue;
    }

    public String getCameraEssidName() {
        AppLog.i("CameraProperties", "start getCameraEssidName");
        String retValue = null;
        try {
            retValue = this.cameraProperty.getCurrentStringPropertyValue(55348);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCameraEssidName retValue =" + retValue);
        return retValue;
    }

    public String getCameraEssidPassword() {
        AppLog.i("CameraProperties", "start getCameraEssidPassword");
        String retValue = null;
        try {
            retValue = this.cameraProperty.getCurrentStringPropertyValue(55349);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCameraEssidPassword retValue =" + retValue);
        return retValue;
    }

    public boolean setCameraEssidPassword(String ssidPassword) {
        AppLog.i("CameraProperties", "start setStringPropertyValue date = " + ssidPassword);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(55349, ssidPassword);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setCameraSsid retValue =" + retValue);
        return retValue;
    }

    public boolean setCameraSsid(String ssid) {
        AppLog.i("CameraProperties", "start setCameraSsid date = " + ssid);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(55356, ssid);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setCameraSsid retValue =" + retValue);
        return retValue;
    }

    public boolean setCameraName(String cameraName) {
        AppLog.i("CameraProperties", "start setStringPropertyValue cameraName = " + cameraName);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(55345, cameraName);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setStringPropertyValue retValue =" + retValue);
        return retValue;
    }

    public String getCameraName() {
        AppLog.i("CameraProperties", "start getCameraName");
        String retValue = null;
        try {
            retValue = this.cameraProperty.getCurrentStringPropertyValue(55345);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCameraName retValue =" + retValue);
        return retValue;
    }

    public String getCameraName(ICatchCameraProperty cameraConfiguration1) {
        AppLog.i("CameraProperties", "start getCameraName");
        String retValue = null;
        try {
            retValue = cameraConfiguration1.getCurrentStringPropertyValue(55345);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCameraName retValue =" + retValue);
        return retValue;
    }

    public String getCameraPasswordNew() {
        AppLog.i("CameraProperties", "start getCameraPassword");
        String retValue = null;
        try {
            retValue = this.cameraProperty.getCurrentStringPropertyValue(55346);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCameraPassword retValue =" + retValue);
        return retValue;
    }

    public boolean setCameraPasswordNew(String cameraNamePassword) {
        AppLog.i("CameraProperties", "start setCameraPasswordNew cameraName = " + cameraNamePassword);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(55346, cameraNamePassword);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setCameraPasswordNew retValue =" + retValue);
        return retValue;
    }

    public String getCameraSsid() {
        AppLog.i("CameraProperties", "start getCameraSsid date = ");
        String retValue = null;
        try {
            retValue = this.cameraProperty.getCurrentStringPropertyValue(55356);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCameraSsid retValue =" + retValue);
        return retValue;
    }

    public boolean setCameraPassword(String password) {
        AppLog.i("CameraProperties", "start setCameraSsid date = " + password);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(55357, password);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setCameraSsid retValue =" + retValue);
        return retValue;
    }

    public boolean enableTCP() {
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(55342, String.valueOf(16));
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setStep retValue =" + retValue);
        return retValue;
    }

    public boolean setMotorStep(int step) {
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(55343, String.valueOf(step));
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setStep retValue =" + retValue);
        return retValue;
    }

    public int getMotorStatus() {
        AppLog.i("CameraProperties", "start getStatus");
        int retValue = 0;
        try {
            retValue = this.cameraProperty.getCurrentPropertyValue(55041);
        }
        catch (Exception e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getStatus retValue =" + retValue);
        return retValue;
    }

    public String getCameraPassword() {
        AppLog.i("CameraProperties", "start getCameraPassword date = ");
        String retValue = null;
        try {
            retValue = this.cameraProperty.getCurrentStringPropertyValue(55357);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCameraPassword retValue =" + retValue);
        return retValue;
    }

    public boolean setCaptureDelayMode(int value) {
        AppLog.i("CameraProperties", "start setCaptureDelayMode value = " + value);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setPropertyValue(55280, value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setCaptureDelayMode retValue =" + retValue);
        return retValue;
    }

    public int getVideoRecordingTime() {
        AppLog.i("CameraProperties", "start getRecordingTime");
        int retValue = 0;
        try {
            retValue = this.cameraProperty.getCurrentPropertyValue(55293);
        }
        catch (Exception e) {
            AppLog.e("CameraProperties", "Exception e:" + e.getClass().getSimpleName());
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getRecordingTime retValue =" + retValue);
        return retValue;
    }

    public boolean setServiceEssid(String value) {
        AppLog.i("CameraProperties", "start setServiceEssid value = " + value);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(55350, value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setServiceEssid retValue =" + retValue);
        return retValue;
    }

    public boolean setServicePassword(String value) {
        AppLog.i("CameraProperties", "start setServicePassword value = " + value);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(55351, value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setServicePassword retValue =" + retValue);
        return retValue;
    }

    public boolean notifyFwToShareMode(int value) {
        AppLog.i("CameraProperties", "start notifyFwToShareMode value = " + value);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setPropertyValue(55291, value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end notifyFwToShareMode retValue =" + retValue);
        return retValue;
    }

    public List<Integer> getSupportedPropertyValues(int propertyId) {
        AppLog.i("CameraProperties", "begin getSupportedPropertyValues propertyId =" + propertyId);
        List list = null;
        try {
            list = this.cameraProperty.getSupportedPropertyValues(propertyId);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
        }
        AppLog.i("CameraProperties", "end getSupportedPropertyValues list.size() =" + list.size());
        return list;
    }

    public int getCurrentPropertyValue(int propertyId) {
        AppLog.i("CameraProperties", "start getCurrentPropertyValue propertyId = " + propertyId);
        int retValue = 0;
        try {
            retValue = this.cameraProperty.getCurrentPropertyValue(propertyId);
        }
        catch (Exception e) {
            AppLog.e("CameraProperties", "Exception e:" + e.getClass().getSimpleName());
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentPropertyValue retValue =" + retValue);
        return retValue;
    }

    public String getCurrentStringPropertyValue(int propertyId) {
        AppLog.i("CameraProperties", "start getCurrentStringPropertyValue propertyId = " + propertyId);
        String retValue = null;
        try {
            retValue = this.cameraProperty.getCurrentStringPropertyValue(propertyId);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentStringPropertyValue retValue =" + retValue);
        return retValue;
    }

    public boolean setPropertyValue(int propertyId, int value) {
        AppLog.i("CameraProperties", "start setPropertyValue propertyId=" + propertyId + " value=" + value);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setPropertyValue(propertyId, value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setPropertyValue retValue =" + retValue);
        return retValue;
    }

    public boolean setStringPropertyValue(int propertyId, String value) {
        AppLog.i("CameraProperties", "start setStringPropertyValue propertyId=" + propertyId + " value=[" + value + "]");
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStringPropertyValue(propertyId, value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setStringPropertyValue retValue =" + retValue);
        return retValue;
    }

    public int getVideoSizeFlow() {
        AppLog.i("CameraProperties", "start getVideoSizeFlow");
        int retValue = 0;
        try {
            retValue = this.cameraProperty.getCurrentPropertyValue(55292);
        }
        catch (Exception e) {
            AppLog.e("CameraProperties", "Exception e:" + e.getClass().getSimpleName());
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getVideoSizeFlow retValue =" + retValue);
        return retValue;
    }

    public boolean notifyCameraConnectChnage(int value) {
        AppLog.i("CameraProperties", "start notifyCameraConnectChnage value = " + value);
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setPropertyValue(55201, value);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end notifyCameraConnectChnage retValue =" + retValue);
        return retValue;
    }

    public List<ICatchVideoFormat> getResolutionList() {
        AppLog.i("CameraProperties", "start getResolution");
        if (this.resolutionList == null) {
            try {
                this.resolutionList = this.cameraProperty.getSupportedStreamingInfos();
            }
            catch (Exception e) {
                AppLog.e("CameraProperties", "Exception e:" + e.getMessage());
                e.printStackTrace();
            }
        }
        AppLog.i("CameraProperties", "end getResolution retList=" + this.resolutionList);
        for (ICatchVideoFormat temp : this.resolutionList) {
            AppLog.i("CameraProperties", "end getResolution format=" + temp);
        }
        return this.resolutionList;
    }

    public List<ICatchVideoFormat> getResolutionList(int codecType) {
        AppLog.i("CameraProperties", "start getResolution");
        if (this.resolutionList == null) {
            try {
                this.resolutionList = this.cameraProperty.getSupportedStreamingInfos();
            }
            catch (Exception e) {
                AppLog.e("CameraProperties", "Exception e:" + e.getMessage());
                e.printStackTrace();
            }
        }
        AppLog.i("CameraProperties", "end getResolution retList=" + this.resolutionList);
        LinkedList<ICatchVideoFormat> tempList = new LinkedList<ICatchVideoFormat>();
        for (ICatchVideoFormat temp : this.resolutionList) {
            if (temp.getCodec() == codecType) {
                tempList.add(temp);
            }
            AppLog.i("CameraProperties", "end getResolution format=" + temp);
        }
        return tempList;
    }

    public String getBestResolution() {
        ICatchVideoFormat temp;
        int ii;
        AppLog.i("CameraProperties", "start getBestResolution");
        String bestResolution = null;
        List<ICatchVideoFormat> tempList = this.getResolutionList();
        if (tempList == null || tempList.size() == 0) {
            return null;
        }
        Log.d((String)"1111", (String)("getResolutionList() tempList.size() = " + tempList.size()));
        int tempWidth = 0;
        int tempHeigth = 0;
        for (ii = 0; ii < tempList.size(); ++ii) {
            temp = tempList.get(ii);
            if (temp.getCodec() != 41) continue;
            if (bestResolution == null) {
                bestResolution = "H264?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
            }
            if (temp.getVideoW() == 640 && temp.getVideoH() == 360) {
                bestResolution = "H264?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
                return bestResolution;
            }
            if (temp.getVideoW() == 640 && temp.getVideoH() == 480) {
                if (tempWidth == 640) continue;
                bestResolution = "H264?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
                tempWidth = 640;
                tempHeigth = 480;
                continue;
            }
            if (temp.getVideoW() == 720) {
                if (tempWidth == 640) continue;
                if (temp.getVideoW() * 9 == temp.getVideoH() * 16) {
                    bestResolution = "H264?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
                    tempWidth = 720;
                    tempHeigth = temp.getVideoH();
                    continue;
                }
                if (temp.getVideoW() * 3 != temp.getVideoH() * 4) continue;
                if (tempWidth != 720) {
                    bestResolution = "H264?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
                }
                tempWidth = 720;
                tempHeigth = temp.getVideoH();
                continue;
            }
            if (temp.getVideoW() >= tempWidth) continue;
            if (temp.getVideoW() * 9 == temp.getVideoH() * 16) {
                bestResolution = "H264?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
                tempWidth = temp.getVideoW();
                tempHeigth = temp.getVideoH();
                continue;
            }
            if (temp.getVideoW() * 3 != temp.getVideoH() * 4) continue;
            if (tempWidth != temp.getVideoW()) {
                bestResolution = "H264?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
            }
            tempWidth = temp.getVideoW();
            tempHeigth = temp.getVideoH();
        }
        if (bestResolution != null) {
            return bestResolution;
        }
        for (ii = 0; ii < tempList.size(); ++ii) {
            temp = tempList.get(ii);
            if (temp.getCodec() != 64) continue;
            if (bestResolution == null) {
                bestResolution = "MJPG?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
            }
            if (temp.getVideoW() == 640 && temp.getVideoH() == 360) {
                bestResolution = "MJPG?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
                return bestResolution;
            }
            if (temp.getVideoW() == 640 && temp.getVideoH() == 480) {
                if (tempWidth == 640) continue;
                bestResolution = "MJPG?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
                tempWidth = 640;
                tempHeigth = 480;
                continue;
            }
            if (temp.getVideoW() == 720) {
                if (tempWidth == 640) continue;
                if (temp.getVideoW() * 9 == temp.getVideoH() * 16) {
                    bestResolution = "MJPG?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
                    tempWidth = 720;
                    tempHeigth = temp.getVideoH();
                    continue;
                }
                if (temp.getVideoW() * 3 != temp.getVideoH() * 4) continue;
                if (tempWidth != 720) {
                    bestResolution = "MJPG?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
                }
                tempWidth = 720;
                tempHeigth = temp.getVideoH();
                continue;
            }
            if (temp.getVideoW() >= tempWidth) continue;
            if (temp.getVideoW() * 9 == temp.getVideoH() * 16) {
                bestResolution = "MJPG?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
                tempWidth = temp.getVideoW();
                tempHeigth = temp.getVideoH();
                continue;
            }
            if (temp.getVideoW() * 3 != temp.getVideoH() * 4) continue;
            if (tempWidth != temp.getVideoW()) {
                bestResolution = "MJPG?W=" + temp.getVideoW() + "&H=" + temp.getVideoH() + "&BR=" + temp.getBitrate() + "&";
            }
            tempWidth = temp.getVideoW();
            tempHeigth = temp.getVideoH();
        }
        AppLog.i("CameraProperties", "end getBestResolution");
        return bestResolution;
    }

    public String getFWDefaultResolution() {
        AppLog.i("CameraProperties", "start getFWDefaultResolution");
        String resolution = null;
        ICatchVideoFormat retValue = null;
        try {
            retValue = this.cameraProperty.getCurrentStreamingInfo();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        if (retValue != null) {
            if (retValue.getCodec() == 41) {
                resolution = "H264?W=" + retValue.getVideoW() + "&H=" + retValue.getVideoH() + "&BR=" + retValue.getBitrate() + "&";
            } else if (retValue.getCodec() == 64) {
                resolution = "MJPG?W=" + retValue.getVideoW() + "&H=" + retValue.getVideoH() + "&BR=" + retValue.getBitrate() + "&";
            }
        }
        AppLog.i("CameraProperties", "end getFWDefaultResolution");
        return resolution;
    }

    public boolean setStreamingInfo(ICatchVideoFormat iCatchVideoFormat) {
        AppLog.i("CameraProperties", "start setStreamingInfo");
        boolean retValue = false;
        try {
            retValue = this.cameraProperty.setStreamingInfo(iCatchVideoFormat);
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end setStreamingInfo");
        return retValue;
    }

    public String getCurrentStreamInfo() {
        AppLog.i("CameraProperties", "start getCurrentStreamInfo cameraProperty=" + this.cameraProperty);
        ICatchVideoFormat retValue = null;
        String bestResolution = null;
        try {
            retValue = this.cameraProperty.getCurrentStreamingInfo();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getCurrentStreamInfo retValue = " + retValue);
        if (retValue == null) {
            return null;
        }
        if (this.hasFuction(55214)) {
            if (retValue.getCodec() == 41) {
                bestResolution = "H264?W=" + retValue.getVideoW() + "&H=" + retValue.getVideoH() + "&BR=" + retValue.getBitrate() + "&FPS=" + retValue.getFrameRate() + "&";
            } else if (retValue.getCodec() == 64) {
                bestResolution = "MJPG?W=" + retValue.getVideoW() + "&H=" + retValue.getVideoH() + "&BR=" + retValue.getBitrate() + "&FPS=" + retValue.getFrameRate() + "&";
            }
        } else if (retValue.getCodec() == 41) {
            bestResolution = "H264?W=" + retValue.getVideoW() + "&H=" + retValue.getVideoH() + "&BR=" + retValue.getBitrate();
        } else if (retValue.getCodec() == 64) {
            bestResolution = "MJPG?W=" + retValue.getVideoW() + "&H=" + retValue.getVideoH() + "&BR=" + retValue.getBitrate();
        }
        AppLog.i("CameraProperties", "end getCurrentStreamInfo bestResolution =" + bestResolution);
        return bestResolution;
    }

    public int getPreviewCacheTime() {
        AppLog.i("CameraProperties", "start getPreviewCacheTime");
        int retValue = 0;
        try {
            retValue = this.cameraProperty.getPreviewCacheTime();
        }
        catch (IchSocketException e) {
            AppLog.e("CameraProperties", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("CameraProperties", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("CameraProperties", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDevicePropException e) {
            AppLog.e("CameraProperties", "IchDevicePropException");
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getPreviewCacheTime retValue =" + retValue);
        return retValue;
    }

    public boolean isSupportPreview() {
        AppLog.i("CameraProperties", "start getRecordingTime");
        int retValue = 0;
        boolean isSupport = false;
        try {
            retValue = this.cameraProperty.getCurrentPropertyValue(55295);
        }
        catch (Exception e) {
            AppLog.e("CameraProperties", "Exception:" + e.getClass().getSimpleName());
            e.printStackTrace();
        }
        AppLog.i("CameraProperties", "end getRecordingTime retValue =" + retValue);
        isSupport = retValue != 0;
        return isSupport;
    }
}

