/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.SdkApi;

import com.icatch.panorama.Log.AppLog;
import com.icatchtek.control.customer.ICatchCameraPlayback;
import com.icatchtek.control.customer.exception.IchCameraModeException;
import com.icatchtek.control.customer.exception.IchNoSuchPathException;
import com.icatchtek.reliant.customer.exception.IchBufferTooSmallException;
import com.icatchtek.reliant.customer.exception.IchDeviceException;
import com.icatchtek.reliant.customer.exception.IchInvalidSessionException;
import com.icatchtek.reliant.customer.exception.IchNoSuchFileException;
import com.icatchtek.reliant.customer.exception.IchSocketException;
import com.icatchtek.reliant.customer.type.ICatchFile;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;
import java.util.List;

public class FileOperation {
    private final String tag = "FileOperation";
    private ICatchCameraPlayback cameraPlayback;

    public FileOperation(ICatchCameraPlayback cameraPlayback) {
        this.cameraPlayback = cameraPlayback;
    }

    public boolean cancelDownload() {
        AppLog.i("FileOperation", "begin cancelDownload");
        if (this.cameraPlayback == null) {
            return true;
        }
        boolean retValue = false;
        try {
            retValue = this.cameraPlayback.cancelFileDownload();
        }
        catch (IchSocketException e) {
            AppLog.e("FileOperation", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("FileOperation", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("FileOperation", "IchInvalidSessionException");
            e.printStackTrace();
        }
        catch (IchDeviceException e) {
            AppLog.e("FileOperation", "IchDeviceException");
            e.printStackTrace();
        }
        AppLog.i("FileOperation", "end cancelDownload retValue =" + retValue);
        return retValue;
    }

    public List<ICatchFile> getFileList(int type) {
        AppLog.i("FileOperation", "begin getFileList");
        List list = null;
        try {
            list = this.cameraPlayback.listFiles(type);
        }
        catch (IchSocketException e) {
            AppLog.e("FileOperation", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("FileOperation", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchNoSuchPathException e) {
            AppLog.e("FileOperation", "IchNoSuchPathException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("FileOperation", "IchInvalidSessionException");
            e.printStackTrace();
        }
        AppLog.i("FileOperation", "end getFileList list=" + list);
        return list;
    }

    public boolean deleteFile(ICatchFile file) {
        AppLog.i("FileOperation", "begin deleteFile filename =" + file.getFileName());
        boolean retValue = false;
        try {
            retValue = this.cameraPlayback.deleteFile(file);
        }
        catch (IchSocketException e) {
            AppLog.e("FileOperation", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("FileOperation", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("FileOperation", "IchInvalidSessionException");
        }
        catch (IchNoSuchFileException e) {
            AppLog.e("FileOperation", "IchNoSuchFileException");
            e.printStackTrace();
        }
        catch (IchDeviceException e) {
            AppLog.e("FileOperation", "IchDeviceException");
            e.printStackTrace();
        }
        AppLog.i("FileOperation", "end deleteFile retValue=" + retValue);
        return retValue;
    }

    public boolean downloadFile(ICatchFile file, String path) {
        AppLog.i("FileOperation", "begin downloadFile filename =" + file.getFileName());
        AppLog.i("FileOperation", "begin downloadFile path =" + path);
        boolean retValue = false;
        try {
            retValue = this.cameraPlayback.downloadFile(file, path);
        }
        catch (IchSocketException e) {
            AppLog.e("FileOperation", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("FileOperation", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("FileOperation", "IchInvalidSessionException");
        }
        catch (IchNoSuchFileException e) {
            AppLog.e("FileOperation", "IchNoSuchFileException");
            e.printStackTrace();
        }
        catch (IchDeviceException e) {
            AppLog.e("FileOperation", "IchDeviceException");
            e.printStackTrace();
        }
        AppLog.i("FileOperation", "end downloadFile retValue =" + retValue);
        return retValue;
    }

    public ICatchFrameBuffer downloadFile(ICatchFile curFile) {
        AppLog.i("FileOperation", "begin downloadFile for buffer filename =" + curFile.getFileName());
        ICatchFrameBuffer buffer = null;
        try {
            buffer = this.cameraPlayback.downloadFile(curFile);
        }
        catch (IchSocketException e) {
            AppLog.e("FileOperation", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("FileOperation", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("FileOperation", "IchInvalidSessionException");
        }
        catch (IchNoSuchFileException e) {
            AppLog.e("FileOperation", "IchNoSuchFileException");
            e.printStackTrace();
        }
        catch (IchDeviceException e) {
            AppLog.e("FileOperation", "IchDeviceException");
            e.printStackTrace();
        }
        catch (IchBufferTooSmallException e) {
            AppLog.e("FileOperation", "IchBufferTooSmallException");
            e.printStackTrace();
        }
        AppLog.i("FileOperation", "end downloadFile for buffer, buffer =" + buffer);
        return buffer;
    }

    public ICatchFrameBuffer getQuickview(ICatchFile curFile) {
        AppLog.i("FileOperation", "begin getQuickview for buffer filename =" + curFile.getFileName());
        ICatchFrameBuffer buffer = null;
        try {
            buffer = this.cameraPlayback.getQuickview(curFile);
        }
        catch (IchSocketException e) {
            AppLog.e("FileOperation", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("FileOperation", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("FileOperation", "IchInvalidSessionException");
        }
        catch (IchDeviceException e) {
            AppLog.e("FileOperation", "IchDeviceException");
            e.printStackTrace();
        }
        catch (IchBufferTooSmallException e) {
            AppLog.e("FileOperation", "IchDeviceException");
            e.printStackTrace();
        }
        catch (IchNoSuchFileException e) {
            AppLog.e("FileOperation", "IchDeviceException");
            e.printStackTrace();
        }
        AppLog.i("FileOperation", "end getQuickview for buffer, buffer =" + buffer);
        if (buffer != null) {
            AppLog.i("FileOperation", "buffer size =" + buffer.getFrameSize());
        }
        return buffer;
    }

    public ICatchFrameBuffer getThumbnail(ICatchFile file) {
        AppLog.i("FileOperation", "begin getThumbnail file=" + file);
        ICatchFrameBuffer frameBuffer = null;
        try {
            frameBuffer = this.cameraPlayback.getThumbnail(file);
        }
        catch (IchSocketException e) {
            AppLog.e("FileOperation", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.e("FileOperation", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.e("FileOperation", "IchInvalidSessionException");
        }
        catch (IchNoSuchFileException e) {
            AppLog.e("FileOperation", "IchNoSuchFileException");
            e.printStackTrace();
        }
        catch (IchDeviceException e) {
            AppLog.e("FileOperation", "IchDeviceException");
            e.printStackTrace();
        }
        catch (IchBufferTooSmallException e) {
            AppLog.e("FileOperation", "IchBufferTooSmallException");
            e.printStackTrace();
        }
        AppLog.i("FileOperation", "end getThumbnail frameBuffer=" + frameBuffer);
        return frameBuffer;
    }

    public ICatchFrameBuffer getThumbnail(String filePath) {
        AppLog.d("[Normal] -- FileOperation: ", "begin getThumbnail");
        ICatchFile icathfile = new ICatchFile(33, 2, filePath, "", 0L);
        AppLog.d("[Normal] -- FileOperation: ", "begin getThumbnail file=" + filePath);
        AppLog.d("[Normal] -- FileOperation: ", "begin getThumbnail cameraPlayback=" + this.cameraPlayback);
        ICatchFrameBuffer frameBuffer = null;
        try {
            AppLog.d("test", "start cameraPlayback.getThumbnail(file) cameraPlayback=" + this.cameraPlayback);
            frameBuffer = this.cameraPlayback.getThumbnail(icathfile);
        }
        catch (IchSocketException e) {
            AppLog.d("[Error] -- FileOperation: ", "IchSocketException");
            e.printStackTrace();
        }
        catch (IchCameraModeException e) {
            AppLog.d("[Error] -- FileOperation: ", "IchCameraModeException");
            e.printStackTrace();
        }
        catch (IchInvalidSessionException e) {
            AppLog.d("[Error] -- FileOperation: ", "IchInvalidSessionException");
        }
        catch (IchNoSuchFileException e) {
            AppLog.d("[Error] -- FileOperation: ", "IchNoSuchFileException");
            e.printStackTrace();
        }
        catch (IchDeviceException e) {
            AppLog.d("[Error] -- FileOperation: ", "IchDeviceException");
            e.printStackTrace();
        }
        catch (IchBufferTooSmallException e) {
            AppLog.d("[Error] -- FileOperation: ", "IchBufferTooSmallException");
            e.printStackTrace();
        }
        AppLog.d("[Normal] -- FileOperation: ", "end getThumbnail frameBuffer=" + frameBuffer);
        return frameBuffer;
    }
}

