/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.SdkApi;

import com.icatch.panorama.Log.AppLog;
import com.icatchtek.pancam.customer.stream.ICatchIStreamProvider;
import com.icatchtek.reliant.customer.exception.IchStreamNotRunningException;
import com.icatchtek.reliant.customer.exception.IchTryAgainException;
import com.icatchtek.reliant.customer.exception.IchVideoStreamClosedException;
import com.icatchtek.reliant.customer.type.ICatchAudioFormat;
import com.icatchtek.reliant.customer.type.ICatchFrameBuffer;
import com.icatchtek.reliant.customer.type.ICatchVideoFormat;

public class StreamProvider {
    private String TAG = StreamProvider.class.getSimpleName();
    private ICatchIStreamProvider iCatchIStreamProvider;

    public StreamProvider(ICatchIStreamProvider streamProvider) {
        this.iCatchIStreamProvider = streamProvider;
    }

    public boolean containsVideoStream() {
        if (this.iCatchIStreamProvider == null) {
            AppLog.e(this.TAG, "iCatchIStreamProvider is null");
            return false;
        }
        boolean ret = false;
        try {
            ret = this.iCatchIStreamProvider.containsVideoStream();
        }
        catch (Exception e) {
            AppLog.e(this.TAG, "containsVideoStream exception: " + e.getMessage());
        }
        return ret;
    }

    public boolean containsAudioStream() {
        AppLog.d(this.TAG, "start containsAudioStream");
        if (this.iCatchIStreamProvider == null) {
            return false;
        }
        boolean ret = false;
        try {
            ret = this.iCatchIStreamProvider.containsAudioStream();
        }
        catch (Exception e) {
            AppLog.e(this.TAG, "containsAudioStream exception: " + e.getMessage());
        }
        AppLog.d(this.TAG, "end containsAudioStream ret=" + ret);
        return ret;
    }

    public ICatchVideoFormat getVideoFormat() {
        if (this.iCatchIStreamProvider == null) {
            return null;
        }
        ICatchVideoFormat iCatchVideoFormat = null;
        try {
            iCatchVideoFormat = this.iCatchIStreamProvider.getVideoFormat();
        }
        catch (Exception e) {
            AppLog.e(this.TAG, "getVideoFormat exception: " + e.getMessage());
            e.printStackTrace();
        }
        return iCatchVideoFormat;
    }

    public ICatchAudioFormat getAudioFormat() {
        if (this.iCatchIStreamProvider == null) {
            AppLog.e(this.TAG, "iCatchIStreamProvider is null");
            return null;
        }
        ICatchAudioFormat iCatchAudioFormat = null;
        try {
            iCatchAudioFormat = this.iCatchIStreamProvider.getAudioFormat();
        }
        catch (Exception e) {
            AppLog.e(this.TAG, "getAudioFormat exception: " + e.getMessage());
            e.printStackTrace();
        }
        return iCatchAudioFormat;
    }

    public boolean getNextVideoFrame(ICatchFrameBuffer buffer) throws IchVideoStreamClosedException, IchTryAgainException, IchStreamNotRunningException {
        if (this.iCatchIStreamProvider == null) {
            AppLog.e(this.TAG, "iCatchIStreamProvider is null");
            return false;
        }
        boolean ret = false;
        try {
            ret = this.iCatchIStreamProvider.getNextVideoFrame(buffer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean getNextAudioFrame(ICatchFrameBuffer buffer) throws IchVideoStreamClosedException, IchTryAgainException, IchStreamNotRunningException {
        if (this.iCatchIStreamProvider == null) {
            AppLog.e(this.TAG, "iCatchIStreamProvider is null");
            return false;
        }
        boolean ret = false;
        try {
            ret = this.iCatchIStreamProvider.getNextAudioFrame(buffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

