/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.AppInfo;

import android.content.Context;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.AppInfo.CfgProperty;
import com.icatch.panorama.utils.FileOpertion.FileOper;
import com.icatchtek.pancam.customer.ICatchPancamConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class ConfigureInfo {
    private static ConfigureInfo configureInfo;
    private static final String TAG = "ConfigureInfo";
    private final String[] cfgTopic = new String[]{"AppVersion=F1.1.19_beta2", "SupportAutoReconnection=false", "SaveStreamVideo=false", "SaveStreamAudio=false", "broadcast=false", "SupportSetting=false", "SaveAppLog=false", "SaveSDKLog=false", "disconnectRetry=3", "enableSoftwareDecoder=false", "disableAudio=false", "enableLive=false", "enableSdkRender=false", "enableInterExtHeadCheck=true"};

    private ConfigureInfo() {
    }

    public static ConfigureInfo getInstance() {
        if (configureInfo == null) {
            configureInfo = new ConfigureInfo();
        }
        return configureInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCfgInfo(Context context) {
        CfgProperty cfgInfo;
        AppLog.d(TAG, "readCfgInfo..........");
        String directoryPath = context.getExternalFilesDir(null) + "/360CamResoure/";
        AppLog.d(TAG, "readCfgInfo..........directoryPath=" + directoryPath);
        String fileName = "netconfig.properties";
        String info = "";
        for (int ii = 0; ii < this.cfgTopic.length; ++ii) {
            info = info + this.cfgTopic[ii] + "\n";
        }
        File file = new File(directoryPath + fileName);
        if (!file.exists()) {
            FileOper.createFile(directoryPath, fileName);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(directoryPath + fileName);
                out.write(info.getBytes());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            cfgInfo = new CfgProperty(directoryPath + fileName);
            String cfgVersion = null;
            try {
                cfgVersion = cfgInfo.getProperty("AppVersion");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            if (cfgVersion != null) {
                AppLog.d(TAG, "cfgVersion..........=" + cfgVersion);
                if (!cfgVersion.equals("F1.1.19_beta2")) {
                    this.writeCfgInfo(directoryPath + fileName, info);
                }
                AppLog.d(TAG, "cfgVersion=" + cfgVersion + " appVersion=" + "F1.1.19_beta2");
            } else {
                this.writeCfgInfo(directoryPath + fileName, info);
                AppLog.d(TAG, "cfgVersion=" + cfgVersion + " appVersion=" + "F1.1.19_beta2");
            }
        }
        cfgInfo = new CfgProperty(directoryPath + fileName);
        String AutoReconnection = null;
        String saveStreamVideo = null;
        String saveStreamAudio = null;
        String broadcast = null;
        String supportSetting = null;
        String saveAppLog = null;
        String saveSDKLog = null;
        String disconnectRetry = null;
        String enableSoftwareDecoder = null;
        String disableAudio = null;
        String enableLive = null;
        String enableRender = null;
        String enableInterExtHeadCheck = null;
        try {
            AutoReconnection = cfgInfo.getProperty("SupportAutoReconnection");
            saveStreamVideo = cfgInfo.getProperty("SaveStreamVideo");
            saveStreamAudio = cfgInfo.getProperty("SaveStreamAudio");
            broadcast = cfgInfo.getProperty("broadcast");
            supportSetting = cfgInfo.getProperty("SupportSetting");
            saveAppLog = cfgInfo.getProperty("SaveAppLog");
            saveSDKLog = cfgInfo.getProperty("SaveSDKLog");
            disconnectRetry = cfgInfo.getProperty("disconnectRetry");
            enableSoftwareDecoder = cfgInfo.getProperty("enableSoftwareDecoder");
            disableAudio = cfgInfo.getProperty("disableAudio");
            enableLive = cfgInfo.getProperty("enableLive");
            enableRender = cfgInfo.getProperty("enableSdkRender");
            enableInterExtHeadCheck = cfgInfo.getProperty("enableInterExtHeadCheck");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String streamOutputPath = PanoramaSDK.getContext().getExternalFilesDir(null) + "/360CamResoure/Raw/";
        FileOper.createDirectory(streamOutputPath);
        if (enableInterExtHeadCheck != null) {
            if (enableInterExtHeadCheck.equals("true")) {
                ICatchPancamConfig.getInstance().setExtHeadCheck(true);
            } else {
                ICatchPancamConfig.getInstance().setExtHeadCheck(false);
            }
            AppLog.i(TAG, "enableInterExtHeadCheck=" + enableInterExtHeadCheck);
        }
        if (enableRender != null) {
            AppInfo.enableRender = enableRender.equals("true");
            AppLog.i(TAG, "AppInfo.enableRender..........=" + AppInfo.enableRender);
        }
        if (AutoReconnection != null) {
            AppInfo.isSupportAutoReconnection = AutoReconnection.equals("true");
            AppLog.i(TAG, " end isSupportAutoReconnection = " + AppInfo.isSupportAutoReconnection);
        }
        if (saveStreamVideo != null) {
            AppInfo.enableDumpVideo = saveStreamVideo.equals("true");
        }
        if (saveStreamAudio != null && saveStreamAudio.equals("true")) {
            AppLog.d(TAG, "enableDumpMediaStream..........=false");
        }
        if (broadcast != null) {
            AppLog.d(TAG, "broadcast..........=" + broadcast);
            if (broadcast.equals("true")) {
                AppLog.d(TAG, "broadcast..........=" + broadcast);
                AppInfo.isSupportBroadcast = true;
            }
            AppLog.d(TAG, "GlobalInfo.isSupportBroadcast..........=" + AppInfo.isSupportBroadcast);
        }
        if (supportSetting != null) {
            AppLog.i(TAG, "supportSetting..........=" + supportSetting);
            if (supportSetting.equals("true")) {
                AppLog.i(TAG, "supportSetting..........=" + supportSetting);
                AppInfo.isSupportSetting = true;
            }
            AppLog.i(TAG, "GlobalInfo.isSupportSetting..........=" + AppInfo.isSupportSetting);
        }
        AppLog.d(TAG, "disconnectRetry=" + disconnectRetry);
        if (disconnectRetry != null) {
            int retryCount = Integer.parseInt(disconnectRetry);
            AppLog.d(TAG, "retryCount=" + retryCount);
        }
        if (enableSoftwareDecoder != null) {
            if (enableSoftwareDecoder.equals("true")) {
                ICatchPancamConfig.getInstance().setSoftwareDecoder(true);
                AppInfo.enableSoftwareDecoder = true;
            } else {
                ICatchPancamConfig.getInstance().setSoftwareDecoder(false);
                AppInfo.enableSoftwareDecoder = false;
            }
        }
        AppLog.d(TAG, "open enableSoftwareDecoder:" + enableSoftwareDecoder);
        AppLog.i(TAG, "disableAudio=" + disableAudio);
        if (disableAudio != null) {
            AppInfo.disableAudio = disableAudio.equals("true");
            AppLog.i(TAG, "AppInfo.disableAudio..........=" + AppInfo.disableAudio);
        }
        AppLog.i(TAG, "enableLive=" + enableLive);
        if (enableLive != null) {
            AppInfo.enableLive = enableLive.equals("true");
            AppLog.i(TAG, "AppInfo.enableLive..........=" + AppInfo.enableLive);
        }
    }

    private void writeCfgInfo(String path, String cfgInfo) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(path);
            out.write(cfgInfo.getBytes(), 0, cfgInfo.getBytes().length);
            out.close();
        }
        catch (IOException e1) {
            AppLog.i(TAG, "end writeCfgInfo :IOException ");
            e1.printStackTrace();
        }
    }
}

