/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.GlobalApp;

import android.app.Activity;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.MyCamera;
import com.icatch.panorama.SdkApi.FileOperation;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import java.util.LinkedList;
import java.util.List;

public class ExitApp {
    private static final String TAG = "ExitApp";
    private LinkedList<Activity> activityList = new LinkedList();
    private static ExitApp instance;

    public static ExitApp getInstance() {
        if (instance == null) {
            instance = new ExitApp();
        }
        return instance;
    }

    public void addActivity(Activity activity) {
        if (!this.activityList.contains(activity)) {
            this.activityList.addFirst(activity);
            AppLog.d(TAG, "addActivity activity=" + activity.getClass().getSimpleName());
            AppLog.d(TAG, "addActivity activityList size=" + this.activityList.size());
        }
    }

    public void removeActivity(Activity activity) {
        this.activityList.remove(activity);
        AppLog.d(TAG, "removeActivity activity=" + activity.getClass().getSimpleName());
        AppLog.d(TAG, "removeActivity activityList size=" + this.activityList.size());
    }

    public void exit() {
        AppLog.i(TAG, "start exit activity activityList size=" + this.activityList.size());
        if (this.activityList != null && !this.activityList.isEmpty()) {
            for (Activity activity : this.activityList) {
                activity.finish();
            }
            this.activityList.clear();
        }
        AppLog.i(TAG, "end exit System.exit");
    }

    public void finishAllActivity() {
        List<MyCamera> cameraList = GlobalInfo.getInstance().getCameraList();
        if (cameraList != null && !cameraList.isEmpty()) {
            for (MyCamera camera : cameraList) {
                if (!camera.isConnected()) continue;
                FileOperation fileOperation = camera.getFileOperation();
                fileOperation.cancelDownload();
                camera.disconnect();
            }
        }
        AppLog.i(TAG, "start finsh activity");
        if (this.activityList != null && !this.activityList.isEmpty()) {
            for (Activity activity : this.activityList) {
                activity.finish();
            }
            this.activityList.clear();
        }
    }
}

