/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.GlobalApp;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.LruCache;
import com.icatch.panorama.Application.PanoramaSDK;
import com.icatch.panorama.Function.SDKEvent;
import com.icatch.panorama.Listener.ScreenListener;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.MyCamera;
import com.icatch.panorama.R;
import com.icatch.panorama.data.AppInfo.AppInfo;
import com.icatch.panorama.data.GlobalApp.ExitApp;
import com.icatch.panorama.data.entity.LocalPbItemInfo;
import com.icatch.panorama.data.entity.MultiPbItemInfo;
import com.icatch.panorama.ui.appdialog.AppDialog;
import com.icatch.panorama.utils.WifiCheck;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class GlobalInfo {
    private static final String TAG = "GlobalInfo";
    private static GlobalInfo instance;
    private Activity activity;
    private List<MyCamera> cameraList;
    private SDKEvent sdkEvent;
    private List<MultiPbItemInfo> remotePhotoList;
    public List<MultiPbItemInfo> remoteVideoList;
    private List<MultiPbItemInfo> remoteCommonPhotoList;
    private List<MultiPbItemInfo> remotePanoramaPhotoList;
    public LruCache<Integer, Bitmap> mLruCache;
    private List<LocalPbItemInfo> localPhotoList;
    private List<LocalPbItemInfo> localVideoList;
    private List<LocalPbItemInfo> localCommonPhotoList;
    private List<LocalPbItemInfo> localPanoramaPhotoList;
    private String ssid;
    private WifiCheck wifiCheck;
    private HashMap<Integer, Integer> panoramaPhotoPositionMap;
    private HashMap<Integer, Integer> commonPhotoPositionMap;
    ScreenListener listener;
    private HashMap<Integer, Integer> videoPositionMap;
    private Handler globalHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 8: {
                    AppLog.i(GlobalInfo.TAG, "receive EVENT_CONNECTION_FAILURE");
                    GlobalInfo.this.wifiCheck = new WifiCheck(GlobalInfo.this.activity);
                    if (!AppInfo.isNeedReconnect) {
                        return;
                    }
                    if (AppInfo.isSupportAutoReconnection) {
                        GlobalInfo.this.wifiCheck.showAutoReconnectDialog();
                        break;
                    }
                    GlobalInfo.this.wifiCheck.showConectFailureWarningDlg((Context)GlobalInfo.this.activity);
                    break;
                }
                case 16: {
                    AppLog.i(GlobalInfo.TAG, "receive EVENT_SDCARD_REMOVED");
                    AppDialog.showDialogWarn((Context)GlobalInfo.this.activity, R.string.dialog_card_removed);
                }
            }
        }
    };

    public static GlobalInfo getInstance() {
        if (instance == null) {
            instance = new GlobalInfo();
        }
        return instance;
    }

    public Context getAppContext() {
        return this.activity == null ? PanoramaSDK.getContext() : this.activity;
    }

    public void setCurrentApp(Activity activity) {
        this.activity = activity;
    }

    public Activity getCurrentApp() {
        return this.activity;
    }

    public List<MyCamera> getCameraList() {
        return this.cameraList;
    }

    public List<LocalPbItemInfo> getLocalPhotoList() {
        return this.localPhotoList;
    }

    public void setLocalPhotoList(List<LocalPbItemInfo> localPhotoList) {
        this.localPhotoList = localPhotoList;
    }

    public List<LocalPbItemInfo> getLocalVideoList() {
        return this.localVideoList;
    }

    public void setLocalVideoList(List<LocalPbItemInfo> localVideoList) {
        this.localVideoList = localVideoList;
    }

    public List<MultiPbItemInfo> getRemotePhotoList() {
        return this.remotePhotoList;
    }

    public void setRemotePhotoList(List<MultiPbItemInfo> remotePhotoList) {
        this.remotePhotoList = remotePhotoList;
    }

    public void initLocalPhotoListInfo() {
        if (this.localPhotoList == null || this.localPhotoList.isEmpty()) {
            return;
        }
        this.localCommonPhotoList = new LinkedList<LocalPbItemInfo>();
        this.localPanoramaPhotoList = new LinkedList<LocalPbItemInfo>();
        this.panoramaPhotoPositionMap = new HashMap();
        this.commonPhotoPositionMap = new HashMap();
        int jj = 0;
        int kk = 0;
        for (int ii = 0; ii < this.localPhotoList.size(); ++ii) {
            if (this.localPhotoList.get(ii).isPanorama()) {
                this.localPanoramaPhotoList.add(this.localPhotoList.get(ii));
                this.panoramaPhotoPositionMap.put(ii, jj++);
                continue;
            }
            this.localCommonPhotoList.add(this.localPhotoList.get(ii));
            this.commonPhotoPositionMap.put(ii, kk++);
        }
    }

    public HashMap<Integer, Integer> getPanoramaPhotoPositionMap() {
        return this.panoramaPhotoPositionMap;
    }

    public HashMap<Integer, Integer> getCommonPhotoPositionMap() {
        return this.commonPhotoPositionMap;
    }

    public void initRemotePhotoListInfo() {
        if (this.remotePhotoList == null || this.remotePhotoList.isEmpty()) {
            return;
        }
        this.remoteCommonPhotoList = new LinkedList<MultiPbItemInfo>();
        this.remotePanoramaPhotoList = new LinkedList<MultiPbItemInfo>();
        this.panoramaPhotoPositionMap = new HashMap();
        this.commonPhotoPositionMap = new HashMap();
        int jj = 0;
        int kk = 0;
        for (int ii = 0; ii < this.remotePhotoList.size(); ++ii) {
            if (this.remotePhotoList.get(ii).isPanorama()) {
                this.remotePanoramaPhotoList.add(this.remotePhotoList.get(ii));
                this.panoramaPhotoPositionMap.put(ii, jj++);
                continue;
            }
            this.remoteCommonPhotoList.add(this.remotePhotoList.get(ii));
            this.commonPhotoPositionMap.put(ii, kk++);
        }
    }

    public List<MultiPbItemInfo> getRemoteCommonPhotoList() {
        return this.remoteCommonPhotoList;
    }

    public List<MultiPbItemInfo> getRemotePanoramaPhotoList() {
        return this.remotePanoramaPhotoList;
    }

    public void startScreenListener() {
        this.listener = new ScreenListener(this.getAppContext());
        this.listener.begin(new ScreenListener.ScreenStateListener(){

            @Override
            public void onUserPresent() {
                AppLog.i(GlobalInfo.TAG, "onUserPresent");
            }

            @Override
            public void onScreenOn() {
                AppLog.i(GlobalInfo.TAG, "onScreenOn");
            }

            @Override
            public void onScreenOff() {
                AppLog.i(GlobalInfo.TAG, "onScreenOff,need to close app!");
                ExitApp.getInstance().finishAllActivity();
            }
        });
    }

    public void endSceenListener() {
        if (this.listener != null) {
            this.listener.unregisterListener();
        }
    }

    public void enableConnectCheck(boolean enable) {
        if (this.sdkEvent == null) {
            this.sdkEvent = new SDKEvent(this.globalHandler);
        }
        this.sdkEvent.addEventListener(74);
    }

    public void addEventListener(int eventId) {
        if (this.sdkEvent == null) {
            this.sdkEvent = new SDKEvent(this.globalHandler);
        }
        this.sdkEvent.addEventListener(eventId);
    }

    public void delEventListener(int eventId) {
        if (this.sdkEvent != null) {
            this.sdkEvent.delEventListener(eventId);
        }
    }
}

