/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.SystemInfo;

import android.content.Context;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.util.Log;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class HotSpot {
    public static final int WIFI_AP_STATE_DISABLING = 10;
    public static final int WIFI_AP_STATE_DISABLED = 11;
    public static final int WIFI_AP_STATE_ENABLING = 12;
    public static final int WIFI_AP_STATE_ENABLED = 13;
    public static final int WIFI_AP_STATE_FAILED = 14;
    private static final String TAG = HotSpot.class.getSimpleName();

    public static int getWifiApState(Context mContext) {
        WifiManager wifiManager = (WifiManager)mContext.getSystemService("wifi");
        try {
            Method method = wifiManager.getClass().getMethod("getWifiApState", new Class[0]);
            int i = (Integer)method.invoke((Object)wifiManager, new Object[0]);
            Log.i((String)TAG, (String)("wifi state:  " + i));
            return i;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Cannot get WiFi AP state" + e));
            return 14;
        }
    }

    public static boolean isApEnabled(Context mContext) {
        int state = HotSpot.getWifiApState(mContext);
        return 13 == state;
    }

    private static ArrayList<String> getConnectedHotIP() {
        ArrayList<String> connectedIP = new ArrayList<String>();
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader("/proc/net/arp"));
            while ((line = br.readLine()) != null) {
                String[] splitted = line.split(" +");
                if (splitted == null || splitted.length < 4) continue;
                String ip = splitted[0];
                connectedIP.add(ip);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return connectedIP;
    }

    public static String getFirstConnectedHotIP() {
        ArrayList<String> connectedIP = HotSpot.getConnectedHotIP();
        if (connectedIP == null || connectedIP.isEmpty()) {
            return null;
        }
        return connectedIP.get(1);
    }

    public static void printHotIp() {
        ArrayList<String> connectedIP = HotSpot.getConnectedHotIP();
        StringBuilder resultList = new StringBuilder();
        for (String ip : connectedIP) {
            resultList.append(ip);
            resultList.append("\n");
        }
        System.out.print(resultList);
        Log.d((String)TAG, (String)("---->>heww resultList=" + resultList));
    }

    public static String getWifiApSharedKey(Context context) {
        WifiManager mWifiManager = (WifiManager)context.getSystemService("wifi");
        Method method = null;
        String SharedKey = null;
        try {
            method = mWifiManager.getClass().getMethod("getWifiApConfiguration", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            WifiConfiguration apConfig = (WifiConfiguration)method.invoke((Object)mWifiManager, new Object[0]);
            SharedKey = apConfig.preSharedKey;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.d((String)TAG, (String)("SharedKey=" + SharedKey));
        return SharedKey;
    }

    public static String getWifiApSSID(Context context) {
        WifiManager mWifiManager = (WifiManager)context.getSystemService("wifi");
        Method method = null;
        String SSID = null;
        try {
            method = mWifiManager.getClass().getMethod("getWifiApConfiguration", new Class[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            WifiConfiguration apConfig = (WifiConfiguration)method.invoke((Object)mWifiManager, new Object[0]);
            SSID = apConfig.SSID;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Log.i((String)TAG, (String)("getWifiApSSID -> " + SSID));
        return SSID;
    }

    public static boolean setWifiApEnabled(Context context, boolean enabled) {
        WifiManager mWifiManager = (WifiManager)context.getSystemService("wifi");
        Method method = null;
        Method configMethod = null;
        boolean result = false;
        if (mWifiManager == null) {
            Log.i((String)TAG, (String)("mWifiManager is null  -> " + result));
            return result;
        }
        try {
            configMethod = mWifiManager.getClass().getMethod("getWifiApConfiguration", new Class[0]);
            method = mWifiManager.getClass().getMethod("setWifiApEnabled", WifiConfiguration.class, Boolean.TYPE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            WifiConfiguration apConfig = (WifiConfiguration)configMethod.invoke((Object)mWifiManager, new Object[0]);
            result = (Boolean)method.invoke((Object)mWifiManager, apConfig, enabled);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        Log.i((String)TAG, (String)("setWifiApEnabled -> " + result));
        return result;
    }
}

