/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.SystemInfo;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import com.icatch.panorama.Log.AppLog;
import java.util.List;

public class MWifiManager {
    private static String TAG = "MWifiManager";

    public static String getSsid(Context context) {
        WifiManager mWifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        WifiInfo wifiInfo = mWifiManager.getConnectionInfo();
        String ssid = wifiInfo.getSSID();
        if (TextUtils.isEmpty((CharSequence)ssid) || ssid.contains("0x") || ssid.contains("<unknown ssid>")) {
            ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
            NetworkInfo wifiInfo2 = mConnectivityManager.getNetworkInfo(1);
            if (wifiInfo2 != null && wifiInfo2.getExtraInfo() != null) {
                String wifiName = wifiInfo2.getExtraInfo();
                AppLog.i(TAG, "getSsid wifiName:" + wifiName);
                return wifiName.replaceAll("\"", "");
            }
            int networkId = wifiInfo.getNetworkId();
            List configuredNetworks = mWifiManager.getConfiguredNetworks();
            if (configuredNetworks == null) {
                return "";
            }
            for (WifiConfiguration wifiConfiguration : configuredNetworks) {
                if (wifiConfiguration.networkId != networkId || TextUtils.isEmpty((CharSequence)(ssid = wifiConfiguration.SSID))) continue;
                return ssid.replaceAll("\"", "");
            }
            return "";
        }
        AppLog.i(TAG, "getSsid getSSID:" + ssid);
        return ssid.replaceAll("\"", "");
    }
}

