/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.SystemInfo;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.text.format.Formatter;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.icatch.panorama.Log.AppLog;
import java.io.File;

public class SystemInfo {
    private static final String TAG = "SystemInfo";
    private static SystemInfo instance;

    public static SystemInfo getInstance() {
        if (instance == null) {
            instance = new SystemInfo();
        }
        return instance;
    }

    public static DisplayMetrics getMetrics(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        return metrics;
    }

    public String getLocalMacAddress(Activity activity) {
        WifiManager wifi = (WifiManager)activity.getSystemService("wifi");
        WifiInfo info = wifi.getConnectionInfo();
        AppLog.i(TAG, "current Mac=" + info.getMacAddress().toLowerCase());
        return info.getMacAddress().toLowerCase();
    }

    public static long getSDFreeSize() {
        long availableBlocks;
        long blockSize;
        File path = Environment.getExternalStorageDirectory();
        StatFs stat = new StatFs(path.getPath());
        if (Build.VERSION.SDK_INT >= 18) {
            blockSize = stat.getBlockSizeLong();
            long totalBlocks = stat.getBlockCountLong();
            availableBlocks = stat.getAvailableBlocksLong();
        } else {
            blockSize = stat.getBlockSize();
            long totalBlocks = stat.getBlockCount();
            availableBlocks = stat.getAvailableBlocks();
        }
        AppLog.i(TAG, "getSDFreeSize=" + blockSize * availableBlocks);
        return blockSize * availableBlocks;
    }

    private String formatSize(Context context, long size) {
        return Formatter.formatFileSize((Context)context, (long)size);
    }

    public static long getFreeMemory(Context mContext) {
        ActivityManager am = (ActivityManager)mContext.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        long freeMemorySize = mi.availMem / 1024L;
        AppLog.i(TAG, "current FreeMemory=" + freeMemorySize);
        return freeMemorySize;
    }

    public static int getWindowVisibleCountMax(Context context, int row) {
        int visibleCountMax = 0;
        int height = SystemInfo.getMetrics((Context)context).heightPixels;
        int width = SystemInfo.getMetrics((Context)context).widthPixels;
        int itemWidth = width / row;
        visibleCountMax = height / itemWidth * row + row;
        AppLog.i(TAG, "end getWindowVisibleCountMax visibleCountMax=" + visibleCountMax);
        return visibleCountMax;
    }

    public static void hideInputMethod(Activity activity) {
        View view;
        InputMethodManager inputMethodManager = (InputMethodManager)activity.getSystemService("input_method");
        if (inputMethodManager.isActive() && (view = activity.getCurrentFocus()) != null) {
            inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 2);
        }
    }
}

