/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.entity;

import com.icatch.panorama.utils.ConvertTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LocalPbItemInfo {
    public File file;
    public int section;
    public boolean isItemChecked = false;
    private boolean isPanorama = false;

    public LocalPbItemInfo(File file, int section) {
        this.file = file;
        this.section = section;
        this.isItemChecked = false;
    }

    public LocalPbItemInfo(File file, int section, boolean isPanorama) {
        this.file = file;
        this.section = section;
        this.isPanorama = isPanorama;
    }

    public LocalPbItemInfo(File file) {
        this.file = file;
        this.isItemChecked = false;
    }

    public void setSection(int section) {
        this.section = section;
    }

    public String getFilePath() {
        return this.file.getPath();
    }

    public String getFileDate() {
        long time = this.file.lastModified();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(new Date(time));
    }

    public String getFileSize() {
        int size = (int)this.file.length();
        return ConvertTools.ByteConversionGBMBKB(size);
    }

    public String getFileName() {
        return this.file.getName();
    }

    public String getFileDateMMSS() {
        long time = this.file.lastModified();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date(time));
    }

    public boolean isPanorama() {
        return this.isPanorama;
    }

    public void setPanorama(boolean panorama) {
        this.isPanorama = panorama;
    }

    public void getCreateTime() {
        String filePath = this.file.getPath();
        String strTime = null;
        try {
            String line;
            Process p = Runtime.getRuntime().exec("cmd /C dir " + filePath + "/tc");
            InputStream is = p.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                if (!line.endsWith(".txt")) continue;
                strTime = line.substring(0, 17);
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("\u521b\u5efa\u65f6\u95f4    " + strTime);
    }

    public String toString() {
        return this.file.getPath();
    }
}

