/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.entity;

import com.icatch.panorama.utils.ConvertTools;
import com.icatchtek.reliant.customer.type.ICatchFile;

public class MultiPbItemInfo {
    private static final String TAG = MultiPbItemInfo.class.getSimpleName();
    public ICatchFile iCatchFile;
    public int section;
    public boolean isItemChecked = false;
    private boolean isPanorama = false;
    private String fileDate;

    public MultiPbItemInfo(ICatchFile file) {
        this.iCatchFile = file;
        this.isItemChecked = false;
    }

    public MultiPbItemInfo(ICatchFile file, int section) {
        this.iCatchFile = file;
        this.section = section;
        this.isItemChecked = false;
    }

    public MultiPbItemInfo(ICatchFile iCatchFile, int section, boolean isPanorama) {
        this.iCatchFile = iCatchFile;
        this.section = section;
        this.isPanorama = isPanorama;
    }

    public void setPanorama(boolean panorama) {
        this.isPanorama = panorama;
    }

    public boolean isPanorama() {
        return this.isPanorama;
    }

    public void setSection(int section) {
        this.section = section;
    }

    public String getFilePath() {
        return this.iCatchFile.getFilePath();
    }

    public int getFileHandle() {
        return this.iCatchFile.getFileHandle();
    }

    public String getFileDate() {
        String time = this.iCatchFile.getFileDate();
        if (time == null || time.isEmpty()) {
            time = "unknown";
        } else if (time.contains("T")) {
            int position = time.indexOf("T");
            time = time.substring(0, position);
        }
        return time;
    }

    public String getFileSize() {
        int size = (int)this.iCatchFile.getFileSize();
        return ConvertTools.ByteConversionGBMBKB(size);
    }

    public long getFileSizeInteger() {
        long fileSize = this.iCatchFile.getFileSize();
        return fileSize;
    }

    public String getFileName() {
        return this.iCatchFile.getFileName();
    }

    public String getFileDateMMSS() {
        return this.dateFormatTransform(this.iCatchFile.getFileDate());
    }

    public String dateFormatTransform(String value) {
        if (value == null) {
            return "";
        }
        String date = "";
        String time = "";
        String yy = "";
        String MM = "";
        String dd = "";
        String hh = "";
        String mm = "";
        String ss = "";
        int position = value.indexOf("T");
        date = value.substring(0, position);
        time = value.substring(position + 1);
        yy = date.substring(0, 4);
        MM = date.substring(4, 6);
        dd = date.substring(6, 8);
        hh = time.substring(0, 2);
        mm = time.substring(2, 4);
        ss = time.substring(4, 6);
        date = yy + "-" + MM + "-" + dd + " " + hh + ":" + mm + ":" + ss;
        return date;
    }
}

