/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.entity;

import android.content.Context;
import android.content.res.Resources;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.MyCamera.CameraManager;
import com.icatch.panorama.SdkApi.CameraProperties;
import com.icatch.panorama.data.CustomException.NullPointerException;
import com.icatch.panorama.data.Hash.PropertyHashMapDynamic;
import com.icatch.panorama.data.entity.ItemInfo;
import com.icatch.panorama.data.type.SlowMotion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PropertyTypeInteger {
    private static final String TAG = "PropertyTypeInteger";
    private HashMap<Integer, ItemInfo> hashMap;
    private int propertyId;
    private String[] valueListString;
    private List<Integer> valueListInt;
    private Context context;
    private Resources res;
    private CameraProperties cameraProperties;

    public PropertyTypeInteger(CameraProperties cameraProperties, HashMap<Integer, ItemInfo> hashMap, int propertyId, Context context) {
        this.hashMap = hashMap;
        this.propertyId = propertyId;
        this.context = context;
        this.cameraProperties = cameraProperties;
        this.initItem();
    }

    public PropertyTypeInteger(CameraProperties cameraProperties, int propertyId, Context context) {
        this.propertyId = propertyId;
        this.context = context;
        this.cameraProperties = cameraProperties;
        this.initItem();
    }

    public void initItem() {
        if (this.hashMap == null) {
            this.hashMap = PropertyHashMapDynamic.getInstance().getDynamicHashInt(this.cameraProperties, this.propertyId);
        }
        this.res = this.context.getResources();
        switch (this.propertyId) {
            case 20485: {
                this.valueListInt = this.cameraProperties.getSupportedWhiteBalances();
                break;
            }
            case 20498: {
                this.valueListInt = this.cameraProperties.getSupportedCaptureDelays();
                break;
            }
            case 20504: {
                this.valueListInt = this.cameraProperties.getsupportedBurstNums();
                break;
            }
            case 54790: {
                this.valueListInt = this.cameraProperties.getSupportedLightFrequencys();
                break;
            }
            case 54791: {
                this.valueListInt = this.cameraProperties.getsupportedDateStamps();
                break;
            }
            case 54804: {
                this.valueListInt = new ArrayList<Integer>();
                this.valueListInt.add(0);
                this.valueListInt.add(1);
                break;
            }
            case 54805: {
                this.valueListInt = new ArrayList<Integer>();
                this.valueListInt.add(SlowMotion.SLOW_MOTION_OFF);
                this.valueListInt.add(SlowMotion.SLOW_MOTION_ON);
                break;
            }
            case 60928: {
                this.valueListInt = new ArrayList<Integer>();
                this.valueListInt.add(0);
                this.valueListInt.add(1);
                break;
            }
            default: {
                this.valueListInt = this.cameraProperties.getSupportedPropertyValues(this.propertyId);
            }
        }
        this.valueListString = new String[this.valueListInt.size()];
        if (this.valueListInt != null) {
            for (int ii = 0; ii < this.valueListInt.size(); ++ii) {
                if (this.hashMap.get(this.valueListInt.get(ii)) == null) continue;
                String uiStringInSettingString = this.hashMap.get((Object)this.valueListInt.get((int)ii)).uiStringInSettingString;
                this.valueListString[ii] = uiStringInSettingString != null ? uiStringInSettingString : this.res.getString(this.hashMap.get((Object)this.valueListInt.get((int)ii)).uiStringInSetting);
            }
        }
    }

    public int getCurrentValue() {
        int retValue;
        switch (this.propertyId) {
            case 20485: {
                retValue = this.cameraProperties.getCurrentWhiteBalance();
                break;
            }
            case 20498: {
                retValue = this.cameraProperties.getCurrentCaptureDelay();
                break;
            }
            case 20504: {
                retValue = this.cameraProperties.getCurrentBurstNum();
                break;
            }
            case 54790: {
                retValue = this.cameraProperties.getCurrentLightFrequency();
                break;
            }
            case 54791: {
                retValue = this.cameraProperties.getCurrentDateStamp();
                break;
            }
            case 54804: {
                retValue = this.cameraProperties.getCurrentUpsideDown();
                break;
            }
            case 54805: {
                retValue = this.cameraProperties.getCurrentSlowMotion();
                break;
            }
            case 60928: {
                retValue = CameraManager.getInstance().getCurCamera().timeLapsePreviewMode;
                break;
            }
            default: {
                retValue = this.cameraProperties.getCurrentPropertyValue(this.propertyId);
            }
        }
        return retValue;
    }

    public String getCurrentUiStringInSetting() {
        if (this.hashMap == null) {
            return "Unknown";
        }
        ItemInfo itemInfo = this.hashMap.get(this.getCurrentValue());
        String ret = null;
        ret = itemInfo == null ? "Unknown" : this.res.getString(this.hashMap.get((Object)Integer.valueOf((int)this.getCurrentValue())).uiStringInSetting);
        return ret;
    }

    public String getCurrentUiStringInPreview() {
        if (this.hashMap == null) {
            return "Unknown";
        }
        ItemInfo itemInfo = this.hashMap.get(this.getCurrentValue());
        String ret = null;
        ret = itemInfo == null ? "Unknown" : itemInfo.uiStringInPreview;
        return ret;
    }

    public String getCurrentUiStringInSetting(int position) {
        return this.valueListString[position];
    }

    public int getCurrentIcon() throws NullPointerException {
        ItemInfo itemInfo = this.hashMap.get(this.getCurrentValue());
        AppLog.d(TAG, "itemInfo=" + itemInfo);
        if (itemInfo == null) {
            throw new NullPointerException(TAG, "getCurrentIcon itemInfo is null", "");
        }
        return itemInfo.iconID;
    }

    public String[] getValueList() {
        return this.valueListString;
    }

    public Boolean setValue(int value) {
        boolean retValue;
        switch (this.propertyId) {
            case 20485: {
                retValue = this.cameraProperties.setWhiteBalance(value);
                break;
            }
            case 20498: {
                retValue = this.cameraProperties.setCaptureDelay(value);
                break;
            }
            case 20504: {
                retValue = this.cameraProperties.setCurrentBurst(value);
                break;
            }
            case 54790: {
                retValue = this.cameraProperties.setLightFrequency(value);
                break;
            }
            case 54791: {
                retValue = this.cameraProperties.setDateStamp(value);
                break;
            }
            default: {
                retValue = this.cameraProperties.setPropertyValue(this.propertyId, value);
            }
        }
        return retValue;
    }

    public Boolean setValueByPosition(int position) {
        boolean retValue = false;
        switch (this.propertyId) {
            case 20485: {
                retValue = this.cameraProperties.setWhiteBalance(this.valueListInt.get(position));
                break;
            }
            case 20498: {
                retValue = this.cameraProperties.setCaptureDelay(this.valueListInt.get(position));
                break;
            }
            case 20504: {
                retValue = this.cameraProperties.setCurrentBurst(this.valueListInt.get(position));
                break;
            }
            case 54790: {
                retValue = this.cameraProperties.setLightFrequency(this.valueListInt.get(position));
                break;
            }
            case 54791: {
                retValue = this.cameraProperties.setDateStamp(this.valueListInt.get(position));
                break;
            }
            case 54804: {
                retValue = this.cameraProperties.setUpsideDown(this.valueListInt.get(position));
                break;
            }
            case 54805: {
                retValue = this.cameraProperties.setSlowMotion(this.valueListInt.get(position));
                break;
            }
            default: {
                retValue = this.cameraProperties.setPropertyValue(this.propertyId, this.valueListInt.get(position));
            }
        }
        return retValue;
    }

    public Boolean needDisplayByMode(int previewMode) {
        boolean retValue = false;
        switch (this.propertyId) {
            case 20485: {
                if (this.cameraProperties.hasFuction(20485)) {
                    retValue = true;
                    break;
                }
                retValue = true;
                break;
            }
            case 20498: {
                if (!this.cameraProperties.hasFuction(20483) || !this.cameraProperties.hasFuction(20498) || previewMode != 1) break;
                retValue = true;
                break;
            }
            case 20504: {
                if (!this.cameraProperties.hasFuction(20504) || previewMode != 1) break;
                retValue = true;
                break;
            }
            case 54790: {
                retValue = true;
                break;
            }
            case 54791: {
                if (!this.cameraProperties.hasFuction(54791) || previewMode != 1 && previewMode != 3) break;
                retValue = true;
                break;
            }
            case 54804: {
                if (!this.cameraProperties.hasFuction(54804)) break;
                return true;
            }
            case 54805: {
                if (!this.cameraProperties.hasFuction(54805) || previewMode != 3 && previewMode != 4) break;
                retValue = true;
                break;
            }
            case 60928: {
                boolean supportTimelapseMode = this.cameraProperties.hasFuction(60928);
                AppLog.i(TAG, "TIMELAPSE_MODE isSupportTimelapseMode=" + supportTimelapseMode);
                if (!supportTimelapseMode || previewMode != 8 && previewMode != 6 && previewMode != 7 && previewMode != 5) break;
                retValue = true;
                break;
            }
        }
        return retValue;
    }
}

