/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.entity;

import android.content.Context;
import com.icatch.panorama.SdkApi.CameraProperties;
import com.icatch.panorama.data.Hash.PropertyHashMapDynamic;
import com.icatch.panorama.data.entity.ItemInfo;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class PropertyTypeString {
    private int propertyId;
    private List<String> valueListString;
    private List<String> valueListStringUI;
    private HashMap<String, ItemInfo> hashMap;
    private String[] valueArrayString;
    private CameraProperties cameraProperties;

    public PropertyTypeString(CameraProperties cameraProperties, int propertyId, Context context) {
        this.propertyId = propertyId;
        this.cameraProperties = cameraProperties;
        this.initItem();
    }

    public void initItem() {
        int ii;
        if (this.hashMap == null) {
            this.hashMap = PropertyHashMapDynamic.getInstance().getDynamicHashString(this.cameraProperties, this.propertyId);
        }
        if (this.hashMap == null) {
            return;
        }
        if (this.propertyId == 20483) {
            this.valueListString = this.cameraProperties.getSupportedImageSizes();
        }
        if (this.propertyId == 54789) {
            this.valueListString = this.cameraProperties.getSupportedVideoSizes();
        }
        for (ii = 0; ii < this.valueListString.size(); ++ii) {
            if (this.hashMap.containsKey(this.valueListString.get(ii))) continue;
            this.valueListString.remove(ii);
            --ii;
        }
        this.valueListStringUI = new LinkedList<String>();
        this.valueArrayString = new String[this.valueListString.size()];
        if (this.valueListString != null) {
            for (ii = 0; ii < this.valueListString.size(); ++ii) {
                this.valueListStringUI.add(ii, this.hashMap.get((Object)this.valueListString.get((int)ii)).uiStringInSettingString);
                this.valueArrayString[ii] = this.hashMap.get((Object)this.valueListString.get((int)ii)).uiStringInSettingString;
            }
        }
    }

    public String getCurrentValue() {
        return this.cameraProperties.getCurrentStringPropertyValue(this.propertyId);
    }

    public String getCurrentUiStringInSetting() {
        if (this.hashMap == null) {
            return "Unknown";
        }
        ItemInfo itemInfo = this.hashMap.get(this.getCurrentValue());
        String ret = null;
        ret = itemInfo == null ? "Unknown" : itemInfo.uiStringInSettingString;
        return ret;
    }

    public String getCurrentUiStringInPreview() {
        if (this.hashMap == null) {
            return "Unknown";
        }
        ItemInfo itemInfo = this.hashMap.get(this.getCurrentValue());
        String ret = null;
        ret = itemInfo == null ? "Unknown" : itemInfo.uiStringInPreview;
        return ret;
    }

    public String getCurrentUiStringInSetting(int position) {
        return this.valueListString.get(position);
    }

    public List<String> getValueList() {
        return this.valueListString;
    }

    public List<String> getValueListUI() {
        return this.valueListString;
    }

    public Boolean setValue(String value) {
        return this.cameraProperties.setStringPropertyValue(this.propertyId, value);
    }

    public boolean setValueByPosition(int position) {
        return this.cameraProperties.setStringPropertyValue(this.propertyId, this.valueListString.get(position));
    }

    public String[] getValueArrayString() {
        return this.valueArrayString;
    }

    public Boolean needDisplayByMode(int previewMode) {
        boolean retValue = false;
        switch (this.propertyId) {
            case 20483: {
                if (!this.cameraProperties.hasFuction(20483) || previewMode != 1 && previewMode != 2 && previewMode != 2 && previewMode != 8 && previewMode != 6) break;
                retValue = true;
                break;
            }
            case 54789: {
                if (!this.cameraProperties.hasFuction(54789) || previewMode != 3 && previewMode != 4 && previewMode != 4 && previewMode != 7 && previewMode != 5) break;
                retValue = true;
                break;
            }
        }
        return retValue;
    }
}

