/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.type;

import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.R;
import com.icatch.panorama.SdkApi.CameraProperties;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import java.util.ArrayList;
import java.util.List;

public class TimeLapseDuration {
    private final String tag = "TimeLapseDuration";
    public static final int TIME_LAPSE_DURATION_2MIN = 2;
    public static final int TIME_LAPSE_DURATION_5MIN = 5;
    public static final int TIME_LAPSE_DURATION_10MIN = 10;
    public static final int TIME_LAPSE_DURATION_15MIN = 15;
    public static final int TIME_LAPSE_DURATION_20MIN = 20;
    public static final int TIME_LAPSE_DURATION_30MIN = 30;
    public static final int TIME_LAPSE_DURATION_60MIN = 60;
    public static final int TIME_LAPSE_DURATION_UNLIMITED = 65535;
    private String[] valueListString;
    private int[] valueListInt;
    private CameraProperties cameraProperties;

    public TimeLapseDuration(CameraProperties cameraProperties) {
        this.cameraProperties = cameraProperties;
        this.initTimeLapseDuration();
    }

    public String getCurrentValue() {
        return TimeLapseDuration.convertTimeLapseDuration(this.cameraProperties.getCurrentTimeLapseDuration());
    }

    public String[] getValueStringList() {
        return this.valueListString;
    }

    public int[] getValueStringInt() {
        return this.valueListInt;
    }

    public boolean setValueByPosition(int position) {
        boolean retValue = this.cameraProperties.setTimeLapseDuration(this.valueListInt[position]);
        return retValue;
    }

    public void initTimeLapseDuration() {
        int ii;
        AppLog.i("TimeLapseDuration", "begin initTimeLapseDuration");
        if (!this.cameraProperties.cameraModeSupport(43)) {
            return;
        }
        List<Integer> list = this.cameraProperties.getSupportedTimeLapseDurations();
        int length = list.size();
        ArrayList<String> tempArrayList = new ArrayList<String>();
        this.valueListInt = new int[length];
        for (ii = 0; ii < length; ++ii) {
            tempArrayList.add(TimeLapseDuration.convertTimeLapseDuration(list.get(ii)));
            this.valueListInt[ii] = list.get(ii);
        }
        this.valueListString = new String[tempArrayList.size()];
        for (ii = 0; ii < tempArrayList.size(); ++ii) {
            this.valueListString[ii] = (String)tempArrayList.get(ii);
        }
        AppLog.i("TimeLapseDuration", "end initTimeLapseDuration timeLapseDuration =" + this.valueListString.length);
    }

    public Boolean needDisplayByMode(int previewMode) {
        if (this.cameraProperties.cameraModeSupport(43) && (previewMode == 8 || previewMode == 6 || previewMode == 7 || previewMode == 5)) {
            return true;
        }
        return false;
    }

    public static String convertTimeLapseDuration(int value) {
        if (value == 65535) {
            return GlobalInfo.getInstance().getAppContext().getResources().getString(R.string.setting_time_lapse_duration_unlimit);
        }
        String time = "";
        int h = value / 60;
        int m = value % 60;
        if (h > 0) {
            time = time + h + "HR";
        }
        if (m > 0) {
            time = time + m + "Min";
        }
        return time;
    }
}

