/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.data.type;

import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.SdkApi.CameraProperties;
import java.util.ArrayList;
import java.util.List;

public class TimeLapseInterval {
    private final String tag = "TimeLapseInterval";
    public static final int TIME_LAPSE_INTERVAL_OFF = 0;
    private String[] valueListString;
    private int[] valueListInt;
    private CameraProperties cameraProperties;

    public TimeLapseInterval(CameraProperties cameraProperties) {
        this.cameraProperties = cameraProperties;
        this.initTimeLapseInterval();
    }

    public String getCurrentValue() {
        return TimeLapseInterval.convertTimeLapseInterval(this.cameraProperties.getCurrentTimeLapseInterval());
    }

    public String[] getValueStringList() {
        return this.valueListString;
    }

    public int[] getValueStringInt() {
        return this.valueListInt;
    }

    public boolean setValueByPosition(int position) {
        boolean retValue = this.cameraProperties.setTimeLapseInterval(this.valueListInt[position]);
        return retValue;
    }

    public void initTimeLapseInterval() {
        int ii;
        AppLog.i("TimeLapseInterval", "begin initTimeLapseInterval");
        if (!this.cameraProperties.cameraModeSupport(43)) {
            return;
        }
        List<Integer> list = this.cameraProperties.getSupportedTimeLapseIntervals();
        int length = list.size();
        ArrayList<String> tempArrayList = new ArrayList<String>();
        this.valueListInt = new int[length];
        for (ii = 0; ii < length; ++ii) {
            tempArrayList.add(TimeLapseInterval.convertTimeLapseInterval(list.get(ii)));
            this.valueListInt[ii] = list.get(ii);
        }
        this.valueListString = new String[tempArrayList.size()];
        for (ii = 0; ii < tempArrayList.size(); ++ii) {
            this.valueListString[ii] = (String)tempArrayList.get(ii);
        }
        AppLog.i("TimeLapseInterval", "end initTimeLapseInterval timeLapseInterval =" + this.valueListString.length);
    }

    public Boolean needDisplayByMode(int previewMode) {
        if (this.cameraProperties.cameraModeSupport(43) && (previewMode == 8 || previewMode == 6 || previewMode == 7 || previewMode == 5)) {
            return true;
        }
        return false;
    }

    public static String convertTimeLapseInterval(int value) {
        if (value == 0) {
            return "OFF";
        }
        String time = "";
        if (value == -2) {
            return "0.5 Sec";
        }
        int h = value / 3600;
        int m = value % 3600 / 60;
        int s = value % 60;
        if (h > 0) {
            time = time + h + " HR ";
        }
        if (m > 0) {
            time = time + m + " Min ";
        }
        if (s > 0) {
            time = time + s + " Sec";
        }
        return time;
    }
}

