/*
 * Decompiled with CFR 0.152.
 */
package com.icatch.panorama.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.icatch.panorama.Log.AppLog;
import com.icatch.panorama.data.GlobalApp.GlobalInfo;
import com.icatch.panorama.data.SystemInfo.MWifiManager;
import com.icatch.panorama.data.entity.CameraSlot;
import com.icatch.panorama.db.CameraSlotSQLiteHelper;
import java.util.ArrayList;

public class CameraSlotSQLite {
    private SQLiteDatabase db;
    private String TAG = "CameraSlotSQLite";
    private static CameraSlotSQLite instance;
    private ArrayList<CameraSlot> camSlotList;
    private Context context;

    public static CameraSlotSQLite getInstance() {
        if (instance == null) {
            instance = new CameraSlotSQLite();
        }
        return instance;
    }

    private CameraSlotSQLite() {
        this.creatTable(GlobalInfo.getInstance().getAppContext());
    }

    private void creatTable(Context context) {
        AppLog.i(this.TAG, "start creatTable");
        this.context = context;
        CameraSlotSQLiteHelper dbHelper = new CameraSlotSQLiteHelper(context);
        this.db = dbHelper.getWritableDatabase();
        AppLog.i(this.TAG, "end creatTable");
    }

    public boolean insert(CameraSlot camSlot) {
        if (this.isExisted(camSlot.cameraName)) {
            return false;
        }
        AppLog.i(this.TAG, "start insert isOccupied=" + this.switchBoolToInt(camSlot.isOccupied));
        ContentValues cValue = new ContentValues();
        cValue.put("isOccupied", Integer.valueOf(this.switchBoolToInt(camSlot.isOccupied)));
        cValue.put("cameraName", camSlot.cameraName);
        cValue.put("imageBuffer", camSlot.cameraPhoto);
        cValue.put("cameraType", Integer.valueOf(camSlot.cameraType));
        if (this.db.insert("cameraSlotInfo", null, cValue) == -1L) {
            AppLog.i(this.TAG, "failed to insert!");
            return false;
        }
        AppLog.i(this.TAG, "end: insert success");
        return true;
    }

    public boolean isExisted(String ssid) {
        boolean existed = false;
        Cursor cursor = this.db.query("cameraSlotInfo", null, "cameraName=?", new String[]{ssid}, null, null, null);
        if (cursor.moveToNext()) {
            existed = true;
        }
        cursor.close();
        return existed;
    }

    public void update(CameraSlot camSlot) {
        ContentValues values = new ContentValues();
        values.put("isOccupied", Boolean.valueOf(camSlot.isOccupied));
        values.put("imageBuffer", camSlot.cameraPhoto);
        values.put("cameraName", camSlot.cameraName);
        values.put("cameraType", Integer.valueOf(camSlot.cameraType));
        String whereClause = "_id=?";
        String[] whereArgs = new String[]{String.valueOf(camSlot.slotPosition)};
        this.db.update("cameraSlotInfo", values, whereClause, whereArgs);
        AppLog.i(this.TAG, "end update");
    }

    public void deleteByPosition(int slotPosition) {
        AppLog.i(this.TAG, "start delete slotPosition=" + slotPosition);
        this.db.delete("cameraSlotInfo", "_id=?", new String[]{String.valueOf(slotPosition)});
        AppLog.i(this.TAG, "end delete");
    }

    public ArrayList<CameraSlot> getAllCameraSlotFormDb() {
        AppLog.i(this.TAG, "start getAllCameraSlotFormDb");
        this.camSlotList = new ArrayList();
        Cursor cursor = this.db.rawQuery("select * from cameraSlotInfo", null);
        AppLog.i(this.TAG, "end rawQuery =" + cursor.getCount());
        String wifiSsid = null;
        wifiSsid = MWifiManager.getSsid(this.context);
        while (cursor.moveToNext()) {
            AppLog.i(this.TAG, "cursor.getInt(cursor.getColumnIndex =" + cursor.getInt(cursor.getColumnIndex("_id")));
            int id2 = cursor.getInt(cursor.getColumnIndex("_id"));
            int isUsed = cursor.getInt(cursor.getColumnIndex("isOccupied"));
            String camName = cursor.getString(cursor.getColumnIndex("cameraName"));
            byte[] imageBuf = cursor.getBlob(cursor.getColumnIndex("imageBuffer"));
            int cameraType = cursor.getInt(cursor.getColumnIndex("cameraType"));
            boolean isReady = false;
            if (wifiSsid != null && wifiSsid.equals(camName)) {
                isReady = true;
            }
            this.camSlotList.add(new CameraSlot(id2, this.switchIntToBool(isUsed), camName, cameraType, imageBuf, isReady));
            AppLog.i(this.TAG, " switchIntToBool(isUsed) =" + this.switchIntToBool(isUsed));
            AppLog.i(this.TAG, "_id=" + id2 + " isOccupied=" + isUsed + " camName=" + camName + " cameraType=" + cameraType);
        }
        AppLog.i(this.TAG, "end query all cameraSlot");
        if (cursor != null) {
            cursor.close();
        }
        AppLog.i(this.TAG, "end getAllCameraSlotFormDb");
        return this.camSlotList;
    }

    public void closeDB() {
        this.db.close();
    }

    private int switchBoolToInt(Boolean value) {
        if (value.booleanValue()) {
            return 1;
        }
        return 0;
    }

    private Boolean switchIntToBool(int value) {
        if (value == 1) {
            return true;
        }
        return false;
    }
}

